/*****
 NAME
 	casyncnet-test.m - test program for CANetStream class
 VERSION
 	$Id$
 CHANGELOG
 	$Log$
 */

#include <coconut/ceventsystem.h>
#include <coconut/papplication.h>
#include <coconut/gnet/casyncclient.h>
#include <coconut/gnet/casyncserver.h>
#include <coconut/cfile.h>
#include <stdlib.h>

#define	PORTNUM		12044

@interface CTest : CEventSystem <PApplication>
{
	id <PAsyncServer>	server ;
	id <PAsyncClient>	client ;

	id <PFile>		input ;
	id <PFile>		output ;
}

- (void) print_result: (error_t) err ;

@end

@implementation CTest

- (error_t) prologue: (int) argc argv: (const char **) argv
{
	printf("prologue\n") ;
	server = [[CAsyncServer alloc] init] ;
	client = [[CAsyncClient alloc] init] ;
	input = [[CFile alloc] init] ;
	output = [[CFile alloc] init] ;

	return [super prologue: argc argv: argv] ;
}

- (error_t) main
{
	error_t			err ;

	printf("*** self test program for CAsyncNet class\n");

	printf("open the input stream\n") ;
	err = [input open: read_open name: "casyncnet-test.in"] ;
	g_assert(err == no_error) ;

	printf("open the output stream\n") ;
	err = [output open: write_open name: NULL] ;
	g_assert(err == no_error) ;

	printf("start the server to send\n") ;
	err = [server openToWrite: PORTNUM input: input] ;
	g_assert(err == no_error) ;

	printf("start the client to receive\n") ;
	err = [client openToRead: PORTNUM server: "localhost" output: output] ;
	g_assert(err == no_error) ;

	[output close] ;

	printf("start the main loop\n") ;
	return [super main] ;
}

- (error_t) epilogue: (error_t) preerror 
{
	[server release] ;
	[client release] ;
	[input release] ;
	[output release] ;
	printf("end of epilogue\n") ;
	return preerror ;
}

- (void) print_result: (error_t) err
{
	if(err == no_error)
		printf("OK\n") ;
	else
		printf("ERROR (code %x)\n", (int) err) ;
}

@end

int main(int argc, const char **argv){
	id system ;
	int status ;
	printf("argv[0] = %s\n", &(argv[0][0])) ;
	system = [[CTest alloc] init] ;
	status = start_program(system, argc, argv) ;
	printf("bye (code %d, %s)\n", status, [CSystem applicationName]) ;
	[system release] ;
	return status ;
}

