/*****
 NAME
 	casyncfile-test.m - test program for CAsyncFile class
 VERSION
 	$Id$
 CHANGELOG
 	$Log$
 */

#include <coconut/casyncfile.m>
#include <coconut/ceventsystem.h>
#include <coconut/cfile.h>
#include <coconut/papplication.h>

@interface CTest : CEventSystem <PApplication>
{
	id <PFile>		outputfile ;
	id <PAsyncFile>		asyncinput ;
}

- (void) print_result: (id <PError>) err ;

@end

@implementation CTest

- (id <PError>) prologue: (int) argc argv: (const char **) argv
{
	return [super prologue: argc argv: argv] ;
}

- (id <PError>) main
{
	id <PError>		err ;

	printf("*** test program for CAsyncFile class\n");

	/* open the file to output to the standard output */
	outputfile = [CFile newFile: write_open name: NULL] ;
	g_assert(outputfile != nil) ;
	[outputfile putPtr: "this is output stream\n"] ;
	[outputfile flush] ;

	/* open the async file to read */
	asyncinput = [[CAsyncFile alloc] init] ;
	err = [asyncinput openToRead: "casyncfile-test.in2" 
	  output: outputfile];
	g_assert(err == nil) ;

	printf("bye.\n");
	return [super main] ;
}

- (id <PError>) epilogue: (id <PError>) preerror 
{
	[outputfile flush] ;
	[outputfile close] ;

	[outputfile release] ;
	[asyncinput release] ;
	return preerror ;
}

- (void) print_result: (id <PError>) err
{
	if(err == no_error)
		printf("OK\n") ;
	else
		printf("ERROR (code %x)\n", (int) err) ;
}

@end

int main(int argc, const char **argv){
	id system ;
	int status ;
	printf("argv[0] = %s\n", &(argv[0][0])) ;
	system = [[CTest alloc] init] ;
	status = start_program(system, argc, argv) ;
	printf("bye (code %d, %s)\n", status, [CSystem applicationName]) ;
	[system release] ;
	return status ;
}

