/*****
 NAME
 	casyncfile-test.m - test program for CAsyncFile class
 VERSION
 	$Id$
 CHANGELOG
 	$Log$
 */

#include <coconut/casyncfile.m>
#include <coconut/ceventsystem.h>
#include <coconut/cfile.h>
#include <coconut/papplication.h>

@interface CTest : CEventSystem <PApplication>
{
	id <PFile>		inputfile ;
	id <PAsyncFile>		asyncoutput ;
}

- (void) print_result: (id <PError>) err ;

@end

@implementation CTest

- (id <PError>) prologue: (int) argc argv: (const char **) argv
{
	return [super prologue: argc argv: argv] ;
}

- (id <PError>) main
{
	id <PError>		err ;

	printf("*** test program for CAsyncFile class\n");

	/* open the file to read */
	inputfile = [CFile newFile: read_open name: "casyncfile-test.in1"] ;
	g_assert(inputfile != nil) ;

	/* open the async file to write */
	asyncoutput = [[CAsyncFile alloc] init] ;
	err=[asyncoutput openToWrite: "casyncfile-test.out1" input: inputfile] ;
	g_assert(err == nil) ;

	printf("bye.\n");
	return [super main] ;
}

- (id <PError>) epilogue: (id <PError>) preerror 
{
	[inputfile close] ;
	[inputfile release] ;
	[asyncoutput release] ;
	return preerror ;
}

- (void) print_result: (id <PError>) err
{
	if(err == no_error)
		printf("OK\n") ;
	else
		printf("ERROR (code %x)\n", (int) err) ;
}

@end

int main(int argc, const char **argv){
	id system ;
	int status ;
	printf("argv[0] = %s\n", &(argv[0][0])) ;
	system = [[CTest alloc] init] ;
	status = start_program(system, argc, argv) ;
	printf("bye (code %d, %s)\n", status, [CSystem applicationName]) ;
	[system release] ;
	return status ;
}

