#!/bin/sh
#####
# NAME
#	make_config_h.sh : generate config file from normal config.h
# USAGE
#	make_config_h.sh src-config.h dst-config.h
# VERSION
#	1.0 2001/08/14 initial version
#

THIS="make_config_h"
SRC=$1
DST=$2 
TMPDST="${DST}.tmp"

message(){
	echo "$THIS $*" ;
}

error(){
	echo "$THIS [ERROR] $*" ;
	exit 1 ;
}

if [ -z $SRC ] ; then
	error "source cofigulation file name is not given" 
fi
if [ ! -f $SRC ] ; then
	error "source configulation file \"$SRC\" is not found." 
fi

if [ -z $DST ] ; then
	error "destination cofigulation file name is not given" 
fi

echo "/* translated from config.h by make_config_h.sh */" > $TMPDST 

sed -e 's/HAVE_/COCONUT_HAVE_/g' \
    -e 's/STDC_/COCONUT_STDC_/g' \
    -e 's/PACKAGE/COCONUT_PACKAGE/g' \
    -e 's/VERSION/COCONUT_VERSION/g' \
  $SRC >> $TMPDST

if test -f $DST ; then
	if diff $TMPDST $DST > /dev/null ; then
		echo "$DST is not updated" ;
		rm -f $TMPDST ;
	else
		echo "updating $DST" ;
		mv $TMPDST $DST ;
	fi
else
	echo "generating $DST" ;
	mv $TMPDST $DST ;
fi

exit 0 ;

