/*****
 NAME
 	cwindow.m - source code for CWindow class
 VERSION
 	$Id$
 CHANGELOG
 	$Log$
 */

#include <coconut/gtk/cwindow.h>
#include <coconut/csystem.h>

@implementation CWindow 

- init
{
	return [self initWindow: window_toplevel align: screen_align_free] ;
}

- initWindow: (window_t) win align: (screen_align_t) align
{
	GtkWidget *	widget ;
	widget = gtk_window_new(windowType2Gtk(win)) ;
	[CSystem checkPtr: widget] ;
	gtk_window_set_position(GTK_WINDOW(widget),screenAlignType2Gtk(align));
	return [super initBin: widget_window widget: widget] ;
}

- (void) dealloc
{
	return [super dealloc] ;
}

- (boolean) hasTitle
{
	return TRUE ;
}

- setTitle: (const char *) title
{
	gtk_window_set_title(GTK_WINDOW(widget_ptr), title) ;
	return nil ;
}

- (const char *) title 
{
	return GTK_WINDOW(widget_ptr)->title ;
}

- (boolean) isGrowable
{
	return GTK_WINDOW(widget_ptr)->allow_grow ;
}

- doShrink: (boolean) doshrink
{
	GtkWindow * win = GTK_WINDOW(widget_ptr) ;
	/* note: the 4th parameter, auto_shrink is not used in
	   version gtk+-2.0.0 */
	gtk_window_set_policy(win, doshrink, win->allow_grow, 0);
	return nil ;
}

- (boolean) isShrinkable
{
	return GTK_WINDOW(widget_ptr)->allow_shrink ;
}

- doGrow: (boolean) dogrow
{
	GtkWindow * win = GTK_WINDOW(widget_ptr) ;
	/* note: the 4th parameter, auto_shrink is not used in
	   version gtk+-2.0.0 */
	gtk_window_set_policy(win, win->allow_shrink, dogrow, 0);
	return nil ;
}

@end

