/*****
 NAME
	ctextview.m - source code for CTextView class
 VERSION
	$Id$
 CHANGELOG
	$Log$
 */

#include <coconut/gtk/ctextview.h>
#include <coconut/csystem.h>

#define	TEXT_VIEW_PTR	GTK_TEXT_VIEW(widget_ptr)

@implementation CTextView

- init
{
	return [self initTextView] ; 
}

- initTextView
{
	GtkWidget * widget ;
	widget = gtk_text_view_new() ;
	[CSystem checkPtr: widget] ;
	return [super initWidget: widget_textview widget: widget] ;
}

- (void) dealloc
{
	[super dealloc] ;
}

- (boolean) hasJustification
{
	return TRUE ;
}

- doWordWrap: (boolean) wrap
{
	GtkWrapMode	mode ;
	mode = wrap ? GTK_WRAP_WORD : GTK_WRAP_NONE ;
	gtk_text_view_set_wrap_mode(TEXT_VIEW_PTR, mode) ;
	return nil ;
}

- doLineWrap: (boolean) wrap
{
	/* ignored */
	return nil ;
}

- setJusitification: (justification_t) just
{
	gtk_text_view_set_justification(TEXT_VIEW_PTR, (GtkJustification) just);
	return nil ;
}

- (boolean) hasTextView
{
	return TRUE ;
}

- setEditable: (boolean) doedit
{
	gtk_text_view_set_editable(TEXT_VIEW_PTR, doedit) ;
	return nil ;
}

- (boolean) isEditable
{
	return gtk_text_view_get_editable(TEXT_VIEW_PTR) ;
}

- setCursorVisible: (boolean) dovis
{
	gtk_text_view_set_cursor_visible(TEXT_VIEW_PTR, dovis);
	return nil ;
}

- (boolean) isCursorVisible
{
	return gtk_text_view_get_cursor_visible(TEXT_VIEW_PTR) ;
}

- setStr: (id <PBasicStr>) str
{
	GtkTextBuffer *	buffer ;
	buffer =  gtk_text_view_get_buffer(TEXT_VIEW_PTR) ;
	gtk_text_buffer_set_text(buffer, [str ptr], [str length]) ;
	return nil ;
}

- setPtr: (const utf8_char *) ptr length: (u_int) length
{
	GtkTextBuffer *	buffer ;
	buffer =  gtk_text_view_get_buffer(TEXT_VIEW_PTR) ;
	gtk_text_buffer_set_text(buffer, ptr, length) ;
	return nil ;
}

@end

