/*****
 NAME
 	cradiobutton.m - source code for CRadioButton class
 VERSION
 	$Id$
 CHANGELOG
 	$Log$
 */

#include <coconut/gtk/cradiobutton.h>
#include <coconut/gtk/clabel.h>

#define	CONTAINER_PTR	GTK_BOX(widget_ptr)
#define	RADIO_PTR	GTK_RADIO_BUTTON(radio_button)
#define	SPACING		1

@implementation CRadioButton

- initRadioButton: (boolean) isvert
{
	GtkWidget *	container ;

	container = isvert ?  gtk_vbox_new(TRUE, SPACING) 
	  : gtk_hbox_new(TRUE, SPACING) ;
	radio_button = gtk_radio_button_new(NULL) ;
	return [super initWidget: widget_radiobutton widget: container] ;
}

- init
{
	return [self initRadioButton: TRUE] ;
}

- (void) dealloc
{
	gtk_widget_destroy(radio_button) ;
	[super dealloc] ;
}

- (boolean) isContainer
{
	return FALSE ;
}

- appendLabel: (const utf8_char *) label
{
	GtkWidget *	widget ;
	CLabel *	labelwidget ;

	widget = gtk_radio_button_new_with_label_from_widget(RADIO_PTR, label) ;
	gtk_box_pack_end(CONTAINER_PTR, widget, FALSE, FALSE, SPACING) ;
	labelwidget = [[CLabel alloc] initLabelFromWidget: widget] ;
	return labelwidget ? nil : self ;
}

- prependLabel: (const utf8_char *) label
{
	GtkWidget *	widget ;
	CLabel *	labelwidget ;

	widget= gtk_radio_button_new_with_label_from_widget(RADIO_PTR, label) ;
	gtk_box_pack_start(CONTAINER_PTR, widget, FALSE, FALSE, SPACING) ;
	labelwidget = [[CLabel alloc] initLabelFromWidget: widget] ;
	return labelwidget ? nil : self ;
}

- activate: (u_int) idx
{
	GSList *	list ;
	u_int		i ;

	list = gtk_radio_button_get_group(RADIO_PTR) ;
	for(i=0 ; list ; list = g_slist_next(list), i++){
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(list->data),
		  i == idx) ;
	}
	return nil ;
}

- show
{
	GSList *	list ;
	id 		object ;

	list = gtk_radio_button_get_group(RADIO_PTR) ;
	for(; list ; list = g_slist_next(list)){
		object = GtkWidget2WidgetObj(list->data) ;
		[object show] ;
	}
	return [super show] ;
}

- hide
{
	GSList *	list ;
	id 		object ;

	list = gtk_radio_button_get_group(RADIO_PTR) ;
	for(; list ; list = g_slist_next(list)){
		object = GtkWidget2WidgetObj(list->data) ;
		[object hide] ;
	}
	return [super hide] ;
}

@end

