/*****
 NAME
 	cpadding.m - source code for CLocation class
 VERSION
 	$Id$
 CHANGELOG
 	$Log$
 */

#include <coconut/gtk/cpadding.h>

#define	MISC_PTR	GTK_MISC(widget_ptr)

@implementation CPadding

- initPadding: (widget_t) type widget: (GtkWidget *) widget
{
	return [super initWidget: type widget: widget] ;
}

- (void) dealloc
{
	[super dealloc] ;
}

- (boolean) hasAlign
{
	return TRUE ;
}

- setAlign: (align_t) holiz and: (align_t) vert
{
	gfloat	xalign, yalign ;

	xalign = [CWidget alignToFloat: holiz] ;
	yalign = [CWidget alignToFloat: vert] ;
	gtk_misc_set_alignment(MISC_PTR, xalign, yalign) ;
	return nil ;
}

- setHolizAlign: (align_t) holiz
{
	gfloat	xorg, yorg ;
	gfloat	xalign ;

	xalign = [CWidget alignToFloat: holiz] ;
	gtk_misc_get_alignment(MISC_PTR, &xorg, &yorg) ;
	gtk_misc_set_alignment(MISC_PTR, xalign, yorg) ;
	return nil ;
}

- setVertAlign: (align_t) vert
{
	gfloat	xorg, yorg ;
	gfloat	yalign ;

	yalign = [CWidget alignToFloat: vert] ;
	gtk_misc_get_alignment(MISC_PTR, &xorg, &yorg) ;
	gtk_misc_set_alignment(MISC_PTR, xorg, yalign) ;
	return nil ;
}

- (align_t) holizAlign
{
	gfloat	xalign, yalign ;
	gtk_misc_get_alignment(MISC_PTR, &xalign, &yalign) ;
	return [CWidget floatToAlign: xalign] ;
}

- (align_t) vertAlign
{
	gfloat	xalign, yalign ;
	gtk_misc_get_alignment(MISC_PTR, &xalign, &yalign) ;
	return [CWidget floatToAlign: yalign] ;
}

- (boolean) hasPadding
{
	return TRUE ;
}

- setPadding: (dimension_t) xpad and: (dimension_t) ypad
{
	gtk_misc_set_padding(MISC_PTR, xpad, ypad) ;
	return nil ;
}

- setHolizPadding: (dimension_t) xpad
{
	gint	xorg, yorg ;
	gtk_misc_get_padding(MISC_PTR, &xorg, &yorg) ;
	gtk_misc_set_padding(MISC_PTR, xpad, yorg) ;
	return nil ;
}

- setVertPadding: (dimension_t) ypad
{
	gint	xorg, yorg ;
	gtk_misc_get_padding(MISC_PTR, &xorg, &yorg) ;
	gtk_misc_set_padding(MISC_PTR, xorg, ypad) ;
	return nil ;
}

- (dimension_t) holizPadding
{
	gint	xpad, ypad ;
	gtk_misc_get_padding(MISC_PTR, &xpad, &ypad) ;
	return xpad ;
}

- (dimension_t) vertPadding
{
	gint	xpad, ypad ;
	gtk_misc_get_padding(MISC_PTR, &xpad, &ypad) ;
	return ypad ;
}

@end

