/*****
 NAME
	clabel.m - source code for CLabel class
 VERSION
	$Id$
 CHANGELOG
	$Log$
 */

#include <coconut/gtk/clabel.h>
#include <coconut/csystem.h>

#define	LABEL_PTR	GTK_LABEL(widget_ptr)

@implementation CLabel

- init
{
	static const char undefined[] = "<undefined>" ;
	return [self initLabel: undefined] ; 
}

- initLabel: (const char *) title
{
	GtkWidget * widget ;
	widget = gtk_label_new(title) ;
	[CSystem checkPtr: widget] ;
	return [super initWidget: widget_label widget: widget] ;
}

- initLabelFromWidget: (GtkWidget *) widget
{
	return [super initWidget: widget_label widget: widget] ;
}

- (void) dealloc
{
	[super dealloc] ;
}

- (boolean) hasTitle
{
	return TRUE ;
}

- setTitle: (const char *) title
{
	gtk_label_set_text(LABEL_PTR, title) ;
	return nil ;
}

- (const char *) title
{
	gchar *	title ;
	gtk_label_get(LABEL_PTR, &title) ;
	return title ;
}

- (boolean) hasText
{
	return TRUE ;
}

- (boolean) setEditable: (boolean) doedit
{
	/* ignored */
	return FALSE ;
}

- (boolean) hasJustification
{
	return TRUE ;
}

- doLineWrap: (boolean) wrap
{
	gtk_label_set_line_wrap(LABEL_PTR, wrap) ;
	return nil ;
}

- doWordWrap: (boolean) wrap
{
	/* ignored */
	return nil ;
}

- setJusitification: (justification_t) just
{
	gtk_label_set_justify(LABEL_PTR, (GtkJustification) just) ;
	return nil ;
}

@end

