/*****
 NAME
 	cguisystem.m - source code for CGUISystem
 VERSION
 	$Id$
 CHANGELOG
 	$Log$
 */

#include <coconut/gtk/cguisystem.h>
#include <coconut/gtk/tgtk.h>

/* define the constant strings */
#define	EXTERN(NAME, STR)	const char NAME[] = STR ;
#include <coconut/gtk/devent.h>

@implementation CGUISystem

- init
{
	retain_count = 1 ;
	return [super init] ;
}

- (void) dealloc
{
	[super dealloc] ;
}

- (id <PError>) prologue: (int) argc argv: (const char **) argv
{
	gtk_init(&argc, (char ***) &argv) ;
	return [super prologue: argc argv:argv] ;
}

- (id <PError>) main
{
	gtk_main() ;
	return [super main] ;
}

- (id <PError>) epilogue: (id <PError>) preerror
{
	return [super epilogue: preerror] ;
}

- exitMainLoop: (id <PError>) err
{
	gtk_main_quit() ;
	return [super exitMainLoop: err] ;
}

- (u_int) getMainLoopNest
{
	return gtk_main_level() + [super getMainLoopNest] - 1 ;
}

- (boolean) isRunning
{
	g_message("not supported");
	return FALSE ;
}

- (boolean) isPending
{
	return gtk_events_pending() ;
}

@end

