/*****
 NAME
 	cframe.m - source code for CFrame class
 VERSION
 	$Id$
 CHANGELOG
 	$Log$
 */

#include <coconut/gtk/cframe.h>
#include <coconut/csystem.h>
#include <coconut/dconststr.h>

#define	FRAME_PTR	GTK_FRAME(widget_ptr)

@implementation CFrame

- initFrame: (const char *) title
{
	GtkWidget *	widget ;
	widget = gtk_frame_new(title) ;
	[CSystem checkPtr: widget] ;
	return [super initBin: widget_frame widget: widget] ;
}

- init 
{
	return [self initFrame: UNKNOWN_STR] ;
}

- (void) dealloc
{
	[super dealloc] ;
}

- (boolean) hasTitle
{
	return TRUE ;
}

- setTitle: (const char *) title
{
	gtk_frame_set_label(FRAME_PTR, title) ;
	return nil ;
}

- (const char *) title
{
	return gtk_frame_get_label(FRAME_PTR) ;
}

- (boolean) hasAlign
{
	return TRUE ;
}

- setAlign: (align_t) holiz and: (align_t) vert
{	
	gfloat	xalign, yalign ;
	xalign = [CWidget alignToFloat: holiz] ;
	yalign = [CWidget alignToFloat: vert] ;
	gtk_frame_set_label_align(FRAME_PTR, xalign, yalign) ;
	return nil ;
}

- setHolizAlign: (align_t) dir
{
	gfloat	xalign ;
	gfloat	orgx, orgy ;

	xalign = [CWidget alignToFloat: dir] ;
	gtk_frame_get_label_align(FRAME_PTR, &orgx, &orgy) ;
	gtk_frame_set_label_align(FRAME_PTR, xalign , orgy) ;
	return nil ;
}

- setVertAlign: (align_t) dir
{
	gfloat	yalign ;
	gfloat	orgx, orgy ;

	yalign = [CWidget alignToFloat: dir] ;
	gtk_frame_get_label_align(FRAME_PTR, &orgx, &orgy) ;
	gtk_frame_set_label_align(FRAME_PTR, orgx , yalign) ;
	return nil ;
}

- (align_t) holizAlign
{
	gfloat	xalign, yalign ;
	gtk_frame_get_label_align(FRAME_PTR, &xalign, &yalign) ;
	return [CWidget floatToAlign: xalign] ;
}

- (align_t) vertAlign
{
	gfloat	xalign, yalign ;
	gtk_frame_get_label_align(FRAME_PTR, &xalign, &yalign) ;
	return [CWidget floatToAlign: yalign] ;
}

- (boolean) hasShadow
{
	return TRUE ;
}

- setShadow: (shadow_t) stype
{
	gtk_frame_set_shadow_type(FRAME_PTR, SHADOW2GTK(stype)) ;
	return nil ;
}

- (shadow_t) shadow
{
	return GTK2SHADOW(gtk_frame_get_shadow_type(FRAME_PTR)) ;
}

@end

