/*****
 NAME
 	ccontainer.m - source code for CContainer class
 VERSION
 	$Id$
 CHANGELOG
 	$Log$
 */

#include <coconut/gtk/ccontainer.h>

#define	CONTAINER_PTR		(GTK_CONTAINER(widget_ptr))
#define	BOX_PTR			(GTK_BOX(widget_ptr))
#define	CHILD_PTR(CONT)		gtk_container_get_children(CONT)

#define	DEF_SPACING		1

@implementation CContainer

- init 
{
	return [self initContainer: dir_down homogeneous: FALSE 
	  spacing: DEF_SPACING] ;
}

- initContainer: (direction_t) dir homogeneous: (boolean) dohomog 
  spacing: (dimension_t) spacing
{
	GtkWidget *	newcont ;

	def_spacing = spacing ;
	newcont = IS_VERT_DIR(dir) ? gtk_vbox_new(dohomog, spacing) :
			  gtk_hbox_new(dohomog, spacing) ;
	return [super initWidget: widget_container widget: newcont] ;
}

- (void) dealloc
{
	[super dealloc] ;
}

- (boolean) isContainer
{
	return TRUE ;
}

/* the function "gtk_widget_show_all(widget_ptr)" can not be used.
   because some classes (such as radio button class) can not call "show"
   message by this function. */
- show
{
	id	result ;
	result = [self foreach: @selector(show) with: nil with: nil] ;
	gtk_widget_show(widget_ptr) ;
	return result ;
}

/* see the comment for "show" method */
- hide
{
	id	result ;
	result = [self foreach: @selector(hide) with: nil with: nil] ;
	gtk_widget_hide(widget_ptr) ;
	return result ;
}

- (u_int) count
{
	return g_list_length(CHILD_PTR(CONTAINER_PTR)) ;
}

- appendWidget: (id <PWidget>) child
{
	gtk_box_pack_start(BOX_PTR, WidgetObj2GtkWidget(child),
	  FALSE, FALSE, def_spacing) ;
	return nil ;
}

- prependWidget: (id <PWidget>) child 
{
	gtk_box_pack_end(BOX_PTR, WidgetObj2GtkWidget(child),
	  FALSE, FALSE, def_spacing) ;
	return nil ;
}

- (id <PWidget>) item: (u_int) index
{
	GtkBoxChild *	child ;
	child = (GtkBoxChild *) g_list_nth(CHILD_PTR(CONTAINER_PTR), index) ;
	return child ? GtkWidget2WidgetObj(child) : NULL ;
}

- removeWidget: (id <PWidget>) child
{
	GtkWidget * 	wid = WidgetObj2GtkWidget(child) ;
	gtk_container_remove(CONTAINER_PTR, wid) ;
	return nil ;
}

- foreach: (SEL) msg with: p1 with: p2
{
	GList * 	list ;
	GtkWidget *	widget ;
	id		result = nil ;

	for(list = CHILD_PTR(CONTAINER_PTR) ; list ; list = list->next){
		widget = (GtkWidget *) list->data ;
		result = [GtkWidget2WidgetObj(widget) perform: msg with: p1 
		  with: p2] ;
		if(result)
			return result ;
	}
	return result ;
}

- setBorderWidth: (dimension_t) width
{
	def_spacing = width ;
	return nil ;
}

- setHomogeneous: (boolean) dohomogeneous
{
	/* no effect */
	return nil ;
}

- setSpacing: (dimension_t) spacing
{
	/* no effect */
	return nil ;
}

@end

