/*****
 NAME
	ccheckbutton.m - source code for CCheckButton class
 VERSION
	$Id$
 CHANGELOG
	$Log$
 */

#include <coconut/gtk/ccheckbutton.h>
#include <coconut/gtk/clabel.h>
#include <coconut/csystem.h>

#define	CHECK_PTR	GTK_CHECK_BUTTON(widget_ptr)
#define	TOGGLE_PTR	GTK_TOGGLE_BUTTON(widget_ptr)

@implementation CCheckButton

- init
{
	return [self initCheckButton: NULL] ; 
}

- initCheckButton: (const char *) title
{
	GtkWidget *	widget ;
	CCheckButton *	check ;
	id <PLabel>	label ;

	widget = gtk_check_button_new() ;
	[CSystem checkPtr: widget] ;

	check = [super initBin: widget_checkbutton widget: widget] ;
	if(title){
		label = [[CLabel alloc] initLabel: title] ;
		[super appendWidget: label] ;
	}
	return check ;
}

- (void) dealloc
{
	[super dealloc] ;
}

- (boolean) hasToggleSwitch
{
	return TRUE ;
}

- toggle: (boolean) doact
{
	gtk_toggle_button_set_active(TOGGLE_PTR, doact) ;
	return nil ;
}

- (boolean) isToggled
{
	return gtk_toggle_button_get_active(TOGGLE_PTR) ;
}

- (boolean) hasInconsistent
{
	return TRUE ;
}

- setInconsistent: (boolean) setting
{
	gtk_toggle_button_set_inconsistent(TOGGLE_PTR, setting) ;
	return nil ;
}

- (boolean) inconsistent
{
	return gtk_toggle_button_get_inconsistent(TOGGLE_PTR) ;
}

- (boolean) hasIndicator
{
	return TRUE ;
}

- setIndicator: (boolean) setting
{
	gtk_toggle_button_set_mode(TOGGLE_PTR, setting) ;
	return nil ;
}

- (boolean) indicator
{
	return gtk_toggle_button_get_mode(TOGGLE_PTR) ;
}

@end

