/*****
 NAME
	ccalendar.m - source code for CCalendar class
 VERSION
	$Id$
 CHANGELOG
	$Log$
 */

#include <coconut/gtk/ccalendar.h>
#include <coconut/cdate.h>
#include <coconut/cerror.h>
#include <coconut/csystem.h>

#define	CALENDAR_PTR	GTK_CALENDAR(widget_ptr)

@implementation CCalendar

- init
{
	GtkWidget * widget ;
	widget = gtk_calendar_new() ;
	[CSystem checkPtr: widget] ;
	return [super initWidget: widget_calendar widget: widget] ;
}

- (void) dealloc
{
	[super dealloc] ;
}

-(id <PError>) setDate: (u_int) day month: (u_int) month year: (u_int) year
{
	if(gtk_calendar_select_month(CALENDAR_PTR, month, year)){
		gtk_calendar_select_day(CALENDAR_PTR, day) ;
		return nil ;
	}
	/* process can not reach here, if no error are occured */
	return [CError illegal_parameter] ;
}

- (u_int) day
{
	guint	year, month, day ;
	gtk_calendar_get_date(CALENDAR_PTR, &year, &month, &day) ;
	return day ;
}

- (u_int) month
{
	guint	year, month, day ;
	gtk_calendar_get_date(CALENDAR_PTR, &year, &month, &day) ;
	return month ;
}

- (u_int) year
{
	guint	year, month, day ;
	gtk_calendar_get_date(CALENDAR_PTR, &year, &month, &day) ;
	return year ;
}

- (id <PDate>) date
{
	id <PDate>	date ;
	guint		year, month, day ;

	gtk_calendar_get_date(CALENDAR_PTR, &year, &month, &day) ;
	date = [[CDate alloc] init] ;
	[date setDate: day month: month year: year] ;
	return date ;
}

- markDay: (u_int) day
{
	gtk_calendar_mark_day(CALENDAR_PTR, day) ;
	return nil ;
}

- unmarkDay: (u_int) day
{
	gtk_calendar_unmark_day(CALENDAR_PTR, day) ;
	return nil ;
}

- clearMarks
{
	gtk_calendar_clear_marks(CALENDAR_PTR) ;
	return nil ;
}

@end

