/*****
 NAME
 	cbin.m - source code for CBin class
 VERSION
 	$Id$
 CHANGELOG
 	$Log$
 */

#include <coconut/gtk/cbin.h>

#define	CONTAINER_PTR	GTK_CONTAINER(widget_ptr)
#define	BIN_PTR		GTK_BIN(widget_ptr)

@implementation CBin

- init
{
	fprintf(stderr, "cbin,init: not supported\n") ;
	return [super init] ;
}

- initBin: (widget_t) type widget: (GtkWidget *) widget
{
	return [super initWidget: type widget: widget] ;
}

- (void) dealloc
{	
	[super dealloc] ;
}

- (boolean) isContainer
{
	return TRUE ;
}

/* gtk_widget_show_all(widget_ptr) ; */
- show
{
	id child = [self item: 0] ;
	if(child)
		[child show] ;
	return [super show] ;
}

/* gtk_widget_hide_all(widget_ptr) ; */
- hide
{
	id child = [self item: 0] ;
	if(child)
		[child hide] ;
	return [super hide] ;
}

- (u_int) count
{
	GtkBin * binptr = BIN_PTR ;
	return binptr->child ? 1 : 0 ;
}

- appendWidget: (id <PWidget>) child 
{
	[self removeWidget: [self item: 0]] ;
	gtk_container_add(GTK_CONTAINER(widget_ptr),WidgetObj2GtkWidget(child));
	return nil ;
}

- prependWidget: (id <PWidget>) child 
{
	[self removeWidget: [self item: 0]] ;
	gtk_container_add(GTK_CONTAINER(widget_ptr),WidgetObj2GtkWidget(child));
	return nil ;
}

- (id <PWidget>) item: (u_int) index 
{
	GtkBin * binptr = BIN_PTR ;
	GtkWidget * child = binptr->child ;
	return index == 0 && child ? GtkWidget2WidgetObj(child) : nil ;
}

- removeWidget: (id <PWidget>) wid
{
	if(wid)
		gtk_container_remove(CONTAINER_PTR, WidgetObj2GtkWidget(wid));
	return nil ;
}

- foreach: (SEL) msg with: p1 with: p2
{
	id child = [self item: 0] ;
	id result ;

	if(child)
		result = [child perform: msg with: p1 with: p2] ;
	else
		result = nil ;
	return result ;
}

- setBorderWidth: (dimension_t) width
{
	gtk_container_set_border_width(CONTAINER_PTR, width) ;
	return nil ;
}

- setHomogeneous: (boolean) dohomogeneous
{
	/* no effect */
	return nil ;
}

- setSpacing: (dimension_t) spacing
{
	/* no effect */
	return nil ;
}

@end

