/*****
 NAME
	carrow.m - source code for CArrow class
 VERSION
	$Id$
 CHANGELOG
	$Log$
 */

#include <coconut/gtk/carrow.h>
#include <coconut/csystem.h>

#define	ARROW_PTR	GTK_ARROW(widget_ptr)

@implementation CArrow

- init
{
	return [self initArrow: dir_left shadow: shadow_none] ; 
}

- initArrow: (direction_t) atype shadow: (shadow_t) stype
{
	GtkWidget * widget ;
	widget = gtk_arrow_new(DIR2GTKARROW(atype), SHADOW2GTK(stype)) ;
	[CSystem checkPtr: widget] ;
	return [super initWidget: widget_arrow widget: widget] ;
}

- (void) dealloc
{
	[super dealloc] ;
}

- (boolean) hasDirection
{
	return TRUE ;
}

- setDirection: (direction_t) atype
{
	gtk_arrow_set(ARROW_PTR, DIR2GTKARROW(atype), (ARROW_PTR)->shadow_type);
	return nil ;
}

- (direction_t) direction
{
	return GTKARROW2DIR(ARROW_PTR->arrow_type) ;
}

- (boolean) hasShadow
{
	return TRUE ;
}

- setShadow: (shadow_t) stype
{
	gtk_arrow_set(ARROW_PTR, ARROW_PTR->arrow_type, SHADOW2GTK(stype)) ;
	return nil ;
}

- (shadow_t) shadow
{
	return GTK2SHADOW(ARROW_PTR->shadow_type) ;
}

@end

