/*****
 NAME
 	cnetclient.m - source code for CNetClient
 VERSION
 	$Id$
 CHANGELOG
 	$Log$
 */

#include <coconut/gnet/cnetclient.h>
#include <coconut/cerror.h>

@implementation CNetClient

- init
{
	client_socket = NULL ;
	return [super init] ;
}

- (void) dealloc
{
	[self close] ;
	[super dealloc] ;
}

- (id <PError>) open: (int) portnum server: (const char *) servername
{
	GInetAddr *	clientaddr ;
	clientaddr = gnet_inetaddr_new(servername, portnum) ;
	if(clientaddr == NULL)
		return [CError can_not_open] ;
	client_socket = gnet_tcp_socket_new(clientaddr) ;
	if(client_socket == NULL)
		return [CError can_not_open] ;
	return [super openChannel: gnet_tcp_socket_get_iochannel(client_socket)] ;
}

- (id <PError>) close
{
	id <PError>	err ;
	if((err = [super closeChannel]) == nil){
		gnet_tcp_socket_delete(client_socket) ; client_socket = NULL ;
	}
	return err ;
}

- (boolean) isServer
{
	return FALSE ;
}

@end

