/*****
 NAME
 	fvector.c - functions for vector2d or vector3d operation
 VERSION
 	$Id$
 CHANGELOG
 	$Log$
 */

#include <coconut/fvector.h>
#include <coconut/dvector.h>

void fprintv2d(FILE * stream, const vector2d_t * vec)
{
	double	x ;
	double	y ;
	x = vec->x ; y = vec->y ;
	x = v2d_scalar_no_neg_zero(x) ;
	y = v2d_scalar_no_neg_zero(y) ;
	fprintf(stream, "(%.3f, %.3f)", x, y) ;
}

void fprintv3d(FILE * stream, const vector3d_t * vec)
{
	double	x ;
	double	y ;
	double	z ;
	x = vec->x ; y = vec->y ; z = vec->z ;
	x = v3d_scalar_no_neg_zero(x) ;
	y = v3d_scalar_no_neg_zero(y) ;
	z = v3d_scalar_no_neg_zero(z) ;
	fprintf(stream, "(%.3f, %.3f, %.3f)", x, y, z) ;
}

