/*****
 NAME
	fbasic.c - basic function source code
 VERSION
	$Id$
 CHANGELOG
	$Log$
 */

#include <coconut/fbasic.h>
#include <coconut/dbasic.h>
#include <coconut/tglib.h>
#include <stdlib.h>
#include <stdio.h>

void print_string_data(const void * data, const void * param){
	SUPPRESS_UNUSED_WARN(param) ;
	if(data)
		puts((char *) data) ;
	else
		puts("(null)") ;
}

void print_int_data(const void * data, const void * param){
	SUPPRESS_UNUSED_WARN(param) ;
	if(data)
		printf("%d ", *((int *) data)) ;
	else
		puts("(null)") ;
}

#define	INT(P)	*((int *) P)
int equal_int_data(const void * p1, const void * p2)
{
	return INT(p1) == INT(p2) ? TRUE : FALSE ;
}

boolean isNotRejectedSelection(selection_t sel)
{
	return IS_NOT_REJECTED(sel) ;
}

boolean isAcceptedSelection(selection_t sel)
{
	return IS_ACCEPTED(sel) ;
}

const char * intFormat2PrintFormat(int_format_t form)
{
	static const char	default_s[] = "%d" ;
	static const char	char_s[] = "%c" ;
	static const char	oct_s[] = "%o" ;
	static const char	hex_s[] = "%x" ;
	const char *		result ;

	switch(form){
	  case char_format:	result = char_s ;	break ;
	  case oct_format:	result = oct_s ;	break ;
	  case hex_format:	result = hex_s ;	break ;
	  default:		result = default_s ;	break ;
	}
	return result ;
}

