/*****
 NAME
 	cxmltable.h - header file for CXMLTable class
 VERSION
 	$Id$
 CHANGELOG
 	$Log$
 */

#include <coconut/cxmltable.h>
#include <coconut/cxmltree.h>
#include <coconut/chtmltree.h>
#include <coconut/cxmlfactory.h>
#include <coconut/cidarray.h>
#include <coconut/csystem.h>
#include <coconut/cerror.h>

@implementation CXMLTable

- init
{
	return [self initXMLTable: NULL] ;
}

- initXMLTable: (id <PStream>) err ;
{
	object_array = [[CIdArray alloc] init] ;
	err_stream = err ;
	if(err_stream)
		[err_stream retain] ;
	return [super init] ;
}

- (void) dealloc
{
	[object_array release] ;
	[err_stream release] ;
	[super dealloc] ;
}

- (id <PXMLTree>) newXmlDocument: (const char *) filename
{
	id <PXMLTree>	xmldoc ;

	xmldoc = [[CXMLTree alloc] init] ;
	[CSystem checkPtr: xmldoc] ;
	[xmldoc newDocument: filename] ;

	if(err_stream){
		[CXMLFactory setErrorHandler: err_stream] ;
	}
	[object_array append: xmldoc] ;
	[xmldoc release] ;

	return xmldoc ;
}

- (id <PXMLTree>) newHtmlDocument: (const char *) filename
{
	id <PXMLTree>	htmldoc ;

	htmldoc = [[CHTMLTree alloc] init] ;
	[CSystem checkPtr: htmldoc] ;
	[htmldoc newDocument: filename] ;
	if(err_stream){
		[CXMLFactory setErrorHandler: err_stream] ;
	}
	[object_array append: htmldoc] ;
	[htmldoc release] ;

	return htmldoc ;
}

- (id <PXMLTree>) loadXmlDocument: (const char *) filename 
  validate: (boolean) dovalid
{
	id <PXMLTree>	xmldoc ;
	u_int		line ;

	xmldoc = [[CXMLTree alloc] init] ;
	[CSystem checkPtr: xmldoc] ;
	if(err_stream){
		[CXMLFactory setErrorHandler: err_stream] ;
	}
	line = [xmldoc loadFile: filename validate: dovalid] ;
	if(line == 0){
		[object_array append: xmldoc] ;
		[xmldoc release] ;
		return xmldoc ;
	} else {
		[xmldoc release] ;
		return nil ;
	}
}

- (id <PXMLTree>) loadHtmlDocument: (const char *) filename 
  validate: (boolean) dovalid
{
	id <PXMLTree>	htmldoc ;
	u_int		line ;

	htmldoc = [[CHTMLTree alloc] init] ;
	[CSystem checkPtr: htmldoc] ;
	if(err_stream){
		[CXMLFactory setErrorHandler: err_stream] ;
	}
	line = [htmldoc loadFile: filename validate: dovalid] ;
	if(line == 0){
		[object_array append: htmldoc] ;
		[htmldoc release] ;
		return htmldoc ;
	} else {
		[htmldoc release] ;
		return nil ;
	}
}

- (id <PError>) saveAll
{
	id result ;
	result = [object_array foreach: @selector(saveFileIfExist) with: nil 
	  with: nil] ;
	return result ? [CError can_not_write] : nil ;
}

- (id <PXMLTree>) searchByInputFileName: (const char *) name
{
	id <PXMLTree>	tree ;
	id <PBasicStr>	input ;
	int		i ;
	
	for(i=0 ; (tree = [object_array item: i]) != nil ; i++){
		input = [tree inputFileName] ;
		if(input && [input comparePtr: name] == 0){
			return tree ;
		}
	}
	return nil ;
}

- (id <PXMLTree>) searchByOutputFileName: (const char *) name
{
	id <PXMLTree>	tree ;
	id <PBasicStr>	output ;
	int		i ;

	for(i=0 ; (tree = [object_array item: i]) != nil ; i++){
		output = [tree outputFileName] ;
		if(output && [output comparePtr: name] == 0){
			return tree ;
		}
	}
	return nil ;
}

- (id <PBasicStr>) searchInputFileNameByNode: (id <PXMLNode>) srcnode
{
	id <PXMLNode>	srcroot ;
	id <PXMLTree>	tree ;
	int		i ;

	if(srcnode == nil)
		return NULL ;
	srcroot = [srcnode rootNode] ;
	for(i=0 ; (tree = [object_array item: i]) != nil ; i++){
		if(tree && [tree rootNode] == srcroot){
			return [tree inputFileName] ;
		}
	}
	return nil ;
}

- (id <PBasicStr>) searchOutputFileNameByNode: (id <PXMLNode>) srcnode
{
	id <PXMLNode>	srcroot ;
	id <PXMLTree>	tree ;
	int		i ;

	if(srcnode == nil)
		return NULL ;
	srcroot = [srcnode rootNode] ;
	for(i=0 ; (tree = [object_array item: i]) != nil ; i++){
		if(tree && [tree rootNode] == srcroot){
			return [tree outputFileName] ;
		}
	}
	return nil ;
}

@end

