/*
 NAME
 	cxmlparser.m - source code for CXMLParser class
 VERSION
 	$Id$
 CHANGELOG
 	$Log$
 */

#include <coconut/cxmlparser.h>
#include <coconut/cconststr.h>
#include <coconut/chash.h>
#include <coconut/cmessage.h>
#include <coconut/dconststr.h>
#include <coconut/fobject.h>
#include <coconut/fxml.h>

@implementation CXMLParser

- init
{
	/* input file name */
	input_name = [[CConstStr alloc] init] ;

	/* hash table for tag names */
	tag_name_table = [[CHash alloc] initHash: g_str_hash
	  equal: &g_str_equal removeKey: &remove_nothing_func
	  removeData: &remove_nothing_func] ;

	/* hash table for attr names */
	attr_name_table = [[CHash alloc] initHash: g_str_hash
	  equal: &g_str_equal removeKey: &remove_nothing_func
	  removeData: &remove_nothing_func] ;

	/* hash table for attr values */
	attr_value_table = [[CHash alloc] initHash: g_str_hash
	  equal: &g_str_equal removeKey: &remove_nothing_func
	  removeData: &remove_nothing_func] ;

	/* verbose mode */
	verbose_mode = FALSE ;

	return [super init] ;
}

- (void) deallc
{
	[tag_name_table release] ;
	[attr_name_table release] ;
	[attr_value_table release] ;
	[input_name release] ;
	[super dealloc] ;
}

- addTagName: (const char *) key value: (int) value
{
	return [tag_name_table add: key data: INT2PTR(value)] ;
}

- addAttrName: (const char *) key value: (int) value
{
	return [attr_name_table add: key data: INT2PTR(value)] ;
}

- addAttrValue: (const char *) key value: (int) value
{
	return [attr_value_table add: key data: INT2PTR(value)] ;
}

- (int) searchTagName: (const char *) key
{
	const void * ptr ;
	ptr = [tag_name_table search: key] ;
	return PTR2INT(ptr) ;
}

- (int) searchAttrName: (const char *) key
{
	const void * ptr ;
	ptr = [attr_name_table search: key] ;
	return PTR2INT(ptr) ;
}

- (int) searchAttrValue: (const char *) key
{
	const void * ptr ;
	ptr = [attr_value_table search: key] ;
	return PTR2INT(ptr) ;
}

- verbose: (id <PXMLNode>) node format: (const char *) form, ...
{
	va_list		args ;

	if(verbose_mode){
		va_start(args, form) ;
		  [CMessage vfmessage: [input_name ptr] lineno: [node lineno]
		    type: note_message code: illegal_format_err
		    format: form valist: args] ;
		va_end(args) ;
	}
	return nil ;
}

- warning: (id <PXMLNode>) node format: (const char *) form, ...
{
	va_list		args ;
	va_start(args, form) ;
	  [CMessage vfmessage: [input_name ptr] lineno: [node lineno]
	    type: warning_message code: illegal_format_err
	    format: form valist: args] ;
	va_end(args) ;
	return nil ;
}

- error: (id <PXMLNode>) node format: (const char *) form, ...
{
	va_list		args ;
	va_start(args, form) ;
	  [CMessage vfmessage: [input_name ptr] lineno: [node lineno]
	    type: error_message code: illegal_format_err
	    format: form valist: args] ;
	va_end(args) ;
	return nil ;
}

- setInputName: (id <PBasicStr>) name
{
	[input_name setStr: name] ;
	return nil ;
}

- setVerboseMode: (boolean) doverbose
{
	verbose_mode = doverbose ;
	return nil ;
}

@end

