/****
 NAME
	cxmlalloc.m - source code for CXMLAlloc class
 VERSION
	$Id$
 CHANGELOG
	$Log$
 */

#include <coconut/cxmlalloc.h>
#include <coconut/csystem.h>
#include <coconut/fxml.h>

@implementation CXMLAlloc

- init
{
	return [super init] ;
}

- (void) dealloc
{
	[super dealloc] ;
}

- (void *) allocate: (size_t) reqsize
{
	return extXmlMalloc(reqsize) ;
}

- (void *) reallocate: (void *) src size: (size_t) reqsize
{
	return extXmlRealloc(src, reqsize) ;
}

- free: (void *) src
{
	extXmlFree(src) ;
	return nil ;
}

- (id <PAllocator>) duplicate
{
	id <PAllocator>	newalloc ;
	newalloc = [[CXMLAlloc alloc] init] ;
	[CSystem checkPtr: newalloc] ;
	return newalloc ;
}

@end

