/*****
 NAME
	cobject.m - source code for CObject class
 VERSION
	$Id$
 CHANGELOG
	$Log$
 */

#include <coconut/cobject.h>
#include <limits.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>

@implementation CObject

- init
{
#	if !defined(__APPLE__)
	retain_count = 1 ;
#	endif
	return [super init] ;
}

- (void) dealloc
{
#	ifdef	__APPLE__
	[super dealloc] ;
#	else
	[super free] ;
#	endif
}

#if !defined(__APPLE__)
- retain
{
	if(retain_count < UINT_MAX-1){
		retain_count++ ;
	}
	return self ;
}

- autorelease
{
	fprintf(stderr, "cobject,autorelease") ;
	return self ;
}

- (oneway void) release
{
	if(retain_count < UINT_MAX){
		if(--retain_count == 0)
			[self dealloc] ;
	}
}

- (unsigned int) retainCount
{
	return retain_count ;
}

#endif  /* !defined(__APPLE__) */

@end

