/****
 NAME
	cmemalloc.m - source code for CMemAlloc class
 VERSION
	$Id$
 CHANGELOG
	$Log$
 */

#include <coconut/cmemalloc.h>
#include <coconut/csystem.h>

@implementation CMemAlloc

+ (void *) allocate: (size_t) size
{
	void *	result ;
	jmp_buf	env ;

	result = g_malloc(size) ;
	if(result == NULL){
		[CSystem getJump: &env] ;
		longjmp(env, (int) no_mem_space_err) ;
	}
	return result ;
}

+ (void *) reallocate: (void *) ptr size: (size_t) size
{
	void *	result ;
	jmp_buf	env ;

	result = g_realloc(ptr, size) ;
	if(result == NULL){
		[CSystem getJump: &env] ;
		longjmp(env, (int) no_mem_space_err) ;
	}
	return result ;
}

+ (void *) duplicate: (const void *) src size: (size_t) size
{
	void *	result ;

	if((result = [CMemAlloc allocate: size]) != NULL && src != NULL)
		g_memmove(result, src, size) ;
	return result ;
}

+ free: (void *) p
{
	g_free(p) ;
	return nil ;
}

- init
{
	return [super init] ;
}

- (void) dealloc
{
	[super dealloc] ;
}

- (void *) allocate: (size_t) reqsize
{
	return [CMemAlloc allocate: reqsize] ;
}

- (void *) reallocate: (void *) src size: (size_t) reqsize
{
	return [CMemAlloc reallocate: src size: reqsize] ;
}

- free: (void *) src
{
	return [CMemAlloc free: src] ;
}

- (id <PAllocator>) duplicate
{
	id <PAllocator>	newalloc ;

	newalloc = [[CMemAlloc alloc] init] ;
	[CSystem checkPtr: newalloc] ;
	return newalloc ;
}

@end

