/*****
 NAME	
 	cindtstream.m - source code for CIndtStream
 VERSION
 	$Id$
 CHANGELOG
 	$Log$
 */

#include <coconut/cindtstream.h>
#include <coconut/cfile.h>
#include <coconut/cstring.h>
#include <coconut/csystem.h>

@implementation CIndtStream

- init
{
	output_stream = [CFile newFile: write_open name: NULL] ;
	[CSystem checkPtr: output_stream] ;
	do_indent = TRUE ;
	return [super init] ;
}

- initIndtStreamWithUnit: (const utf8_char *) unit
{
	output_stream = [CFile newFile: write_open name: NULL] ;
	[CSystem checkPtr: output_stream] ;
	do_indent = TRUE ;
	return [super initIndent: unit] ;
}

- initIndtStream: (id <PStream>) output 
{
	output_stream = output ;
	[output_stream retain] ;
	do_indent = TRUE ;
	return [super init] ;
}

- initIndtStream: (id <PStream>) output unit: (const utf8_char *) unit 
{
	output_stream = output ;
	[output_stream retain] ;
	do_indent = TRUE ;
	return [super initIndent: unit] ;
}

- (void) dealloc
{
	[output_stream release] ;
	[super dealloc] ;
}

- (id <PConstStr>) getLine
{
	g_message("this class is used for output") ;
	return nil ;
}

- (io_status_t) putChar: (utf8_char) c
{
	if(do_indent)
		[output_stream putPtr: [super ptr]] ;
	do_indent = (c == '\n') ;
	return [output_stream putChar: c] ;
}

- (io_status_t) putPtr: (const utf8_char *) ptr length: (u_int) len
{
	if(do_indent)
		[output_stream putPtr: [super ptr]] ;
	do_indent = len > 0 ? (ptr[len-1] == '\n') : FALSE ;
	return [output_stream putPtr: ptr length: len] ;
}

- (io_status_t) putPtr: (const utf8_char *) ptr
{
	return [self putPtr: ptr length: strlen(ptr)] ;
}

- (io_status_t) putStr: (id <PBasicStr>) str
{
	return [self putPtr: [str ptr] length: [str length]] ;
}

- (io_status_t) putFormat: (const utf8_char *) form, ...
{
	id <PString>	str ;
	va_list		args ;
	io_status_t	stat ;

	str = [[CString alloc] init] ;
	  va_start(args, form) ;
	    [str setFormat: form valist: args] ;
	  va_end(args) ;
	  stat = [self putPtr: [str ptr] length: [str length]] ;
	[str release] ;
	return stat ;
}

- (open_t) accessMode
{
	return write_open ;
}

- (boolean) isReadable
{
	return FALSE ;
}

- (boolean) isWritable
{
	return TRUE ;
}

- (io_status_t) flush
{
	return [output_stream flush] ;
}

- (io_status_t) rewind
{
	return io_status_error ;
}

@end

