/*****
 NAME
 	cindent.m - source code for CIndent class
 VERSION
 	$Id$
 CHANGELOG
 	$Log$
 */

#include <coconut/cindent.h>
#include <coconut/cmemory.h>
#include <coconut/cstring.h>
#include <coconut/csystem.h>

#define	CHAR_SIZE	sizeof(utf8_char)

@implementation CIndent

- init
{
	return [self initIndent: " "] ;
}

- initIndent: (const utf8_char *) space
{
	utf8_char *	ptr ;

	indent_level = 0 ;
	indent_line = [[CMemory alloc] initMemoryWithPage: 1024] ;
	[CSystem checkPtr: indent_line] ;
	[indent_line new: 1] ;
	ptr = (utf8_char *) [indent_line ptr] ;
	*ptr = '\0' ;

	space_ptr = [CString duplicate: space] ;
	space_length = [CString length: space_ptr] ;
	return [super init] ;
}

- (void) dealloc
{
	[indent_line release] ;
	[CString free: space_ptr] ;
	[super dealloc] ;
}

- (const utf8_char *) ptr
{
	return (const utf8_char *) [indent_line ptr] ;
}

- (const utf8_char *) unitPtr
{
	return (const utf8_char *) space_ptr ;
}

- (u_int) level
{
	return indent_level ;
}

- incLevel
{
	u_int		curlen ;
	utf8_char *	head ;
	utf8_char *	ptr ;

	[indent_line increaseSize: space_length] ;
	curlen = indent_level * space_length ;
	head = (utf8_char *) [indent_line ptr] ;
	ptr = &(head[curlen]) ; 
	memmove(ptr, space_ptr, space_length) ;
	ptr[space_length] = '\0' ;
	indent_level++ ;
	return nil ;
}

- decLevel
{
	u_int		newlen ;
	utf8_char *	head ;

	if(indent_level == 0)
		return nil ;
	[indent_line decreaseSize: space_length] ;
	newlen = (--indent_level) * space_length ;
	head = (utf8_char *) [indent_line ptr] ;
	head[newlen] = '\0' ;
	return nil ;
}

@end

