/*****
 NAME
 	ceventsystem.m - source code for CEventSystem class
 VERSION
 	$Id$
 CHANGELOG
 	$Log$
 */

#define	EXTERN_EVENT_SYSTEM
#include <coconut/ceventsystem.h>

static id <PEventSystem>	s_event_system = nil ;

@implementation CEventSystem

- init
{
	g_assert(s_event_system == nil) ;
	s_event_system = self ;
	main_loop = g_main_loop_new(NULL, FALSE) ;
	return [super init] ;
}

- (void) dealloc
{
	g_main_loop_unref(main_loop) ;
	[super dealloc] ;
}

- (id <PError>) main
{
	g_main_loop_run(main_loop) ;
	return nil ;
}

- exitMainLoop: (id <PError>) err ;
{
	g_main_loop_quit(main_loop) ;
	return [super exitMainLoop: err] ;
}

- (u_int) getMainLoopNest
{
	return [super getMainLoopNest] ;
}

- (boolean) isRunning
{
	return g_main_loop_is_running(main_loop) ;
}

- (boolean) isPending
{
	return g_main_context_pending(NULL) ;
}

@end

