/*****
 NAME
 	cerror.h - source code for CError class
 VERSION
 	$Id$
 CHANGELOG
 	$Log$
 */

#include <coconut/cerror.h>
#include <errno.h>

static id <PError>	can_not_close_obj ;
static id <PError>	can_not_continue_obj ;
static id <PError>	can_not_happen_obj ;
static id <PError>	can_not_open_obj ;
static id <PError>	can_not_read_obj ;
static id <PError>	can_not_write_obj ;
static id <PError>	exit_obj ;
static id <PError>	illegal_arg_obj ;
static id <PError>	illegal_format_obj ;
static id <PError>	illegal_param_obj ;
static id <PError>	illegal_range_obj ;
static id <PError>	no_arg_obj ;
static id <PError>	not_exist_obj ;
static id <PError>	not_matched_obj ;
static id <PError>	not_supported_obj ;
static id <PError>	not_serious_obj ;
static id <PError>	overflow_obj ;
static id <PError>	system_obj ;
static id <PError>	unknown_obj ;

static id <PError> newError(error_code_t code)
{
	id <PError>	err ;
	err = [[CError alloc] init] ;
	g_assert(err != nil) ;
	[err set: code] ;
	return err ;
}

@implementation CError

+ initialize
{
	can_not_close_obj = newError(can_not_close_err) ;
	can_not_continue_obj = newError(can_not_continue_err) ;
	can_not_happen_obj = newError(can_not_happen_err) ;
	can_not_open_obj = newError(can_not_open_err) ;
	can_not_read_obj = newError(can_not_read_err) ;
	can_not_write_obj = newError(can_not_write_err) ;
	exit_obj = newError(exit_err) ;
	illegal_arg_obj = newError(illegal_arg_err) ;
	illegal_format_obj = newError(illegal_format_err) ;
	illegal_param_obj = newError(illegal_param_err) ;
	illegal_range_obj = newError(illegal_range_err) ;
	no_arg_obj = newError(no_arg_err) ;
	not_exist_obj = newError(not_exist_err) ;
	not_matched_obj = newError(not_matched_err) ;
	not_supported_obj = newError(not_supported_err) ;
	not_serious_obj = newError(not_serious_err) ;
	overflow_obj = newError(overflow_err) ;
	unknown_obj = newError(unknown_err) ;
	system_obj = newError(errno_err) ;
	return nil ;
}

+ (id <PError>) can_not_close
{
	return can_not_close_obj ;
}

+ (id <PError>) can_not_continue
{
	return can_not_continue_obj ;
}

+ (id <PError>) can_not_happen
{
	return can_not_happen_obj ;
}

+ (id <PError>) can_not_open
{
	return can_not_open_obj ;
}

+ (id <PError>) can_not_read
{
	return can_not_read_obj ;
}

+ (id <PError>) can_not_write
{
	return can_not_write_obj ;
}

+ (id <PError>) exit: (int) no
{
	[exit_obj setValue: no] ;
	return exit_obj ;
}

+ (id <PError>) illegal_arg
{
	return illegal_arg_obj ;
}

+ (id <PError>) illegal_format
{
	return illegal_format_obj ;
}

+ (id <PError>) illegal_parameter
{
	return illegal_param_obj ;
}

+ (id <PError>) illegal_range
{
	return illegal_range_obj ;
}

+ (id <PError>) no_arg
{
	return no_arg_obj ;
}

+ (id <PError>) not_exist
{
	return not_exist_obj ;
}

+ (id <PError>) not_matched
{
	return not_matched_obj ;
}

+ (id <PError>) not_supported
{
	return not_supported_obj ;
}

+ (id <PError>) not_serious
{
	return not_serious_obj ;
}

+ (id <PError>) overflow
{
	return overflow_obj ;
}

+ (id <PError>) unknown
{
	return unknown_obj ;
}

+ (id <PError>) system: (int) no
{
	[system_obj setValue: no] ;
	return system_obj ;
}

- init
{
	error_code = unknown_err ;
	return [super init] ;
}

- (void) dealloc
{
	[super dealloc] ;
}

- set: (error_code_t) code
{
	error_code = code ;
	return nil ;
}

- (error_code_t) code
{
	return error_code ;
}

- setValue: (int) val
{
	error_value = val ;
	return nil ;
}

- (int) value
{
	return error_value ;
}

- (exit_code_t) exitCode
{
	exit_code_t	exitcode ;

	switch(error_code){
	  case no_error:
	  	exitcode = normal_exit ;
	  break ;
	  case exit_err: 
	  	exitcode = (error_value == 0) ? 0 : error_exit ;
	  break ;
	  case errno_err:
	  	exitcode = (errno == 0) ? 0 : error_exit ;
	  break ;
	  default:
	  	exitcode = error_exit ;
	  break ;
	}
	return exitcode ;
}

@end

