/*****
 NAME
 	cdate.m - source code for CData class
 VERSION
 	$Id$
 CHANGELOG
 	$Log$
 */

#include <coconut/cdate.h>
#include <coconut/cerror.h>

static const int days_of_month[] =
  {31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31} ;

@implementation CDate 

+ (boolean) isLeapYear: (u_int) year
{
	return (year%4 == 0 && year%100 != 0) || (year % 400 == 0) ;
}

+ (u_int) daysFromMonth: (u_int) year and: (u_int) month
{
	u_int y, m, d ;

	y = year + month / 12 ;
	m = month % 12 ;
	if(m == 2){
		if([CDate isLeapYear: y])
			d = 29 ;
		else
			d = 28 ;
	} else
		d = days_of_month[m-1] ;
	return d ;
}

- init
{
	this_date = g_date_new() ;
	return this_date ? [super init] : nil ;
}

- (void) dealloc
{
	g_date_free(this_date) ;
	[super dealloc] ;
}

- (id <PError>) setDate: (u_int) day month: (u_int) month year: (u_int) year
{
	if(g_date_valid_dmy(day, month, year)){
		g_date_set_dmy(this_date, day, month, year) ;
		return nil ;
	} else
		return [CError illegal_parameter] ;
}

- (u_int) day
{
	return g_date_get_day(this_date) ;
}

- (u_int) month
{
	return g_date_get_month(this_date) ;
}

- (u_int) year
{
	return g_date_get_year(this_date) ;
}

@end

