/*****
 NAME
 	ccmdtext.m - source code for CCmdText class
 VERSION
 	$Id$
 CHANGELOG
 	$Log$
 */

#include <coconut/ccmdtext.h>
#include <coconut/ctext.h>
#include <coconut/cerror.h>

@implementation CCmdText

- init
{
	text_object = [[CText alloc] initText: FALSE] ;
	return [super init] ;
}

- (void) dealloc
{
	[text_object release] ;
	[super release] ;
}

- (command_t) type
{
	return command_text ;
}

- (id <PError>) exec: p1 with: p2
{
	return [[self next] exec: p1 with: p2] ;
}

- appendStr: (id <PBasicStr>) str
{
	[text_object appendStr: str] ;
	return nil ;
}

- appendPtr: (const utf8_char *) text length: (u_int) len
{
	[text_object appendPtr: text length: len] ;
	return nil ;
}

- (id <PText>) text
{
	return text_object ;
}

- print: (id <PIndentStream>) stream
{
	return [text_object print: stream] ;
}

- doPrintWithNewline: (boolean) flag
{
	return [text_object doPrintWithNewline: flag] ;
}

@end

