/*****
 NAME
 	ccmdprint.m - source code for CCmdPrint class
 VERSION
 	$Id$
 CHANGELOG
 	$Log$
 */

#include <coconut/ccmdprint.h>
#include <coconut/cindtstream.h>
#include <coconut/cerror.h>

@implementation CCmdPrint 

- initCmdPrint: (id <PText>) text stream: (id <PStream>) stream 
{
	output_stream = stream ; [output_stream retain] ;
	first_left_spaces = 0 ;
	return [super init] ;
}

- init
{
	output_stream = [[CIndtStream alloc] init] ;
	first_left_spaces = 0 ;
	return [super init] ;
}

- (void) dealloc
{
	[output_stream release] ;
	[super dealloc] ;
}

- (command_t) type
{
	return command_print ;
}

- (id <PError>) exec: p1 with: p2
{
	id <PError>	result ;

	result = [self print: output_stream] ;
	if(result == nil)
		return [[self next] exec: p1 with: p2] ;
	else
		return result ;
}

- setOutput: (id <PStream>) stream
{
	/* close origianl stream */
	[output_stream release] ;
	/* set new stream */
	output_stream = stream ;
	[output_stream retain] ;
	return nil ;
}

- print: (id) stream
{
	id <PCommand>	child ;

	for(child = [self child] ; child ; child = [child next]){
		[child print: stream] ;
	}
	[stream flush] ;
	return nil ;
}

- (u_int) firstLeftSpaces
{
	return first_left_spaces ;
}

- setFirstLeftSpaces: (u_int) spaces 
{
	first_left_spaces = spaces ;
	return nil ;
}

@end

