/*****
 NAME
 	ccmdnum.m - source code for CCmdNum class
 VERSION
 	$Id$
 CHANGELOG
 	$Log$
 */

#include <coconut/ccmdnum.h>

@implementation CCmdNum

- init
{
	cmd_number = nil ;
	return [super init] ;
}

- initCmdNum: (id <PNumber>) num
{
	cmd_number = num ; [cmd_number retain] ;
	return [super init] ;
}

- (void) dealloc
{	
	[cmd_number release] ;
	[super dealloc] ;
}

- (command_t) type
{
	return command_num ;
}

- (id <PError>) exec: p1 with: p2
{
	return [[self next] exec: p1 with: p2] ;
}

- setNum: (id <PNumber>) num
{
	[cmd_number release] ;
	cmd_number = num ;
	return nil ;
}

- (id <PNumber>) number
{
	return cmd_number ;
}

- print: (id <PIndentStream>) stream
{
	return [cmd_number print: stream] ;
}

@end

