/*****
 NAME
 	ccmdexit.m - source code for CCmdExit class
 VERSION
 	$Id$
 CHANGELOG
 	$Log$
 */

#include <coconut/ccmdexit.h>
#include <coconut/cmessage.h>
#include <coconut/csystem.h>
#include <coconut/cerror.h>
#include <coconut/ptext.h>
#include <stdlib.h>

@implementation CCmdExit 

- initCmdExit: (id <PExp>) exp
{
	exit_exp = exp ; [exit_exp retain] ;
	return [super init] ;
}

- init
{
	exit_exp = nil ;
	return [super init] ;
}

- (void) dealloc
{
	[exit_exp release] ;
	[super dealloc] ;
}

- (command_t) type
{
	return command_exit ;
}

- (id <PError>) exec: p1 with: p2
{
	id <PError>	err ;

	fflush(stdout) ; fflush(stderr) ;
	err = [CError exit: [self intValue]] ;
	[CSystem releaseMainLoop: err] ;
	return err ;
}

- setExp: (id <PExp>) exp 
{
	[exit_exp release] ;
	exit_exp = exp ; [exit_exp retain] ;
	return nil ;
}

- (int) intValue
{
	id <PNumber>	num ;
	int		value ;
	if(exit_exp){
		if((num = [exit_exp eval]) != nil)
			value = [num intNum] ;
		else {
			[CMessage message: error_message code: no_effect_err
			  format: "could no get constant value"] ;
			value = 1 ;
		}
	} else
		value = 0 ;
	return value ;
}

#define	STREAM	((id <PIndentStream>) stream)
- print: (id) stream
{
	[STREAM putFormat: "(exit: %d)", [self intValue]] ;
	return nil ;
}

@end

