/*****
 NAME
 	ccmdenv.m - source code for CCmdEnv class
 VERSION
 	$Id$
 CHANGELOG
 	$Log$
 */

#include <coconut/ccmdenv.h>
#include <coconut/cstring.h>
#include <coconut/csystem.h>
#include <coconut/dconststr.h>

@implementation CCmdEnv

- init
{
	env_name = env_value = NULL ;
	return [super init] ;
}

- (void) dealloc
{
	[CString free: env_name] ;
	[CString free: env_value] ;
	[super dealloc] ;
}

- (command_t) type
{
	return command_env ;
}

- setNameAndValue: (const char *) name value: (const char *) value
{
	if(name != NULL)
		[self setName: name] ;
	if(env_name == NULL)
		return nil ;
	if(value){
		[self setValue: value] ;
		return [CSystem setEnv: env_name value: env_value] ;
	} else {
		return [CSystem unsetEnv: env_name] ;
	}
}

- setName: (const char *) name
{
	[CString free: env_name] ;
	env_name = name ? [CString duplicate: name] : NULL ;
	return nil ;
}

- setValue: (const char *) value
{
	[CString free: env_value] ;
	env_value = value ? [CString duplicate: value] : NULL ;
	return nil ;
}

- unsetName: (const char *) name
{
	return [CSystem unsetEnv: env_name] ;
}

- (const char *) name
{
	return env_name ;
}

- (const char *) value
{
	return env_name ? [CSystem getEnv: env_name] : NULL ;
}

- (id <PError>) exec: p1 with: p2
{
	if(env_name && env_value)
		[CSystem setEnv: env_name value: env_value] ;
	return [[self next] exec: p1 with: p2] ;
}

#define	STREAM	((id <PIndentStream>) stream)
- print: (id) stream
{
	const char *	value ;

	if((value = [self value]) != NULL){
		[STREAM putPtr: value] ;
	}
	return nil ;
}

@end

