/*****
 NAME
 	casyncfile.m - source code for CAsyncFile class
 VERSION
 	$Id$
 CHANGELOG
 	$Log$
 */

#include <coconut/casyncfile.h>
#include <coconut/cconststr.h>
#include <coconut/dconststr.h>
#include <unistd.h>

@implementation CAsyncFile 

- init
{
	file_name = [CConstStr newConstStr: UNKNOWN_STR] ;
	return file_name ? [super init] : nil ;
}

- (void) dealloc
{
	[file_name release] ;
	[super dealloc] ;
}

- (id <PError>) openToRead: (const char *) file output: (id <PStream>) output
{
	GIOChannel *		channel ;
	if(file == NULL){
		channel  = g_io_channel_unix_new(STDIN_FILENO) ;
		g_io_channel_set_close_on_unref(channel, FALSE) ;
		[file_name setPtr: STDIN_STR] ;
	} else {
		channel = g_io_channel_new_file(file, "r", NULL) ;
		[file_name setPtr: file] ;
	}
	return [super openChannel: channel input: nil output: output] ;
}

- (id <PError>) openToWrite: (const char *) file input: (id <PStream>) input
{
	GIOChannel *		channel ;
	if(file == NULL){
		channel  = g_io_channel_unix_new(STDOUT_FILENO) ;
		g_io_channel_set_close_on_unref(channel, FALSE) ;
		[file_name setPtr: STDOUT_STR] ;
	} else {
		channel = g_io_channel_new_file(file, "w", NULL) ;
		[file_name setPtr: file] ;
	}
	return [super openChannel: channel input: input output: nil] ;
}

- (id <PError>) close
{
	[file_name setPtr: UNKNOWN_STR] ;
	return [super closeChannel] ;
}

- (id <PConstStr>) fileName
{
	return file_name ;
}

- (id <PConstStr>) fileNameStr
{
	return file_name ;
}

@end

