#include <sys/ioctl.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <fcntl.h>
#include <unistd.h>
#include <string.h>
#include <err.h>

#include <dev/usb/usb.h>

#include "cnxt.h"

int camera_init(int fd)
{
    int	i;
    int ret;
    int *ignore;
    u_int8_t val[LENNUM_MAX];

    /* set interface (altsetting 0) */
    if ( usb_set_interface(fd, 0) < 0 ) {
	return -1;
    }

    ignore = (int *)ignoreURB;
    /* initial spell #1 */
    for ( i=0; i < INIT1_URBS_NUM; i++ ) {
	switch ( rgb24_init1[i].act ) {
	case ACT_WRITE:
	    ret = camera_reg_write(fd, (initURB_t const *)&rgb24_init1[i]);
	    break;
	case ACT_READ:
	    while ( (i > *ignore) && (*ignore >= 0) ) ignore++;	    
	    ret = camera_reg_read(fd, (initURB_t const *)&rgb24_init1[i], val, ((*ignore == i) ? 1 : 0));
	    /*
	     * is configured ?   XXX
	     */
	    if ( i == 5 ) {
		if ( (val[0] & 0x40) == 0x40 ) {
		    fprintf(stderr, "camera has configured\n");
		    ret = usb_set_interface(fd, ISOCH_IFNUM);
		    return ret;
		}
	    }
	    break;
	case ACT_SETIF:
	    ret = usb_set_interface(fd, rgb24_init1[i].idx);
	    break;
	default:
	    fprintf(stderr, "unknown init action: %d\n",i);
	    ret = -1;
	    break;
	}
	if ( ret != 0 ) {
	    fprintf(stderr, "init fail: %d\n",i);
	    break;
	}
    }

    return ret;

}

int camera_init2(int fd)
{
    int i, ret;
    u_int8_t readdat[LENNUM_MAX];

    for ( i = 0; i < INIT2_URBS_NUM; i++ ) {
	switch ( rgb24_init2[i].act ) {
	case ACT_WRITE:
	    ret = camera_reg_write(fd, (initURB_t const *)&rgb24_init2[i]);
	    break;
	case ACT_READ:
	    ret = camera_reg_read(fd, (initURB_t const *)&rgb24_init2[i], readdat, 0);
	    if ( ret != 0 ) {
		fprintf(stderr, "init2: read fail: %d\n",i);
		ret = 0;
	    }
	    break;
	default:
	    fprintf(stderr, "init2: unknown init action: %d\n",i);
	    ret = -1;
	    break;
	}
	if ( ret != 0 ) {
	    fprintf(stderr, "init2: write fail: %d\n",i);
	    break;
	}

    }
    return ret;

}
