/* 
 * CREATIVE WEBCAM Notebook (conexant chip) basic I/F routines
 * Copyright (C) 2004 Takafumi Mizuno <taka-qce@ls-a.jp>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */
/*
 * Credits:
 * Special Thanks to Windows USb Sniffer Project developers.
 */

#include <sys/ioctl.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <fcntl.h>
#include <unistd.h>
#include <errno.h>
#include <string.h>
#include <err.h>

#include <dev/usb/usb.h>

#include "cnxt.h"

/*
 * device probe 
 */
int
usbdev_probe(int fd, struct usb_dev_info *list)
{
    int ret;
    struct usb_device_info udi;

    if (ioctl(fd, USB_GET_DEVICEINFO, &udi) < 0) {
	perror("USB_GET_DEVICEINFO");
	return -1;
    }

    ret = -1;
    while (list->productName != NULL){
	if ((udi.udi_vendorNo == list->vendorNo) && (udi.udi_productNo == list->productNo)) {
	    fprintf(stderr,"%s Found.\n", list->productName);
	    ret = list->returnNo;
	    break;
	}
	list++;
    }

    return ret;
}

int camera_reg_write(int fd, initURB_t const *urb)
{
    struct usb_ctl_request ur;

    ur.ucr_request.bmRequestType = UT_WRITE_VENDOR_DEVICE;
    ur.ucr_request.bRequest = UR_GET_STATUS;

    USETW(ur.ucr_request.wValue, 0); /* always zero */
    USETW(ur.ucr_request.wIndex, urb->idx); /* spec write address */
    USETW(ur.ucr_request.wLength, urb->len); /* spec write data size (bytes)*/
    ur.ucr_data = (void *)urb->data;
/*    ur.ucr_flags = USBD_SHORT_XFER_OK;*/
    ur.ucr_flags = 0;
    ur.ucr_actlen = 0;

    if (ioctl(fd, USB_DO_REQUEST, &ur) < 0) {
	perror("ioctl USB(_DO)_REQUEST");
	return -1;
    }
    
    return 0;

}

/*
 * camera_reg_read
 * return byte stream to *val.
 * Note: *val alloc at leaset more than urb->len.
 */
int camera_reg_read(int fd, initURB_t const *urb, u_int8_t *val, int flag)
{
    int i,ret;
    struct usb_ctl_request ur;

    if ( urb->len > LENNUM_MAX ) return -1;
    if ( val == NULL ) return -1;

    ur.ucr_request.bmRequestType = UT_READ_VENDOR_DEVICE;
    ur.ucr_request.bRequest = UR_GET_STATUS;

    USETW(ur.ucr_request.wValue, 0); /* always zero */
    USETW(ur.ucr_request.wIndex, urb->idx);
    USETW(ur.ucr_request.wLength, urb->len);
    ur.ucr_data = (void *)val;
/*    ur.ucr_flags = USBD_SHORT_XFER_OK;*/
    ur.ucr_flags = 0;
    ur.ucr_actlen = 0;

    if (ioctl(fd, USB_DO_REQUEST, &ur) < 0) {
	perror("ioctl USB_DO_REQUEST");
	return -1;
    }

    ret = 0;
    for ( i = 0; i < urb->len; i++ ) {
	if ( val[i] != urb->data[i] ) {
	    ret = -1;
	    break;
	}
    }

    if ( ret != 0 ) {
	fprintf(stderr,"Expected data: ");
	for ( i = 0; i < urb->len; i++ ) fprintf(stderr,"%x ",urb->data[i]);
	fprintf(stderr,"\nReturned data: ");
	for ( i = 0; i < urb->len; i++ ) fprintf(stderr,"%x ",val[i]);
	fprintf(stderr,"\n");
    }

    if ( flag == 1 ) {
	if ( ret != 0 ) fprintf(stderr,"ignore error, go next step.\n");
	ret = 0;
    }
    return ret;

}

int usb_set_interface(int fd, int alternate)
{
    struct usb_alt_interface alt;	/* interface/alternate selection */

    alt.uai_config_index = USB_CURRENT_CONFIG_INDEX;
    alt.uai_interface_index = 0;
    alt.uai_alt_no = alternate;
    if (ioctl(fd, USB_SET_ALTINTERFACE, &alt) < 0) {
	perror("USB_SET_ALTINTERFACE");
	return -1;
    }
    return 0;
}
