#include <stdio.h>

/*
	Build 'big2ejis_cjk.t' based on 'CJKXRef'

*/
struct code_table {
	char	tbl_name[20];
	int	row;
	int	char_per_row;
	char	*tbl;
	int	loaded;
}  table;

int	debug=0;
unsigned char*build_ejis2big(),*modify_ejis2big(),*init_ejis2big();


main(argc,argv)
int	argc;
char	**argv;
{
	unsigned big,set,code,seq_jis,big5,hi,lo;
	unsigned char	*ejis2big;
	char	c1,c2,b1,b2;

	if(argc>1) debug=1;

if(debug>0) {
	puts(" Translate stdin from Big5 to Ejis based on 'big2ejis_cjk.t'...");
	puts(" Usage: t1 [-d] < big5_file");
	puts("----------- now waiting for your input ----------------");
}

	ejis2big=modify_ejis2big();
	if(ejis2big==NULL) exit(-1);

	while((c1=getchar())!=EOF){
		if(c1&0x80) {
			c2=getchar();

			c1 &= 0x7f;
			c2 &= 0x7f;

			if((c1>=0x21) && (c1<=0x7e) &&
			  (c2>=0x21) && (c2<=0x7e))
				seq_jis = (c1 - 0x21) * 94 + (c2 - 0x21) + 1;
			else
				seq_jis = 9;  /* question mark */

			b1=ejis2big[(seq_jis-1)*2];
			b2=ejis2big[(seq_jis-1)*2+1];

			putchar(b1);
			putchar(b2);
		} else putchar(c1);
	}

	free(ejis2big);

fprintf(stderr,"\n================ Symbol Legend ======================");
fprintf(stderr,"\nHollow circle : No corresponding Big5 code");
fprintf(stderr,"\nHollow square : Jis code not defined in 'cjkref'");

	return (0);
}



unsigned char *
build_ejis2big()
{
	char	s_jis[64],s_big5[64],*tbl;
	unsigned hi,lo,big,index,i,num,row,col;
	int	line;


	tbl = (unsigned char*) calloc(94*94*2,sizeof(unsigned char));
	if(tbl==NULL) {
		fprintf(stderr,"\nError:  Unable to allocate for table ");
		return NULL;
	}
	for(i=0; i<94*94; i++)  {	/* init with hollow square */
		tbl[i*2] = 0xa1;
		tbl[i*2+1] = 0xbc;
	}

	if(init_cjkref(5,3)!=0) return NULL;

	while((line=get_cjkref(s_jis, s_big5))!=EOF) {
		if(s_jis[0]=='*')
			continue;
		else if(s_jis[0]=='I') continue; /* IBM code */
		else if(s_jis[0]=='1') continue; /* 0212 code */
		else if(s_jis[0]=='0') {	 /* 0208 code */
		sscanf(&s_jis[2],"%d",&num);
		row=num/100;
		col=num%100;
		index=(row-1)*94 + (col-1) + 1;
/*
		lo = col-1+0x21;
		hi = row-1+0x21;
		jis= (lo|0x80) + ((hi|0x80)<<8);
*/
		}
		else {
			fprintf(stderr,"\nError(%d):  Undefined jis code = %s", line, s_jis);
			return NULL;
		}

		if(s_big5[0]=='*')
			big=0xa1b3;  /* maru */
		else if(sscanf(s_big5,"%x",&big)==1);
		else {
			fprintf(stderr,"\nError(%d):  Undefined big5 code = %s", line, s_big5);
			return NULL;
		}

		hi = (big & 0xff00 ) >> 8;
		lo = big & 0xff;

		tbl[(index-1)*2]   = hi;
		tbl[(index-1)*2+1] = lo;
	}

	return tbl;
}


unsigned char *
modify_ejis2big()
{
	unsigned char	s_jis[64],s_big5[64],*tbl;
	unsigned hi,lo,big,index,i,num,row,col;
	int	line;


	tbl = init_ejis2big(&table);
	if(tbl==NULL) {
		fprintf(stderr,"\nError:  Unable to allocate for table ");
		return NULL;
	}

	if(init_cjkref(5,3)!=0) return NULL;

	while((line=get_cjkref(s_jis, s_big5))!=EOF) {
		if(s_jis[0]=='*')
			continue;
		else if(s_jis[0]=='I') continue; /* IBM code */
		else if(s_jis[0]=='1') continue; /* 0212 code */
		else if(s_jis[0]=='0') {	 /* 0208 code */
		sscanf(&s_jis[2],"%d",&num);
		row=num/100;
		col=num%100;
		index=(row-1)*94 + (col-1) + 1;
/*
		lo = col-1+0x21;
		hi = row-1+0x21;
		jis= (lo|0x80) + ((hi|0x80)<<8);
*/
		}
		else {
			fprintf(stderr,"\nError(%d):  Undefined jis code = %s", line, s_jis);
			return NULL;
		}

		if(s_big5[0]=='*') {
			big=0xa1b3;  /* maru */
			continue;	/* skip undefined big5 */
		}
		else if(sscanf(s_big5,"%x",&big)==1);
		else {
			fprintf(stderr,"\nError(%d):  Undefined big5 code = %s", line, s_big5);
			return NULL;
		}

		hi = (big & 0xff00 ) >> 8;
		lo = big & 0xff;

		tbl[(index-1)*2]   = hi;
		tbl[(index-1)*2+1] = lo;
	}

	return tbl;
}


/*
	get fields from 'cjkref'

		init_cjkref(from,to)

			field definition for from and to:
				1: unicode  2: gb  3: big5  4: cns  5: jis
				6: ksc  7: eacc  8: cccii  9: xerox

		get_cjkref()
*/

struct s_cjkref {
int	from;
int	to;
int	line;
FILE	*fp;
} cjkref;


init_cjkref(from, to)
int	from,to;
{
	char	c1,c2;

	cjkref.fp=fopen("CJKXRef","r");
	if(cjkref.fp==NULL) {
		fprintf(stderr, "\nError: CJKXRef not found.");
		return -1;
	}
	cjkref.line=0;
	while((c1=fgetc(cjkref.fp))=='#') {
		while((fgetc(cjkref.fp))!='\n');
		cjkref.line++;
	}
	ungetc(c1,cjkref.fp);

	cjkref.from = from;
	cjkref.to = to;

	return 0;
}

get_cjkref(from, to)
char from[],to[];
{
	char 	code[10][64],c;
	int	count;

	count=fscanf(cjkref.fp,"%s %s %s %s %s %s %s %s %s",
		code[1],code[2],code[3],code[4],code[5],
		code[6],code[7],code[8],code[9]);
/*
			s_unicode,s_gb,s_big5,s_cns,s_jis,
			s_ksc,s_eacc,s_cccii,s_xerox
*/
	if(count==EOF)
		return EOF;
	else if(count!=9) {
		fprintf(stderr,"\nError(%d): less than 9 fields read",cjkref.line);
		return -2;
	}

	strcpy(from,code[cjkref.from]);
	strcpy(to,code[cjkref.to]);

	while((fgetc(cjkref.fp))!='\n');
	cjkref.line++;

	return cjkref.line;
}

unsigned char*
init_ejis2big(table)
struct code_table 	*table;
{
	unsigned char *ejis2big,tbl_name[20],c;
	int	k,row,char_per_row,tbl_size;
	FILE	*fp;

	table->loaded = 0;
	/* open the lookup table */
	fp=fopen("jis2big.t","rb");
	if(fp==NULL) {
		fp = fopen("jis2big.tbl","rb");
		if(fp==NULL) return NULL;
		fclose(fp);
		k=system("mktable < ejis2big.tbl > ejis2big.t");
		if(k!=0) return NULL;
		fp=fopen("big2ejis.t","rb");
	}

	fscanf(fp,"%s ( %d x %d )", tbl_name, &row, &char_per_row);
	tbl_size = row * char_per_row * 2;

	strcpy(table->tbl_name,tbl_name);
	table->row = row;
	table->char_per_row = char_per_row;


	/* allocate for the table */
	ejis2big = (unsigned char*) calloc(tbl_size,sizeof(unsigned char));
	if(ejis2big==NULL) return NULL;

	/* fill in the table */
	while((fgetc(fp)) != '\n');

	fread(ejis2big, row, char_per_row*2,fp);

	fclose(fp);

	table->tbl = ejis2big;
	table->loaded=1;

	return ejis2big;
}
