static char version[] = "cn2jp 1.3 (Mar 1, 1996)";

/*
  Copyright (C) 1996      Seke Wei      (seke@sys.es.osaka-u.ac.jp)

  uzpj-util.c: provides the supplementary routines for translation

	unsigned char	*py2uzpj(py)
		;returns corresponding pinyin code for certain uzpj code


	unsigned char	*uzpj2py(uzpj)
		;returns corresponding uzpj code for certain pinyin code

  This program is free for general distribution.

  This program runs on UNIX. You are welcome to port it to other operating
  systems.

*/



#include <stdio.h>
#include "lang-util.h"

extern unsigned char	py_tbl_static[MAX_PY_TBL][MAX_PY_LEN]
			, uzpj_tbl_static[MAX_PY_TBL][MAX_PY_LEN];

unsigned char		*uzpj2py(),*py2uzpj();


struct uzpj_table uzpjtbl_static = {
	MAX_PY_TBL,
	py_tbl_static,
	uzpj_tbl_static,
	1,

	py2uzpj,
	uzpj2py
};

/*
#define MAX_PY_TBL      2066
#define MAX_PY_LEN      10

typedef unsigned char Mnemonic[MAX_PY_LEN];

Mnemonic *py_tbl=NULL;
Mnemonic *uzpj_tbl=NULL;
*/

/*
	Supplementary Routine for Translation
*/

unsigned char	*
py2uzpj(py)
char	*py;
{
	int	i,cmp,upper,lower;


	upper = uzpjtbl.py_size - 1;
	lower = 0;

	while(upper>=lower) {

		i = (upper + lower) / 2;

		cmp = strcmp(py, uzpjtbl.py_tbl[i]);

		if(cmp==0)
			return uzpjtbl.uzpj_tbl[i];
		else if(cmp>0)
			lower = i + 1;
		else
			upper = i - 1;
	}

	return NULL;
}


unsigned char	*
uzpj2py(uzpj)
char	*uzpj;
{
	int	i,cmp;


	for(i=0; i < uzpjtbl.py_size; i++) {

		cmp = strcmp(uzpj, uzpjtbl.uzpj_tbl[i]);

		if(cmp==0)
			return uzpjtbl.py_tbl[i];
	}

	return NULL;
}
