static char version[] = "cn2jp 1.3 (Mar 1, 1996)";

/*
  Copyright (C) 1996      Seke Wei      (seke@sys.es.osaka-u.ac.jp)

  j2b.c: translates any jis code into big5 code

	Usage: j2b [-d]
	       j2b any_jis_file
	       j2b < any_jis_file

	-d: show debug info

	uses a line buffer of 1024 chars
		[] hollow square for Jis codes unused yet
		() hollow circle for Jis codes unmappable to Big5
		?q for non-Jis codes (outside of the Jis code set)
		?m for errors or entries undefined in the main translation table
		?s for errors in the supplementary translation table

  Input:

	a Japanese file in Jis/Shift-Jis/EUC-Jis

  Output:

	returns corresponding Chinese in Big5


  This program is free for general distribution.

  This program runs on UNIX. You are welcome to port it to other operating
  systems.

*/
#include <stdio.h>
#include "lang-util.h"

/*
	Translate any Jis into Big5 based on jis2big.tbl
*/

main(argc,argv)
int     argc;
char    **argv;
{
	char	istr[1024],euc[1024],*ostr;
	char	c1,c2,e1,e2;
	int	ilen,olen,line,i,ojis,candidate_filename_index;
	FILE	*fp;


	lang_debug=candidate_filename_index=0;

	for(i=argc; i>0; i--) {
		if(strcmp(argv[i-1],"-d")==0) lang_debug=1;
		else if(candidate_filename_index==0)
			candidate_filename_index=i-1;
	}

if(lang_debug>0) {
	puts(" Usage: j2b [-d]");
	puts("        j2b any_jis_file");
	puts("        j2b < any_jis_file");
	puts("");
	puts("  j2b translates any Japanese (Jis/EUC-Jis/Shift-Jis) into Chinese (Big5)");
	puts("	uses a line buffer of 1024 chars");
	puts("	[] hollow square for Jis codes unused yet");
	puts("	() hollow circle for Jis codes unmappable to Big5");
	puts("	?q for non-Jis codes (outside of the Jis code set)");
	puts("	?m for errors or entries undefined in the main translation table");
	puts("	?s for errors in the supplementary translation table");
}

	if(candidate_filename_index==0) {
		fp = stdin;
		puts("------- waiting for your input;  use <ctrl-z) to exit ----------------");
	}
	else if(!(fp = fopen(argv[candidate_filename_index],"rt")))
		return -1;


	ilen=line=0;
	while((c1=fgetc(fp))!=EOF){
		/* read a line into istr */
		istr[ilen++]=c1;

		/* translate the line */
		if(c1=='\n') {
			istr[ilen++]=0;
			if(lang_debug) fprintf(stderr,"\n%d:",++line);

			TO_EUC(istr,euc);
			ostr=lang_eucjis_to_big5(euc);
			printf("%s",ostr);
			ilen=0;
		}
	}

	istr[ilen++]=0;
	if(lang_debug) fprintf(stderr,"\n%d:",++line);

	TO_EUC(istr,euc);
	ostr=lang_eucjis_to_big5(istr);
	printf("%s",ostr);

	fclose(fp);

	return 0;
}
