static char version[] = "cn2jp 1.3 (Mar 1, 1996)";

/*
  Copyright (C) 1996      Seke Wei      (seke@sys.es.osaka-u.ac.jp)

  g2b.c:  translates gb code into big5 code

	Usage: g2b [-d] [-u]
	       g2b gb_file
	       g2b < gb_file

	-d: show debug info
	-u: output uzpj for unmappable (pinyin used when unspecified)

	uses a line buffer of 1024 chars
		[] hollow square for GB codes unused yet
		() hollow circle for GB codes unmappable to Big5
		?q for non-GB codes (outside of the GB code set)
		?m for errors or entries undefined in the main translation table
		?s for errors in the supplementary translation table

  Input:

	a Chinese file in GB code

  Output:

	returns corresponding Chinese in Big5


  This program is free for general distribution.

  This program runs on UNIX. You are welcome to port it to other operating
  systems.

*/

#include <stdio.h>
#include "lang-util.h"

/*
	Translate GB into Big5 based on gb2big.t
*/

main(argc,argv)
int     argc;
char    **argv;
{
	char	istr[1024],big[1024],*ostr;
	char	c1,c2,e1,e2;
	int	ilen,olen,line,i,candidate_filename_index;
	FILE	*fp;

	lang_uzpj=lang_debug=candidate_filename_index=0;

	for(i=argc; i>0; i--) {
		if(strcmp(argv[i-1],"-d")==0) lang_debug=1;
		else if(strcmp(argv[i-1],"-u")==0) lang_uzpj=1;
		else if(candidate_filename_index==0)
			candidate_filename_index=i-1;
	}


if(lang_debug>0) {
	puts(" Usage: g2b [-d] [-u]");
	puts("        g2b gb_file");
	puts("        g2b < gb_file");
	puts("  -d: show debug info");
	puts("  -u: output uzpj for unmappable (pinyin used when unspecified)");
	puts("");
	puts("  g2b translates gb code into big5 code");
	puts("	use a line buffer of 1024 chars");
	puts("	[] hollow square for GB codes unused yet");
	puts("	() hollow circle for GB codes unmappable to Big5");
	puts("	?q for non-GB codes (outside of the GB code set)");
	puts("	?m for errors or entries undefined in main translation table");
	puts("	?s for errors in supplementary translation table");
}

	if(candidate_filename_index==0) {
		fp = stdin;
		puts("------- waiting for your input;  use <ctrl-z) to exit ----------------");
	}
	else if(!(fp = fopen(argv[candidate_filename_index],"rt")))
		return -1;

	ilen=line=0;
	while((c1=fgetc(fp))!=EOF){
		/* read a line into istr */
		istr[ilen++]=c1;

		/* translate the line */
		if(c1=='\n') {
			if(lang_debug) fprintf(stderr,"\n%d:", ++line);
			istr[ilen++]=0;

			ostr=lang_gb_to_big5(istr);

			printf("%s",ostr);

			ilen=0;
		}
	}

	if(lang_debug) fprintf(stderr,"\n%d:", ++line);
	istr[ilen++]=0;

	ostr=lang_gb_to_big5(istr);

	printf("%s",ostr);

	fclose(fp);

	return 0;
}
