/* 
    This is to test the library, add node_t nodes and retrieve them in
    different ways.
*/

#include<stdio.h>
#include<stdlib.h>
#include<string.h>

#include "llist.h"
#include "inifile.h"

int main(int argc, char **argv)
{
    INI     theIni;
    INISECT theSect;
    char   *value;
    int     boolreturned;
    char    tag[20];
    int     i;

    if (argc < 2)
    {
        printf("Usage: %s [ini file]\n", argv[0]);
        return(1);
    }

    theIni = ini_create();
    
    ini_load(theIni, argv[1]);

    theSect = ini_getSection(theIni, "sect1");
    if (theSect == NULL) {
        printf("missing section\n");
        exit(1);
    }

    i = 0;
    do {
        sprintf(tag, "string%d", ++i);
        value = ini_getValueStringSect(theIni, theSect, tag);
        printf("Strings: sect1:%s comes out to be '%s'\n", tag, value);
    } while (value != NULL);

    i = 0;
    do {
        sprintf(tag, "bool%d", ++i);
        boolreturned = ini_getValueBoolSect(theIni, theSect, tag, 0);
        printf("Bools: sect1:%s comes out to be %s\n", tag,
                    boolreturned ? "true" : "false");
    } while (i != 5);

    ini_writeFile(theIni, stdout);

    ini_destroy(theIni);

    return(0);
}

#if 0
typedef struct node {
    char *string;
    int num;
} node_t;

void freenode(void *node) {
    node_t *ptr = (node_t*) node;
/*    printf("Freeing %s\n", ptr->string);*/
    free(ptr->string);
    return;
}

void printnode(void *node, int iscur) {
    node_t *ptr = (node_t*) node;

    printf("%2d:%s \"%s\"\n", ptr->num, iscur ? "->" : "  ", ptr->string);
    return;
}

int main(int argc, char **argv)
{
    int i;
    char string[100];
    node_t str, *gotten;
    LLIST list;
    
    if (argc != 3) {
        printf("Please send in start and stop numbers\n");
        exit(0);
    }

    list = ll_create(sizeof(node_t), &freenode);
    ll_prninit(list, &printnode);
    ll_info(list, strdup("The mac daddy of all lists"));

    for (i = atoi(argv[1]); i <= atoi(argv[2]); i++) {
        sprintf(string, "This is value number %d", i);
        str.string = strdup(string);
        str.num = i;
        ll_enqueue(list, &str);
        ll_prnall(list);
        printf("\n");
    }

    printf("%s\n", (char*) ll_info(list, NULL));
    ll_reset(list);
    gotten = (node_t*) ll_prev(list);
    while (gotten != NULL) {
        printf("top: got node with value %2d:\"%s\"\n",
                                        gotten->num, gotten->string);
        ll_prnall(list);
        printf("\n");
        gotten = (node_t*) ll_prev(list);
    }

/*    ll_prnall(list);*/

    ll_reset(list);
    ll_next(list);

    i=20;
    sprintf(string, "This is value number %d", i);
    str.string = strdup(string);
    str.num = i;
    ll_addbeforecur(list, &str);
    ll_prnall(list);
    printf("\n");

    i=30;
    sprintf(string, "This is value number %d", i);
    str.string = strdup(string);
    str.num = i;
    ll_addaftercur(list, &str);
    ll_prnall(list);
    printf("\n");

    ll_reset(list);
    ll_next(list);
    ll_next(list);
    ll_prnprev(list);
    ll_prncur(list);
    ll_prnnext(list);

    printf("The number of elements in the list is %d\n", ll_total(list));

    ll_destroy(list);

    return(0);
}
#endif

/* EOF */