/* Neville's linked list implementation */

/* Meant to use as an array or general purpose list */
/* Has interfaces to use as a stack, or a queue */

#if !defined LLIST_H
#define LLIST_H

#include <stdlib.h>
#include <string.h>

typedef unsigned int un_int;

/* Use this type for readability reasons */
typedef void *LLIST;

#define LLIST_PASS 1
#define LLIST_FAIL 0

/* List creation and destroying calls */
extern LLIST ll_create(un_int size, void (*freefunc) (void *node));
extern void ll_destroy(LLIST list);

/* List management calls */
extern int ll_rmfirst(const LLIST list);
extern int ll_rmlast(const LLIST list);
extern int ll_rmcurr(const LLIST list);
extern void *ll_addlast(const LLIST list, void *element);
extern void *ll_addfirst(const LLIST list, void *element);
extern void *ll_addaftercur(const LLIST list, void *element);
extern void *ll_addbeforecur(const LLIST list, void *element);

/* Use like a queue with enqueue and dequeue */
#define ll_enqueue(a,b) ll_addlast(a,b)
#define ll_dequeue(a) ll_pop(a)

/* Use like a stack with ll_push and ll_pop/ll_pull */
#define     ll_push(a,b) ll_addfirst(a,b)
extern void *ll_pop(const LLIST list);
#define     ll_pull(a) ll_pop(a)

/* List retrieval calls */
extern int  ll_reset(const LLIST list);
extern void *ll_next(const LLIST list);
extern void *ll_prev(const LLIST list);
extern void *ll_data(const LLIST list);
extern void *ll_head(const LLIST list);
extern void *ll_tail(const LLIST list);

/* List info pointer calls */
extern void *ll_info(const LLIST list, void *ptr);

/* List printing calls */
extern int ll_prninit(const LLIST list,
                      void (*prnfunc) (void *node, int iscur));
extern int ll_prncur(const LLIST list);
extern int ll_prnprev(const LLIST list);
extern int ll_prnnext(const LLIST list);
extern int ll_prnall(const LLIST list);

/* Give some of the feel of an array */
extern un_int ll_total(const LLIST list);
extern un_int ll_curnum(const LLIST list);
extern un_int ll_nodenum(const LLIST list, const void *node);
extern void   *ll_getnode(const LLIST inlist, int nodenum);

#endif /* LLIST_H */

/* EOF */
