#include "cmp3.h"

/* Everything that sits in shared memory */

int main(int argc, char **argv)
{
    char *home;
    shmdata_t *shmptr;
    int shmid;
    int i;
    char *ptr;

    home = getenv("HOME");
    shmid = shmget(ftok(home,69),
                   sizeof(shmdata_t),
                   0600);
    if (shmid == -1)
    {
        printf("Cmp3 is not running\n");
        exit(1);
    }
    
    shmptr = (shmdata_t*) shmat(shmid, NULL, 0);
    if (shmptr < 0) {
        perror("shmat");
        exit(1);
    }

    printf("int pid         = %8d - mpg123 process pid\n", shmptr->pid);
	if(kill(shmptr->pid,0)){
		printf("\tWARNING! pid is an orphan\n");
	}
    printf("int managpid    = %8d - manager process pid\n", shmptr->managpid);
	if(kill(shmptr->managpid,0)){
		printf("\tWARNING! managpid is an orphan\n");
	}
    printf("int pause       = %8d - is mpg123 paused\n", shmptr->pause);
    printf("int using       = %8d - number of cmp3's using shm\n", shmptr->using);
    printf("int listlen     = %8d - number of entries in playlist\n", shmptr->listlen);
    printf("int repeat      = %8d - boolean for repeat mode\n", shmptr->repeat);
    if (shmptr->listlen > 0) {
        printf("Playlist:\n");
        ptr = shmptr->plhead;
        for (i = 0; i < shmptr->listlen; i++) {
            printf("           %s\n", ptr);
            ptr += strlen(ptr) + 1;
        }
    }

    if (shmdt((char*)shmptr) < 0)
        perror("shmdt");

    return(0);
}

/* EOF */
