/*
    This file contains all id3 tag reading and writing functions
*/

#include "cmp3funcs.h"
#include "cmp3id3.h"

/****************************************************************************
 *  Read the id3 tag from the songfilename
 *  Returns: 0 on success, -1 on fail, 1 for no tag
 ****************************************************************************/
int readid3(id3info_t *songinfo, char *songfilename)
{
    FILE *songfile;
    char tagloc[3];
    
    songfile = fopen(songfilename, "rb");
    if (!songfile)
    {
        return(-1);
    }
    fseek(songfile, -128, SEEK_END);
    
    fread(tagloc, sizeof(char), 3, songfile);
    if (strncmp(tagloc, "TAG", 3) != 0)
        return(1);
    fread(songinfo->name,    sizeof(char), 30, songfile);
    fread(songinfo->artist,  sizeof(char), 30, songfile);
    fread(songinfo->album,   sizeof(char), 30, songfile);
    fread(songinfo->year,    sizeof(char),  4, songfile);
    fread(songinfo->comment, sizeof(char), 30, songfile);
    songinfo->genre = (char) fgetc(songfile);

    fclose(songfile);    

    songinfo->name[30]      = '\0';
    songinfo->artist[30]    = '\0';
    songinfo->album[30]     = '\0';
    songinfo->year[4]       = '\0';
    songinfo->comment[30]   = '\0';

    return(0);
}
 
 /* EOF */
