// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.21.5
// source: google/api/serviceusage/v1/serviceusage.proto

package serviceusagepb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Enum to determine if service usage should be checked when disabling a
// service.
type DisableServiceRequest_CheckIfServiceHasUsage int32

const (
	// When unset, the default behavior is used, which is SKIP.
	DisableServiceRequest_CHECK_IF_SERVICE_HAS_USAGE_UNSPECIFIED DisableServiceRequest_CheckIfServiceHasUsage = 0
	// If set, skip checking service usage when disabling a service.
	DisableServiceRequest_SKIP DisableServiceRequest_CheckIfServiceHasUsage = 1
	// If set, service usage is checked when disabling the service. If a
	// service, or its dependents, has usage in the last 30 days, the request
	// returns a FAILED_PRECONDITION error.
	DisableServiceRequest_CHECK DisableServiceRequest_CheckIfServiceHasUsage = 2
)

// Enum value maps for DisableServiceRequest_CheckIfServiceHasUsage.
var (
	DisableServiceRequest_CheckIfServiceHasUsage_name = map[int32]string{
		0: "CHECK_IF_SERVICE_HAS_USAGE_UNSPECIFIED",
		1: "SKIP",
		2: "CHECK",
	}
	DisableServiceRequest_CheckIfServiceHasUsage_value = map[string]int32{
		"CHECK_IF_SERVICE_HAS_USAGE_UNSPECIFIED": 0,
		"SKIP":                                   1,
		"CHECK":                                  2,
	}
)

func (x DisableServiceRequest_CheckIfServiceHasUsage) Enum() *DisableServiceRequest_CheckIfServiceHasUsage {
	p := new(DisableServiceRequest_CheckIfServiceHasUsage)
	*p = x
	return p
}

func (x DisableServiceRequest_CheckIfServiceHasUsage) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DisableServiceRequest_CheckIfServiceHasUsage) Descriptor() protoreflect.EnumDescriptor {
	return file_google_api_serviceusage_v1_serviceusage_proto_enumTypes[0].Descriptor()
}

func (DisableServiceRequest_CheckIfServiceHasUsage) Type() protoreflect.EnumType {
	return &file_google_api_serviceusage_v1_serviceusage_proto_enumTypes[0]
}

func (x DisableServiceRequest_CheckIfServiceHasUsage) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DisableServiceRequest_CheckIfServiceHasUsage.Descriptor instead.
func (DisableServiceRequest_CheckIfServiceHasUsage) EnumDescriptor() ([]byte, []int) {
	return file_google_api_serviceusage_v1_serviceusage_proto_rawDescGZIP(), []int{2, 0}
}

// Request message for the `EnableService` method.
type EnableServiceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the consumer and service to enable the service on.
	//
	// The `EnableService` and `DisableService` methods currently only support
	// projects.
	//
	// Enabling a service requires that the service is public or is shared with
	// the user enabling the service.
	//
	// An example name would be:
	// `projects/123/services/serviceusage.googleapis.com` where `123` is the
	// project number.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *EnableServiceRequest) Reset() {
	*x = EnableServiceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_api_serviceusage_v1_serviceusage_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EnableServiceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EnableServiceRequest) ProtoMessage() {}

func (x *EnableServiceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_serviceusage_v1_serviceusage_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EnableServiceRequest.ProtoReflect.Descriptor instead.
func (*EnableServiceRequest) Descriptor() ([]byte, []int) {
	return file_google_api_serviceusage_v1_serviceusage_proto_rawDescGZIP(), []int{0}
}

func (x *EnableServiceRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Response message for the `EnableService` method.
// This response message is assigned to the `response` field of the returned
// Operation when that operation is done.
type EnableServiceResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The new state of the service after enabling.
	Service *Service `protobuf:"bytes,1,opt,name=service,proto3" json:"service,omitempty"`
}

func (x *EnableServiceResponse) Reset() {
	*x = EnableServiceResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_api_serviceusage_v1_serviceusage_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EnableServiceResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EnableServiceResponse) ProtoMessage() {}

func (x *EnableServiceResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_serviceusage_v1_serviceusage_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EnableServiceResponse.ProtoReflect.Descriptor instead.
func (*EnableServiceResponse) Descriptor() ([]byte, []int) {
	return file_google_api_serviceusage_v1_serviceusage_proto_rawDescGZIP(), []int{1}
}

func (x *EnableServiceResponse) GetService() *Service {
	if x != nil {
		return x.Service
	}
	return nil
}

// Request message for the `DisableService` method.
type DisableServiceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the consumer and service to disable the service on.
	//
	// The enable and disable methods currently only support projects.
	//
	// An example name would be:
	// `projects/123/services/serviceusage.googleapis.com` where `123` is the
	// project number.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Indicates if services that are enabled and which depend on this service
	// should also be disabled. If not set, an error will be generated if any
	// enabled services depend on the service to be disabled. When set, the
	// service, and any enabled services that depend on it, will be disabled
	// together.
	DisableDependentServices bool `protobuf:"varint,2,opt,name=disable_dependent_services,json=disableDependentServices,proto3" json:"disable_dependent_services,omitempty"`
	// Defines the behavior for checking service usage when disabling a service.
	CheckIfServiceHasUsage DisableServiceRequest_CheckIfServiceHasUsage `protobuf:"varint,3,opt,name=check_if_service_has_usage,json=checkIfServiceHasUsage,proto3,enum=google.api.serviceusage.v1.DisableServiceRequest_CheckIfServiceHasUsage" json:"check_if_service_has_usage,omitempty"`
}

func (x *DisableServiceRequest) Reset() {
	*x = DisableServiceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_api_serviceusage_v1_serviceusage_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DisableServiceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DisableServiceRequest) ProtoMessage() {}

func (x *DisableServiceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_serviceusage_v1_serviceusage_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DisableServiceRequest.ProtoReflect.Descriptor instead.
func (*DisableServiceRequest) Descriptor() ([]byte, []int) {
	return file_google_api_serviceusage_v1_serviceusage_proto_rawDescGZIP(), []int{2}
}

func (x *DisableServiceRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DisableServiceRequest) GetDisableDependentServices() bool {
	if x != nil {
		return x.DisableDependentServices
	}
	return false
}

func (x *DisableServiceRequest) GetCheckIfServiceHasUsage() DisableServiceRequest_CheckIfServiceHasUsage {
	if x != nil {
		return x.CheckIfServiceHasUsage
	}
	return DisableServiceRequest_CHECK_IF_SERVICE_HAS_USAGE_UNSPECIFIED
}

// Response message for the `DisableService` method.
// This response message is assigned to the `response` field of the returned
// Operation when that operation is done.
type DisableServiceResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The new state of the service after disabling.
	Service *Service `protobuf:"bytes,1,opt,name=service,proto3" json:"service,omitempty"`
}

func (x *DisableServiceResponse) Reset() {
	*x = DisableServiceResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_api_serviceusage_v1_serviceusage_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DisableServiceResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DisableServiceResponse) ProtoMessage() {}

func (x *DisableServiceResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_serviceusage_v1_serviceusage_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DisableServiceResponse.ProtoReflect.Descriptor instead.
func (*DisableServiceResponse) Descriptor() ([]byte, []int) {
	return file_google_api_serviceusage_v1_serviceusage_proto_rawDescGZIP(), []int{3}
}

func (x *DisableServiceResponse) GetService() *Service {
	if x != nil {
		return x.Service
	}
	return nil
}

// Request message for the `GetService` method.
type GetServiceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the consumer and service to get the `ConsumerState` for.
	//
	// An example name would be:
	// `projects/123/services/serviceusage.googleapis.com` where `123` is the
	// project number.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetServiceRequest) Reset() {
	*x = GetServiceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_api_serviceusage_v1_serviceusage_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetServiceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetServiceRequest) ProtoMessage() {}

func (x *GetServiceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_serviceusage_v1_serviceusage_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetServiceRequest.ProtoReflect.Descriptor instead.
func (*GetServiceRequest) Descriptor() ([]byte, []int) {
	return file_google_api_serviceusage_v1_serviceusage_proto_rawDescGZIP(), []int{4}
}

func (x *GetServiceRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for the `ListServices` method.
type ListServicesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Parent to search for services on.
	//
	// An example name would be:
	// `projects/123` where `123` is the project number.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Requested size of the next page of data.
	// Requested page size cannot exceed 200.
	// If not set, the default page size is 50.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Token identifying which result to start with, which is returned by a
	// previous list call.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Only list services that conform to the given filter.
	// The allowed filter strings are `state:ENABLED` and `state:DISABLED`.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListServicesRequest) Reset() {
	*x = ListServicesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_api_serviceusage_v1_serviceusage_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListServicesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListServicesRequest) ProtoMessage() {}

func (x *ListServicesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_serviceusage_v1_serviceusage_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListServicesRequest.ProtoReflect.Descriptor instead.
func (*ListServicesRequest) Descriptor() ([]byte, []int) {
	return file_google_api_serviceusage_v1_serviceusage_proto_rawDescGZIP(), []int{5}
}

func (x *ListServicesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListServicesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListServicesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListServicesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// Response message for the `ListServices` method.
type ListServicesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The available services for the requested project.
	Services []*Service `protobuf:"bytes,1,rep,name=services,proto3" json:"services,omitempty"`
	// Token that can be passed to `ListServices` to resume a paginated
	// query.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListServicesResponse) Reset() {
	*x = ListServicesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_api_serviceusage_v1_serviceusage_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListServicesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListServicesResponse) ProtoMessage() {}

func (x *ListServicesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_serviceusage_v1_serviceusage_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListServicesResponse.ProtoReflect.Descriptor instead.
func (*ListServicesResponse) Descriptor() ([]byte, []int) {
	return file_google_api_serviceusage_v1_serviceusage_proto_rawDescGZIP(), []int{6}
}

func (x *ListServicesResponse) GetServices() []*Service {
	if x != nil {
		return x.Services
	}
	return nil
}

func (x *ListServicesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for the `BatchEnableServices` method.
type BatchEnableServicesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Parent to enable services on.
	//
	// An example name would be:
	// `projects/123` where `123` is the project number.
	//
	// The `BatchEnableServices` method currently only supports projects.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The identifiers of the services to enable on the project.
	//
	// A valid identifier would be:
	// serviceusage.googleapis.com
	//
	// Enabling services requires that each service is public or is shared with
	// the user enabling the service.
	//
	// A single request can enable a maximum of 20 services at a time. If more
	// than 20 services are specified, the request will fail, and no state changes
	// will occur.
	ServiceIds []string `protobuf:"bytes,2,rep,name=service_ids,json=serviceIds,proto3" json:"service_ids,omitempty"`
}

func (x *BatchEnableServicesRequest) Reset() {
	*x = BatchEnableServicesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_api_serviceusage_v1_serviceusage_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchEnableServicesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchEnableServicesRequest) ProtoMessage() {}

func (x *BatchEnableServicesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_serviceusage_v1_serviceusage_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchEnableServicesRequest.ProtoReflect.Descriptor instead.
func (*BatchEnableServicesRequest) Descriptor() ([]byte, []int) {
	return file_google_api_serviceusage_v1_serviceusage_proto_rawDescGZIP(), []int{7}
}

func (x *BatchEnableServicesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *BatchEnableServicesRequest) GetServiceIds() []string {
	if x != nil {
		return x.ServiceIds
	}
	return nil
}

// Response message for the `BatchEnableServices` method.
// This response message is assigned to the `response` field of the returned
// Operation when that operation is done.
type BatchEnableServicesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The new state of the services after enabling.
	Services []*Service `protobuf:"bytes,1,rep,name=services,proto3" json:"services,omitempty"`
	// If allow_partial_success is true, and one or more services could not be
	// enabled, this field contains the details about each failure.
	Failures []*BatchEnableServicesResponse_EnableFailure `protobuf:"bytes,2,rep,name=failures,proto3" json:"failures,omitempty"`
}

func (x *BatchEnableServicesResponse) Reset() {
	*x = BatchEnableServicesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_api_serviceusage_v1_serviceusage_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchEnableServicesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchEnableServicesResponse) ProtoMessage() {}

func (x *BatchEnableServicesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_serviceusage_v1_serviceusage_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchEnableServicesResponse.ProtoReflect.Descriptor instead.
func (*BatchEnableServicesResponse) Descriptor() ([]byte, []int) {
	return file_google_api_serviceusage_v1_serviceusage_proto_rawDescGZIP(), []int{8}
}

func (x *BatchEnableServicesResponse) GetServices() []*Service {
	if x != nil {
		return x.Services
	}
	return nil
}

func (x *BatchEnableServicesResponse) GetFailures() []*BatchEnableServicesResponse_EnableFailure {
	if x != nil {
		return x.Failures
	}
	return nil
}

// Request message for the `BatchGetServices` method.
type BatchGetServicesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Parent to retrieve services from.
	// If this is set, the parent of all of the services specified in `names` must
	// match this field. An example name would be: `projects/123` where `123` is
	// the project number. The `BatchGetServices` method currently only supports
	// projects.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Names of the services to retrieve.
	//
	// An example name would be:
	// `projects/123/services/serviceusage.googleapis.com` where `123` is the
	// project number.
	// A single request can get a maximum of 30 services at a time.
	Names []string `protobuf:"bytes,2,rep,name=names,proto3" json:"names,omitempty"`
}

func (x *BatchGetServicesRequest) Reset() {
	*x = BatchGetServicesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_api_serviceusage_v1_serviceusage_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchGetServicesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchGetServicesRequest) ProtoMessage() {}

func (x *BatchGetServicesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_serviceusage_v1_serviceusage_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchGetServicesRequest.ProtoReflect.Descriptor instead.
func (*BatchGetServicesRequest) Descriptor() ([]byte, []int) {
	return file_google_api_serviceusage_v1_serviceusage_proto_rawDescGZIP(), []int{9}
}

func (x *BatchGetServicesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *BatchGetServicesRequest) GetNames() []string {
	if x != nil {
		return x.Names
	}
	return nil
}

// Response message for the `BatchGetServices` method.
type BatchGetServicesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The requested Service states.
	Services []*Service `protobuf:"bytes,1,rep,name=services,proto3" json:"services,omitempty"`
}

func (x *BatchGetServicesResponse) Reset() {
	*x = BatchGetServicesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_api_serviceusage_v1_serviceusage_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchGetServicesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchGetServicesResponse) ProtoMessage() {}

func (x *BatchGetServicesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_serviceusage_v1_serviceusage_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchGetServicesResponse.ProtoReflect.Descriptor instead.
func (*BatchGetServicesResponse) Descriptor() ([]byte, []int) {
	return file_google_api_serviceusage_v1_serviceusage_proto_rawDescGZIP(), []int{10}
}

func (x *BatchGetServicesResponse) GetServices() []*Service {
	if x != nil {
		return x.Services
	}
	return nil
}

// Provides error messages for the failing services.
type BatchEnableServicesResponse_EnableFailure struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The service id of a service that could not be enabled.
	ServiceId string `protobuf:"bytes,1,opt,name=service_id,json=serviceId,proto3" json:"service_id,omitempty"`
	// An error message describing why the service could not be enabled.
	ErrorMessage string `protobuf:"bytes,2,opt,name=error_message,json=errorMessage,proto3" json:"error_message,omitempty"`
}

func (x *BatchEnableServicesResponse_EnableFailure) Reset() {
	*x = BatchEnableServicesResponse_EnableFailure{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_api_serviceusage_v1_serviceusage_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchEnableServicesResponse_EnableFailure) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchEnableServicesResponse_EnableFailure) ProtoMessage() {}

func (x *BatchEnableServicesResponse_EnableFailure) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_serviceusage_v1_serviceusage_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchEnableServicesResponse_EnableFailure.ProtoReflect.Descriptor instead.
func (*BatchEnableServicesResponse_EnableFailure) Descriptor() ([]byte, []int) {
	return file_google_api_serviceusage_v1_serviceusage_proto_rawDescGZIP(), []int{8, 0}
}

func (x *BatchEnableServicesResponse_EnableFailure) GetServiceId() string {
	if x != nil {
		return x.ServiceId
	}
	return ""
}

func (x *BatchEnableServicesResponse_EnableFailure) GetErrorMessage() string {
	if x != nil {
		return x.ErrorMessage
	}
	return ""
}

var File_google_api_serviceusage_v1_serviceusage_proto protoreflect.FileDescriptor

var file_google_api_serviceusage_v1_serviceusage_proto_rawDesc = []byte{
	0x0a, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x75, 0x73, 0x61, 0x67, 0x65, 0x2f, 0x76, 0x31, 0x2f, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x75, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x1a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x75, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2a, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x75, 0x73, 0x61,
	0x67, 0x65, 0x2f, 0x76, 0x31, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f,
	0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x22, 0x2a, 0x0a, 0x14, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22,
	0x56, 0x0a, 0x15, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3d, 0x0a, 0x07, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x75, 0x73,
	0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x52, 0x07,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x22, 0xcb, 0x02, 0x0a, 0x15, 0x44, 0x69, 0x73, 0x61,
	0x62, 0x6c, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x3c, 0x0a, 0x1a, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65,
	0x5f, 0x64, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x18, 0x64, 0x69, 0x73, 0x61, 0x62,
	0x6c, 0x65, 0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x73, 0x12, 0x84, 0x01, 0x0a, 0x1a, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x5f, 0x69, 0x66,
	0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x68, 0x61, 0x73, 0x5f, 0x75, 0x73, 0x61,
	0x67, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x75, 0x73, 0x61,
	0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x43, 0x68, 0x65, 0x63,
	0x6b, 0x49, 0x66, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x48, 0x61, 0x73, 0x55, 0x73, 0x61,
	0x67, 0x65, 0x52, 0x16, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x49, 0x66, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x48, 0x61, 0x73, 0x55, 0x73, 0x61, 0x67, 0x65, 0x22, 0x59, 0x0a, 0x16, 0x43, 0x68,
	0x65, 0x63, 0x6b, 0x49, 0x66, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x48, 0x61, 0x73, 0x55,
	0x73, 0x61, 0x67, 0x65, 0x12, 0x2a, 0x0a, 0x26, 0x43, 0x48, 0x45, 0x43, 0x4b, 0x5f, 0x49, 0x46,
	0x5f, 0x53, 0x45, 0x52, 0x56, 0x49, 0x43, 0x45, 0x5f, 0x48, 0x41, 0x53, 0x5f, 0x55, 0x53, 0x41,
	0x47, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x08, 0x0a, 0x04, 0x53, 0x4b, 0x49, 0x50, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x43, 0x48,
	0x45, 0x43, 0x4b, 0x10, 0x02, 0x22, 0x57, 0x0a, 0x16, 0x44, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x3d, 0x0a, 0x07, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x75, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x52, 0x07, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x22, 0x27,
	0x0a, 0x11, 0x47, 0x65, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x81, 0x01, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x16, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65,
	0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0x7f, 0x0a, 0x14, 0x4c,
	0x69, 0x73, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x3f, 0x0a, 0x08, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x70, 0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x75, 0x73, 0x61, 0x67, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x52, 0x08, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e,
	0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x55, 0x0a, 0x1a,
	0x42, 0x61, 0x74, 0x63, 0x68, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x69, 0x64,
	0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0a, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x49, 0x64, 0x73, 0x22, 0x96, 0x02, 0x0a, 0x1b, 0x42, 0x61, 0x74, 0x63, 0x68, 0x45, 0x6e, 0x61,
	0x62, 0x6c, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x3f, 0x0a, 0x08, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x70, 0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x75, 0x73, 0x61, 0x67, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x52, 0x08, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x73, 0x12, 0x61, 0x0a, 0x08, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x73,
	0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x70, 0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x75, 0x73, 0x61, 0x67, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e,
	0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x52, 0x08, 0x66,
	0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x73, 0x1a, 0x53, 0x0a, 0x0d, 0x45, 0x6e, 0x61, 0x62, 0x6c,
	0x65, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x49, 0x64, 0x12, 0x23, 0x0a, 0x0d, 0x65, 0x72, 0x72, 0x6f, 0x72,
	0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c,
	0x65, 0x72, 0x72, 0x6f, 0x72, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x22, 0x47, 0x0a, 0x17,
	0x42, 0x61, 0x74, 0x63, 0x68, 0x47, 0x65, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x14, 0x0a, 0x05, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x05,
	0x6e, 0x61, 0x6d, 0x65, 0x73, 0x22, 0x5b, 0x0a, 0x18, 0x42, 0x61, 0x74, 0x63, 0x68, 0x47, 0x65,
	0x74, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x3f, 0x0a, 0x08, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69,
	0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x75, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x52, 0x08, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x73, 0x32, 0xe8, 0x09, 0x0a, 0x0c, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x55, 0x73,
	0x61, 0x67, 0x65, 0x12, 0xba, 0x01, 0x0a, 0x0d, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x70, 0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x75, 0x73, 0x61, 0x67, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x58, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x25, 0x22, 0x20,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x2a, 0x2f, 0x2a, 0x2f, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65,
	0x3a, 0x01, 0x2a, 0xca, 0x41, 0x2a, 0x0a, 0x15, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x11, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x12, 0xbe, 0x01, 0x0a, 0x0e, 0x44, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x12, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69,
	0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x75, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x5a, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x26, 0x22, 0x21, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x2a, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65,
	0x3a, 0x01, 0x2a, 0xca, 0x41, 0x2b, 0x0a, 0x16, 0x44, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x11,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x12, 0x83, 0x01, 0x0a, 0x0a, 0x47, 0x65, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x12, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x75, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65,
	0x74, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x75, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x22, 0x21, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x1b, 0x12, 0x19, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x2a, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x94, 0x01, 0x0a, 0x0c, 0x4c, 0x69, 0x73, 0x74,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x75, 0x73, 0x61,
	0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x75, 0x73,
	0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x21, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x1b, 0x12, 0x19, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x2a, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x12, 0xd1,
	0x01, 0x0a, 0x13, 0x42, 0x61, 0x74, 0x63, 0x68, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x70, 0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x75, 0x73, 0x61, 0x67, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e,
	0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x63, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x2a, 0x22, 0x25, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x2a, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73,
	0x3a, 0x62, 0x61, 0x74, 0x63, 0x68, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x3a, 0x01, 0x2a, 0xca,
	0x41, 0x30, 0x0a, 0x1b, 0x42, 0x61, 0x74, 0x63, 0x68, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x12, 0xa9, 0x01, 0x0a, 0x10, 0x42, 0x61, 0x74, 0x63, 0x68, 0x47, 0x65, 0x74, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x70, 0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x75, 0x73, 0x61, 0x67,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x47, 0x65, 0x74, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x34, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x75, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x47,
	0x65, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x2a, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x24, 0x12, 0x22, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x2a, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x73, 0x3a, 0x62, 0x61, 0x74, 0x63, 0x68, 0x47, 0x65, 0x74, 0x1a, 0xbc,
	0x01, 0xca, 0x41, 0x1b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x75, 0x73, 0x61, 0x67, 0x65,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2,
	0x41, 0x9a, 0x01, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75,
	0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74,
	0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x72, 0x65, 0x61, 0x64, 0x2d, 0x6f, 0x6e, 0x6c, 0x79, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73,
	0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x42, 0xdd, 0x01,
	0x0a, 0x1e, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69,
	0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x75, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31,
	0x42, 0x11, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x55, 0x73, 0x61, 0x67, 0x65, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x46, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f,
	0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x75, 0x73, 0x61, 0x67, 0x65, 0x2f, 0x76, 0x31,
	0x3b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x75, 0x73, 0x61, 0x67, 0x65, 0xaa, 0x02, 0x1c,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x55, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x1c, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x55, 0x73, 0x61, 0x67, 0x65, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x1f, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x55, 0x73, 0x61, 0x67, 0x65, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_api_serviceusage_v1_serviceusage_proto_rawDescOnce sync.Once
	file_google_api_serviceusage_v1_serviceusage_proto_rawDescData = file_google_api_serviceusage_v1_serviceusage_proto_rawDesc
)

func file_google_api_serviceusage_v1_serviceusage_proto_rawDescGZIP() []byte {
	file_google_api_serviceusage_v1_serviceusage_proto_rawDescOnce.Do(func() {
		file_google_api_serviceusage_v1_serviceusage_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_api_serviceusage_v1_serviceusage_proto_rawDescData)
	})
	return file_google_api_serviceusage_v1_serviceusage_proto_rawDescData
}

var file_google_api_serviceusage_v1_serviceusage_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_api_serviceusage_v1_serviceusage_proto_msgTypes = make([]protoimpl.MessageInfo, 12)
var file_google_api_serviceusage_v1_serviceusage_proto_goTypes = []interface{}{
	(DisableServiceRequest_CheckIfServiceHasUsage)(0), // 0: google.api.serviceusage.v1.DisableServiceRequest.CheckIfServiceHasUsage
	(*EnableServiceRequest)(nil),                      // 1: google.api.serviceusage.v1.EnableServiceRequest
	(*EnableServiceResponse)(nil),                     // 2: google.api.serviceusage.v1.EnableServiceResponse
	(*DisableServiceRequest)(nil),                     // 3: google.api.serviceusage.v1.DisableServiceRequest
	(*DisableServiceResponse)(nil),                    // 4: google.api.serviceusage.v1.DisableServiceResponse
	(*GetServiceRequest)(nil),                         // 5: google.api.serviceusage.v1.GetServiceRequest
	(*ListServicesRequest)(nil),                       // 6: google.api.serviceusage.v1.ListServicesRequest
	(*ListServicesResponse)(nil),                      // 7: google.api.serviceusage.v1.ListServicesResponse
	(*BatchEnableServicesRequest)(nil),                // 8: google.api.serviceusage.v1.BatchEnableServicesRequest
	(*BatchEnableServicesResponse)(nil),               // 9: google.api.serviceusage.v1.BatchEnableServicesResponse
	(*BatchGetServicesRequest)(nil),                   // 10: google.api.serviceusage.v1.BatchGetServicesRequest
	(*BatchGetServicesResponse)(nil),                  // 11: google.api.serviceusage.v1.BatchGetServicesResponse
	(*BatchEnableServicesResponse_EnableFailure)(nil), // 12: google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailure
	(*Service)(nil),                                   // 13: google.api.serviceusage.v1.Service
	(*longrunning.Operation)(nil),                     // 14: google.longrunning.Operation
}
var file_google_api_serviceusage_v1_serviceusage_proto_depIdxs = []int32{
	13, // 0: google.api.serviceusage.v1.EnableServiceResponse.service:type_name -> google.api.serviceusage.v1.Service
	0,  // 1: google.api.serviceusage.v1.DisableServiceRequest.check_if_service_has_usage:type_name -> google.api.serviceusage.v1.DisableServiceRequest.CheckIfServiceHasUsage
	13, // 2: google.api.serviceusage.v1.DisableServiceResponse.service:type_name -> google.api.serviceusage.v1.Service
	13, // 3: google.api.serviceusage.v1.ListServicesResponse.services:type_name -> google.api.serviceusage.v1.Service
	13, // 4: google.api.serviceusage.v1.BatchEnableServicesResponse.services:type_name -> google.api.serviceusage.v1.Service
	12, // 5: google.api.serviceusage.v1.BatchEnableServicesResponse.failures:type_name -> google.api.serviceusage.v1.BatchEnableServicesResponse.EnableFailure
	13, // 6: google.api.serviceusage.v1.BatchGetServicesResponse.services:type_name -> google.api.serviceusage.v1.Service
	1,  // 7: google.api.serviceusage.v1.ServiceUsage.EnableService:input_type -> google.api.serviceusage.v1.EnableServiceRequest
	3,  // 8: google.api.serviceusage.v1.ServiceUsage.DisableService:input_type -> google.api.serviceusage.v1.DisableServiceRequest
	5,  // 9: google.api.serviceusage.v1.ServiceUsage.GetService:input_type -> google.api.serviceusage.v1.GetServiceRequest
	6,  // 10: google.api.serviceusage.v1.ServiceUsage.ListServices:input_type -> google.api.serviceusage.v1.ListServicesRequest
	8,  // 11: google.api.serviceusage.v1.ServiceUsage.BatchEnableServices:input_type -> google.api.serviceusage.v1.BatchEnableServicesRequest
	10, // 12: google.api.serviceusage.v1.ServiceUsage.BatchGetServices:input_type -> google.api.serviceusage.v1.BatchGetServicesRequest
	14, // 13: google.api.serviceusage.v1.ServiceUsage.EnableService:output_type -> google.longrunning.Operation
	14, // 14: google.api.serviceusage.v1.ServiceUsage.DisableService:output_type -> google.longrunning.Operation
	13, // 15: google.api.serviceusage.v1.ServiceUsage.GetService:output_type -> google.api.serviceusage.v1.Service
	7,  // 16: google.api.serviceusage.v1.ServiceUsage.ListServices:output_type -> google.api.serviceusage.v1.ListServicesResponse
	14, // 17: google.api.serviceusage.v1.ServiceUsage.BatchEnableServices:output_type -> google.longrunning.Operation
	11, // 18: google.api.serviceusage.v1.ServiceUsage.BatchGetServices:output_type -> google.api.serviceusage.v1.BatchGetServicesResponse
	13, // [13:19] is the sub-list for method output_type
	7,  // [7:13] is the sub-list for method input_type
	7,  // [7:7] is the sub-list for extension type_name
	7,  // [7:7] is the sub-list for extension extendee
	0,  // [0:7] is the sub-list for field type_name
}

func init() { file_google_api_serviceusage_v1_serviceusage_proto_init() }
func file_google_api_serviceusage_v1_serviceusage_proto_init() {
	if File_google_api_serviceusage_v1_serviceusage_proto != nil {
		return
	}
	file_google_api_serviceusage_v1_resources_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_api_serviceusage_v1_serviceusage_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EnableServiceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_api_serviceusage_v1_serviceusage_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EnableServiceResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_api_serviceusage_v1_serviceusage_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DisableServiceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_api_serviceusage_v1_serviceusage_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DisableServiceResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_api_serviceusage_v1_serviceusage_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetServiceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_api_serviceusage_v1_serviceusage_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListServicesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_api_serviceusage_v1_serviceusage_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListServicesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_api_serviceusage_v1_serviceusage_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchEnableServicesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_api_serviceusage_v1_serviceusage_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchEnableServicesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_api_serviceusage_v1_serviceusage_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchGetServicesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_api_serviceusage_v1_serviceusage_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchGetServicesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_api_serviceusage_v1_serviceusage_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchEnableServicesResponse_EnableFailure); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_api_serviceusage_v1_serviceusage_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   12,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_api_serviceusage_v1_serviceusage_proto_goTypes,
		DependencyIndexes: file_google_api_serviceusage_v1_serviceusage_proto_depIdxs,
		EnumInfos:         file_google_api_serviceusage_v1_serviceusage_proto_enumTypes,
		MessageInfos:      file_google_api_serviceusage_v1_serviceusage_proto_msgTypes,
	}.Build()
	File_google_api_serviceusage_v1_serviceusage_proto = out.File
	file_google_api_serviceusage_v1_serviceusage_proto_rawDesc = nil
	file_google_api_serviceusage_v1_serviceusage_proto_goTypes = nil
	file_google_api_serviceusage_v1_serviceusage_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// ServiceUsageClient is the client API for ServiceUsage service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ServiceUsageClient interface {
	// Enable a service so that it can be used with a project.
	EnableService(ctx context.Context, in *EnableServiceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Disable a service so that it can no longer be used with a project.
	// This prevents unintended usage that may cause unexpected billing
	// charges or security leaks.
	//
	// It is not valid to call the disable method on a service that is not
	// currently enabled. Callers will receive a `FAILED_PRECONDITION` status if
	// the target service is not currently enabled.
	DisableService(ctx context.Context, in *DisableServiceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Returns the service configuration and enabled state for a given service.
	GetService(ctx context.Context, in *GetServiceRequest, opts ...grpc.CallOption) (*Service, error)
	// List all services available to the specified project, and the current
	// state of those services with respect to the project. The list includes
	// all public services, all services for which the calling user has the
	// `servicemanagement.services.bind` permission, and all services that have
	// already been enabled on the project. The list can be filtered to
	// only include services in a specific state, for example to only include
	// services enabled on the project.
	//
	// WARNING: If you need to query enabled services frequently or across
	// an organization, you should use
	// [Cloud Asset Inventory
	// API](https://cloud.google.com/asset-inventory/docs/apis), which provides
	// higher throughput and richer filtering capability.
	ListServices(ctx context.Context, in *ListServicesRequest, opts ...grpc.CallOption) (*ListServicesResponse, error)
	// Enable multiple services on a project. The operation is atomic: if enabling
	// any service fails, then the entire batch fails, and no state changes occur.
	// To enable a single service, use the `EnableService` method instead.
	BatchEnableServices(ctx context.Context, in *BatchEnableServicesRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Returns the service configurations and enabled states for a given list of
	// services.
	BatchGetServices(ctx context.Context, in *BatchGetServicesRequest, opts ...grpc.CallOption) (*BatchGetServicesResponse, error)
}

type serviceUsageClient struct {
	cc grpc.ClientConnInterface
}

func NewServiceUsageClient(cc grpc.ClientConnInterface) ServiceUsageClient {
	return &serviceUsageClient{cc}
}

func (c *serviceUsageClient) EnableService(ctx context.Context, in *EnableServiceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.api.serviceusage.v1.ServiceUsage/EnableService", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceUsageClient) DisableService(ctx context.Context, in *DisableServiceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.api.serviceusage.v1.ServiceUsage/DisableService", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceUsageClient) GetService(ctx context.Context, in *GetServiceRequest, opts ...grpc.CallOption) (*Service, error) {
	out := new(Service)
	err := c.cc.Invoke(ctx, "/google.api.serviceusage.v1.ServiceUsage/GetService", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceUsageClient) ListServices(ctx context.Context, in *ListServicesRequest, opts ...grpc.CallOption) (*ListServicesResponse, error) {
	out := new(ListServicesResponse)
	err := c.cc.Invoke(ctx, "/google.api.serviceusage.v1.ServiceUsage/ListServices", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceUsageClient) BatchEnableServices(ctx context.Context, in *BatchEnableServicesRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.api.serviceusage.v1.ServiceUsage/BatchEnableServices", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceUsageClient) BatchGetServices(ctx context.Context, in *BatchGetServicesRequest, opts ...grpc.CallOption) (*BatchGetServicesResponse, error) {
	out := new(BatchGetServicesResponse)
	err := c.cc.Invoke(ctx, "/google.api.serviceusage.v1.ServiceUsage/BatchGetServices", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ServiceUsageServer is the server API for ServiceUsage service.
type ServiceUsageServer interface {
	// Enable a service so that it can be used with a project.
	EnableService(context.Context, *EnableServiceRequest) (*longrunning.Operation, error)
	// Disable a service so that it can no longer be used with a project.
	// This prevents unintended usage that may cause unexpected billing
	// charges or security leaks.
	//
	// It is not valid to call the disable method on a service that is not
	// currently enabled. Callers will receive a `FAILED_PRECONDITION` status if
	// the target service is not currently enabled.
	DisableService(context.Context, *DisableServiceRequest) (*longrunning.Operation, error)
	// Returns the service configuration and enabled state for a given service.
	GetService(context.Context, *GetServiceRequest) (*Service, error)
	// List all services available to the specified project, and the current
	// state of those services with respect to the project. The list includes
	// all public services, all services for which the calling user has the
	// `servicemanagement.services.bind` permission, and all services that have
	// already been enabled on the project. The list can be filtered to
	// only include services in a specific state, for example to only include
	// services enabled on the project.
	//
	// WARNING: If you need to query enabled services frequently or across
	// an organization, you should use
	// [Cloud Asset Inventory
	// API](https://cloud.google.com/asset-inventory/docs/apis), which provides
	// higher throughput and richer filtering capability.
	ListServices(context.Context, *ListServicesRequest) (*ListServicesResponse, error)
	// Enable multiple services on a project. The operation is atomic: if enabling
	// any service fails, then the entire batch fails, and no state changes occur.
	// To enable a single service, use the `EnableService` method instead.
	BatchEnableServices(context.Context, *BatchEnableServicesRequest) (*longrunning.Operation, error)
	// Returns the service configurations and enabled states for a given list of
	// services.
	BatchGetServices(context.Context, *BatchGetServicesRequest) (*BatchGetServicesResponse, error)
}

// UnimplementedServiceUsageServer can be embedded to have forward compatible implementations.
type UnimplementedServiceUsageServer struct {
}

func (*UnimplementedServiceUsageServer) EnableService(context.Context, *EnableServiceRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method EnableService not implemented")
}
func (*UnimplementedServiceUsageServer) DisableService(context.Context, *DisableServiceRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DisableService not implemented")
}
func (*UnimplementedServiceUsageServer) GetService(context.Context, *GetServiceRequest) (*Service, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetService not implemented")
}
func (*UnimplementedServiceUsageServer) ListServices(context.Context, *ListServicesRequest) (*ListServicesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListServices not implemented")
}
func (*UnimplementedServiceUsageServer) BatchEnableServices(context.Context, *BatchEnableServicesRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchEnableServices not implemented")
}
func (*UnimplementedServiceUsageServer) BatchGetServices(context.Context, *BatchGetServicesRequest) (*BatchGetServicesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchGetServices not implemented")
}

func RegisterServiceUsageServer(s *grpc.Server, srv ServiceUsageServer) {
	s.RegisterService(&_ServiceUsage_serviceDesc, srv)
}

func _ServiceUsage_EnableService_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(EnableServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceUsageServer).EnableService(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.serviceusage.v1.ServiceUsage/EnableService",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceUsageServer).EnableService(ctx, req.(*EnableServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceUsage_DisableService_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DisableServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceUsageServer).DisableService(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.serviceusage.v1.ServiceUsage/DisableService",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceUsageServer).DisableService(ctx, req.(*DisableServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceUsage_GetService_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceUsageServer).GetService(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.serviceusage.v1.ServiceUsage/GetService",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceUsageServer).GetService(ctx, req.(*GetServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceUsage_ListServices_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListServicesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceUsageServer).ListServices(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.serviceusage.v1.ServiceUsage/ListServices",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceUsageServer).ListServices(ctx, req.(*ListServicesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceUsage_BatchEnableServices_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchEnableServicesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceUsageServer).BatchEnableServices(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.serviceusage.v1.ServiceUsage/BatchEnableServices",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceUsageServer).BatchEnableServices(ctx, req.(*BatchEnableServicesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceUsage_BatchGetServices_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchGetServicesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceUsageServer).BatchGetServices(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.serviceusage.v1.ServiceUsage/BatchGetServices",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceUsageServer).BatchGetServices(ctx, req.(*BatchGetServicesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ServiceUsage_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.api.serviceusage.v1.ServiceUsage",
	HandlerType: (*ServiceUsageServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "EnableService",
			Handler:    _ServiceUsage_EnableService_Handler,
		},
		{
			MethodName: "DisableService",
			Handler:    _ServiceUsage_DisableService_Handler,
		},
		{
			MethodName: "GetService",
			Handler:    _ServiceUsage_GetService_Handler,
		},
		{
			MethodName: "ListServices",
			Handler:    _ServiceUsage_ListServices_Handler,
		},
		{
			MethodName: "BatchEnableServices",
			Handler:    _ServiceUsage_BatchEnableServices_Handler,
		},
		{
			MethodName: "BatchGetServices",
			Handler:    _ServiceUsage_BatchGetServices_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/api/serviceusage/v1/serviceusage.proto",
}
