// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.2
// 	protoc        v4.25.3
// source: google/maps/places/v1/travel_mode.proto

package placespb

import (
	reflect "reflect"
	sync "sync"

	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Travel mode options.
// These options map to what [Routes API
// offers](https://developers.google.com/maps/documentation/routes/reference/rest/v2/RouteTravelMode).
type TravelMode int32

const (
	// No travel mode specified. Defaults to `DRIVE`.
	TravelMode_TRAVEL_MODE_UNSPECIFIED TravelMode = 0
	// Travel by passenger car.
	TravelMode_DRIVE TravelMode = 1
	// Travel by bicycle.  Not supported with `search_along_route_parameters`.
	TravelMode_BICYCLE TravelMode = 2
	// Travel by walking.  Not supported with `search_along_route_parameters`.
	TravelMode_WALK TravelMode = 3
	// Motorized two wheeled vehicles of all kinds such as scooters and
	// motorcycles. Note that this is distinct from the `BICYCLE` travel mode
	// which covers human-powered transport.  Not supported with
	// `search_along_route_parameters`. Only supported in those countries listed
	// at [Countries and regions supported for two-wheeled
	// vehicles](https://developers.google.com/maps/documentation/routes/coverage-two-wheeled).
	TravelMode_TWO_WHEELER TravelMode = 4
)

// Enum value maps for TravelMode.
var (
	TravelMode_name = map[int32]string{
		0: "TRAVEL_MODE_UNSPECIFIED",
		1: "DRIVE",
		2: "BICYCLE",
		3: "WALK",
		4: "TWO_WHEELER",
	}
	TravelMode_value = map[string]int32{
		"TRAVEL_MODE_UNSPECIFIED": 0,
		"DRIVE":                   1,
		"BICYCLE":                 2,
		"WALK":                    3,
		"TWO_WHEELER":             4,
	}
)

func (x TravelMode) Enum() *TravelMode {
	p := new(TravelMode)
	*p = x
	return p
}

func (x TravelMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TravelMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_maps_places_v1_travel_mode_proto_enumTypes[0].Descriptor()
}

func (TravelMode) Type() protoreflect.EnumType {
	return &file_google_maps_places_v1_travel_mode_proto_enumTypes[0]
}

func (x TravelMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TravelMode.Descriptor instead.
func (TravelMode) EnumDescriptor() ([]byte, []int) {
	return file_google_maps_places_v1_travel_mode_proto_rawDescGZIP(), []int{0}
}

var File_google_maps_places_v1_travel_mode_proto protoreflect.FileDescriptor

var file_google_maps_places_v1_travel_mode_proto_rawDesc = []byte{
	0x0a, 0x27, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6d, 0x61, 0x70, 0x73, 0x2f, 0x70, 0x6c,
	0x61, 0x63, 0x65, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x74, 0x72, 0x61, 0x76, 0x65, 0x6c, 0x5f, 0x6d,
	0x6f, 0x64, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31,
	0x2a, 0x5c, 0x0a, 0x0a, 0x54, 0x72, 0x61, 0x76, 0x65, 0x6c, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x1b,
	0x0a, 0x17, 0x54, 0x52, 0x41, 0x56, 0x45, 0x4c, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x44,
	0x52, 0x49, 0x56, 0x45, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x42, 0x49, 0x43, 0x59, 0x43, 0x4c,
	0x45, 0x10, 0x02, 0x12, 0x08, 0x0a, 0x04, 0x57, 0x41, 0x4c, 0x4b, 0x10, 0x03, 0x12, 0x0f, 0x0a,
	0x0b, 0x54, 0x57, 0x4f, 0x5f, 0x57, 0x48, 0x45, 0x45, 0x4c, 0x45, 0x52, 0x10, 0x04, 0x42, 0xa3,
	0x01, 0x0a, 0x19, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61,
	0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x42, 0x0f, 0x54, 0x72,
	0x61, 0x76, 0x65, 0x6c, 0x4d, 0x6f, 0x64, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a,
	0x37, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x6d, 0x61, 0x70, 0x73, 0x2f, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73,
	0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x70, 0x62, 0x3b,
	0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x70, 0x62, 0xf8, 0x01, 0x01, 0xa2, 0x02, 0x06, 0x47, 0x4d,
	0x50, 0x53, 0x56, 0x31, 0xaa, 0x02, 0x15, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x4d, 0x61,
	0x70, 0x73, 0x2e, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x15, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x4d, 0x61, 0x70, 0x73, 0x5c, 0x50, 0x6c, 0x61, 0x63, 0x65,
	0x73, 0x5c, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_maps_places_v1_travel_mode_proto_rawDescOnce sync.Once
	file_google_maps_places_v1_travel_mode_proto_rawDescData = file_google_maps_places_v1_travel_mode_proto_rawDesc
)

func file_google_maps_places_v1_travel_mode_proto_rawDescGZIP() []byte {
	file_google_maps_places_v1_travel_mode_proto_rawDescOnce.Do(func() {
		file_google_maps_places_v1_travel_mode_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_maps_places_v1_travel_mode_proto_rawDescData)
	})
	return file_google_maps_places_v1_travel_mode_proto_rawDescData
}

var file_google_maps_places_v1_travel_mode_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_maps_places_v1_travel_mode_proto_goTypes = []any{
	(TravelMode)(0), // 0: google.maps.places.v1.TravelMode
}
var file_google_maps_places_v1_travel_mode_proto_depIdxs = []int32{
	0, // [0:0] is the sub-list for method output_type
	0, // [0:0] is the sub-list for method input_type
	0, // [0:0] is the sub-list for extension type_name
	0, // [0:0] is the sub-list for extension extendee
	0, // [0:0] is the sub-list for field type_name
}

func init() { file_google_maps_places_v1_travel_mode_proto_init() }
func file_google_maps_places_v1_travel_mode_proto_init() {
	if File_google_maps_places_v1_travel_mode_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_maps_places_v1_travel_mode_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   0,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_maps_places_v1_travel_mode_proto_goTypes,
		DependencyIndexes: file_google_maps_places_v1_travel_mode_proto_depIdxs,
		EnumInfos:         file_google_maps_places_v1_travel_mode_proto_enumTypes,
	}.Build()
	File_google_maps_places_v1_travel_mode_proto = out.File
	file_google_maps_places_v1_travel_mode_proto_rawDesc = nil
	file_google_maps_places_v1_travel_mode_proto_goTypes = nil
	file_google_maps_places_v1_travel_mode_proto_depIdxs = nil
}
