// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.2
// 	protoc        v4.25.3
// source: google/cloud/dialogflow/v2beta1/conversation_profile.proto

package dialogflowpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Selectable sections to return when requesting a summary of a
// conversation.
type HumanAgentAssistantConfig_SuggestionQueryConfig_Sections_SectionType int32

const (
	// Undefined section type, does not return anything.
	HumanAgentAssistantConfig_SuggestionQueryConfig_Sections_SECTION_TYPE_UNSPECIFIED HumanAgentAssistantConfig_SuggestionQueryConfig_Sections_SectionType = 0
	// What the customer needs help with or has question about.
	// Section name: "situation".
	HumanAgentAssistantConfig_SuggestionQueryConfig_Sections_SITUATION HumanAgentAssistantConfig_SuggestionQueryConfig_Sections_SectionType = 1
	// What the agent does to help the customer.
	// Section name: "action".
	HumanAgentAssistantConfig_SuggestionQueryConfig_Sections_ACTION HumanAgentAssistantConfig_SuggestionQueryConfig_Sections_SectionType = 2
	// Result of the customer service. A single word describing the result
	// of the conversation.
	// Section name: "resolution".
	HumanAgentAssistantConfig_SuggestionQueryConfig_Sections_RESOLUTION HumanAgentAssistantConfig_SuggestionQueryConfig_Sections_SectionType = 3
	// Reason for cancellation if the customer requests for a cancellation.
	// "N/A" otherwise.
	// Section name: "reason_for_cancellation".
	HumanAgentAssistantConfig_SuggestionQueryConfig_Sections_REASON_FOR_CANCELLATION HumanAgentAssistantConfig_SuggestionQueryConfig_Sections_SectionType = 4
	// "Unsatisfied" or "Satisfied" depending on the customer's feelings at
	// the end of the conversation.
	// Section name: "customer_satisfaction".
	HumanAgentAssistantConfig_SuggestionQueryConfig_Sections_CUSTOMER_SATISFACTION HumanAgentAssistantConfig_SuggestionQueryConfig_Sections_SectionType = 5
	// Key entities extracted from the conversation, such as ticket number,
	// order number, dollar amount, etc.
	// Section names are prefixed by "entities/".
	HumanAgentAssistantConfig_SuggestionQueryConfig_Sections_ENTITIES HumanAgentAssistantConfig_SuggestionQueryConfig_Sections_SectionType = 6
)

// Enum value maps for HumanAgentAssistantConfig_SuggestionQueryConfig_Sections_SectionType.
var (
	HumanAgentAssistantConfig_SuggestionQueryConfig_Sections_SectionType_name = map[int32]string{
		0: "SECTION_TYPE_UNSPECIFIED",
		1: "SITUATION",
		2: "ACTION",
		3: "RESOLUTION",
		4: "REASON_FOR_CANCELLATION",
		5: "CUSTOMER_SATISFACTION",
		6: "ENTITIES",
	}
	HumanAgentAssistantConfig_SuggestionQueryConfig_Sections_SectionType_value = map[string]int32{
		"SECTION_TYPE_UNSPECIFIED": 0,
		"SITUATION":                1,
		"ACTION":                   2,
		"RESOLUTION":               3,
		"REASON_FOR_CANCELLATION":  4,
		"CUSTOMER_SATISFACTION":    5,
		"ENTITIES":                 6,
	}
)

func (x HumanAgentAssistantConfig_SuggestionQueryConfig_Sections_SectionType) Enum() *HumanAgentAssistantConfig_SuggestionQueryConfig_Sections_SectionType {
	p := new(HumanAgentAssistantConfig_SuggestionQueryConfig_Sections_SectionType)
	*p = x
	return p
}

func (x HumanAgentAssistantConfig_SuggestionQueryConfig_Sections_SectionType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HumanAgentAssistantConfig_SuggestionQueryConfig_Sections_SectionType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_enumTypes[0].Descriptor()
}

func (HumanAgentAssistantConfig_SuggestionQueryConfig_Sections_SectionType) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_enumTypes[0]
}

func (x HumanAgentAssistantConfig_SuggestionQueryConfig_Sections_SectionType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HumanAgentAssistantConfig_SuggestionQueryConfig_Sections_SectionType.Descriptor instead.
func (HumanAgentAssistantConfig_SuggestionQueryConfig_Sections_SectionType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_rawDescGZIP(), []int{2, 3, 4, 0}
}

// Format of cloud pub/sub message.
type NotificationConfig_MessageFormat int32

const (
	// If it is unspecified, PROTO will be used.
	NotificationConfig_MESSAGE_FORMAT_UNSPECIFIED NotificationConfig_MessageFormat = 0
	// Pub/Sub message will be serialized proto.
	NotificationConfig_PROTO NotificationConfig_MessageFormat = 1
	// Pub/Sub message will be json.
	NotificationConfig_JSON NotificationConfig_MessageFormat = 2
)

// Enum value maps for NotificationConfig_MessageFormat.
var (
	NotificationConfig_MessageFormat_name = map[int32]string{
		0: "MESSAGE_FORMAT_UNSPECIFIED",
		1: "PROTO",
		2: "JSON",
	}
	NotificationConfig_MessageFormat_value = map[string]int32{
		"MESSAGE_FORMAT_UNSPECIFIED": 0,
		"PROTO":                      1,
		"JSON":                       2,
	}
)

func (x NotificationConfig_MessageFormat) Enum() *NotificationConfig_MessageFormat {
	p := new(NotificationConfig_MessageFormat)
	*p = x
	return p
}

func (x NotificationConfig_MessageFormat) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NotificationConfig_MessageFormat) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_enumTypes[1].Descriptor()
}

func (NotificationConfig_MessageFormat) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_enumTypes[1]
}

func (x NotificationConfig_MessageFormat) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NotificationConfig_MessageFormat.Descriptor instead.
func (NotificationConfig_MessageFormat) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_rawDescGZIP(), []int{4, 0}
}

// Defines the services to connect to incoming Dialogflow conversations.
type ConversationProfile struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unique identifier of this conversation profile.
	// Format: `projects/<Project ID>/locations/<Location
	// ID>/conversationProfiles/<Conversation Profile ID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Human readable name for this profile. Max length 1024 bytes.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Output only. Create time of the conversation profile.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,11,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Update time of the conversation profile.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,12,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Configuration for an automated agent to use with this profile.
	AutomatedAgentConfig *AutomatedAgentConfig `protobuf:"bytes,3,opt,name=automated_agent_config,json=automatedAgentConfig,proto3" json:"automated_agent_config,omitempty"`
	// Configuration for agent assistance to use with this profile.
	HumanAgentAssistantConfig *HumanAgentAssistantConfig `protobuf:"bytes,4,opt,name=human_agent_assistant_config,json=humanAgentAssistantConfig,proto3" json:"human_agent_assistant_config,omitempty"`
	// Configuration for connecting to a live agent.
	//
	// Currently, this feature is not general available, please contact Google
	// to get access.
	HumanAgentHandoffConfig *HumanAgentHandoffConfig `protobuf:"bytes,5,opt,name=human_agent_handoff_config,json=humanAgentHandoffConfig,proto3" json:"human_agent_handoff_config,omitempty"`
	// Configuration for publishing conversation lifecycle events.
	NotificationConfig *NotificationConfig `protobuf:"bytes,6,opt,name=notification_config,json=notificationConfig,proto3" json:"notification_config,omitempty"`
	// Configuration for logging conversation lifecycle events.
	LoggingConfig *LoggingConfig `protobuf:"bytes,7,opt,name=logging_config,json=loggingConfig,proto3" json:"logging_config,omitempty"`
	// Configuration for publishing new message events. Event will be sent in
	// format of
	// [ConversationEvent][google.cloud.dialogflow.v2beta1.ConversationEvent]
	NewMessageEventNotificationConfig *NotificationConfig `protobuf:"bytes,8,opt,name=new_message_event_notification_config,json=newMessageEventNotificationConfig,proto3" json:"new_message_event_notification_config,omitempty"`
	// Settings for speech transcription.
	SttConfig *SpeechToTextConfig `protobuf:"bytes,9,opt,name=stt_config,json=sttConfig,proto3" json:"stt_config,omitempty"`
	// Language code for the conversation profile. If not specified, the language
	// is en-US. Language at ConversationProfile should be set for all non en-us
	// languages.
	// This should be a [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt)
	// language tag. Example: "en-US".
	LanguageCode string `protobuf:"bytes,10,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// The time zone of this conversational profile from the
	// [time zone database](https://www.iana.org/time-zones), e.g.,
	// America/New_York, Europe/Paris. Defaults to America/New_York.
	TimeZone string `protobuf:"bytes,14,opt,name=time_zone,json=timeZone,proto3" json:"time_zone,omitempty"`
	// Name of the CX SecuritySettings reference for the agent.
	// Format: `projects/<Project ID>/locations/<Location
	// ID>/securitySettings/<Security Settings ID>`.
	SecuritySettings string `protobuf:"bytes,13,opt,name=security_settings,json=securitySettings,proto3" json:"security_settings,omitempty"`
	// Configuration for Text-to-Speech synthesization.
	//
	// Used by Phone Gateway to specify synthesization options. If agent defines
	// synthesization options as well, agent settings overrides the option here.
	TtsConfig *SynthesizeSpeechConfig `protobuf:"bytes,18,opt,name=tts_config,json=ttsConfig,proto3" json:"tts_config,omitempty"`
}

func (x *ConversationProfile) Reset() {
	*x = ConversationProfile{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConversationProfile) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConversationProfile) ProtoMessage() {}

func (x *ConversationProfile) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConversationProfile.ProtoReflect.Descriptor instead.
func (*ConversationProfile) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_rawDescGZIP(), []int{0}
}

func (x *ConversationProfile) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ConversationProfile) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *ConversationProfile) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *ConversationProfile) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *ConversationProfile) GetAutomatedAgentConfig() *AutomatedAgentConfig {
	if x != nil {
		return x.AutomatedAgentConfig
	}
	return nil
}

func (x *ConversationProfile) GetHumanAgentAssistantConfig() *HumanAgentAssistantConfig {
	if x != nil {
		return x.HumanAgentAssistantConfig
	}
	return nil
}

func (x *ConversationProfile) GetHumanAgentHandoffConfig() *HumanAgentHandoffConfig {
	if x != nil {
		return x.HumanAgentHandoffConfig
	}
	return nil
}

func (x *ConversationProfile) GetNotificationConfig() *NotificationConfig {
	if x != nil {
		return x.NotificationConfig
	}
	return nil
}

func (x *ConversationProfile) GetLoggingConfig() *LoggingConfig {
	if x != nil {
		return x.LoggingConfig
	}
	return nil
}

func (x *ConversationProfile) GetNewMessageEventNotificationConfig() *NotificationConfig {
	if x != nil {
		return x.NewMessageEventNotificationConfig
	}
	return nil
}

func (x *ConversationProfile) GetSttConfig() *SpeechToTextConfig {
	if x != nil {
		return x.SttConfig
	}
	return nil
}

func (x *ConversationProfile) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

func (x *ConversationProfile) GetTimeZone() string {
	if x != nil {
		return x.TimeZone
	}
	return ""
}

func (x *ConversationProfile) GetSecuritySettings() string {
	if x != nil {
		return x.SecuritySettings
	}
	return ""
}

func (x *ConversationProfile) GetTtsConfig() *SynthesizeSpeechConfig {
	if x != nil {
		return x.TtsConfig
	}
	return nil
}

// Defines the Automated Agent to connect to a conversation.
type AutomatedAgentConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. ID of the Dialogflow agent environment to use.
	//
	// This project needs to either be the same project as the conversation or you
	// need to grant `service-<Conversation Project
	// Number>@gcp-sa-dialogflow.iam.gserviceaccount.com` the `Dialogflow API
	// Service Agent` role in this project.
	//
	// - For ES agents, use format: `projects/<Project ID>/locations/<Location
	// ID>/agent/environments/<Environment ID or '-'>`. If environment is not
	// specified, the default `draft` environment is used. Refer to
	// [DetectIntentRequest](/dialogflow/docs/reference/rpc/google.cloud.dialogflow.v2beta1#google.cloud.dialogflow.v2beta1.DetectIntentRequest)
	// for more details.
	//
	// - For CX agents, use format `projects/<Project ID>/locations/<Location
	// ID>/agents/<Agent ID>/environments/<Environment ID
	// or '-'>`. If environment is not specified, the default `draft` environment
	// is used.
	Agent string `protobuf:"bytes,1,opt,name=agent,proto3" json:"agent,omitempty"`
	// Optional. Configure lifetime of the Dialogflow session.
	// By default, a Dialogflow CX session remains active and its data is stored
	// for 30 minutes after the last request is sent for the session.
	// This value should be no longer than 1 day.
	SessionTtl *durationpb.Duration `protobuf:"bytes,3,opt,name=session_ttl,json=sessionTtl,proto3" json:"session_ttl,omitempty"`
}

func (x *AutomatedAgentConfig) Reset() {
	*x = AutomatedAgentConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AutomatedAgentConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutomatedAgentConfig) ProtoMessage() {}

func (x *AutomatedAgentConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutomatedAgentConfig.ProtoReflect.Descriptor instead.
func (*AutomatedAgentConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_rawDescGZIP(), []int{1}
}

func (x *AutomatedAgentConfig) GetAgent() string {
	if x != nil {
		return x.Agent
	}
	return ""
}

func (x *AutomatedAgentConfig) GetSessionTtl() *durationpb.Duration {
	if x != nil {
		return x.SessionTtl
	}
	return nil
}

// Defines the Human Agent Assistant to connect to a conversation.
type HumanAgentAssistantConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Pub/Sub topic on which to publish new agent assistant events.
	NotificationConfig *NotificationConfig `protobuf:"bytes,2,opt,name=notification_config,json=notificationConfig,proto3" json:"notification_config,omitempty"`
	// Configuration for agent assistance of human agent participant.
	HumanAgentSuggestionConfig *HumanAgentAssistantConfig_SuggestionConfig `protobuf:"bytes,3,opt,name=human_agent_suggestion_config,json=humanAgentSuggestionConfig,proto3" json:"human_agent_suggestion_config,omitempty"`
	// Configuration for agent assistance of end user participant.
	//
	// Currently, this feature is not general available, please contact Google
	// to get access.
	EndUserSuggestionConfig *HumanAgentAssistantConfig_SuggestionConfig `protobuf:"bytes,4,opt,name=end_user_suggestion_config,json=endUserSuggestionConfig,proto3" json:"end_user_suggestion_config,omitempty"`
	// Configuration for message analysis.
	MessageAnalysisConfig *HumanAgentAssistantConfig_MessageAnalysisConfig `protobuf:"bytes,5,opt,name=message_analysis_config,json=messageAnalysisConfig,proto3" json:"message_analysis_config,omitempty"`
}

func (x *HumanAgentAssistantConfig) Reset() {
	*x = HumanAgentAssistantConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HumanAgentAssistantConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HumanAgentAssistantConfig) ProtoMessage() {}

func (x *HumanAgentAssistantConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HumanAgentAssistantConfig.ProtoReflect.Descriptor instead.
func (*HumanAgentAssistantConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_rawDescGZIP(), []int{2}
}

func (x *HumanAgentAssistantConfig) GetNotificationConfig() *NotificationConfig {
	if x != nil {
		return x.NotificationConfig
	}
	return nil
}

func (x *HumanAgentAssistantConfig) GetHumanAgentSuggestionConfig() *HumanAgentAssistantConfig_SuggestionConfig {
	if x != nil {
		return x.HumanAgentSuggestionConfig
	}
	return nil
}

func (x *HumanAgentAssistantConfig) GetEndUserSuggestionConfig() *HumanAgentAssistantConfig_SuggestionConfig {
	if x != nil {
		return x.EndUserSuggestionConfig
	}
	return nil
}

func (x *HumanAgentAssistantConfig) GetMessageAnalysisConfig() *HumanAgentAssistantConfig_MessageAnalysisConfig {
	if x != nil {
		return x.MessageAnalysisConfig
	}
	return nil
}

// Defines the hand off to a live agent, typically on which external agent
// service provider to connect to a conversation.
//
// Currently, this feature is not general available, please contact Google
// to get access.
type HumanAgentHandoffConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Specifies which agent service to connect for human agent handoff.
	//
	// Types that are assignable to AgentService:
	//
	//	*HumanAgentHandoffConfig_LivePersonConfig_
	//	*HumanAgentHandoffConfig_SalesforceLiveAgentConfig_
	AgentService isHumanAgentHandoffConfig_AgentService `protobuf_oneof:"agent_service"`
}

func (x *HumanAgentHandoffConfig) Reset() {
	*x = HumanAgentHandoffConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HumanAgentHandoffConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HumanAgentHandoffConfig) ProtoMessage() {}

func (x *HumanAgentHandoffConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HumanAgentHandoffConfig.ProtoReflect.Descriptor instead.
func (*HumanAgentHandoffConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_rawDescGZIP(), []int{3}
}

func (m *HumanAgentHandoffConfig) GetAgentService() isHumanAgentHandoffConfig_AgentService {
	if m != nil {
		return m.AgentService
	}
	return nil
}

func (x *HumanAgentHandoffConfig) GetLivePersonConfig() *HumanAgentHandoffConfig_LivePersonConfig {
	if x, ok := x.GetAgentService().(*HumanAgentHandoffConfig_LivePersonConfig_); ok {
		return x.LivePersonConfig
	}
	return nil
}

func (x *HumanAgentHandoffConfig) GetSalesforceLiveAgentConfig() *HumanAgentHandoffConfig_SalesforceLiveAgentConfig {
	if x, ok := x.GetAgentService().(*HumanAgentHandoffConfig_SalesforceLiveAgentConfig_); ok {
		return x.SalesforceLiveAgentConfig
	}
	return nil
}

type isHumanAgentHandoffConfig_AgentService interface {
	isHumanAgentHandoffConfig_AgentService()
}

type HumanAgentHandoffConfig_LivePersonConfig_ struct {
	// Uses [LivePerson](https://www.liveperson.com).
	LivePersonConfig *HumanAgentHandoffConfig_LivePersonConfig `protobuf:"bytes,1,opt,name=live_person_config,json=livePersonConfig,proto3,oneof"`
}

type HumanAgentHandoffConfig_SalesforceLiveAgentConfig_ struct {
	// Uses Salesforce Live Agent.
	SalesforceLiveAgentConfig *HumanAgentHandoffConfig_SalesforceLiveAgentConfig `protobuf:"bytes,2,opt,name=salesforce_live_agent_config,json=salesforceLiveAgentConfig,proto3,oneof"`
}

func (*HumanAgentHandoffConfig_LivePersonConfig_) isHumanAgentHandoffConfig_AgentService() {}

func (*HumanAgentHandoffConfig_SalesforceLiveAgentConfig_) isHumanAgentHandoffConfig_AgentService() {}

// Defines notification behavior.
type NotificationConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the Pub/Sub topic to publish conversation
	// events like
	// [CONVERSATION_STARTED][google.cloud.dialogflow.v2beta1.ConversationEvent.Type.CONVERSATION_STARTED]
	// as serialized
	// [ConversationEvent][google.cloud.dialogflow.v2beta1.ConversationEvent]
	// protos.
	//
	// For telephony integration to receive notification, make sure either this
	// topic is in the same project as the conversation or you grant
	// `service-<Conversation Project
	// Number>@gcp-sa-dialogflow.iam.gserviceaccount.com` the `Dialogflow Service
	// Agent` role in the topic project.
	//
	// For chat integration to receive notification, make sure API caller has been
	// granted the `Dialogflow Service Agent` role for the topic.
	//
	// Format: `projects/<Project ID>/locations/<Location ID>/topics/<Topic ID>`.
	Topic string `protobuf:"bytes,1,opt,name=topic,proto3" json:"topic,omitempty"`
	// Format of message.
	MessageFormat NotificationConfig_MessageFormat `protobuf:"varint,2,opt,name=message_format,json=messageFormat,proto3,enum=google.cloud.dialogflow.v2beta1.NotificationConfig_MessageFormat" json:"message_format,omitempty"`
}

func (x *NotificationConfig) Reset() {
	*x = NotificationConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NotificationConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NotificationConfig) ProtoMessage() {}

func (x *NotificationConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NotificationConfig.ProtoReflect.Descriptor instead.
func (*NotificationConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_rawDescGZIP(), []int{4}
}

func (x *NotificationConfig) GetTopic() string {
	if x != nil {
		return x.Topic
	}
	return ""
}

func (x *NotificationConfig) GetMessageFormat() NotificationConfig_MessageFormat {
	if x != nil {
		return x.MessageFormat
	}
	return NotificationConfig_MESSAGE_FORMAT_UNSPECIFIED
}

// Defines logging behavior for conversation lifecycle events.
type LoggingConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether to log conversation events like
	// [CONVERSATION_STARTED][google.cloud.dialogflow.v2beta1.ConversationEvent.Type.CONVERSATION_STARTED]
	// to Stackdriver in the conversation project as JSON format
	// [ConversationEvent][google.cloud.dialogflow.v2beta1.ConversationEvent]
	// protos.
	EnableStackdriverLogging bool `protobuf:"varint,3,opt,name=enable_stackdriver_logging,json=enableStackdriverLogging,proto3" json:"enable_stackdriver_logging,omitempty"`
}

func (x *LoggingConfig) Reset() {
	*x = LoggingConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LoggingConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LoggingConfig) ProtoMessage() {}

func (x *LoggingConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LoggingConfig.ProtoReflect.Descriptor instead.
func (*LoggingConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_rawDescGZIP(), []int{5}
}

func (x *LoggingConfig) GetEnableStackdriverLogging() bool {
	if x != nil {
		return x.EnableStackdriverLogging
	}
	return false
}

// The request message for
// [ConversationProfiles.ListConversationProfiles][google.cloud.dialogflow.v2beta1.ConversationProfiles.ListConversationProfiles].
type ListConversationProfilesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project to list all conversation profiles from.
	// Format: `projects/<Project ID>/locations/<Location ID>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of items to return in a single page. By
	// default 100 and at most 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The next_page_token value returned from a previous list request.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListConversationProfilesRequest) Reset() {
	*x = ListConversationProfilesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListConversationProfilesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListConversationProfilesRequest) ProtoMessage() {}

func (x *ListConversationProfilesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListConversationProfilesRequest.ProtoReflect.Descriptor instead.
func (*ListConversationProfilesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_rawDescGZIP(), []int{6}
}

func (x *ListConversationProfilesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListConversationProfilesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListConversationProfilesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The response message for
// [ConversationProfiles.ListConversationProfiles][google.cloud.dialogflow.v2beta1.ConversationProfiles.ListConversationProfiles].
type ListConversationProfilesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of project conversation profiles. There is a maximum number
	// of items returned based on the page_size field in the request.
	ConversationProfiles []*ConversationProfile `protobuf:"bytes,1,rep,name=conversation_profiles,json=conversationProfiles,proto3" json:"conversation_profiles,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no
	// more results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListConversationProfilesResponse) Reset() {
	*x = ListConversationProfilesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListConversationProfilesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListConversationProfilesResponse) ProtoMessage() {}

func (x *ListConversationProfilesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListConversationProfilesResponse.ProtoReflect.Descriptor instead.
func (*ListConversationProfilesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_rawDescGZIP(), []int{7}
}

func (x *ListConversationProfilesResponse) GetConversationProfiles() []*ConversationProfile {
	if x != nil {
		return x.ConversationProfiles
	}
	return nil
}

func (x *ListConversationProfilesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request message for
// [ConversationProfiles.GetConversationProfile][google.cloud.dialogflow.v2beta1.ConversationProfiles.GetConversationProfile].
type GetConversationProfileRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the conversation profile.
	// Format: `projects/<Project ID>/locations/<Location
	// ID>/conversationProfiles/<Conversation Profile ID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetConversationProfileRequest) Reset() {
	*x = GetConversationProfileRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetConversationProfileRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetConversationProfileRequest) ProtoMessage() {}

func (x *GetConversationProfileRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetConversationProfileRequest.ProtoReflect.Descriptor instead.
func (*GetConversationProfileRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_rawDescGZIP(), []int{8}
}

func (x *GetConversationProfileRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request message for
// [ConversationProfiles.CreateConversationProfile][google.cloud.dialogflow.v2beta1.ConversationProfiles.CreateConversationProfile].
type CreateConversationProfileRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project to create a conversation profile for.
	// Format: `projects/<Project ID>/locations/<Location ID>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The conversation profile to create.
	ConversationProfile *ConversationProfile `protobuf:"bytes,2,opt,name=conversation_profile,json=conversationProfile,proto3" json:"conversation_profile,omitempty"`
}

func (x *CreateConversationProfileRequest) Reset() {
	*x = CreateConversationProfileRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateConversationProfileRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateConversationProfileRequest) ProtoMessage() {}

func (x *CreateConversationProfileRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateConversationProfileRequest.ProtoReflect.Descriptor instead.
func (*CreateConversationProfileRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_rawDescGZIP(), []int{9}
}

func (x *CreateConversationProfileRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateConversationProfileRequest) GetConversationProfile() *ConversationProfile {
	if x != nil {
		return x.ConversationProfile
	}
	return nil
}

// The request message for
// [ConversationProfiles.UpdateConversationProfile][google.cloud.dialogflow.v2beta1.ConversationProfiles.UpdateConversationProfile].
type UpdateConversationProfileRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The conversation profile to update.
	ConversationProfile *ConversationProfile `protobuf:"bytes,1,opt,name=conversation_profile,json=conversationProfile,proto3" json:"conversation_profile,omitempty"`
	// Required. The mask to control which fields to update.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateConversationProfileRequest) Reset() {
	*x = UpdateConversationProfileRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateConversationProfileRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateConversationProfileRequest) ProtoMessage() {}

func (x *UpdateConversationProfileRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateConversationProfileRequest.ProtoReflect.Descriptor instead.
func (*UpdateConversationProfileRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_rawDescGZIP(), []int{10}
}

func (x *UpdateConversationProfileRequest) GetConversationProfile() *ConversationProfile {
	if x != nil {
		return x.ConversationProfile
	}
	return nil
}

func (x *UpdateConversationProfileRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// The request message for
// [ConversationProfiles.DeleteConversationProfile][google.cloud.dialogflow.v2beta1.ConversationProfiles.DeleteConversationProfile].
//
// This operation fails if the conversation profile is still referenced from
// a phone number.
type DeleteConversationProfileRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the conversation profile to delete.
	// Format: `projects/<Project ID>/locations/<Location
	// ID>/conversationProfiles/<Conversation Profile ID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteConversationProfileRequest) Reset() {
	*x = DeleteConversationProfileRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteConversationProfileRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteConversationProfileRequest) ProtoMessage() {}

func (x *DeleteConversationProfileRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteConversationProfileRequest.ProtoReflect.Descriptor instead.
func (*DeleteConversationProfileRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_rawDescGZIP(), []int{11}
}

func (x *DeleteConversationProfileRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request message for
// [ConversationProfiles.SetSuggestionFeature][].
type SetSuggestionFeatureConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Conversation Profile to add or update the suggestion feature
	// config. Format: `projects/<Project ID>/locations/<Location
	// ID>/conversationProfiles/<Conversation Profile ID>`.
	ConversationProfile string `protobuf:"bytes,1,opt,name=conversation_profile,json=conversationProfile,proto3" json:"conversation_profile,omitempty"`
	// Required. The participant role to add or update the suggestion feature
	// config. Only HUMAN_AGENT or END_USER can be used.
	ParticipantRole Participant_Role `protobuf:"varint,2,opt,name=participant_role,json=participantRole,proto3,enum=google.cloud.dialogflow.v2beta1.Participant_Role" json:"participant_role,omitempty"`
	// Required. The suggestion feature config to add or update.
	SuggestionFeatureConfig *HumanAgentAssistantConfig_SuggestionFeatureConfig `protobuf:"bytes,3,opt,name=suggestion_feature_config,json=suggestionFeatureConfig,proto3" json:"suggestion_feature_config,omitempty"`
}

func (x *SetSuggestionFeatureConfigRequest) Reset() {
	*x = SetSuggestionFeatureConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SetSuggestionFeatureConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetSuggestionFeatureConfigRequest) ProtoMessage() {}

func (x *SetSuggestionFeatureConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetSuggestionFeatureConfigRequest.ProtoReflect.Descriptor instead.
func (*SetSuggestionFeatureConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_rawDescGZIP(), []int{12}
}

func (x *SetSuggestionFeatureConfigRequest) GetConversationProfile() string {
	if x != nil {
		return x.ConversationProfile
	}
	return ""
}

func (x *SetSuggestionFeatureConfigRequest) GetParticipantRole() Participant_Role {
	if x != nil {
		return x.ParticipantRole
	}
	return Participant_ROLE_UNSPECIFIED
}

func (x *SetSuggestionFeatureConfigRequest) GetSuggestionFeatureConfig() *HumanAgentAssistantConfig_SuggestionFeatureConfig {
	if x != nil {
		return x.SuggestionFeatureConfig
	}
	return nil
}

// The request message for [ConversationProfiles.ClearFeature][].
type ClearSuggestionFeatureConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Conversation Profile to add or update the suggestion feature
	// config. Format: `projects/<Project ID>/locations/<Location
	// ID>/conversationProfiles/<Conversation Profile ID>`.
	ConversationProfile string `protobuf:"bytes,1,opt,name=conversation_profile,json=conversationProfile,proto3" json:"conversation_profile,omitempty"`
	// Required. The participant role to remove the suggestion feature
	// config. Only HUMAN_AGENT or END_USER can be used.
	ParticipantRole Participant_Role `protobuf:"varint,2,opt,name=participant_role,json=participantRole,proto3,enum=google.cloud.dialogflow.v2beta1.Participant_Role" json:"participant_role,omitempty"`
	// Required. The type of the suggestion feature to remove.
	SuggestionFeatureType SuggestionFeature_Type `protobuf:"varint,3,opt,name=suggestion_feature_type,json=suggestionFeatureType,proto3,enum=google.cloud.dialogflow.v2beta1.SuggestionFeature_Type" json:"suggestion_feature_type,omitempty"`
}

func (x *ClearSuggestionFeatureConfigRequest) Reset() {
	*x = ClearSuggestionFeatureConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ClearSuggestionFeatureConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClearSuggestionFeatureConfigRequest) ProtoMessage() {}

func (x *ClearSuggestionFeatureConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClearSuggestionFeatureConfigRequest.ProtoReflect.Descriptor instead.
func (*ClearSuggestionFeatureConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_rawDescGZIP(), []int{13}
}

func (x *ClearSuggestionFeatureConfigRequest) GetConversationProfile() string {
	if x != nil {
		return x.ConversationProfile
	}
	return ""
}

func (x *ClearSuggestionFeatureConfigRequest) GetParticipantRole() Participant_Role {
	if x != nil {
		return x.ParticipantRole
	}
	return Participant_ROLE_UNSPECIFIED
}

func (x *ClearSuggestionFeatureConfigRequest) GetSuggestionFeatureType() SuggestionFeature_Type {
	if x != nil {
		return x.SuggestionFeatureType
	}
	return SuggestionFeature_TYPE_UNSPECIFIED
}

// Metadata for a [ConversationProfile.SetSuggestionFeatureConfig][]
// operation.
type SetSuggestionFeatureConfigOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the conversation profile. Format:
	// `projects/<Project ID>/locations/<Location
	// ID>/conversationProfiles/<Conversation Profile ID>`
	ConversationProfile string `protobuf:"bytes,1,opt,name=conversation_profile,json=conversationProfile,proto3" json:"conversation_profile,omitempty"`
	// Required. The participant role to add or update the suggestion feature
	// config. Only HUMAN_AGENT or END_USER can be used.
	ParticipantRole Participant_Role `protobuf:"varint,2,opt,name=participant_role,json=participantRole,proto3,enum=google.cloud.dialogflow.v2beta1.Participant_Role" json:"participant_role,omitempty"`
	// Required. The type of the suggestion feature to add or update.
	SuggestionFeatureType SuggestionFeature_Type `protobuf:"varint,3,opt,name=suggestion_feature_type,json=suggestionFeatureType,proto3,enum=google.cloud.dialogflow.v2beta1.SuggestionFeature_Type" json:"suggestion_feature_type,omitempty"`
	// Timestamp whe the request was created. The time is measured on server side.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
}

func (x *SetSuggestionFeatureConfigOperationMetadata) Reset() {
	*x = SetSuggestionFeatureConfigOperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SetSuggestionFeatureConfigOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetSuggestionFeatureConfigOperationMetadata) ProtoMessage() {}

func (x *SetSuggestionFeatureConfigOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetSuggestionFeatureConfigOperationMetadata.ProtoReflect.Descriptor instead.
func (*SetSuggestionFeatureConfigOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_rawDescGZIP(), []int{14}
}

func (x *SetSuggestionFeatureConfigOperationMetadata) GetConversationProfile() string {
	if x != nil {
		return x.ConversationProfile
	}
	return ""
}

func (x *SetSuggestionFeatureConfigOperationMetadata) GetParticipantRole() Participant_Role {
	if x != nil {
		return x.ParticipantRole
	}
	return Participant_ROLE_UNSPECIFIED
}

func (x *SetSuggestionFeatureConfigOperationMetadata) GetSuggestionFeatureType() SuggestionFeature_Type {
	if x != nil {
		return x.SuggestionFeatureType
	}
	return SuggestionFeature_TYPE_UNSPECIFIED
}

func (x *SetSuggestionFeatureConfigOperationMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

// Metadata for a [ConversationProfile.ClearSuggestionFeatureConfig][]
// operation.
type ClearSuggestionFeatureConfigOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the conversation profile. Format:
	// `projects/<Project ID>/locations/<Location
	// ID>/conversationProfiles/<Conversation Profile ID>`
	ConversationProfile string `protobuf:"bytes,1,opt,name=conversation_profile,json=conversationProfile,proto3" json:"conversation_profile,omitempty"`
	// Required. The participant role to remove the suggestion feature
	// config. Only HUMAN_AGENT or END_USER can be used.
	ParticipantRole Participant_Role `protobuf:"varint,2,opt,name=participant_role,json=participantRole,proto3,enum=google.cloud.dialogflow.v2beta1.Participant_Role" json:"participant_role,omitempty"`
	// Required. The type of the suggestion feature to remove.
	SuggestionFeatureType SuggestionFeature_Type `protobuf:"varint,3,opt,name=suggestion_feature_type,json=suggestionFeatureType,proto3,enum=google.cloud.dialogflow.v2beta1.SuggestionFeature_Type" json:"suggestion_feature_type,omitempty"`
	// Timestamp whe the request was created. The time is measured on server side.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
}

func (x *ClearSuggestionFeatureConfigOperationMetadata) Reset() {
	*x = ClearSuggestionFeatureConfigOperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ClearSuggestionFeatureConfigOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClearSuggestionFeatureConfigOperationMetadata) ProtoMessage() {}

func (x *ClearSuggestionFeatureConfigOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClearSuggestionFeatureConfigOperationMetadata.ProtoReflect.Descriptor instead.
func (*ClearSuggestionFeatureConfigOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_rawDescGZIP(), []int{15}
}

func (x *ClearSuggestionFeatureConfigOperationMetadata) GetConversationProfile() string {
	if x != nil {
		return x.ConversationProfile
	}
	return ""
}

func (x *ClearSuggestionFeatureConfigOperationMetadata) GetParticipantRole() Participant_Role {
	if x != nil {
		return x.ParticipantRole
	}
	return Participant_ROLE_UNSPECIFIED
}

func (x *ClearSuggestionFeatureConfigOperationMetadata) GetSuggestionFeatureType() SuggestionFeature_Type {
	if x != nil {
		return x.SuggestionFeatureType
	}
	return SuggestionFeature_TYPE_UNSPECIFIED
}

func (x *ClearSuggestionFeatureConfigOperationMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

// Settings of suggestion trigger.
type HumanAgentAssistantConfig_SuggestionTriggerSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Do not trigger if last utterance is small talk.
	NoSmallTalk bool `protobuf:"varint,1,opt,name=no_small_talk,json=noSmallTalk,proto3" json:"no_small_talk,omitempty"`
	// Only trigger suggestion if participant role of last utterance is
	// END_USER.
	OnlyEndUser bool `protobuf:"varint,2,opt,name=only_end_user,json=onlyEndUser,proto3" json:"only_end_user,omitempty"`
}

func (x *HumanAgentAssistantConfig_SuggestionTriggerSettings) Reset() {
	*x = HumanAgentAssistantConfig_SuggestionTriggerSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HumanAgentAssistantConfig_SuggestionTriggerSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HumanAgentAssistantConfig_SuggestionTriggerSettings) ProtoMessage() {}

func (x *HumanAgentAssistantConfig_SuggestionTriggerSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HumanAgentAssistantConfig_SuggestionTriggerSettings.ProtoReflect.Descriptor instead.
func (*HumanAgentAssistantConfig_SuggestionTriggerSettings) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_rawDescGZIP(), []int{2, 0}
}

func (x *HumanAgentAssistantConfig_SuggestionTriggerSettings) GetNoSmallTalk() bool {
	if x != nil {
		return x.NoSmallTalk
	}
	return false
}

func (x *HumanAgentAssistantConfig_SuggestionTriggerSettings) GetOnlyEndUser() bool {
	if x != nil {
		return x.OnlyEndUser
	}
	return false
}

// Config for suggestion features.
type HumanAgentAssistantConfig_SuggestionFeatureConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The suggestion feature.
	SuggestionFeature *SuggestionFeature `protobuf:"bytes,5,opt,name=suggestion_feature,json=suggestionFeature,proto3" json:"suggestion_feature,omitempty"`
	// Automatically iterates all participants and tries to compile
	// suggestions.
	//
	// Supported features: ARTICLE_SUGGESTION, FAQ, DIALOGFLOW_ASSIST,
	// ENTITY_EXTRACTION, KNOWLEDGE_ASSIST.
	EnableEventBasedSuggestion bool `protobuf:"varint,3,opt,name=enable_event_based_suggestion,json=enableEventBasedSuggestion,proto3" json:"enable_event_based_suggestion,omitempty"`
	// Optional. Disable the logging of search queries sent by human agents. It
	// can prevent those queries from being stored at answer records.
	//
	// Supported features: KNOWLEDGE_SEARCH.
	DisableAgentQueryLogging bool `protobuf:"varint,14,opt,name=disable_agent_query_logging,json=disableAgentQueryLogging,proto3" json:"disable_agent_query_logging,omitempty"`
	// Optional. Enable query suggestion even if we can't find its answer.
	// By default, queries are suggested only if we find its answer.
	// Supported features: KNOWLEDGE_ASSIST
	EnableQuerySuggestionWhenNoAnswer bool `protobuf:"varint,15,opt,name=enable_query_suggestion_when_no_answer,json=enableQuerySuggestionWhenNoAnswer,proto3" json:"enable_query_suggestion_when_no_answer,omitempty"`
	// Optional. Enable including conversation context during query answer
	// generation. Supported features: KNOWLEDGE_SEARCH.
	EnableConversationAugmentedQuery bool `protobuf:"varint,16,opt,name=enable_conversation_augmented_query,json=enableConversationAugmentedQuery,proto3" json:"enable_conversation_augmented_query,omitempty"`
	// Optional. Enable query suggestion only.
	// Supported features: KNOWLEDGE_ASSIST
	EnableQuerySuggestionOnly bool `protobuf:"varint,17,opt,name=enable_query_suggestion_only,json=enableQuerySuggestionOnly,proto3" json:"enable_query_suggestion_only,omitempty"`
	// Settings of suggestion trigger.
	//
	// Currently, only ARTICLE_SUGGESTION, FAQ, and DIALOGFLOW_ASSIST will use
	// this field.
	SuggestionTriggerSettings *HumanAgentAssistantConfig_SuggestionTriggerSettings `protobuf:"bytes,10,opt,name=suggestion_trigger_settings,json=suggestionTriggerSettings,proto3" json:"suggestion_trigger_settings,omitempty"`
	// Configs of query.
	QueryConfig *HumanAgentAssistantConfig_SuggestionQueryConfig `protobuf:"bytes,6,opt,name=query_config,json=queryConfig,proto3" json:"query_config,omitempty"`
	// Configs of custom conversation model.
	ConversationModelConfig *HumanAgentAssistantConfig_ConversationModelConfig `protobuf:"bytes,7,opt,name=conversation_model_config,json=conversationModelConfig,proto3" json:"conversation_model_config,omitempty"`
	// Configs for processing conversation.
	ConversationProcessConfig *HumanAgentAssistantConfig_ConversationProcessConfig `protobuf:"bytes,8,opt,name=conversation_process_config,json=conversationProcessConfig,proto3" json:"conversation_process_config,omitempty"`
}

func (x *HumanAgentAssistantConfig_SuggestionFeatureConfig) Reset() {
	*x = HumanAgentAssistantConfig_SuggestionFeatureConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HumanAgentAssistantConfig_SuggestionFeatureConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HumanAgentAssistantConfig_SuggestionFeatureConfig) ProtoMessage() {}

func (x *HumanAgentAssistantConfig_SuggestionFeatureConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HumanAgentAssistantConfig_SuggestionFeatureConfig.ProtoReflect.Descriptor instead.
func (*HumanAgentAssistantConfig_SuggestionFeatureConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_rawDescGZIP(), []int{2, 1}
}

func (x *HumanAgentAssistantConfig_SuggestionFeatureConfig) GetSuggestionFeature() *SuggestionFeature {
	if x != nil {
		return x.SuggestionFeature
	}
	return nil
}

func (x *HumanAgentAssistantConfig_SuggestionFeatureConfig) GetEnableEventBasedSuggestion() bool {
	if x != nil {
		return x.EnableEventBasedSuggestion
	}
	return false
}

func (x *HumanAgentAssistantConfig_SuggestionFeatureConfig) GetDisableAgentQueryLogging() bool {
	if x != nil {
		return x.DisableAgentQueryLogging
	}
	return false
}

func (x *HumanAgentAssistantConfig_SuggestionFeatureConfig) GetEnableQuerySuggestionWhenNoAnswer() bool {
	if x != nil {
		return x.EnableQuerySuggestionWhenNoAnswer
	}
	return false
}

func (x *HumanAgentAssistantConfig_SuggestionFeatureConfig) GetEnableConversationAugmentedQuery() bool {
	if x != nil {
		return x.EnableConversationAugmentedQuery
	}
	return false
}

func (x *HumanAgentAssistantConfig_SuggestionFeatureConfig) GetEnableQuerySuggestionOnly() bool {
	if x != nil {
		return x.EnableQuerySuggestionOnly
	}
	return false
}

func (x *HumanAgentAssistantConfig_SuggestionFeatureConfig) GetSuggestionTriggerSettings() *HumanAgentAssistantConfig_SuggestionTriggerSettings {
	if x != nil {
		return x.SuggestionTriggerSettings
	}
	return nil
}

func (x *HumanAgentAssistantConfig_SuggestionFeatureConfig) GetQueryConfig() *HumanAgentAssistantConfig_SuggestionQueryConfig {
	if x != nil {
		return x.QueryConfig
	}
	return nil
}

func (x *HumanAgentAssistantConfig_SuggestionFeatureConfig) GetConversationModelConfig() *HumanAgentAssistantConfig_ConversationModelConfig {
	if x != nil {
		return x.ConversationModelConfig
	}
	return nil
}

func (x *HumanAgentAssistantConfig_SuggestionFeatureConfig) GetConversationProcessConfig() *HumanAgentAssistantConfig_ConversationProcessConfig {
	if x != nil {
		return x.ConversationProcessConfig
	}
	return nil
}

// Detail human agent assistant config.
type HumanAgentAssistantConfig_SuggestionConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Configuration of different suggestion features. One feature can have only
	// one config.
	FeatureConfigs []*HumanAgentAssistantConfig_SuggestionFeatureConfig `protobuf:"bytes,2,rep,name=feature_configs,json=featureConfigs,proto3" json:"feature_configs,omitempty"`
	// If `group_suggestion_responses` is false, and there are multiple
	// `feature_configs` in `event based suggestion` or
	// StreamingAnalyzeContent, we will try to deliver suggestions to customers
	// as soon as we get new suggestion. Different type of suggestions based on
	// the same context will be in  separate Pub/Sub event or
	// `StreamingAnalyzeContentResponse`.
	//
	// If `group_suggestion_responses` set to true. All the suggestions to the
	// same participant based on the same context will be grouped into a single
	// Pub/Sub event or StreamingAnalyzeContentResponse.
	GroupSuggestionResponses bool `protobuf:"varint,3,opt,name=group_suggestion_responses,json=groupSuggestionResponses,proto3" json:"group_suggestion_responses,omitempty"`
	// Optional. List of various generator resource names used in the
	// conversation profile.
	Generators []string `protobuf:"bytes,4,rep,name=generators,proto3" json:"generators,omitempty"`
	// Optional. When disable_high_latency_features_sync_delivery is true and
	// using the AnalyzeContent API, we will not deliver the responses from high
	// latency features in the API response. The
	// human_agent_assistant_config.notification_config must be configured and
	// enable_event_based_suggestion must be set to true to receive the
	// responses from high latency features in Pub/Sub. High latency feature(s):
	// KNOWLEDGE_ASSIST
	DisableHighLatencyFeaturesSyncDelivery bool `protobuf:"varint,5,opt,name=disable_high_latency_features_sync_delivery,json=disableHighLatencyFeaturesSyncDelivery,proto3" json:"disable_high_latency_features_sync_delivery,omitempty"`
}

func (x *HumanAgentAssistantConfig_SuggestionConfig) Reset() {
	*x = HumanAgentAssistantConfig_SuggestionConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HumanAgentAssistantConfig_SuggestionConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HumanAgentAssistantConfig_SuggestionConfig) ProtoMessage() {}

func (x *HumanAgentAssistantConfig_SuggestionConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HumanAgentAssistantConfig_SuggestionConfig.ProtoReflect.Descriptor instead.
func (*HumanAgentAssistantConfig_SuggestionConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_rawDescGZIP(), []int{2, 2}
}

func (x *HumanAgentAssistantConfig_SuggestionConfig) GetFeatureConfigs() []*HumanAgentAssistantConfig_SuggestionFeatureConfig {
	if x != nil {
		return x.FeatureConfigs
	}
	return nil
}

func (x *HumanAgentAssistantConfig_SuggestionConfig) GetGroupSuggestionResponses() bool {
	if x != nil {
		return x.GroupSuggestionResponses
	}
	return false
}

func (x *HumanAgentAssistantConfig_SuggestionConfig) GetGenerators() []string {
	if x != nil {
		return x.Generators
	}
	return nil
}

func (x *HumanAgentAssistantConfig_SuggestionConfig) GetDisableHighLatencyFeaturesSyncDelivery() bool {
	if x != nil {
		return x.DisableHighLatencyFeaturesSyncDelivery
	}
	return false
}

// Config for suggestion query.
type HumanAgentAssistantConfig_SuggestionQueryConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Source of query.
	//
	// Types that are assignable to QuerySource:
	//
	//	*HumanAgentAssistantConfig_SuggestionQueryConfig_KnowledgeBaseQuerySource_
	//	*HumanAgentAssistantConfig_SuggestionQueryConfig_DocumentQuerySource_
	//	*HumanAgentAssistantConfig_SuggestionQueryConfig_DialogflowQuerySource_
	QuerySource isHumanAgentAssistantConfig_SuggestionQueryConfig_QuerySource `protobuf_oneof:"query_source"`
	// Maximum number of results to return. Currently, if unset, defaults to 10.
	// And the max number is 20.
	MaxResults int32 `protobuf:"varint,4,opt,name=max_results,json=maxResults,proto3" json:"max_results,omitempty"`
	// Confidence threshold of query result.
	//
	// Agent Assist gives each suggestion a score in the range [0.0, 1.0], based
	// on the relevance between the suggestion and the current conversation
	// context. A score of 0.0 has no relevance, while a score of 1.0 has high
	// relevance. Only suggestions with a score greater than or equal to the
	// value of this field are included in the results.
	//
	// For a baseline model (the default), the recommended value is in the range
	// [0.05, 0.1].
	//
	// For a custom model, there is no recommended value. Tune this value by
	// starting from a very low value and slowly increasing until you have
	// desired results.
	//
	// If this field is not set, it is default to 0.0, which means that all
	// suggestions are returned.
	//
	// Supported features: ARTICLE_SUGGESTION, FAQ, SMART_REPLY, SMART_COMPOSE,
	// KNOWLEDGE_SEARCH, KNOWLEDGE_ASSIST, ENTITY_EXTRACTION.
	ConfidenceThreshold float32 `protobuf:"fixed32,5,opt,name=confidence_threshold,json=confidenceThreshold,proto3" json:"confidence_threshold,omitempty"`
	// Determines how recent conversation context is filtered when generating
	// suggestions. If unspecified, no messages will be dropped.
	ContextFilterSettings *HumanAgentAssistantConfig_SuggestionQueryConfig_ContextFilterSettings `protobuf:"bytes,7,opt,name=context_filter_settings,json=contextFilterSettings,proto3" json:"context_filter_settings,omitempty"`
	// Optional. The customized sections chosen to return when requesting a
	// summary of a conversation.
	Sections *HumanAgentAssistantConfig_SuggestionQueryConfig_Sections `protobuf:"bytes,8,opt,name=sections,proto3" json:"sections,omitempty"`
}

func (x *HumanAgentAssistantConfig_SuggestionQueryConfig) Reset() {
	*x = HumanAgentAssistantConfig_SuggestionQueryConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HumanAgentAssistantConfig_SuggestionQueryConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HumanAgentAssistantConfig_SuggestionQueryConfig) ProtoMessage() {}

func (x *HumanAgentAssistantConfig_SuggestionQueryConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HumanAgentAssistantConfig_SuggestionQueryConfig.ProtoReflect.Descriptor instead.
func (*HumanAgentAssistantConfig_SuggestionQueryConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_rawDescGZIP(), []int{2, 3}
}

func (m *HumanAgentAssistantConfig_SuggestionQueryConfig) GetQuerySource() isHumanAgentAssistantConfig_SuggestionQueryConfig_QuerySource {
	if m != nil {
		return m.QuerySource
	}
	return nil
}

func (x *HumanAgentAssistantConfig_SuggestionQueryConfig) GetKnowledgeBaseQuerySource() *HumanAgentAssistantConfig_SuggestionQueryConfig_KnowledgeBaseQuerySource {
	if x, ok := x.GetQuerySource().(*HumanAgentAssistantConfig_SuggestionQueryConfig_KnowledgeBaseQuerySource_); ok {
		return x.KnowledgeBaseQuerySource
	}
	return nil
}

func (x *HumanAgentAssistantConfig_SuggestionQueryConfig) GetDocumentQuerySource() *HumanAgentAssistantConfig_SuggestionQueryConfig_DocumentQuerySource {
	if x, ok := x.GetQuerySource().(*HumanAgentAssistantConfig_SuggestionQueryConfig_DocumentQuerySource_); ok {
		return x.DocumentQuerySource
	}
	return nil
}

func (x *HumanAgentAssistantConfig_SuggestionQueryConfig) GetDialogflowQuerySource() *HumanAgentAssistantConfig_SuggestionQueryConfig_DialogflowQuerySource {
	if x, ok := x.GetQuerySource().(*HumanAgentAssistantConfig_SuggestionQueryConfig_DialogflowQuerySource_); ok {
		return x.DialogflowQuerySource
	}
	return nil
}

func (x *HumanAgentAssistantConfig_SuggestionQueryConfig) GetMaxResults() int32 {
	if x != nil {
		return x.MaxResults
	}
	return 0
}

func (x *HumanAgentAssistantConfig_SuggestionQueryConfig) GetConfidenceThreshold() float32 {
	if x != nil {
		return x.ConfidenceThreshold
	}
	return 0
}

func (x *HumanAgentAssistantConfig_SuggestionQueryConfig) GetContextFilterSettings() *HumanAgentAssistantConfig_SuggestionQueryConfig_ContextFilterSettings {
	if x != nil {
		return x.ContextFilterSettings
	}
	return nil
}

func (x *HumanAgentAssistantConfig_SuggestionQueryConfig) GetSections() *HumanAgentAssistantConfig_SuggestionQueryConfig_Sections {
	if x != nil {
		return x.Sections
	}
	return nil
}

type isHumanAgentAssistantConfig_SuggestionQueryConfig_QuerySource interface {
	isHumanAgentAssistantConfig_SuggestionQueryConfig_QuerySource()
}

type HumanAgentAssistantConfig_SuggestionQueryConfig_KnowledgeBaseQuerySource_ struct {
	// Query from knowledgebase. It is used by:
	// ARTICLE_SUGGESTION, FAQ.
	KnowledgeBaseQuerySource *HumanAgentAssistantConfig_SuggestionQueryConfig_KnowledgeBaseQuerySource `protobuf:"bytes,1,opt,name=knowledge_base_query_source,json=knowledgeBaseQuerySource,proto3,oneof"`
}

type HumanAgentAssistantConfig_SuggestionQueryConfig_DocumentQuerySource_ struct {
	// Query from knowledge base document. It is used by:
	// SMART_REPLY, SMART_COMPOSE.
	DocumentQuerySource *HumanAgentAssistantConfig_SuggestionQueryConfig_DocumentQuerySource `protobuf:"bytes,2,opt,name=document_query_source,json=documentQuerySource,proto3,oneof"`
}

type HumanAgentAssistantConfig_SuggestionQueryConfig_DialogflowQuerySource_ struct {
	// Query from Dialogflow agent. It is used by DIALOGFLOW_ASSIST,
	// ENTITY_EXTRACTION.
	DialogflowQuerySource *HumanAgentAssistantConfig_SuggestionQueryConfig_DialogflowQuerySource `protobuf:"bytes,3,opt,name=dialogflow_query_source,json=dialogflowQuerySource,proto3,oneof"`
}

func (*HumanAgentAssistantConfig_SuggestionQueryConfig_KnowledgeBaseQuerySource_) isHumanAgentAssistantConfig_SuggestionQueryConfig_QuerySource() {
}

func (*HumanAgentAssistantConfig_SuggestionQueryConfig_DocumentQuerySource_) isHumanAgentAssistantConfig_SuggestionQueryConfig_QuerySource() {
}

func (*HumanAgentAssistantConfig_SuggestionQueryConfig_DialogflowQuerySource_) isHumanAgentAssistantConfig_SuggestionQueryConfig_QuerySource() {
}

// Custom conversation models used in agent assist feature.
//
// Supported feature: ARTICLE_SUGGESTION, SMART_COMPOSE, SMART_REPLY,
// CONVERSATION_SUMMARIZATION.
type HumanAgentAssistantConfig_ConversationModelConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Conversation model resource name. Format: `projects/<Project
	// ID>/conversationModels/<Model ID>`.
	Model string `protobuf:"bytes,1,opt,name=model,proto3" json:"model,omitempty"`
	// Version of current baseline model. It will be ignored if
	// [model][google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationModelConfig.model]
	// is set. Valid versions are:
	//
	//	Article Suggestion baseline model:
	//	  - 0.9
	//	  - 1.0 (default)
	//	Summarization baseline model:
	//	  - 1.0
	BaselineModelVersion string `protobuf:"bytes,8,opt,name=baseline_model_version,json=baselineModelVersion,proto3" json:"baseline_model_version,omitempty"`
}

func (x *HumanAgentAssistantConfig_ConversationModelConfig) Reset() {
	*x = HumanAgentAssistantConfig_ConversationModelConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HumanAgentAssistantConfig_ConversationModelConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HumanAgentAssistantConfig_ConversationModelConfig) ProtoMessage() {}

func (x *HumanAgentAssistantConfig_ConversationModelConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HumanAgentAssistantConfig_ConversationModelConfig.ProtoReflect.Descriptor instead.
func (*HumanAgentAssistantConfig_ConversationModelConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_rawDescGZIP(), []int{2, 4}
}

func (x *HumanAgentAssistantConfig_ConversationModelConfig) GetModel() string {
	if x != nil {
		return x.Model
	}
	return ""
}

func (x *HumanAgentAssistantConfig_ConversationModelConfig) GetBaselineModelVersion() string {
	if x != nil {
		return x.BaselineModelVersion
	}
	return ""
}

// Config to process conversation.
type HumanAgentAssistantConfig_ConversationProcessConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Number of recent non-small-talk sentences to use as context for article
	// and FAQ suggestion
	RecentSentencesCount int32 `protobuf:"varint,2,opt,name=recent_sentences_count,json=recentSentencesCount,proto3" json:"recent_sentences_count,omitempty"`
}

func (x *HumanAgentAssistantConfig_ConversationProcessConfig) Reset() {
	*x = HumanAgentAssistantConfig_ConversationProcessConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HumanAgentAssistantConfig_ConversationProcessConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HumanAgentAssistantConfig_ConversationProcessConfig) ProtoMessage() {}

func (x *HumanAgentAssistantConfig_ConversationProcessConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HumanAgentAssistantConfig_ConversationProcessConfig.ProtoReflect.Descriptor instead.
func (*HumanAgentAssistantConfig_ConversationProcessConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_rawDescGZIP(), []int{2, 5}
}

func (x *HumanAgentAssistantConfig_ConversationProcessConfig) GetRecentSentencesCount() int32 {
	if x != nil {
		return x.RecentSentencesCount
	}
	return 0
}

// Configuration for analyses to run on each conversation message.
type HumanAgentAssistantConfig_MessageAnalysisConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Enable entity extraction in conversation messages on [agent assist
	// stage](https://cloud.google.com/dialogflow/priv/docs/contact-center/basics#stages).
	// If unspecified, defaults to false.
	//
	// Currently, this feature is not general available, please contact Google
	// to get access.
	EnableEntityExtraction bool `protobuf:"varint,2,opt,name=enable_entity_extraction,json=enableEntityExtraction,proto3" json:"enable_entity_extraction,omitempty"`
	// Enable sentiment analysis in conversation messages on [agent assist
	// stage](https://cloud.google.com/dialogflow/priv/docs/contact-center/basics#stages).
	// If unspecified, defaults to false. Sentiment analysis inspects user input
	// and identifies the prevailing subjective opinion, especially to determine
	// a user's attitude as positive, negative, or neutral:
	// https://cloud.google.com/natural-language/docs/basics#sentiment_analysis
	// For
	// [Participants.StreamingAnalyzeContent][google.cloud.dialogflow.v2beta1.Participants.StreamingAnalyzeContent]
	// method, result will be in
	// [StreamingAnalyzeContentResponse.message.SentimentAnalysisResult][google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentResponse.message].
	// For
	// [Participants.AnalyzeContent][google.cloud.dialogflow.v2beta1.Participants.AnalyzeContent]
	// method, result will be in
	// [AnalyzeContentResponse.message.SentimentAnalysisResult][google.cloud.dialogflow.v2beta1.AnalyzeContentResponse.message]
	// For
	// [Conversations.ListMessages][google.cloud.dialogflow.v2beta1.Conversations.ListMessages]
	// method, result will be in
	// [ListMessagesResponse.messages.SentimentAnalysisResult][google.cloud.dialogflow.v2beta1.ListMessagesResponse.messages]
	// If Pub/Sub notification is configured, result will be in
	// [ConversationEvent.new_message_payload.SentimentAnalysisResult][google.cloud.dialogflow.v2beta1.ConversationEvent.new_message_payload].
	EnableSentimentAnalysis bool `protobuf:"varint,3,opt,name=enable_sentiment_analysis,json=enableSentimentAnalysis,proto3" json:"enable_sentiment_analysis,omitempty"`
}

func (x *HumanAgentAssistantConfig_MessageAnalysisConfig) Reset() {
	*x = HumanAgentAssistantConfig_MessageAnalysisConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HumanAgentAssistantConfig_MessageAnalysisConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HumanAgentAssistantConfig_MessageAnalysisConfig) ProtoMessage() {}

func (x *HumanAgentAssistantConfig_MessageAnalysisConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HumanAgentAssistantConfig_MessageAnalysisConfig.ProtoReflect.Descriptor instead.
func (*HumanAgentAssistantConfig_MessageAnalysisConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_rawDescGZIP(), []int{2, 6}
}

func (x *HumanAgentAssistantConfig_MessageAnalysisConfig) GetEnableEntityExtraction() bool {
	if x != nil {
		return x.EnableEntityExtraction
	}
	return false
}

func (x *HumanAgentAssistantConfig_MessageAnalysisConfig) GetEnableSentimentAnalysis() bool {
	if x != nil {
		return x.EnableSentimentAnalysis
	}
	return false
}

// Knowledge base source settings.
//
// Supported features: ARTICLE_SUGGESTION, FAQ.
type HumanAgentAssistantConfig_SuggestionQueryConfig_KnowledgeBaseQuerySource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Knowledge bases to query. Format:
	// `projects/<Project ID>/locations/<Location
	// ID>/knowledgeBases/<Knowledge Base ID>`. Currently, only one knowledge
	// base is supported.
	KnowledgeBases []string `protobuf:"bytes,1,rep,name=knowledge_bases,json=knowledgeBases,proto3" json:"knowledge_bases,omitempty"`
}

func (x *HumanAgentAssistantConfig_SuggestionQueryConfig_KnowledgeBaseQuerySource) Reset() {
	*x = HumanAgentAssistantConfig_SuggestionQueryConfig_KnowledgeBaseQuerySource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HumanAgentAssistantConfig_SuggestionQueryConfig_KnowledgeBaseQuerySource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HumanAgentAssistantConfig_SuggestionQueryConfig_KnowledgeBaseQuerySource) ProtoMessage() {}

func (x *HumanAgentAssistantConfig_SuggestionQueryConfig_KnowledgeBaseQuerySource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HumanAgentAssistantConfig_SuggestionQueryConfig_KnowledgeBaseQuerySource.ProtoReflect.Descriptor instead.
func (*HumanAgentAssistantConfig_SuggestionQueryConfig_KnowledgeBaseQuerySource) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_rawDescGZIP(), []int{2, 3, 0}
}

func (x *HumanAgentAssistantConfig_SuggestionQueryConfig_KnowledgeBaseQuerySource) GetKnowledgeBases() []string {
	if x != nil {
		return x.KnowledgeBases
	}
	return nil
}

// Document source settings.
//
// Supported features: SMART_REPLY, SMART_COMPOSE.
type HumanAgentAssistantConfig_SuggestionQueryConfig_DocumentQuerySource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Knowledge documents to query from. Format:
	// `projects/<Project ID>/locations/<Location
	// ID>/knowledgeBases/<KnowledgeBase ID>/documents/<Document ID>`.
	// Currently, only one document is supported.
	Documents []string `protobuf:"bytes,1,rep,name=documents,proto3" json:"documents,omitempty"`
}

func (x *HumanAgentAssistantConfig_SuggestionQueryConfig_DocumentQuerySource) Reset() {
	*x = HumanAgentAssistantConfig_SuggestionQueryConfig_DocumentQuerySource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HumanAgentAssistantConfig_SuggestionQueryConfig_DocumentQuerySource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HumanAgentAssistantConfig_SuggestionQueryConfig_DocumentQuerySource) ProtoMessage() {}

func (x *HumanAgentAssistantConfig_SuggestionQueryConfig_DocumentQuerySource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HumanAgentAssistantConfig_SuggestionQueryConfig_DocumentQuerySource.ProtoReflect.Descriptor instead.
func (*HumanAgentAssistantConfig_SuggestionQueryConfig_DocumentQuerySource) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_rawDescGZIP(), []int{2, 3, 1}
}

func (x *HumanAgentAssistantConfig_SuggestionQueryConfig_DocumentQuerySource) GetDocuments() []string {
	if x != nil {
		return x.Documents
	}
	return nil
}

// Dialogflow source setting.
//
// Supported feature: DIALOGFLOW_ASSIST, ENTITY_EXTRACTION.
type HumanAgentAssistantConfig_SuggestionQueryConfig_DialogflowQuerySource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of a dialogflow virtual agent used for end user side
	// intent detection and suggestion. Format: `projects/<Project
	// ID>/locations/<Location ID>/agent`. When multiple agents are allowed in
	// the same Dialogflow project.
	Agent string `protobuf:"bytes,1,opt,name=agent,proto3" json:"agent,omitempty"`
	// The Dialogflow assist configuration for human agent.
	HumanAgentSideConfig *HumanAgentAssistantConfig_SuggestionQueryConfig_DialogflowQuerySource_HumanAgentSideConfig `protobuf:"bytes,3,opt,name=human_agent_side_config,json=humanAgentSideConfig,proto3" json:"human_agent_side_config,omitempty"`
}

func (x *HumanAgentAssistantConfig_SuggestionQueryConfig_DialogflowQuerySource) Reset() {
	*x = HumanAgentAssistantConfig_SuggestionQueryConfig_DialogflowQuerySource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HumanAgentAssistantConfig_SuggestionQueryConfig_DialogflowQuerySource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HumanAgentAssistantConfig_SuggestionQueryConfig_DialogflowQuerySource) ProtoMessage() {}

func (x *HumanAgentAssistantConfig_SuggestionQueryConfig_DialogflowQuerySource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HumanAgentAssistantConfig_SuggestionQueryConfig_DialogflowQuerySource.ProtoReflect.Descriptor instead.
func (*HumanAgentAssistantConfig_SuggestionQueryConfig_DialogflowQuerySource) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_rawDescGZIP(), []int{2, 3, 2}
}

func (x *HumanAgentAssistantConfig_SuggestionQueryConfig_DialogflowQuerySource) GetAgent() string {
	if x != nil {
		return x.Agent
	}
	return ""
}

func (x *HumanAgentAssistantConfig_SuggestionQueryConfig_DialogflowQuerySource) GetHumanAgentSideConfig() *HumanAgentAssistantConfig_SuggestionQueryConfig_DialogflowQuerySource_HumanAgentSideConfig {
	if x != nil {
		return x.HumanAgentSideConfig
	}
	return nil
}

// Settings that determine how to filter recent conversation context when
// generating suggestions.
type HumanAgentAssistantConfig_SuggestionQueryConfig_ContextFilterSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// If set to true, the last message from virtual agent (hand off message)
	// and the message before it (trigger message of hand off) are dropped.
	DropHandoffMessages bool `protobuf:"varint,1,opt,name=drop_handoff_messages,json=dropHandoffMessages,proto3" json:"drop_handoff_messages,omitempty"`
	// If set to true, all messages from virtual agent are dropped.
	DropVirtualAgentMessages bool `protobuf:"varint,2,opt,name=drop_virtual_agent_messages,json=dropVirtualAgentMessages,proto3" json:"drop_virtual_agent_messages,omitempty"`
	// If set to true, all messages from ivr stage are dropped.
	DropIvrMessages bool `protobuf:"varint,3,opt,name=drop_ivr_messages,json=dropIvrMessages,proto3" json:"drop_ivr_messages,omitempty"`
}

func (x *HumanAgentAssistantConfig_SuggestionQueryConfig_ContextFilterSettings) Reset() {
	*x = HumanAgentAssistantConfig_SuggestionQueryConfig_ContextFilterSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HumanAgentAssistantConfig_SuggestionQueryConfig_ContextFilterSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HumanAgentAssistantConfig_SuggestionQueryConfig_ContextFilterSettings) ProtoMessage() {}

func (x *HumanAgentAssistantConfig_SuggestionQueryConfig_ContextFilterSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HumanAgentAssistantConfig_SuggestionQueryConfig_ContextFilterSettings.ProtoReflect.Descriptor instead.
func (*HumanAgentAssistantConfig_SuggestionQueryConfig_ContextFilterSettings) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_rawDescGZIP(), []int{2, 3, 3}
}

func (x *HumanAgentAssistantConfig_SuggestionQueryConfig_ContextFilterSettings) GetDropHandoffMessages() bool {
	if x != nil {
		return x.DropHandoffMessages
	}
	return false
}

func (x *HumanAgentAssistantConfig_SuggestionQueryConfig_ContextFilterSettings) GetDropVirtualAgentMessages() bool {
	if x != nil {
		return x.DropVirtualAgentMessages
	}
	return false
}

func (x *HumanAgentAssistantConfig_SuggestionQueryConfig_ContextFilterSettings) GetDropIvrMessages() bool {
	if x != nil {
		return x.DropIvrMessages
	}
	return false
}

// Custom sections to return when requesting a summary of a conversation.
// This is only supported when `baseline_model_version` == '2.0'.
//
// Supported features: CONVERSATION_SUMMARIZATION,
// CONVERSATION_SUMMARIZATION_VOICE.
type HumanAgentAssistantConfig_SuggestionQueryConfig_Sections struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The selected sections chosen to return when requesting a summary of a
	// conversation. A duplicate selected section will be treated as a single
	// selected section. If section types are not provided, the default will
	// be {SITUATION, ACTION, RESULT}.
	SectionTypes []HumanAgentAssistantConfig_SuggestionQueryConfig_Sections_SectionType `protobuf:"varint,1,rep,packed,name=section_types,json=sectionTypes,proto3,enum=google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig_SuggestionQueryConfig_Sections_SectionType" json:"section_types,omitempty"`
}

func (x *HumanAgentAssistantConfig_SuggestionQueryConfig_Sections) Reset() {
	*x = HumanAgentAssistantConfig_SuggestionQueryConfig_Sections{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HumanAgentAssistantConfig_SuggestionQueryConfig_Sections) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HumanAgentAssistantConfig_SuggestionQueryConfig_Sections) ProtoMessage() {}

func (x *HumanAgentAssistantConfig_SuggestionQueryConfig_Sections) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HumanAgentAssistantConfig_SuggestionQueryConfig_Sections.ProtoReflect.Descriptor instead.
func (*HumanAgentAssistantConfig_SuggestionQueryConfig_Sections) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_rawDescGZIP(), []int{2, 3, 4}
}

func (x *HumanAgentAssistantConfig_SuggestionQueryConfig_Sections) GetSectionTypes() []HumanAgentAssistantConfig_SuggestionQueryConfig_Sections_SectionType {
	if x != nil {
		return x.SectionTypes
	}
	return nil
}

// The configuration used for human agent side Dialogflow assist
// suggestion.
type HumanAgentAssistantConfig_SuggestionQueryConfig_DialogflowQuerySource_HumanAgentSideConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The name of a dialogflow virtual agent used for intent
	// detection and suggestion triggered by human agent.
	// Format: `projects/<Project ID>/locations/<Location ID>/agent`.
	Agent string `protobuf:"bytes,1,opt,name=agent,proto3" json:"agent,omitempty"`
}

func (x *HumanAgentAssistantConfig_SuggestionQueryConfig_DialogflowQuerySource_HumanAgentSideConfig) Reset() {
	*x = HumanAgentAssistantConfig_SuggestionQueryConfig_DialogflowQuerySource_HumanAgentSideConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HumanAgentAssistantConfig_SuggestionQueryConfig_DialogflowQuerySource_HumanAgentSideConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HumanAgentAssistantConfig_SuggestionQueryConfig_DialogflowQuerySource_HumanAgentSideConfig) ProtoMessage() {
}

func (x *HumanAgentAssistantConfig_SuggestionQueryConfig_DialogflowQuerySource_HumanAgentSideConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HumanAgentAssistantConfig_SuggestionQueryConfig_DialogflowQuerySource_HumanAgentSideConfig.ProtoReflect.Descriptor instead.
func (*HumanAgentAssistantConfig_SuggestionQueryConfig_DialogflowQuerySource_HumanAgentSideConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_rawDescGZIP(), []int{2, 3, 2, 0}
}

func (x *HumanAgentAssistantConfig_SuggestionQueryConfig_DialogflowQuerySource_HumanAgentSideConfig) GetAgent() string {
	if x != nil {
		return x.Agent
	}
	return ""
}

// Configuration specific to [LivePerson](https://www.liveperson.com).
type HumanAgentHandoffConfig_LivePersonConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Account number of the LivePerson account to connect. This is
	// the account number you input at the login page.
	AccountNumber string `protobuf:"bytes,1,opt,name=account_number,json=accountNumber,proto3" json:"account_number,omitempty"`
}

func (x *HumanAgentHandoffConfig_LivePersonConfig) Reset() {
	*x = HumanAgentHandoffConfig_LivePersonConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HumanAgentHandoffConfig_LivePersonConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HumanAgentHandoffConfig_LivePersonConfig) ProtoMessage() {}

func (x *HumanAgentHandoffConfig_LivePersonConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HumanAgentHandoffConfig_LivePersonConfig.ProtoReflect.Descriptor instead.
func (*HumanAgentHandoffConfig_LivePersonConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_rawDescGZIP(), []int{3, 0}
}

func (x *HumanAgentHandoffConfig_LivePersonConfig) GetAccountNumber() string {
	if x != nil {
		return x.AccountNumber
	}
	return ""
}

// Configuration specific to Salesforce Live Agent.
type HumanAgentHandoffConfig_SalesforceLiveAgentConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The organization ID of the Salesforce account.
	OrganizationId string `protobuf:"bytes,1,opt,name=organization_id,json=organizationId,proto3" json:"organization_id,omitempty"`
	// Required. Live Agent deployment ID.
	DeploymentId string `protobuf:"bytes,2,opt,name=deployment_id,json=deploymentId,proto3" json:"deployment_id,omitempty"`
	// Required. Live Agent chat button ID.
	ButtonId string `protobuf:"bytes,3,opt,name=button_id,json=buttonId,proto3" json:"button_id,omitempty"`
	// Required. Domain of the Live Agent endpoint for this agent. You can find
	// the endpoint URL in the `Live Agent settings` page. For example if URL
	// has the form https://d.la4-c2-phx.salesforceliveagent.com/...,
	// you should fill in d.la4-c2-phx.salesforceliveagent.com.
	EndpointDomain string `protobuf:"bytes,4,opt,name=endpoint_domain,json=endpointDomain,proto3" json:"endpoint_domain,omitempty"`
}

func (x *HumanAgentHandoffConfig_SalesforceLiveAgentConfig) Reset() {
	*x = HumanAgentHandoffConfig_SalesforceLiveAgentConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HumanAgentHandoffConfig_SalesforceLiveAgentConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HumanAgentHandoffConfig_SalesforceLiveAgentConfig) ProtoMessage() {}

func (x *HumanAgentHandoffConfig_SalesforceLiveAgentConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HumanAgentHandoffConfig_SalesforceLiveAgentConfig.ProtoReflect.Descriptor instead.
func (*HumanAgentHandoffConfig_SalesforceLiveAgentConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_rawDescGZIP(), []int{3, 1}
}

func (x *HumanAgentHandoffConfig_SalesforceLiveAgentConfig) GetOrganizationId() string {
	if x != nil {
		return x.OrganizationId
	}
	return ""
}

func (x *HumanAgentHandoffConfig_SalesforceLiveAgentConfig) GetDeploymentId() string {
	if x != nil {
		return x.DeploymentId
	}
	return ""
}

func (x *HumanAgentHandoffConfig_SalesforceLiveAgentConfig) GetButtonId() string {
	if x != nil {
		return x.ButtonId
	}
	return ""
}

func (x *HumanAgentHandoffConfig_SalesforceLiveAgentConfig) GetEndpointDomain() string {
	if x != nil {
		return x.EndpointDomain
	}
	return ""
}

var File_google_cloud_dialogflow_v2beta1_conversation_profile_proto protoreflect.FileDescriptor

var file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_rawDesc = []byte{
	0x0a, 0x3a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70,
	0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x1a, 0x1c, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x32, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x31, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x76, 0x32,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e,
	0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d,
	0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64,
	0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x94, 0x0b, 0x0a,
	0x13, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f,
	0x66, 0x69, 0x6c, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70,
	0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x6b, 0x0a, 0x16, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x65,
	0x64, 0x5f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76,
	0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x65, 0x64,
	0x41, 0x67, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x14, 0x61, 0x75, 0x74,
	0x6f, 0x6d, 0x61, 0x74, 0x65, 0x64, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x7b, 0x0a, 0x1c, 0x68, 0x75, 0x6d, 0x61, 0x6e, 0x5f, 0x61, 0x67, 0x65, 0x6e, 0x74,
	0x5f, 0x61, 0x73, 0x73, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x48, 0x75, 0x6d, 0x61, 0x6e, 0x41,
	0x67, 0x65, 0x6e, 0x74, 0x41, 0x73, 0x73, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x52, 0x19, 0x68, 0x75, 0x6d, 0x61, 0x6e, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x41,
	0x73, 0x73, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x75,
	0x0a, 0x1a, 0x68, 0x75, 0x6d, 0x61, 0x6e, 0x5f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x68, 0x61,
	0x6e, 0x64, 0x6f, 0x66, 0x66, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x48, 0x75, 0x6d, 0x61, 0x6e, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x48,
	0x61, 0x6e, 0x64, 0x6f, 0x66, 0x66, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x17, 0x68, 0x75,
	0x6d, 0x61, 0x6e, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x48, 0x61, 0x6e, 0x64, 0x6f, 0x66, 0x66, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x64, 0x0a, 0x13, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x12, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x55, 0x0a, 0x0e, 0x6c,
	0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x52, 0x0d, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x85, 0x01, 0x0a, 0x25, 0x6e, 0x65, 0x77, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x08, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x21, 0x6e, 0x65, 0x77, 0x4d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x52, 0x0a, 0x0a, 0x73, 0x74,
	0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x53, 0x70, 0x65, 0x65, 0x63, 0x68, 0x54, 0x6f, 0x54, 0x65, 0x78, 0x74, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x52, 0x09, 0x73, 0x74, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x23,
	0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18,
	0x0a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43,
	0x6f, 0x64, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x7a, 0x6f, 0x6e, 0x65,
	0x18, 0x0e, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x74, 0x69, 0x6d, 0x65, 0x5a, 0x6f, 0x6e, 0x65,
	0x12, 0x5e, 0x0a, 0x11, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x73, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x09, 0x42, 0x31, 0xfa, 0x41, 0x2e,
	0x0a, 0x2c, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x58, 0x53, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x10,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x12, 0x56, 0x0a, 0x0a, 0x74, 0x74, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x12,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76,
	0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x79, 0x6e, 0x74, 0x68, 0x65, 0x73, 0x69, 0x7a,
	0x65, 0x53, 0x70, 0x65, 0x65, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x09, 0x74,
	0x74, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x3a, 0xc8, 0x01, 0xea, 0x41, 0xc4, 0x01, 0x0a,
	0x2d, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x12, 0x3e,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x7d, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50,
	0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x2f, 0x7b, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x7d, 0x12, 0x53,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x2f, 0x7b, 0x63, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69,
	0x6c, 0x65, 0x7d, 0x22, 0x96, 0x01, 0x0a, 0x14, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x65,
	0x64, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3d, 0x0a, 0x05,
	0x61, 0x67, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41,
	0x67, 0x65, 0x6e, 0x74, 0x52, 0x05, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x12, 0x3f, 0x0a, 0x0b, 0x73,
	0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x74, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0a, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x54, 0x74, 0x6c, 0x22, 0xeb, 0x22, 0x0a,
	0x19, 0x48, 0x75, 0x6d, 0x61, 0x6e, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x41, 0x73, 0x73, 0x69, 0x73,
	0x74, 0x61, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x64, 0x0a, 0x13, 0x6e, 0x6f,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x12, 0x6e, 0x6f,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x8e, 0x01, 0x0a, 0x1d, 0x68, 0x75, 0x6d, 0x61, 0x6e, 0x5f, 0x61, 0x67, 0x65, 0x6e, 0x74,
	0x5f, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x48, 0x75, 0x6d, 0x61, 0x6e,
	0x41, 0x67, 0x65, 0x6e, 0x74, 0x41, 0x73, 0x73, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x1a, 0x68, 0x75, 0x6d, 0x61, 0x6e, 0x41, 0x67, 0x65, 0x6e,
	0x74, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x88, 0x01, 0x0a, 0x1a, 0x65, 0x6e, 0x64, 0x5f, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x73,
	0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x48, 0x75, 0x6d, 0x61, 0x6e, 0x41, 0x67,
	0x65, 0x6e, 0x74, 0x41, 0x73, 0x73, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x52, 0x17, 0x65, 0x6e, 0x64, 0x55, 0x73, 0x65, 0x72, 0x53, 0x75, 0x67, 0x67,
	0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x88, 0x01, 0x0a,
	0x17, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69,
	0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x50,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x48, 0x75, 0x6d, 0x61, 0x6e, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x41, 0x73, 0x73, 0x69, 0x73,
	0x74, 0x61, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x52, 0x15, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69,
	0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a, 0x63, 0x0a, 0x19, 0x53, 0x75, 0x67, 0x67, 0x65,
	0x73, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x12, 0x22, 0x0a, 0x0d, 0x6e, 0x6f, 0x5f, 0x73, 0x6d, 0x61, 0x6c, 0x6c,
	0x5f, 0x74, 0x61, 0x6c, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0b, 0x6e, 0x6f, 0x53,
	0x6d, 0x61, 0x6c, 0x6c, 0x54, 0x61, 0x6c, 0x6b, 0x12, 0x22, 0x0a, 0x0d, 0x6f, 0x6e, 0x6c, 0x79,
	0x5f, 0x65, 0x6e, 0x64, 0x5f, 0x75, 0x73, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x0b, 0x6f, 0x6e, 0x6c, 0x79, 0x45, 0x6e, 0x64, 0x55, 0x73, 0x65, 0x72, 0x1a, 0xa9, 0x08, 0x0a,
	0x17, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x65, 0x61, 0x74, 0x75,
	0x72, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x61, 0x0a, 0x12, 0x73, 0x75, 0x67, 0x67,
	0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76,
	0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f,
	0x6e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x52, 0x11, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73,
	0x74, 0x69, 0x6f, 0x6e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x12, 0x41, 0x0a, 0x1d, 0x65,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x62, 0x61, 0x73, 0x65,
	0x64, 0x5f, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x1a, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x42,
	0x61, 0x73, 0x65, 0x64, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x42,
	0x0a, 0x1b, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x18, 0x0e, 0x20,
	0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x18, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c,
	0x65, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x51, 0x75, 0x65, 0x72, 0x79, 0x4c, 0x6f, 0x67, 0x67, 0x69,
	0x6e, 0x67, 0x12, 0x56, 0x0a, 0x26, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x5f, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x77, 0x68,
	0x65, 0x6e, 0x5f, 0x6e, 0x6f, 0x5f, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x18, 0x0f, 0x20, 0x01,
	0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x21, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x51,
	0x75, 0x65, 0x72, 0x79, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x57, 0x68,
	0x65, 0x6e, 0x4e, 0x6f, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x12, 0x52, 0x0a, 0x23, 0x65, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x61, 0x75, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x65, 0x64, 0x5f, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x18, 0x10, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x20, 0x65, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x41, 0x75, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x79, 0x12, 0x44,
	0x0a, 0x1c, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x73,
	0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x11,
	0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x19, 0x65, 0x6e, 0x61, 0x62, 0x6c,
	0x65, 0x51, 0x75, 0x65, 0x72, 0x79, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e,
	0x4f, 0x6e, 0x6c, 0x79, 0x12, 0x94, 0x01, 0x0a, 0x1b, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x5f, 0x73, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x54, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x48, 0x75, 0x6d,
	0x61, 0x6e, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x41, 0x73, 0x73, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x74,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f,
	0x6e, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x52, 0x19, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x72, 0x69, 0x67,
	0x67, 0x65, 0x72, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x73, 0x0a, 0x0c, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x50, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x48, 0x75, 0x6d, 0x61, 0x6e, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x41, 0x73,
	0x73, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x53, 0x75,
	0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x52, 0x0b, 0x71, 0x75, 0x65, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x8e, 0x01, 0x0a, 0x19, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x52, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76,
	0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x48, 0x75, 0x6d, 0x61, 0x6e, 0x41, 0x67, 0x65, 0x6e,
	0x74, 0x41, 0x73, 0x73, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64,
	0x65, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x17, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x94, 0x01, 0x0a, 0x1b, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x54, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x48, 0x75, 0x6d, 0x61, 0x6e, 0x41,
	0x67, 0x65, 0x6e, 0x74, 0x41, 0x73, 0x73, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x19, 0x63,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x63, 0x65,
	0x73, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a, 0xfc, 0x02, 0x0a, 0x10, 0x53, 0x75, 0x67,
	0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x7b, 0x0a,
	0x0f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73,
	0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x52, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x48, 0x75, 0x6d, 0x61, 0x6e, 0x41, 0x67,
	0x65, 0x6e, 0x74, 0x41, 0x73, 0x73, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x65, 0x61,
	0x74, 0x75, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0e, 0x66, 0x65, 0x61, 0x74,
	0x75, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0x3c, 0x0a, 0x1a, 0x67, 0x72,
	0x6f, 0x75, 0x70, 0x5f, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x18,
	0x67, 0x72, 0x6f, 0x75, 0x70, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x73, 0x12, 0x4b, 0x0a, 0x0a, 0x67, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x6f, 0x72, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41,
	0x01, 0xfa, 0x41, 0x25, 0x0a, 0x23, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x52, 0x0a, 0x67, 0x65, 0x6e, 0x65, 0x72,
	0x61, 0x74, 0x6f, 0x72, 0x73, 0x12, 0x60, 0x0a, 0x2b, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65,
	0x5f, 0x68, 0x69, 0x67, 0x68, 0x5f, 0x6c, 0x61, 0x74, 0x65, 0x6e, 0x63, 0x79, 0x5f, 0x66, 0x65,
	0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x5f, 0x73, 0x79, 0x6e, 0x63, 0x5f, 0x64, 0x65, 0x6c, 0x69,
	0x76, 0x65, 0x72, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x26, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x48, 0x69, 0x67, 0x68, 0x4c, 0x61, 0x74, 0x65,
	0x6e, 0x63, 0x79, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x53, 0x79, 0x6e, 0x63, 0x44,
	0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x1a, 0xb3, 0x0f, 0x0a, 0x15, 0x53, 0x75, 0x67, 0x67,
	0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0xaa, 0x01, 0x0a, 0x1b, 0x6b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x5f,
	0x62, 0x61, 0x73, 0x65, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x48, 0x75, 0x6d, 0x61, 0x6e, 0x41,
	0x67, 0x65, 0x6e, 0x74, 0x41, 0x73, 0x73, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2e, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x51, 0x75,
	0x65, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4b, 0x6e, 0x6f, 0x77, 0x6c, 0x65,
	0x64, 0x67, 0x65, 0x42, 0x61, 0x73, 0x65, 0x51, 0x75, 0x65, 0x72, 0x79, 0x53, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x48, 0x00, 0x52, 0x18, 0x6b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x42,
	0x61, 0x73, 0x65, 0x51, 0x75, 0x65, 0x72, 0x79, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x9a,
	0x01, 0x0a, 0x15, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x64,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x48, 0x75, 0x6d, 0x61, 0x6e, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x41, 0x73, 0x73, 0x69, 0x73,
	0x74, 0x61, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x53, 0x75, 0x67, 0x67, 0x65,
	0x73, 0x74, 0x69, 0x6f, 0x6e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x51, 0x75, 0x65, 0x72, 0x79, 0x53, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x48, 0x00, 0x52, 0x13, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x51, 0x75, 0x65, 0x72, 0x79, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0xa0, 0x01, 0x0a, 0x17,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x66, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x48, 0x75, 0x6d, 0x61, 0x6e, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x41, 0x73, 0x73, 0x69, 0x73, 0x74,
	0x61, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73,
	0x74, 0x69, 0x6f, 0x6e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x44, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x51, 0x75, 0x65, 0x72, 0x79, 0x53,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x48, 0x00, 0x52, 0x15, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x51, 0x75, 0x65, 0x72, 0x79, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x1f,
	0x0a, 0x0b, 0x6d, 0x61, 0x78, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x0a, 0x6d, 0x61, 0x78, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x12,
	0x31, 0x0a, 0x14, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x74, 0x68,
	0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x02, 0x52, 0x13, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x54, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f,
	0x6c, 0x64, 0x12, 0x9e, 0x01, 0x0a, 0x17, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x66, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76,
	0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x48, 0x75, 0x6d, 0x61, 0x6e, 0x41, 0x67, 0x65, 0x6e,
	0x74, 0x41, 0x73, 0x73, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x46, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x15, 0x63, 0x6f,
	0x6e, 0x74, 0x65, 0x78, 0x74, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x12, 0x7a, 0x0a, 0x08, 0x73, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x59, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x48, 0x75, 0x6d, 0x61, 0x6e, 0x41, 0x67, 0x65,
	0x6e, 0x74, 0x41, 0x73, 0x73, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x51, 0x75, 0x65, 0x72,
	0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x53, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x73, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a,
	0x74, 0x0a, 0x18, 0x4b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x42, 0x61, 0x73, 0x65,
	0x51, 0x75, 0x65, 0x72, 0x79, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x58, 0x0a, 0x0f, 0x6b,
	0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x5f, 0x62, 0x61, 0x73, 0x65, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29, 0x0a, 0x27, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67,
	0x65, 0x42, 0x61, 0x73, 0x65, 0x52, 0x0e, 0x6b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65,
	0x42, 0x61, 0x73, 0x65, 0x73, 0x1a, 0x5f, 0x0a, 0x13, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
	0x74, 0x51, 0x75, 0x65, 0x72, 0x79, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x48, 0x0a, 0x09,
	0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x42,
	0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x09, 0x64, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x1a, 0xe2, 0x02, 0x0a, 0x15, 0x44, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x51, 0x75, 0x65, 0x72, 0x79, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x12, 0x3d, 0x0a, 0x05, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x27, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x52, 0x05, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x12,
	0xb2, 0x01, 0x0a, 0x17, 0x68, 0x75, 0x6d, 0x61, 0x6e, 0x5f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f,
	0x73, 0x69, 0x64, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x7b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x48, 0x75, 0x6d, 0x61, 0x6e, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x41, 0x73,
	0x73, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x53, 0x75,
	0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2e, 0x44, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x51, 0x75,
	0x65, 0x72, 0x79, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x48, 0x75, 0x6d, 0x61, 0x6e, 0x41,
	0x67, 0x65, 0x6e, 0x74, 0x53, 0x69, 0x64, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x14,
	0x68, 0x75, 0x6d, 0x61, 0x6e, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x53, 0x69, 0x64, 0x65, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x1a, 0x55, 0x0a, 0x14, 0x48, 0x75, 0x6d, 0x61, 0x6e, 0x41, 0x67, 0x65,
	0x6e, 0x74, 0x53, 0x69, 0x64, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3d, 0x0a, 0x05,
	0x61, 0x67, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x01,
	0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41,
	0x67, 0x65, 0x6e, 0x74, 0x52, 0x05, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x1a, 0xb6, 0x01, 0x0a, 0x15,
	0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x32, 0x0a, 0x15, 0x64, 0x72, 0x6f, 0x70, 0x5f, 0x68, 0x61,
	0x6e, 0x64, 0x6f, 0x66, 0x66, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x13, 0x64, 0x72, 0x6f, 0x70, 0x48, 0x61, 0x6e, 0x64, 0x6f, 0x66,
	0x66, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x12, 0x3d, 0x0a, 0x1b, 0x64, 0x72, 0x6f,
	0x70, 0x5f, 0x76, 0x69, 0x72, 0x74, 0x75, 0x61, 0x6c, 0x5f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f,
	0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x18,
	0x64, 0x72, 0x6f, 0x70, 0x56, 0x69, 0x72, 0x74, 0x75, 0x61, 0x6c, 0x41, 0x67, 0x65, 0x6e, 0x74,
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x12, 0x2a, 0x0a, 0x11, 0x64, 0x72, 0x6f, 0x70,
	0x5f, 0x69, 0x76, 0x72, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x0f, 0x64, 0x72, 0x6f, 0x70, 0x49, 0x76, 0x72, 0x4d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x73, 0x1a, 0xb6, 0x02, 0x0a, 0x08, 0x53, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x12, 0x8a, 0x01, 0x0a, 0x0d, 0x73, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x48, 0x75, 0x6d, 0x61,
	0x6e, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x41, 0x73, 0x73, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e,
	0x51, 0x75, 0x65, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x53, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x53, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65,
	0x52, 0x0c, 0x73, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x73, 0x22, 0x9c,
	0x01, 0x0a, 0x0b, 0x53, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1c,
	0x0a, 0x18, 0x53, 0x45, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09,
	0x53, 0x49, 0x54, 0x55, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x41,
	0x43, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x02, 0x12, 0x0e, 0x0a, 0x0a, 0x52, 0x45, 0x53, 0x4f, 0x4c,
	0x55, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x03, 0x12, 0x1b, 0x0a, 0x17, 0x52, 0x45, 0x41, 0x53, 0x4f,
	0x4e, 0x5f, 0x46, 0x4f, 0x52, 0x5f, 0x43, 0x41, 0x4e, 0x43, 0x45, 0x4c, 0x4c, 0x41, 0x54, 0x49,
	0x4f, 0x4e, 0x10, 0x04, 0x12, 0x19, 0x0a, 0x15, 0x43, 0x55, 0x53, 0x54, 0x4f, 0x4d, 0x45, 0x52,
	0x5f, 0x53, 0x41, 0x54, 0x49, 0x53, 0x46, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x05, 0x12,
	0x0c, 0x0a, 0x08, 0x45, 0x4e, 0x54, 0x49, 0x54, 0x49, 0x45, 0x53, 0x10, 0x06, 0x42, 0x0e, 0x0a,
	0x0c, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x1a, 0x97, 0x01,
	0x0a, 0x17, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f,
	0x64, 0x65, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x46, 0x0a, 0x05, 0x6d, 0x6f, 0x64,
	0x65, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x05, 0x6d, 0x6f, 0x64, 0x65,
	0x6c, 0x12, 0x34, 0x0a, 0x16, 0x62, 0x61, 0x73, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x6d, 0x6f,
	0x64, 0x65, 0x6c, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x14, 0x62, 0x61, 0x73, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x1a, 0x51, 0x0a, 0x19, 0x43, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x34, 0x0a, 0x16, 0x72, 0x65, 0x63, 0x65, 0x6e, 0x74, 0x5f, 0x73,
	0x65, 0x6e, 0x74, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x14, 0x72, 0x65, 0x63, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x6e, 0x74,
	0x65, 0x6e, 0x63, 0x65, 0x73, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x1a, 0x8d, 0x01, 0x0a, 0x15, 0x4d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x38, 0x0a, 0x18, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x65,
	0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x65, 0x78, 0x74, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x16, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x45, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x45, 0x78, 0x74, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3a,
	0x0a, 0x19, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x73, 0x65, 0x6e, 0x74, 0x69, 0x6d, 0x65,
	0x6e, 0x74, 0x5f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x17, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x65, 0x6e, 0x74, 0x69, 0x6d, 0x65,
	0x6e, 0x74, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x22, 0xc3, 0x04, 0x0a, 0x17, 0x48,
	0x75, 0x6d, 0x61, 0x6e, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x48, 0x61, 0x6e, 0x64, 0x6f, 0x66, 0x66,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x79, 0x0a, 0x12, 0x6c, 0x69, 0x76, 0x65, 0x5f, 0x70,
	0x65, 0x72, 0x73, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x49, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x48, 0x75, 0x6d, 0x61, 0x6e, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x48,
	0x61, 0x6e, 0x64, 0x6f, 0x66, 0x66, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4c, 0x69, 0x76,
	0x65, 0x50, 0x65, 0x72, 0x73, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52,
	0x10, 0x6c, 0x69, 0x76, 0x65, 0x50, 0x65, 0x72, 0x73, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x95, 0x01, 0x0a, 0x1c, 0x73, 0x61, 0x6c, 0x65, 0x73, 0x66, 0x6f, 0x72, 0x63, 0x65,
	0x5f, 0x6c, 0x69, 0x76, 0x65, 0x5f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x52, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x48, 0x75, 0x6d, 0x61, 0x6e,
	0x41, 0x67, 0x65, 0x6e, 0x74, 0x48, 0x61, 0x6e, 0x64, 0x6f, 0x66, 0x66, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x53, 0x61, 0x6c, 0x65, 0x73, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x4c, 0x69, 0x76,
	0x65, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x19,
	0x73, 0x61, 0x6c, 0x65, 0x73, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x4c, 0x69, 0x76, 0x65, 0x41, 0x67,
	0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a, 0x3e, 0x0a, 0x10, 0x4c, 0x69, 0x76,
	0x65, 0x50, 0x65, 0x72, 0x73, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x2a, 0x0a,
	0x0e, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x61, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x1a, 0xc3, 0x01, 0x0a, 0x19, 0x53, 0x61,
	0x6c, 0x65, 0x73, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x4c, 0x69, 0x76, 0x65, 0x41, 0x67, 0x65, 0x6e,
	0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x2c, 0x0a, 0x0f, 0x6f, 0x72, 0x67, 0x61, 0x6e,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x28, 0x0a, 0x0d, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d,
	0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0c, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x12,
	0x20, 0x0a, 0x09, 0x62, 0x75, 0x74, 0x74, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x62, 0x75, 0x74, 0x74, 0x6f, 0x6e, 0x49,
	0x64, 0x12, 0x2c, 0x0a, 0x0f, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x5f, 0x64, 0x6f,
	0x6d, 0x61, 0x69, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x0e, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x42,
	0x0f, 0x0a, 0x0d, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x22, 0xda, 0x01, 0x0a, 0x12, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x6f, 0x70, 0x69, 0x63,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x12, 0x68, 0x0a,
	0x0e, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x52, 0x0d, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x22, 0x44, 0x0a, 0x0d, 0x4d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x1e, 0x0a, 0x1a, 0x4d, 0x45, 0x53, 0x53,
	0x41, 0x47, 0x45, 0x5f, 0x46, 0x4f, 0x52, 0x4d, 0x41, 0x54, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x50, 0x52, 0x4f, 0x54,
	0x4f, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x4a, 0x53, 0x4f, 0x4e, 0x10, 0x02, 0x22, 0x4d, 0x0a,
	0x0d, 0x4c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3c,
	0x0a, 0x1a, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x64, 0x72,
	0x69, 0x76, 0x65, 0x72, 0x5f, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x18, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x64,
	0x72, 0x69, 0x76, 0x65, 0x72, 0x4c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x22, 0xac, 0x01, 0x0a,
	0x1f, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x4d, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x35, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2f, 0x12, 0x2d, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xb5, 0x01, 0x0a, 0x20,
	0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x69, 0x0a, 0x15, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72,
	0x6f, 0x66, 0x69, 0x6c, 0x65, 0x52, 0x14, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e,
	0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x22, 0x6a, 0x0a, 0x1d, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x49, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x35, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2f, 0x0a, 0x2d, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22,
	0xdf, 0x01, 0x0a, 0x20, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x4d, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x35, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2f, 0x12, 0x2d, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0x6c, 0x0a, 0x14, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x13, 0x63, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c,
	0x65, 0x22, 0xd2, 0x01, 0x0a, 0x20, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x6c, 0x0a, 0x14, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76,
	0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x13, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f,
	0x66, 0x69, 0x6c, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d,
	0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c,
	0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x6d, 0x0a, 0x20, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66,
	0x69, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x49, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x35, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2f,
	0x0a, 0x2d, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xd4, 0x02, 0x0a, 0x21, 0x53, 0x65, 0x74, 0x53, 0x75, 0x67,
	0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x36, 0x0a, 0x14, 0x63,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x6f, 0x66,
	0x69, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x13,
	0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66,
	0x69, 0x6c, 0x65, 0x12, 0x61, 0x0a, 0x10, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61,
	0x6e, 0x74, 0x5f, 0x72, 0x6f, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x31, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x2e, 0x52, 0x6f, 0x6c, 0x65,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61,
	0x6e, 0x74, 0x52, 0x6f, 0x6c, 0x65, 0x12, 0x93, 0x01, 0x0a, 0x19, 0x73, 0x75, 0x67, 0x67, 0x65,
	0x73, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x52, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x48, 0x75, 0x6d,
	0x61, 0x6e, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x41, 0x73, 0x73, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x74,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f,
	0x6e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x17, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x46,
	0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0xb6, 0x02, 0x0a,
	0x23, 0x43, 0x6c, 0x65, 0x61, 0x72, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e,
	0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x36, 0x0a, 0x14, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x13, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x12, 0x61, 0x0a, 0x10,
	0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x5f, 0x72, 0x6f, 0x6c, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69,
	0x70, 0x61, 0x6e, 0x74, 0x2e, 0x52, 0x6f, 0x6c, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f,
	0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x52, 0x6f, 0x6c, 0x65, 0x12,
	0x74, 0x0a, 0x17, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x66, 0x65,
	0x61, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x65, 0x61,
	0x74, 0x75, 0x72, 0x65, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x15,
	0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72,
	0x65, 0x54, 0x79, 0x70, 0x65, 0x22, 0xf6, 0x02, 0x0a, 0x2b, 0x53, 0x65, 0x74, 0x53, 0x75, 0x67,
	0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x31, 0x0a, 0x14, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x13, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x12, 0x61, 0x0a, 0x10, 0x70, 0x61, 0x72, 0x74,
	0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x5f, 0x72, 0x6f, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74,
	0x2e, 0x52, 0x6f, 0x6c, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x70, 0x61, 0x72, 0x74,
	0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x52, 0x6f, 0x6c, 0x65, 0x12, 0x74, 0x0a, 0x17, 0x73,
	0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72,
	0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x37, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53,
	0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65,
	0x2e, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x15, 0x73, 0x75, 0x67, 0x67,
	0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x22, 0xf8,
	0x02, 0x0a, 0x2d, 0x43, 0x6c, 0x65, 0x61, 0x72, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69,
	0x6f, 0x6e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x12, 0x31, 0x0a, 0x14, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x13,
	0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66,
	0x69, 0x6c, 0x65, 0x12, 0x61, 0x0a, 0x10, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61,
	0x6e, 0x74, 0x5f, 0x72, 0x6f, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x31, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x2e, 0x52, 0x6f, 0x6c, 0x65,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61,
	0x6e, 0x74, 0x52, 0x6f, 0x6c, 0x65, 0x12, 0x74, 0x0a, 0x17, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73,
	0x74, 0x69, 0x6f, 0x6e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x2e, 0x54, 0x79, 0x70, 0x65,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x15, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f,
	0x6e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x3b, 0x0a, 0x0b,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x32, 0xb3, 0x15, 0x0a, 0x14, 0x43, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c,
	0x65, 0x73, 0x12, 0xa5, 0x02, 0x0a, 0x18, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x12,
	0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x83, 0x01, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x74, 0x5a, 0x3f, 0x12, 0x3d, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50,
	0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x12, 0x31, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x12, 0x92, 0x02, 0x0a, 0x16, 0x47,
	0x65, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72,
	0x6f, 0x66, 0x69, 0x6c, 0x65, 0x12, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x22, 0x81, 0x01, 0xda, 0x41,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x74, 0x5a, 0x3f, 0x12, 0x3d, 0x2f,
	0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x31, 0x2f, 0x76,
	0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12,
	0xdc, 0x02, 0x0a, 0x19, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x12, 0x41, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50,
	0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x22, 0xc5, 0x01, 0xda, 0x41, 0x1b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x2c, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xa0, 0x01, 0x3a, 0x14,
	0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x6f,
	0x66, 0x69, 0x6c, 0x65, 0x5a, 0x55, 0x3a, 0x14, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x22, 0x3d, 0x2f, 0x76,
	0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x22, 0x31, 0x2f, 0x76, 0x32,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x12, 0x8b,
	0x03, 0x0a, 0x19, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x12, 0x41, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72,
	0x6f, 0x66, 0x69, 0x6c, 0x65, 0x22, 0xf4, 0x01, 0xda, 0x41, 0x20, 0x63, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x2c,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0xca, 0x01, 0x3a, 0x14, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x5a, 0x6a, 0x3a, 0x14, 0x63, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65,
	0x32, 0x52, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x63, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65,
	0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65,
	0x73, 0x2f, 0x2a, 0x7d, 0x32, 0x46, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b,
	0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x6f,
	0x66, 0x69, 0x6c, 0x65, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xfa, 0x01, 0x0a,
	0x19, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x12, 0x41, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50,
	0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x81, 0x01, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x74, 0x5a, 0x3f, 0x2a, 0x3d, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69,
	0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2a, 0x31, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72,
	0x6f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xf7, 0x03, 0x0a, 0x1a, 0x53, 0x65,
	0x74, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x65, 0x61, 0x74, 0x75,
	0x72, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x65, 0x74, 0x53, 0x75,
	0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e,
	0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xf5, 0x02, 0xca, 0x41,
	0x42, 0x0a, 0x13, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50,
	0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x12, 0x2b, 0x53, 0x65, 0x74, 0x53, 0x75, 0x67, 0x67, 0x65,
	0x73, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0xda, 0x41, 0x14, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0xda, 0x41, 0x3f, 0x63, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c,
	0x65, 0x2c, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x5f, 0x72, 0x6f,
	0x6c, 0x65, 0x2c, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x66, 0x65,
	0x61, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0xd0, 0x01, 0x3a, 0x01, 0x2a, 0x5a, 0x6d, 0x3a, 0x01, 0x2a, 0x22, 0x68, 0x2f, 0x76, 0x32,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50,
	0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x65, 0x74, 0x53, 0x75,
	0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x5c, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f,
	0x7b, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x72,
	0x6f, 0x66, 0x69, 0x6c, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f,
	0x66, 0x69, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x65, 0x74, 0x53, 0x75, 0x67, 0x67,
	0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0xff, 0x03, 0x0a, 0x1c, 0x43, 0x6c, 0x65, 0x61, 0x72, 0x53, 0x75, 0x67,
	0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76,
	0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6c, 0x65, 0x61, 0x72, 0x53, 0x75, 0x67, 0x67,
	0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xf9, 0x02, 0xca, 0x41, 0x44, 0x0a,
	0x13, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f,
	0x66, 0x69, 0x6c, 0x65, 0x12, 0x2d, 0x43, 0x6c, 0x65, 0x61, 0x72, 0x53, 0x75, 0x67, 0x67, 0x65,
	0x73, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0xda, 0x41, 0x14, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0xda, 0x41, 0x3d, 0x63, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c,
	0x65, 0x2c, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x5f, 0x72, 0x6f,
	0x6c, 0x65, 0x2c, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x66, 0x65,
	0x61, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xd4,
	0x01, 0x3a, 0x01, 0x2a, 0x5a, 0x6f, 0x3a, 0x01, 0x2a, 0x22, 0x6a, 0x2f, 0x76, 0x32, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2f, 0x7b, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f,
	0x66, 0x69, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x63, 0x6c, 0x65, 0x61, 0x72, 0x53, 0x75,
	0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x5e, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f,
	0x7b, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x72,
	0x6f, 0x66, 0x69, 0x6c, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f,
	0x66, 0x69, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x63, 0x6c, 0x65, 0x61, 0x72, 0x53, 0x75,
	0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a, 0x78, 0xca, 0x41, 0x19, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x59, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77,
	0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x61, 0x75, 0x74, 0x68, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x42,
	0xb0, 0x03, 0xea, 0x41, 0x7c, 0x0a, 0x2c, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x43, 0x58, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x12, 0x4c, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x7b, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x7d, 0xea, 0x41, 0x7e, 0x0a, 0x2b, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65,
	0x6c, 0x12, 0x4f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x2f, 0x7b, 0x63,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x6f, 0x64, 0x65,
	0x6c, 0x7d, 0x0a, 0x23, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x42, 0x18, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x50, 0x01, 0x5a, 0x43, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x70, 0x62, 0x3b, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x70, 0x62, 0xf8, 0x01, 0x01, 0xa2, 0x02, 0x02, 0x44, 0x46,
	0xaa, 0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x44, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x56, 0x32, 0x42, 0x65, 0x74,
	0x61, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_rawDescOnce sync.Once
	file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_rawDescData = file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_rawDesc
)

func file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_rawDescGZIP() []byte {
	file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_rawDescOnce.Do(func() {
		file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_rawDescData)
	})
	return file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_rawDescData
}

var file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_msgTypes = make([]protoimpl.MessageInfo, 31)
var file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_goTypes = []any{
	(HumanAgentAssistantConfig_SuggestionQueryConfig_Sections_SectionType)(0),                          // 0: google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.Sections.SectionType
	(NotificationConfig_MessageFormat)(0),                                                              // 1: google.cloud.dialogflow.v2beta1.NotificationConfig.MessageFormat
	(*ConversationProfile)(nil),                                                                        // 2: google.cloud.dialogflow.v2beta1.ConversationProfile
	(*AutomatedAgentConfig)(nil),                                                                       // 3: google.cloud.dialogflow.v2beta1.AutomatedAgentConfig
	(*HumanAgentAssistantConfig)(nil),                                                                  // 4: google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
	(*HumanAgentHandoffConfig)(nil),                                                                    // 5: google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig
	(*NotificationConfig)(nil),                                                                         // 6: google.cloud.dialogflow.v2beta1.NotificationConfig
	(*LoggingConfig)(nil),                                                                              // 7: google.cloud.dialogflow.v2beta1.LoggingConfig
	(*ListConversationProfilesRequest)(nil),                                                            // 8: google.cloud.dialogflow.v2beta1.ListConversationProfilesRequest
	(*ListConversationProfilesResponse)(nil),                                                           // 9: google.cloud.dialogflow.v2beta1.ListConversationProfilesResponse
	(*GetConversationProfileRequest)(nil),                                                              // 10: google.cloud.dialogflow.v2beta1.GetConversationProfileRequest
	(*CreateConversationProfileRequest)(nil),                                                           // 11: google.cloud.dialogflow.v2beta1.CreateConversationProfileRequest
	(*UpdateConversationProfileRequest)(nil),                                                           // 12: google.cloud.dialogflow.v2beta1.UpdateConversationProfileRequest
	(*DeleteConversationProfileRequest)(nil),                                                           // 13: google.cloud.dialogflow.v2beta1.DeleteConversationProfileRequest
	(*SetSuggestionFeatureConfigRequest)(nil),                                                          // 14: google.cloud.dialogflow.v2beta1.SetSuggestionFeatureConfigRequest
	(*ClearSuggestionFeatureConfigRequest)(nil),                                                        // 15: google.cloud.dialogflow.v2beta1.ClearSuggestionFeatureConfigRequest
	(*SetSuggestionFeatureConfigOperationMetadata)(nil),                                                // 16: google.cloud.dialogflow.v2beta1.SetSuggestionFeatureConfigOperationMetadata
	(*ClearSuggestionFeatureConfigOperationMetadata)(nil),                                              // 17: google.cloud.dialogflow.v2beta1.ClearSuggestionFeatureConfigOperationMetadata
	(*HumanAgentAssistantConfig_SuggestionTriggerSettings)(nil),                                        // 18: google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionTriggerSettings
	(*HumanAgentAssistantConfig_SuggestionFeatureConfig)(nil),                                          // 19: google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionFeatureConfig
	(*HumanAgentAssistantConfig_SuggestionConfig)(nil),                                                 // 20: google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig
	(*HumanAgentAssistantConfig_SuggestionQueryConfig)(nil),                                            // 21: google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
	(*HumanAgentAssistantConfig_ConversationModelConfig)(nil),                                          // 22: google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationModelConfig
	(*HumanAgentAssistantConfig_ConversationProcessConfig)(nil),                                        // 23: google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationProcessConfig
	(*HumanAgentAssistantConfig_MessageAnalysisConfig)(nil),                                            // 24: google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.MessageAnalysisConfig
	(*HumanAgentAssistantConfig_SuggestionQueryConfig_KnowledgeBaseQuerySource)(nil),                   // 25: google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.KnowledgeBaseQuerySource
	(*HumanAgentAssistantConfig_SuggestionQueryConfig_DocumentQuerySource)(nil),                        // 26: google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.DocumentQuerySource
	(*HumanAgentAssistantConfig_SuggestionQueryConfig_DialogflowQuerySource)(nil),                      // 27: google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.DialogflowQuerySource
	(*HumanAgentAssistantConfig_SuggestionQueryConfig_ContextFilterSettings)(nil),                      // 28: google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.ContextFilterSettings
	(*HumanAgentAssistantConfig_SuggestionQueryConfig_Sections)(nil),                                   // 29: google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.Sections
	(*HumanAgentAssistantConfig_SuggestionQueryConfig_DialogflowQuerySource_HumanAgentSideConfig)(nil), // 30: google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.DialogflowQuerySource.HumanAgentSideConfig
	(*HumanAgentHandoffConfig_LivePersonConfig)(nil),                                                   // 31: google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.LivePersonConfig
	(*HumanAgentHandoffConfig_SalesforceLiveAgentConfig)(nil),                                          // 32: google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.SalesforceLiveAgentConfig
	(*timestamppb.Timestamp)(nil),                                                                      // 33: google.protobuf.Timestamp
	(*SpeechToTextConfig)(nil),                                                                         // 34: google.cloud.dialogflow.v2beta1.SpeechToTextConfig
	(*SynthesizeSpeechConfig)(nil),                                                                     // 35: google.cloud.dialogflow.v2beta1.SynthesizeSpeechConfig
	(*durationpb.Duration)(nil),                                                                        // 36: google.protobuf.Duration
	(*fieldmaskpb.FieldMask)(nil),                                                                      // 37: google.protobuf.FieldMask
	(Participant_Role)(0),                                                                              // 38: google.cloud.dialogflow.v2beta1.Participant.Role
	(SuggestionFeature_Type)(0),                                                                        // 39: google.cloud.dialogflow.v2beta1.SuggestionFeature.Type
	(*SuggestionFeature)(nil),                                                                          // 40: google.cloud.dialogflow.v2beta1.SuggestionFeature
	(*emptypb.Empty)(nil),                                                                              // 41: google.protobuf.Empty
	(*longrunningpb.Operation)(nil),                                                                    // 42: google.longrunning.Operation
}
var file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_depIdxs = []int32{
	33, // 0: google.cloud.dialogflow.v2beta1.ConversationProfile.create_time:type_name -> google.protobuf.Timestamp
	33, // 1: google.cloud.dialogflow.v2beta1.ConversationProfile.update_time:type_name -> google.protobuf.Timestamp
	3,  // 2: google.cloud.dialogflow.v2beta1.ConversationProfile.automated_agent_config:type_name -> google.cloud.dialogflow.v2beta1.AutomatedAgentConfig
	4,  // 3: google.cloud.dialogflow.v2beta1.ConversationProfile.human_agent_assistant_config:type_name -> google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
	5,  // 4: google.cloud.dialogflow.v2beta1.ConversationProfile.human_agent_handoff_config:type_name -> google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig
	6,  // 5: google.cloud.dialogflow.v2beta1.ConversationProfile.notification_config:type_name -> google.cloud.dialogflow.v2beta1.NotificationConfig
	7,  // 6: google.cloud.dialogflow.v2beta1.ConversationProfile.logging_config:type_name -> google.cloud.dialogflow.v2beta1.LoggingConfig
	6,  // 7: google.cloud.dialogflow.v2beta1.ConversationProfile.new_message_event_notification_config:type_name -> google.cloud.dialogflow.v2beta1.NotificationConfig
	34, // 8: google.cloud.dialogflow.v2beta1.ConversationProfile.stt_config:type_name -> google.cloud.dialogflow.v2beta1.SpeechToTextConfig
	35, // 9: google.cloud.dialogflow.v2beta1.ConversationProfile.tts_config:type_name -> google.cloud.dialogflow.v2beta1.SynthesizeSpeechConfig
	36, // 10: google.cloud.dialogflow.v2beta1.AutomatedAgentConfig.session_ttl:type_name -> google.protobuf.Duration
	6,  // 11: google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.notification_config:type_name -> google.cloud.dialogflow.v2beta1.NotificationConfig
	20, // 12: google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.human_agent_suggestion_config:type_name -> google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig
	20, // 13: google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.end_user_suggestion_config:type_name -> google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig
	24, // 14: google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.message_analysis_config:type_name -> google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.MessageAnalysisConfig
	31, // 15: google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.live_person_config:type_name -> google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.LivePersonConfig
	32, // 16: google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.salesforce_live_agent_config:type_name -> google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.SalesforceLiveAgentConfig
	1,  // 17: google.cloud.dialogflow.v2beta1.NotificationConfig.message_format:type_name -> google.cloud.dialogflow.v2beta1.NotificationConfig.MessageFormat
	2,  // 18: google.cloud.dialogflow.v2beta1.ListConversationProfilesResponse.conversation_profiles:type_name -> google.cloud.dialogflow.v2beta1.ConversationProfile
	2,  // 19: google.cloud.dialogflow.v2beta1.CreateConversationProfileRequest.conversation_profile:type_name -> google.cloud.dialogflow.v2beta1.ConversationProfile
	2,  // 20: google.cloud.dialogflow.v2beta1.UpdateConversationProfileRequest.conversation_profile:type_name -> google.cloud.dialogflow.v2beta1.ConversationProfile
	37, // 21: google.cloud.dialogflow.v2beta1.UpdateConversationProfileRequest.update_mask:type_name -> google.protobuf.FieldMask
	38, // 22: google.cloud.dialogflow.v2beta1.SetSuggestionFeatureConfigRequest.participant_role:type_name -> google.cloud.dialogflow.v2beta1.Participant.Role
	19, // 23: google.cloud.dialogflow.v2beta1.SetSuggestionFeatureConfigRequest.suggestion_feature_config:type_name -> google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionFeatureConfig
	38, // 24: google.cloud.dialogflow.v2beta1.ClearSuggestionFeatureConfigRequest.participant_role:type_name -> google.cloud.dialogflow.v2beta1.Participant.Role
	39, // 25: google.cloud.dialogflow.v2beta1.ClearSuggestionFeatureConfigRequest.suggestion_feature_type:type_name -> google.cloud.dialogflow.v2beta1.SuggestionFeature.Type
	38, // 26: google.cloud.dialogflow.v2beta1.SetSuggestionFeatureConfigOperationMetadata.participant_role:type_name -> google.cloud.dialogflow.v2beta1.Participant.Role
	39, // 27: google.cloud.dialogflow.v2beta1.SetSuggestionFeatureConfigOperationMetadata.suggestion_feature_type:type_name -> google.cloud.dialogflow.v2beta1.SuggestionFeature.Type
	33, // 28: google.cloud.dialogflow.v2beta1.SetSuggestionFeatureConfigOperationMetadata.create_time:type_name -> google.protobuf.Timestamp
	38, // 29: google.cloud.dialogflow.v2beta1.ClearSuggestionFeatureConfigOperationMetadata.participant_role:type_name -> google.cloud.dialogflow.v2beta1.Participant.Role
	39, // 30: google.cloud.dialogflow.v2beta1.ClearSuggestionFeatureConfigOperationMetadata.suggestion_feature_type:type_name -> google.cloud.dialogflow.v2beta1.SuggestionFeature.Type
	33, // 31: google.cloud.dialogflow.v2beta1.ClearSuggestionFeatureConfigOperationMetadata.create_time:type_name -> google.protobuf.Timestamp
	40, // 32: google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionFeatureConfig.suggestion_feature:type_name -> google.cloud.dialogflow.v2beta1.SuggestionFeature
	18, // 33: google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionFeatureConfig.suggestion_trigger_settings:type_name -> google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionTriggerSettings
	21, // 34: google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionFeatureConfig.query_config:type_name -> google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
	22, // 35: google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionFeatureConfig.conversation_model_config:type_name -> google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationModelConfig
	23, // 36: google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionFeatureConfig.conversation_process_config:type_name -> google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationProcessConfig
	19, // 37: google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig.feature_configs:type_name -> google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionFeatureConfig
	25, // 38: google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.knowledge_base_query_source:type_name -> google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.KnowledgeBaseQuerySource
	26, // 39: google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.document_query_source:type_name -> google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.DocumentQuerySource
	27, // 40: google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.dialogflow_query_source:type_name -> google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.DialogflowQuerySource
	28, // 41: google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.context_filter_settings:type_name -> google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.ContextFilterSettings
	29, // 42: google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.sections:type_name -> google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.Sections
	30, // 43: google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.DialogflowQuerySource.human_agent_side_config:type_name -> google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.DialogflowQuerySource.HumanAgentSideConfig
	0,  // 44: google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.Sections.section_types:type_name -> google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.Sections.SectionType
	8,  // 45: google.cloud.dialogflow.v2beta1.ConversationProfiles.ListConversationProfiles:input_type -> google.cloud.dialogflow.v2beta1.ListConversationProfilesRequest
	10, // 46: google.cloud.dialogflow.v2beta1.ConversationProfiles.GetConversationProfile:input_type -> google.cloud.dialogflow.v2beta1.GetConversationProfileRequest
	11, // 47: google.cloud.dialogflow.v2beta1.ConversationProfiles.CreateConversationProfile:input_type -> google.cloud.dialogflow.v2beta1.CreateConversationProfileRequest
	12, // 48: google.cloud.dialogflow.v2beta1.ConversationProfiles.UpdateConversationProfile:input_type -> google.cloud.dialogflow.v2beta1.UpdateConversationProfileRequest
	13, // 49: google.cloud.dialogflow.v2beta1.ConversationProfiles.DeleteConversationProfile:input_type -> google.cloud.dialogflow.v2beta1.DeleteConversationProfileRequest
	14, // 50: google.cloud.dialogflow.v2beta1.ConversationProfiles.SetSuggestionFeatureConfig:input_type -> google.cloud.dialogflow.v2beta1.SetSuggestionFeatureConfigRequest
	15, // 51: google.cloud.dialogflow.v2beta1.ConversationProfiles.ClearSuggestionFeatureConfig:input_type -> google.cloud.dialogflow.v2beta1.ClearSuggestionFeatureConfigRequest
	9,  // 52: google.cloud.dialogflow.v2beta1.ConversationProfiles.ListConversationProfiles:output_type -> google.cloud.dialogflow.v2beta1.ListConversationProfilesResponse
	2,  // 53: google.cloud.dialogflow.v2beta1.ConversationProfiles.GetConversationProfile:output_type -> google.cloud.dialogflow.v2beta1.ConversationProfile
	2,  // 54: google.cloud.dialogflow.v2beta1.ConversationProfiles.CreateConversationProfile:output_type -> google.cloud.dialogflow.v2beta1.ConversationProfile
	2,  // 55: google.cloud.dialogflow.v2beta1.ConversationProfiles.UpdateConversationProfile:output_type -> google.cloud.dialogflow.v2beta1.ConversationProfile
	41, // 56: google.cloud.dialogflow.v2beta1.ConversationProfiles.DeleteConversationProfile:output_type -> google.protobuf.Empty
	42, // 57: google.cloud.dialogflow.v2beta1.ConversationProfiles.SetSuggestionFeatureConfig:output_type -> google.longrunning.Operation
	42, // 58: google.cloud.dialogflow.v2beta1.ConversationProfiles.ClearSuggestionFeatureConfig:output_type -> google.longrunning.Operation
	52, // [52:59] is the sub-list for method output_type
	45, // [45:52] is the sub-list for method input_type
	45, // [45:45] is the sub-list for extension type_name
	45, // [45:45] is the sub-list for extension extendee
	0,  // [0:45] is the sub-list for field type_name
}

func init() { file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_init() }
func file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_init() {
	if File_google_cloud_dialogflow_v2beta1_conversation_profile_proto != nil {
		return
	}
	file_google_cloud_dialogflow_v2beta1_audio_config_proto_init()
	file_google_cloud_dialogflow_v2beta1_participant_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_msgTypes[0].Exporter = func(v any, i int) any {
			switch v := v.(*ConversationProfile); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_msgTypes[1].Exporter = func(v any, i int) any {
			switch v := v.(*AutomatedAgentConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_msgTypes[2].Exporter = func(v any, i int) any {
			switch v := v.(*HumanAgentAssistantConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_msgTypes[3].Exporter = func(v any, i int) any {
			switch v := v.(*HumanAgentHandoffConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_msgTypes[4].Exporter = func(v any, i int) any {
			switch v := v.(*NotificationConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_msgTypes[5].Exporter = func(v any, i int) any {
			switch v := v.(*LoggingConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_msgTypes[6].Exporter = func(v any, i int) any {
			switch v := v.(*ListConversationProfilesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_msgTypes[7].Exporter = func(v any, i int) any {
			switch v := v.(*ListConversationProfilesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_msgTypes[8].Exporter = func(v any, i int) any {
			switch v := v.(*GetConversationProfileRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_msgTypes[9].Exporter = func(v any, i int) any {
			switch v := v.(*CreateConversationProfileRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_msgTypes[10].Exporter = func(v any, i int) any {
			switch v := v.(*UpdateConversationProfileRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_msgTypes[11].Exporter = func(v any, i int) any {
			switch v := v.(*DeleteConversationProfileRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_msgTypes[12].Exporter = func(v any, i int) any {
			switch v := v.(*SetSuggestionFeatureConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_msgTypes[13].Exporter = func(v any, i int) any {
			switch v := v.(*ClearSuggestionFeatureConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_msgTypes[14].Exporter = func(v any, i int) any {
			switch v := v.(*SetSuggestionFeatureConfigOperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_msgTypes[15].Exporter = func(v any, i int) any {
			switch v := v.(*ClearSuggestionFeatureConfigOperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_msgTypes[16].Exporter = func(v any, i int) any {
			switch v := v.(*HumanAgentAssistantConfig_SuggestionTriggerSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_msgTypes[17].Exporter = func(v any, i int) any {
			switch v := v.(*HumanAgentAssistantConfig_SuggestionFeatureConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_msgTypes[18].Exporter = func(v any, i int) any {
			switch v := v.(*HumanAgentAssistantConfig_SuggestionConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_msgTypes[19].Exporter = func(v any, i int) any {
			switch v := v.(*HumanAgentAssistantConfig_SuggestionQueryConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_msgTypes[20].Exporter = func(v any, i int) any {
			switch v := v.(*HumanAgentAssistantConfig_ConversationModelConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_msgTypes[21].Exporter = func(v any, i int) any {
			switch v := v.(*HumanAgentAssistantConfig_ConversationProcessConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_msgTypes[22].Exporter = func(v any, i int) any {
			switch v := v.(*HumanAgentAssistantConfig_MessageAnalysisConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_msgTypes[23].Exporter = func(v any, i int) any {
			switch v := v.(*HumanAgentAssistantConfig_SuggestionQueryConfig_KnowledgeBaseQuerySource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_msgTypes[24].Exporter = func(v any, i int) any {
			switch v := v.(*HumanAgentAssistantConfig_SuggestionQueryConfig_DocumentQuerySource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_msgTypes[25].Exporter = func(v any, i int) any {
			switch v := v.(*HumanAgentAssistantConfig_SuggestionQueryConfig_DialogflowQuerySource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_msgTypes[26].Exporter = func(v any, i int) any {
			switch v := v.(*HumanAgentAssistantConfig_SuggestionQueryConfig_ContextFilterSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_msgTypes[27].Exporter = func(v any, i int) any {
			switch v := v.(*HumanAgentAssistantConfig_SuggestionQueryConfig_Sections); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_msgTypes[28].Exporter = func(v any, i int) any {
			switch v := v.(*HumanAgentAssistantConfig_SuggestionQueryConfig_DialogflowQuerySource_HumanAgentSideConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_msgTypes[29].Exporter = func(v any, i int) any {
			switch v := v.(*HumanAgentHandoffConfig_LivePersonConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_msgTypes[30].Exporter = func(v any, i int) any {
			switch v := v.(*HumanAgentHandoffConfig_SalesforceLiveAgentConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_msgTypes[3].OneofWrappers = []any{
		(*HumanAgentHandoffConfig_LivePersonConfig_)(nil),
		(*HumanAgentHandoffConfig_SalesforceLiveAgentConfig_)(nil),
	}
	file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_msgTypes[19].OneofWrappers = []any{
		(*HumanAgentAssistantConfig_SuggestionQueryConfig_KnowledgeBaseQuerySource_)(nil),
		(*HumanAgentAssistantConfig_SuggestionQueryConfig_DocumentQuerySource_)(nil),
		(*HumanAgentAssistantConfig_SuggestionQueryConfig_DialogflowQuerySource_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   31,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_goTypes,
		DependencyIndexes: file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_depIdxs,
		EnumInfos:         file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_enumTypes,
		MessageInfos:      file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_msgTypes,
	}.Build()
	File_google_cloud_dialogflow_v2beta1_conversation_profile_proto = out.File
	file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_rawDesc = nil
	file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_goTypes = nil
	file_google_cloud_dialogflow_v2beta1_conversation_profile_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// ConversationProfilesClient is the client API for ConversationProfiles service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ConversationProfilesClient interface {
	// Returns the list of all conversation profiles in the specified project.
	ListConversationProfiles(ctx context.Context, in *ListConversationProfilesRequest, opts ...grpc.CallOption) (*ListConversationProfilesResponse, error)
	// Retrieves the specified conversation profile.
	GetConversationProfile(ctx context.Context, in *GetConversationProfileRequest, opts ...grpc.CallOption) (*ConversationProfile, error)
	// Creates a conversation profile in the specified project.
	//
	// [ConversationProfile.CreateTime][] and [ConversationProfile.UpdateTime][]
	// aren't populated in the response. You can retrieve them via
	// [GetConversationProfile][google.cloud.dialogflow.v2beta1.ConversationProfiles.GetConversationProfile]
	// API.
	CreateConversationProfile(ctx context.Context, in *CreateConversationProfileRequest, opts ...grpc.CallOption) (*ConversationProfile, error)
	// Updates the specified conversation profile.
	//
	// [ConversationProfile.CreateTime][] and [ConversationProfile.UpdateTime][]
	// aren't populated in the response. You can retrieve them via
	// [GetConversationProfile][google.cloud.dialogflow.v2beta1.ConversationProfiles.GetConversationProfile]
	// API.
	UpdateConversationProfile(ctx context.Context, in *UpdateConversationProfileRequest, opts ...grpc.CallOption) (*ConversationProfile, error)
	// Deletes the specified conversation profile.
	DeleteConversationProfile(ctx context.Context, in *DeleteConversationProfileRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Adds or updates a suggestion feature in a conversation profile.
	// If the conversation profile contains the type of suggestion feature for
	// the participant role, it will update it. Otherwise it will insert the
	// suggestion feature.
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/es/docs/how/long-running-operations).
	// The returned `Operation` type has the following method-specific fields:
	//
	// - `metadata`:
	// [SetSuggestionFeatureConfigOperationMetadata][google.cloud.dialogflow.v2beta1.SetSuggestionFeatureConfigOperationMetadata]
	// - `response`:
	// [ConversationProfile][google.cloud.dialogflow.v2beta1.ConversationProfile]
	//
	// If a long running operation to add or update suggestion feature
	// config for the same conversation profile, participant role and suggestion
	// feature type exists, please cancel the existing long running operation
	// before sending such request, otherwise the request will be rejected.
	SetSuggestionFeatureConfig(ctx context.Context, in *SetSuggestionFeatureConfigRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Clears a suggestion feature from a conversation profile for the given
	// participant role.
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/es/docs/how/long-running-operations).
	// The returned `Operation` type has the following method-specific fields:
	//
	// - `metadata`:
	// [ClearSuggestionFeatureConfigOperationMetadata][google.cloud.dialogflow.v2beta1.ClearSuggestionFeatureConfigOperationMetadata]
	// - `response`:
	// [ConversationProfile][google.cloud.dialogflow.v2beta1.ConversationProfile]
	ClearSuggestionFeatureConfig(ctx context.Context, in *ClearSuggestionFeatureConfigRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type conversationProfilesClient struct {
	cc grpc.ClientConnInterface
}

func NewConversationProfilesClient(cc grpc.ClientConnInterface) ConversationProfilesClient {
	return &conversationProfilesClient{cc}
}

func (c *conversationProfilesClient) ListConversationProfiles(ctx context.Context, in *ListConversationProfilesRequest, opts ...grpc.CallOption) (*ListConversationProfilesResponse, error) {
	out := new(ListConversationProfilesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.ConversationProfiles/ListConversationProfiles", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conversationProfilesClient) GetConversationProfile(ctx context.Context, in *GetConversationProfileRequest, opts ...grpc.CallOption) (*ConversationProfile, error) {
	out := new(ConversationProfile)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.ConversationProfiles/GetConversationProfile", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conversationProfilesClient) CreateConversationProfile(ctx context.Context, in *CreateConversationProfileRequest, opts ...grpc.CallOption) (*ConversationProfile, error) {
	out := new(ConversationProfile)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.ConversationProfiles/CreateConversationProfile", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conversationProfilesClient) UpdateConversationProfile(ctx context.Context, in *UpdateConversationProfileRequest, opts ...grpc.CallOption) (*ConversationProfile, error) {
	out := new(ConversationProfile)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.ConversationProfiles/UpdateConversationProfile", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conversationProfilesClient) DeleteConversationProfile(ctx context.Context, in *DeleteConversationProfileRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.ConversationProfiles/DeleteConversationProfile", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conversationProfilesClient) SetSuggestionFeatureConfig(ctx context.Context, in *SetSuggestionFeatureConfigRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.ConversationProfiles/SetSuggestionFeatureConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conversationProfilesClient) ClearSuggestionFeatureConfig(ctx context.Context, in *ClearSuggestionFeatureConfigRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.ConversationProfiles/ClearSuggestionFeatureConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ConversationProfilesServer is the server API for ConversationProfiles service.
type ConversationProfilesServer interface {
	// Returns the list of all conversation profiles in the specified project.
	ListConversationProfiles(context.Context, *ListConversationProfilesRequest) (*ListConversationProfilesResponse, error)
	// Retrieves the specified conversation profile.
	GetConversationProfile(context.Context, *GetConversationProfileRequest) (*ConversationProfile, error)
	// Creates a conversation profile in the specified project.
	//
	// [ConversationProfile.CreateTime][] and [ConversationProfile.UpdateTime][]
	// aren't populated in the response. You can retrieve them via
	// [GetConversationProfile][google.cloud.dialogflow.v2beta1.ConversationProfiles.GetConversationProfile]
	// API.
	CreateConversationProfile(context.Context, *CreateConversationProfileRequest) (*ConversationProfile, error)
	// Updates the specified conversation profile.
	//
	// [ConversationProfile.CreateTime][] and [ConversationProfile.UpdateTime][]
	// aren't populated in the response. You can retrieve them via
	// [GetConversationProfile][google.cloud.dialogflow.v2beta1.ConversationProfiles.GetConversationProfile]
	// API.
	UpdateConversationProfile(context.Context, *UpdateConversationProfileRequest) (*ConversationProfile, error)
	// Deletes the specified conversation profile.
	DeleteConversationProfile(context.Context, *DeleteConversationProfileRequest) (*emptypb.Empty, error)
	// Adds or updates a suggestion feature in a conversation profile.
	// If the conversation profile contains the type of suggestion feature for
	// the participant role, it will update it. Otherwise it will insert the
	// suggestion feature.
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/es/docs/how/long-running-operations).
	// The returned `Operation` type has the following method-specific fields:
	//
	// - `metadata`:
	// [SetSuggestionFeatureConfigOperationMetadata][google.cloud.dialogflow.v2beta1.SetSuggestionFeatureConfigOperationMetadata]
	// - `response`:
	// [ConversationProfile][google.cloud.dialogflow.v2beta1.ConversationProfile]
	//
	// If a long running operation to add or update suggestion feature
	// config for the same conversation profile, participant role and suggestion
	// feature type exists, please cancel the existing long running operation
	// before sending such request, otherwise the request will be rejected.
	SetSuggestionFeatureConfig(context.Context, *SetSuggestionFeatureConfigRequest) (*longrunningpb.Operation, error)
	// Clears a suggestion feature from a conversation profile for the given
	// participant role.
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/es/docs/how/long-running-operations).
	// The returned `Operation` type has the following method-specific fields:
	//
	// - `metadata`:
	// [ClearSuggestionFeatureConfigOperationMetadata][google.cloud.dialogflow.v2beta1.ClearSuggestionFeatureConfigOperationMetadata]
	// - `response`:
	// [ConversationProfile][google.cloud.dialogflow.v2beta1.ConversationProfile]
	ClearSuggestionFeatureConfig(context.Context, *ClearSuggestionFeatureConfigRequest) (*longrunningpb.Operation, error)
}

// UnimplementedConversationProfilesServer can be embedded to have forward compatible implementations.
type UnimplementedConversationProfilesServer struct {
}

func (*UnimplementedConversationProfilesServer) ListConversationProfiles(context.Context, *ListConversationProfilesRequest) (*ListConversationProfilesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListConversationProfiles not implemented")
}
func (*UnimplementedConversationProfilesServer) GetConversationProfile(context.Context, *GetConversationProfileRequest) (*ConversationProfile, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetConversationProfile not implemented")
}
func (*UnimplementedConversationProfilesServer) CreateConversationProfile(context.Context, *CreateConversationProfileRequest) (*ConversationProfile, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateConversationProfile not implemented")
}
func (*UnimplementedConversationProfilesServer) UpdateConversationProfile(context.Context, *UpdateConversationProfileRequest) (*ConversationProfile, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateConversationProfile not implemented")
}
func (*UnimplementedConversationProfilesServer) DeleteConversationProfile(context.Context, *DeleteConversationProfileRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteConversationProfile not implemented")
}
func (*UnimplementedConversationProfilesServer) SetSuggestionFeatureConfig(context.Context, *SetSuggestionFeatureConfigRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetSuggestionFeatureConfig not implemented")
}
func (*UnimplementedConversationProfilesServer) ClearSuggestionFeatureConfig(context.Context, *ClearSuggestionFeatureConfigRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ClearSuggestionFeatureConfig not implemented")
}

func RegisterConversationProfilesServer(s *grpc.Server, srv ConversationProfilesServer) {
	s.RegisterService(&_ConversationProfiles_serviceDesc, srv)
}

func _ConversationProfiles_ListConversationProfiles_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListConversationProfilesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversationProfilesServer).ListConversationProfiles(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.ConversationProfiles/ListConversationProfiles",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversationProfilesServer).ListConversationProfiles(ctx, req.(*ListConversationProfilesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConversationProfiles_GetConversationProfile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetConversationProfileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversationProfilesServer).GetConversationProfile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.ConversationProfiles/GetConversationProfile",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversationProfilesServer).GetConversationProfile(ctx, req.(*GetConversationProfileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConversationProfiles_CreateConversationProfile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateConversationProfileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversationProfilesServer).CreateConversationProfile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.ConversationProfiles/CreateConversationProfile",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversationProfilesServer).CreateConversationProfile(ctx, req.(*CreateConversationProfileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConversationProfiles_UpdateConversationProfile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateConversationProfileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversationProfilesServer).UpdateConversationProfile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.ConversationProfiles/UpdateConversationProfile",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversationProfilesServer).UpdateConversationProfile(ctx, req.(*UpdateConversationProfileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConversationProfiles_DeleteConversationProfile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteConversationProfileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversationProfilesServer).DeleteConversationProfile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.ConversationProfiles/DeleteConversationProfile",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversationProfilesServer).DeleteConversationProfile(ctx, req.(*DeleteConversationProfileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConversationProfiles_SetSuggestionFeatureConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetSuggestionFeatureConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversationProfilesServer).SetSuggestionFeatureConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.ConversationProfiles/SetSuggestionFeatureConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversationProfilesServer).SetSuggestionFeatureConfig(ctx, req.(*SetSuggestionFeatureConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConversationProfiles_ClearSuggestionFeatureConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ClearSuggestionFeatureConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversationProfilesServer).ClearSuggestionFeatureConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.ConversationProfiles/ClearSuggestionFeatureConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversationProfilesServer).ClearSuggestionFeatureConfig(ctx, req.(*ClearSuggestionFeatureConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ConversationProfiles_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dialogflow.v2beta1.ConversationProfiles",
	HandlerType: (*ConversationProfilesServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListConversationProfiles",
			Handler:    _ConversationProfiles_ListConversationProfiles_Handler,
		},
		{
			MethodName: "GetConversationProfile",
			Handler:    _ConversationProfiles_GetConversationProfile_Handler,
		},
		{
			MethodName: "CreateConversationProfile",
			Handler:    _ConversationProfiles_CreateConversationProfile_Handler,
		},
		{
			MethodName: "UpdateConversationProfile",
			Handler:    _ConversationProfiles_UpdateConversationProfile_Handler,
		},
		{
			MethodName: "DeleteConversationProfile",
			Handler:    _ConversationProfiles_DeleteConversationProfile_Handler,
		},
		{
			MethodName: "SetSuggestionFeatureConfig",
			Handler:    _ConversationProfiles_SetSuggestionFeatureConfig_Handler,
		},
		{
			MethodName: "ClearSuggestionFeatureConfig",
			Handler:    _ConversationProfiles_ClearSuggestionFeatureConfig_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dialogflow/v2beta1/conversation_profile.proto",
}
