// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.21.5
// source: google/cloud/deploy/v1/cloud_deploy.proto

package deploypb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	date "google.golang.org/genproto/googleapis/type/date"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Possible usages of this configuration.
type ExecutionConfig_ExecutionEnvironmentUsage int32

const (
	// Default value. This value is unused.
	ExecutionConfig_EXECUTION_ENVIRONMENT_USAGE_UNSPECIFIED ExecutionConfig_ExecutionEnvironmentUsage = 0
	// Use for rendering.
	ExecutionConfig_RENDER ExecutionConfig_ExecutionEnvironmentUsage = 1
	// Use for deploying and deployment hooks.
	ExecutionConfig_DEPLOY ExecutionConfig_ExecutionEnvironmentUsage = 2
	// Use for deployment verification.
	ExecutionConfig_VERIFY ExecutionConfig_ExecutionEnvironmentUsage = 3
)

// Enum value maps for ExecutionConfig_ExecutionEnvironmentUsage.
var (
	ExecutionConfig_ExecutionEnvironmentUsage_name = map[int32]string{
		0: "EXECUTION_ENVIRONMENT_USAGE_UNSPECIFIED",
		1: "RENDER",
		2: "DEPLOY",
		3: "VERIFY",
	}
	ExecutionConfig_ExecutionEnvironmentUsage_value = map[string]int32{
		"EXECUTION_ENVIRONMENT_USAGE_UNSPECIFIED": 0,
		"RENDER": 1,
		"DEPLOY": 2,
		"VERIFY": 3,
	}
)

func (x ExecutionConfig_ExecutionEnvironmentUsage) Enum() *ExecutionConfig_ExecutionEnvironmentUsage {
	p := new(ExecutionConfig_ExecutionEnvironmentUsage)
	*p = x
	return p
}

func (x ExecutionConfig_ExecutionEnvironmentUsage) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ExecutionConfig_ExecutionEnvironmentUsage) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_enumTypes[0].Descriptor()
}

func (ExecutionConfig_ExecutionEnvironmentUsage) Type() protoreflect.EnumType {
	return &file_google_cloud_deploy_v1_cloud_deploy_proto_enumTypes[0]
}

func (x ExecutionConfig_ExecutionEnvironmentUsage) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ExecutionConfig_ExecutionEnvironmentUsage.Descriptor instead.
func (ExecutionConfig_ExecutionEnvironmentUsage) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{15, 0}
}

// Valid states of the render operation.
type Release_RenderState int32

const (
	// The render state is unspecified.
	Release_RENDER_STATE_UNSPECIFIED Release_RenderState = 0
	// All rendering operations have completed successfully.
	Release_SUCCEEDED Release_RenderState = 1
	// All rendering operations have completed, and one or more have failed.
	Release_FAILED Release_RenderState = 2
	// Rendering has started and is not complete.
	Release_IN_PROGRESS Release_RenderState = 3
)

// Enum value maps for Release_RenderState.
var (
	Release_RenderState_name = map[int32]string{
		0: "RENDER_STATE_UNSPECIFIED",
		1: "SUCCEEDED",
		2: "FAILED",
		3: "IN_PROGRESS",
	}
	Release_RenderState_value = map[string]int32{
		"RENDER_STATE_UNSPECIFIED": 0,
		"SUCCEEDED":                1,
		"FAILED":                   2,
		"IN_PROGRESS":              3,
	}
)

func (x Release_RenderState) Enum() *Release_RenderState {
	p := new(Release_RenderState)
	*p = x
	return p
}

func (x Release_RenderState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Release_RenderState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_enumTypes[1].Descriptor()
}

func (Release_RenderState) Type() protoreflect.EnumType {
	return &file_google_cloud_deploy_v1_cloud_deploy_proto_enumTypes[1]
}

func (x Release_RenderState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Release_RenderState.Descriptor instead.
func (Release_RenderState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{27, 0}
}

// Valid states of the render operation.
type Release_TargetRender_TargetRenderState int32

const (
	// The render operation state is unspecified.
	Release_TargetRender_TARGET_RENDER_STATE_UNSPECIFIED Release_TargetRender_TargetRenderState = 0
	// The render operation has completed successfully.
	Release_TargetRender_SUCCEEDED Release_TargetRender_TargetRenderState = 1
	// The render operation has failed.
	Release_TargetRender_FAILED Release_TargetRender_TargetRenderState = 2
	// The render operation is in progress.
	Release_TargetRender_IN_PROGRESS Release_TargetRender_TargetRenderState = 3
)

// Enum value maps for Release_TargetRender_TargetRenderState.
var (
	Release_TargetRender_TargetRenderState_name = map[int32]string{
		0: "TARGET_RENDER_STATE_UNSPECIFIED",
		1: "SUCCEEDED",
		2: "FAILED",
		3: "IN_PROGRESS",
	}
	Release_TargetRender_TargetRenderState_value = map[string]int32{
		"TARGET_RENDER_STATE_UNSPECIFIED": 0,
		"SUCCEEDED":                       1,
		"FAILED":                          2,
		"IN_PROGRESS":                     3,
	}
)

func (x Release_TargetRender_TargetRenderState) Enum() *Release_TargetRender_TargetRenderState {
	p := new(Release_TargetRender_TargetRenderState)
	*p = x
	return p
}

func (x Release_TargetRender_TargetRenderState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Release_TargetRender_TargetRenderState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_enumTypes[2].Descriptor()
}

func (Release_TargetRender_TargetRenderState) Type() protoreflect.EnumType {
	return &file_google_cloud_deploy_v1_cloud_deploy_proto_enumTypes[2]
}

func (x Release_TargetRender_TargetRenderState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Release_TargetRender_TargetRenderState.Descriptor instead.
func (Release_TargetRender_TargetRenderState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{27, 0, 0}
}

// Well-known rendering failures.
type Release_TargetRender_FailureCause int32

const (
	// No reason for failure is specified.
	Release_TargetRender_FAILURE_CAUSE_UNSPECIFIED Release_TargetRender_FailureCause = 0
	// Cloud Build is not available, either because it is not enabled or
	// because Google Cloud Deploy has insufficient permissions. See [required
	// permission](/deploy/docs/cloud-deploy-service-account#required_permissions).
	Release_TargetRender_CLOUD_BUILD_UNAVAILABLE Release_TargetRender_FailureCause = 1
	// The render operation did not complete successfully; check Cloud Build
	// logs.
	Release_TargetRender_EXECUTION_FAILED Release_TargetRender_FailureCause = 2
)

// Enum value maps for Release_TargetRender_FailureCause.
var (
	Release_TargetRender_FailureCause_name = map[int32]string{
		0: "FAILURE_CAUSE_UNSPECIFIED",
		1: "CLOUD_BUILD_UNAVAILABLE",
		2: "EXECUTION_FAILED",
	}
	Release_TargetRender_FailureCause_value = map[string]int32{
		"FAILURE_CAUSE_UNSPECIFIED": 0,
		"CLOUD_BUILD_UNAVAILABLE":   1,
		"EXECUTION_FAILED":          2,
	}
)

func (x Release_TargetRender_FailureCause) Enum() *Release_TargetRender_FailureCause {
	p := new(Release_TargetRender_FailureCause)
	*p = x
	return p
}

func (x Release_TargetRender_FailureCause) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Release_TargetRender_FailureCause) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_enumTypes[3].Descriptor()
}

func (Release_TargetRender_FailureCause) Type() protoreflect.EnumType {
	return &file_google_cloud_deploy_v1_cloud_deploy_proto_enumTypes[3]
}

func (x Release_TargetRender_FailureCause) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Release_TargetRender_FailureCause.Descriptor instead.
func (Release_TargetRender_FailureCause) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{27, 0, 1}
}

// Valid approval states of a `Rollout`.
type Rollout_ApprovalState int32

const (
	// The `Rollout` has an unspecified approval state.
	Rollout_APPROVAL_STATE_UNSPECIFIED Rollout_ApprovalState = 0
	// The `Rollout` requires approval.
	Rollout_NEEDS_APPROVAL Rollout_ApprovalState = 1
	// The `Rollout` does not require approval.
	Rollout_DOES_NOT_NEED_APPROVAL Rollout_ApprovalState = 2
	// The `Rollout` has been approved.
	Rollout_APPROVED Rollout_ApprovalState = 3
	// The `Rollout` has been rejected.
	Rollout_REJECTED Rollout_ApprovalState = 4
)

// Enum value maps for Rollout_ApprovalState.
var (
	Rollout_ApprovalState_name = map[int32]string{
		0: "APPROVAL_STATE_UNSPECIFIED",
		1: "NEEDS_APPROVAL",
		2: "DOES_NOT_NEED_APPROVAL",
		3: "APPROVED",
		4: "REJECTED",
	}
	Rollout_ApprovalState_value = map[string]int32{
		"APPROVAL_STATE_UNSPECIFIED": 0,
		"NEEDS_APPROVAL":             1,
		"DOES_NOT_NEED_APPROVAL":     2,
		"APPROVED":                   3,
		"REJECTED":                   4,
	}
)

func (x Rollout_ApprovalState) Enum() *Rollout_ApprovalState {
	p := new(Rollout_ApprovalState)
	*p = x
	return p
}

func (x Rollout_ApprovalState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Rollout_ApprovalState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_enumTypes[4].Descriptor()
}

func (Rollout_ApprovalState) Type() protoreflect.EnumType {
	return &file_google_cloud_deploy_v1_cloud_deploy_proto_enumTypes[4]
}

func (x Rollout_ApprovalState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Rollout_ApprovalState.Descriptor instead.
func (Rollout_ApprovalState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{34, 0}
}

// Valid states of a `Rollout`.
type Rollout_State int32

const (
	// The `Rollout` has an unspecified state.
	Rollout_STATE_UNSPECIFIED Rollout_State = 0
	// The `Rollout` has completed successfully.
	Rollout_SUCCEEDED Rollout_State = 1
	// The `Rollout` has failed.
	Rollout_FAILED Rollout_State = 2
	// The `Rollout` is being deployed.
	Rollout_IN_PROGRESS Rollout_State = 3
	// The `Rollout` needs approval.
	Rollout_PENDING_APPROVAL Rollout_State = 4
	// An approver rejected the `Rollout`.
	Rollout_APPROVAL_REJECTED Rollout_State = 5
	// The `Rollout` is waiting for an earlier Rollout(s) to complete on this
	// `Target`.
	Rollout_PENDING Rollout_State = 6
	// The `Rollout` is waiting for the `Release` to be fully rendered.
	Rollout_PENDING_RELEASE Rollout_State = 7
)

// Enum value maps for Rollout_State.
var (
	Rollout_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "SUCCEEDED",
		2: "FAILED",
		3: "IN_PROGRESS",
		4: "PENDING_APPROVAL",
		5: "APPROVAL_REJECTED",
		6: "PENDING",
		7: "PENDING_RELEASE",
	}
	Rollout_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"SUCCEEDED":         1,
		"FAILED":            2,
		"IN_PROGRESS":       3,
		"PENDING_APPROVAL":  4,
		"APPROVAL_REJECTED": 5,
		"PENDING":           6,
		"PENDING_RELEASE":   7,
	}
)

func (x Rollout_State) Enum() *Rollout_State {
	p := new(Rollout_State)
	*p = x
	return p
}

func (x Rollout_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Rollout_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_enumTypes[5].Descriptor()
}

func (Rollout_State) Type() protoreflect.EnumType {
	return &file_google_cloud_deploy_v1_cloud_deploy_proto_enumTypes[5]
}

func (x Rollout_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Rollout_State.Descriptor instead.
func (Rollout_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{34, 1}
}

// Well-known rollout failures.
type Rollout_FailureCause int32

const (
	// No reason for failure is specified.
	Rollout_FAILURE_CAUSE_UNSPECIFIED Rollout_FailureCause = 0
	// Cloud Build is not available, either because it is not enabled or because
	// Cloud Deploy has insufficient permissions. See [required
	// permission](/deploy/docs/cloud-deploy-service-account#required_permissions).
	Rollout_CLOUD_BUILD_UNAVAILABLE Rollout_FailureCause = 1
	// The deploy operation did not complete successfully; check Cloud Build
	// logs.
	Rollout_EXECUTION_FAILED Rollout_FailureCause = 2
	// Deployment did not complete within the alloted time.
	Rollout_DEADLINE_EXCEEDED Rollout_FailureCause = 3
	// Release is in a failed state.
	Rollout_RELEASE_FAILED Rollout_FailureCause = 4
	// Release is abandoned.
	Rollout_RELEASE_ABANDONED Rollout_FailureCause = 5
	// No skaffold verify configuration was found.
	Rollout_VERIFICATION_CONFIG_NOT_FOUND Rollout_FailureCause = 6
)

// Enum value maps for Rollout_FailureCause.
var (
	Rollout_FailureCause_name = map[int32]string{
		0: "FAILURE_CAUSE_UNSPECIFIED",
		1: "CLOUD_BUILD_UNAVAILABLE",
		2: "EXECUTION_FAILED",
		3: "DEADLINE_EXCEEDED",
		4: "RELEASE_FAILED",
		5: "RELEASE_ABANDONED",
		6: "VERIFICATION_CONFIG_NOT_FOUND",
	}
	Rollout_FailureCause_value = map[string]int32{
		"FAILURE_CAUSE_UNSPECIFIED":     0,
		"CLOUD_BUILD_UNAVAILABLE":       1,
		"EXECUTION_FAILED":              2,
		"DEADLINE_EXCEEDED":             3,
		"RELEASE_FAILED":                4,
		"RELEASE_ABANDONED":             5,
		"VERIFICATION_CONFIG_NOT_FOUND": 6,
	}
)

func (x Rollout_FailureCause) Enum() *Rollout_FailureCause {
	p := new(Rollout_FailureCause)
	*p = x
	return p
}

func (x Rollout_FailureCause) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Rollout_FailureCause) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_enumTypes[6].Descriptor()
}

func (Rollout_FailureCause) Type() protoreflect.EnumType {
	return &file_google_cloud_deploy_v1_cloud_deploy_proto_enumTypes[6]
}

func (x Rollout_FailureCause) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Rollout_FailureCause.Descriptor instead.
func (Rollout_FailureCause) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{34, 2}
}

// Valid states of a Phase.
type Phase_State int32

const (
	// The Phase has an unspecified state.
	Phase_STATE_UNSPECIFIED Phase_State = 0
	// The Phase is waiting for an earlier Phase(s) to complete.
	Phase_PENDING Phase_State = 1
	// The Phase is in progress.
	Phase_IN_PROGRESS Phase_State = 2
	// The Phase has succeeded.
	Phase_SUCCEEDED Phase_State = 3
	// The Phase has failed.
	Phase_FAILED Phase_State = 4
	// The Phase was aborted.
	Phase_ABORTED Phase_State = 5
)

// Enum value maps for Phase_State.
var (
	Phase_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "PENDING",
		2: "IN_PROGRESS",
		3: "SUCCEEDED",
		4: "FAILED",
		5: "ABORTED",
	}
	Phase_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"PENDING":           1,
		"IN_PROGRESS":       2,
		"SUCCEEDED":         3,
		"FAILED":            4,
		"ABORTED":           5,
	}
)

func (x Phase_State) Enum() *Phase_State {
	p := new(Phase_State)
	*p = x
	return p
}

func (x Phase_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Phase_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_enumTypes[7].Descriptor()
}

func (Phase_State) Type() protoreflect.EnumType {
	return &file_google_cloud_deploy_v1_cloud_deploy_proto_enumTypes[7]
}

func (x Phase_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Phase_State.Descriptor instead.
func (Phase_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{38, 0}
}

// Valid states of a Job.
type Job_State int32

const (
	// The Job has an unspecified state.
	Job_STATE_UNSPECIFIED Job_State = 0
	// The Job is waiting for an earlier Phase(s) or Job(s) to complete.
	Job_PENDING Job_State = 1
	// The Job is disabled.
	Job_DISABLED Job_State = 2
	// The Job is in progress.
	Job_IN_PROGRESS Job_State = 3
	// The Job succeeded.
	Job_SUCCEEDED Job_State = 4
	// The Job failed.
	Job_FAILED Job_State = 5
	// The Job was aborted.
	Job_ABORTED Job_State = 6
)

// Enum value maps for Job_State.
var (
	Job_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "PENDING",
		2: "DISABLED",
		3: "IN_PROGRESS",
		4: "SUCCEEDED",
		5: "FAILED",
		6: "ABORTED",
	}
	Job_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"PENDING":           1,
		"DISABLED":          2,
		"IN_PROGRESS":       3,
		"SUCCEEDED":         4,
		"FAILED":            5,
		"ABORTED":           6,
	}
)

func (x Job_State) Enum() *Job_State {
	p := new(Job_State)
	*p = x
	return p
}

func (x Job_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Job_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_enumTypes[8].Descriptor()
}

func (Job_State) Type() protoreflect.EnumType {
	return &file_google_cloud_deploy_v1_cloud_deploy_proto_enumTypes[8]
}

func (x Job_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Job_State.Descriptor instead.
func (Job_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{40, 0}
}

// Valid states of a `JobRun`.
type JobRun_State int32

const (
	// The `JobRun` has an unspecified state.
	JobRun_STATE_UNSPECIFIED JobRun_State = 0
	// The `JobRun` is in progress.
	JobRun_IN_PROGRESS JobRun_State = 1
	// The `JobRun` has succeeded.
	JobRun_SUCCEEDED JobRun_State = 2
	// The `JobRun` has failed.
	JobRun_FAILED JobRun_State = 3
)

// Enum value maps for JobRun_State.
var (
	JobRun_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "IN_PROGRESS",
		2: "SUCCEEDED",
		3: "FAILED",
	}
	JobRun_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"IN_PROGRESS":       1,
		"SUCCEEDED":         2,
		"FAILED":            3,
	}
)

func (x JobRun_State) Enum() *JobRun_State {
	p := new(JobRun_State)
	*p = x
	return p
}

func (x JobRun_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (JobRun_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_enumTypes[9].Descriptor()
}

func (JobRun_State) Type() protoreflect.EnumType {
	return &file_google_cloud_deploy_v1_cloud_deploy_proto_enumTypes[9]
}

func (x JobRun_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use JobRun_State.Descriptor instead.
func (JobRun_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{54, 0}
}

// Well-known deploy failures.
type DeployJobRun_FailureCause int32

const (
	// No reason for failure is specified.
	DeployJobRun_FAILURE_CAUSE_UNSPECIFIED DeployJobRun_FailureCause = 0
	// Cloud Build is not available, either because it is not enabled or because
	// Google Cloud Deploy has insufficient permissions. See [Required
	// permission](/deploy/docs/cloud-deploy-service-account#required_permissions).
	DeployJobRun_CLOUD_BUILD_UNAVAILABLE DeployJobRun_FailureCause = 1
	// The deploy operation did not complete successfully; check Cloud Build
	// logs.
	DeployJobRun_EXECUTION_FAILED DeployJobRun_FailureCause = 2
	// The deploy build did not complete within the alloted time.
	DeployJobRun_DEADLINE_EXCEEDED DeployJobRun_FailureCause = 3
)

// Enum value maps for DeployJobRun_FailureCause.
var (
	DeployJobRun_FailureCause_name = map[int32]string{
		0: "FAILURE_CAUSE_UNSPECIFIED",
		1: "CLOUD_BUILD_UNAVAILABLE",
		2: "EXECUTION_FAILED",
		3: "DEADLINE_EXCEEDED",
	}
	DeployJobRun_FailureCause_value = map[string]int32{
		"FAILURE_CAUSE_UNSPECIFIED": 0,
		"CLOUD_BUILD_UNAVAILABLE":   1,
		"EXECUTION_FAILED":          2,
		"DEADLINE_EXCEEDED":         3,
	}
)

func (x DeployJobRun_FailureCause) Enum() *DeployJobRun_FailureCause {
	p := new(DeployJobRun_FailureCause)
	*p = x
	return p
}

func (x DeployJobRun_FailureCause) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DeployJobRun_FailureCause) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_enumTypes[10].Descriptor()
}

func (DeployJobRun_FailureCause) Type() protoreflect.EnumType {
	return &file_google_cloud_deploy_v1_cloud_deploy_proto_enumTypes[10]
}

func (x DeployJobRun_FailureCause) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DeployJobRun_FailureCause.Descriptor instead.
func (DeployJobRun_FailureCause) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{55, 0}
}

// Well-known verify failures.
type VerifyJobRun_FailureCause int32

const (
	// No reason for failure is specified.
	VerifyJobRun_FAILURE_CAUSE_UNSPECIFIED VerifyJobRun_FailureCause = 0
	// Cloud Build is not available, either because it is not enabled or because
	// Google Cloud Deploy has insufficient permissions. See [required
	// permission](/deploy/docs/cloud-deploy-service-account#required_permissions).
	VerifyJobRun_CLOUD_BUILD_UNAVAILABLE VerifyJobRun_FailureCause = 1
	// The verify operation did not complete successfully; check Cloud Build
	// logs.
	VerifyJobRun_EXECUTION_FAILED VerifyJobRun_FailureCause = 2
	// The verify build did not complete within the alloted time.
	VerifyJobRun_DEADLINE_EXCEEDED VerifyJobRun_FailureCause = 3
	// No Skaffold verify configuration was found.
	VerifyJobRun_VERIFICATION_CONFIG_NOT_FOUND VerifyJobRun_FailureCause = 4
)

// Enum value maps for VerifyJobRun_FailureCause.
var (
	VerifyJobRun_FailureCause_name = map[int32]string{
		0: "FAILURE_CAUSE_UNSPECIFIED",
		1: "CLOUD_BUILD_UNAVAILABLE",
		2: "EXECUTION_FAILED",
		3: "DEADLINE_EXCEEDED",
		4: "VERIFICATION_CONFIG_NOT_FOUND",
	}
	VerifyJobRun_FailureCause_value = map[string]int32{
		"FAILURE_CAUSE_UNSPECIFIED":     0,
		"CLOUD_BUILD_UNAVAILABLE":       1,
		"EXECUTION_FAILED":              2,
		"DEADLINE_EXCEEDED":             3,
		"VERIFICATION_CONFIG_NOT_FOUND": 4,
	}
)

func (x VerifyJobRun_FailureCause) Enum() *VerifyJobRun_FailureCause {
	p := new(VerifyJobRun_FailureCause)
	*p = x
	return p
}

func (x VerifyJobRun_FailureCause) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (VerifyJobRun_FailureCause) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_enumTypes[11].Descriptor()
}

func (VerifyJobRun_FailureCause) Type() protoreflect.EnumType {
	return &file_google_cloud_deploy_v1_cloud_deploy_proto_enumTypes[11]
}

func (x VerifyJobRun_FailureCause) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use VerifyJobRun_FailureCause.Descriptor instead.
func (VerifyJobRun_FailureCause) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{56, 0}
}

// A `DeliveryPipeline` resource in the Google Cloud Deploy API.
//
// A `DeliveryPipeline` defines a pipeline through which a Skaffold
// configuration can progress.
type DeliveryPipeline struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Name of the `DeliveryPipeline`. Format is projects/{project}/
	// locations/{location}/deliveryPipelines/[a-z][a-z0-9\-]{0,62}.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Unique identifier of the `DeliveryPipeline`.
	Uid string `protobuf:"bytes,2,opt,name=uid,proto3" json:"uid,omitempty"`
	// Description of the `DeliveryPipeline`. Max length is 255 characters.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// User annotations. These attributes can only be set and used by the
	// user, and not by Google Cloud Deploy.
	Annotations map[string]string `protobuf:"bytes,4,rep,name=annotations,proto3" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Labels are attributes that can be set and used by both the
	// user and by Google Cloud Deploy. Labels must meet the following
	// constraints:
	//
	// * Keys and values can contain only lowercase letters, numeric characters,
	// underscores, and dashes.
	// * All characters must use UTF-8 encoding, and international characters are
	// allowed.
	// * Keys must start with a lowercase letter or international character.
	// * Each resource is limited to a maximum of 64 labels.
	//
	// Both keys and values are additionally constrained to be <= 128 bytes.
	Labels map[string]string `protobuf:"bytes,5,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. Time at which the pipeline was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Most recent time at which the pipeline was updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// The ordering configuration of the `DeliveryPipeline`.
	//
	// Types that are assignable to Pipeline:
	//
	//	*DeliveryPipeline_SerialPipeline
	Pipeline isDeliveryPipeline_Pipeline `protobuf_oneof:"pipeline"`
	// Output only. Information around the state of the Delivery Pipeline.
	Condition *PipelineCondition `protobuf:"bytes,11,opt,name=condition,proto3" json:"condition,omitempty"`
	// This checksum is computed by the server based on the value of other
	// fields, and may be sent on update and delete requests to ensure the
	// client has an up-to-date value before proceeding.
	Etag string `protobuf:"bytes,10,opt,name=etag,proto3" json:"etag,omitempty"`
	// When suspended, no new releases or rollouts can be created,
	// but in-progress ones will complete.
	Suspended bool `protobuf:"varint,12,opt,name=suspended,proto3" json:"suspended,omitempty"`
}

func (x *DeliveryPipeline) Reset() {
	*x = DeliveryPipeline{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeliveryPipeline) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeliveryPipeline) ProtoMessage() {}

func (x *DeliveryPipeline) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeliveryPipeline.ProtoReflect.Descriptor instead.
func (*DeliveryPipeline) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{0}
}

func (x *DeliveryPipeline) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeliveryPipeline) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

func (x *DeliveryPipeline) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *DeliveryPipeline) GetAnnotations() map[string]string {
	if x != nil {
		return x.Annotations
	}
	return nil
}

func (x *DeliveryPipeline) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *DeliveryPipeline) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *DeliveryPipeline) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (m *DeliveryPipeline) GetPipeline() isDeliveryPipeline_Pipeline {
	if m != nil {
		return m.Pipeline
	}
	return nil
}

func (x *DeliveryPipeline) GetSerialPipeline() *SerialPipeline {
	if x, ok := x.GetPipeline().(*DeliveryPipeline_SerialPipeline); ok {
		return x.SerialPipeline
	}
	return nil
}

func (x *DeliveryPipeline) GetCondition() *PipelineCondition {
	if x != nil {
		return x.Condition
	}
	return nil
}

func (x *DeliveryPipeline) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *DeliveryPipeline) GetSuspended() bool {
	if x != nil {
		return x.Suspended
	}
	return false
}

type isDeliveryPipeline_Pipeline interface {
	isDeliveryPipeline_Pipeline()
}

type DeliveryPipeline_SerialPipeline struct {
	// SerialPipeline defines a sequential set of stages for a
	// `DeliveryPipeline`.
	SerialPipeline *SerialPipeline `protobuf:"bytes,8,opt,name=serial_pipeline,json=serialPipeline,proto3,oneof"`
}

func (*DeliveryPipeline_SerialPipeline) isDeliveryPipeline_Pipeline() {}

// SerialPipeline defines a sequential set of stages for a `DeliveryPipeline`.
type SerialPipeline struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Each stage specifies configuration for a `Target`. The ordering
	// of this list defines the promotion flow.
	Stages []*Stage `protobuf:"bytes,1,rep,name=stages,proto3" json:"stages,omitempty"`
}

func (x *SerialPipeline) Reset() {
	*x = SerialPipeline{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SerialPipeline) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SerialPipeline) ProtoMessage() {}

func (x *SerialPipeline) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SerialPipeline.ProtoReflect.Descriptor instead.
func (*SerialPipeline) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{1}
}

func (x *SerialPipeline) GetStages() []*Stage {
	if x != nil {
		return x.Stages
	}
	return nil
}

// Stage specifies a location to which to deploy.
type Stage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The target_id to which this stage points. This field refers exclusively to
	// the last segment of a target name. For example, this field would just be
	// `my-target` (rather than
	// `projects/project/locations/location/targets/my-target`). The location of
	// the `Target` is inferred to be the same as the location of the
	// `DeliveryPipeline` that contains this `Stage`.
	TargetId string `protobuf:"bytes,1,opt,name=target_id,json=targetId,proto3" json:"target_id,omitempty"`
	// Skaffold profiles to use when rendering the manifest for this stage's
	// `Target`.
	Profiles []string `protobuf:"bytes,2,rep,name=profiles,proto3" json:"profiles,omitempty"`
	// Optional. The strategy to use for a `Rollout` to this stage.
	Strategy *Strategy `protobuf:"bytes,5,opt,name=strategy,proto3" json:"strategy,omitempty"`
}

func (x *Stage) Reset() {
	*x = Stage{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Stage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Stage) ProtoMessage() {}

func (x *Stage) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Stage.ProtoReflect.Descriptor instead.
func (*Stage) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{2}
}

func (x *Stage) GetTargetId() string {
	if x != nil {
		return x.TargetId
	}
	return ""
}

func (x *Stage) GetProfiles() []string {
	if x != nil {
		return x.Profiles
	}
	return nil
}

func (x *Stage) GetStrategy() *Strategy {
	if x != nil {
		return x.Strategy
	}
	return nil
}

// Strategy contains deployment strategy information.
type Strategy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Deployment strategy details.
	//
	// Types that are assignable to DeploymentStrategy:
	//
	//	*Strategy_Standard
	DeploymentStrategy isStrategy_DeploymentStrategy `protobuf_oneof:"deployment_strategy"`
}

func (x *Strategy) Reset() {
	*x = Strategy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Strategy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Strategy) ProtoMessage() {}

func (x *Strategy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Strategy.ProtoReflect.Descriptor instead.
func (*Strategy) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{3}
}

func (m *Strategy) GetDeploymentStrategy() isStrategy_DeploymentStrategy {
	if m != nil {
		return m.DeploymentStrategy
	}
	return nil
}

func (x *Strategy) GetStandard() *Standard {
	if x, ok := x.GetDeploymentStrategy().(*Strategy_Standard); ok {
		return x.Standard
	}
	return nil
}

type isStrategy_DeploymentStrategy interface {
	isStrategy_DeploymentStrategy()
}

type Strategy_Standard struct {
	// Standard deployment strategy executes a single deploy and allows
	// verifying the deployment.
	Standard *Standard `protobuf:"bytes,1,opt,name=standard,proto3,oneof"`
}

func (*Strategy_Standard) isStrategy_DeploymentStrategy() {}

// Standard represents the standard deployment strategy.
type Standard struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether to verify a deployment.
	Verify bool `protobuf:"varint,1,opt,name=verify,proto3" json:"verify,omitempty"`
}

func (x *Standard) Reset() {
	*x = Standard{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Standard) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Standard) ProtoMessage() {}

func (x *Standard) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Standard.ProtoReflect.Descriptor instead.
func (*Standard) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{4}
}

func (x *Standard) GetVerify() bool {
	if x != nil {
		return x.Verify
	}
	return false
}

// PipelineReadyCondition contains information around the status of the
// Pipeline.
type PipelineReadyCondition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// True if the Pipeline is in a valid state. Otherwise at least one condition
	// in `PipelineCondition` is in an invalid state. Iterate over those
	// conditions and see which condition(s) has status = false to find out what
	// is wrong with the Pipeline.
	Status bool `protobuf:"varint,3,opt,name=status,proto3" json:"status,omitempty"`
	// Last time the condition was updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
}

func (x *PipelineReadyCondition) Reset() {
	*x = PipelineReadyCondition{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PipelineReadyCondition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PipelineReadyCondition) ProtoMessage() {}

func (x *PipelineReadyCondition) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PipelineReadyCondition.ProtoReflect.Descriptor instead.
func (*PipelineReadyCondition) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{5}
}

func (x *PipelineReadyCondition) GetStatus() bool {
	if x != nil {
		return x.Status
	}
	return false
}

func (x *PipelineReadyCondition) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

// TargetsPresentCondition contains information on any Targets defined in
// the Delivery Pipeline that do not actually exist.
type TargetsPresentCondition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// True if there aren't any missing Targets.
	Status bool `protobuf:"varint,1,opt,name=status,proto3" json:"status,omitempty"`
	// The list of Target names that are missing. For example,
	// projects/{project_id}/locations/{location_name}/targets/{target_name}.
	MissingTargets []string `protobuf:"bytes,2,rep,name=missing_targets,json=missingTargets,proto3" json:"missing_targets,omitempty"`
	// Last time the condition was updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
}

func (x *TargetsPresentCondition) Reset() {
	*x = TargetsPresentCondition{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TargetsPresentCondition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TargetsPresentCondition) ProtoMessage() {}

func (x *TargetsPresentCondition) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TargetsPresentCondition.ProtoReflect.Descriptor instead.
func (*TargetsPresentCondition) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{6}
}

func (x *TargetsPresentCondition) GetStatus() bool {
	if x != nil {
		return x.Status
	}
	return false
}

func (x *TargetsPresentCondition) GetMissingTargets() []string {
	if x != nil {
		return x.MissingTargets
	}
	return nil
}

func (x *TargetsPresentCondition) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

// PipelineCondition contains all conditions relevant to a Delivery Pipeline.
type PipelineCondition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Details around the Pipeline's overall status.
	PipelineReadyCondition *PipelineReadyCondition `protobuf:"bytes,1,opt,name=pipeline_ready_condition,json=pipelineReadyCondition,proto3" json:"pipeline_ready_condition,omitempty"`
	// Detalis around targets enumerated in the pipeline.
	TargetsPresentCondition *TargetsPresentCondition `protobuf:"bytes,3,opt,name=targets_present_condition,json=targetsPresentCondition,proto3" json:"targets_present_condition,omitempty"`
}

func (x *PipelineCondition) Reset() {
	*x = PipelineCondition{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PipelineCondition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PipelineCondition) ProtoMessage() {}

func (x *PipelineCondition) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PipelineCondition.ProtoReflect.Descriptor instead.
func (*PipelineCondition) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{7}
}

func (x *PipelineCondition) GetPipelineReadyCondition() *PipelineReadyCondition {
	if x != nil {
		return x.PipelineReadyCondition
	}
	return nil
}

func (x *PipelineCondition) GetTargetsPresentCondition() *TargetsPresentCondition {
	if x != nil {
		return x.TargetsPresentCondition
	}
	return nil
}

// The request object for `ListDeliveryPipelines`.
type ListDeliveryPipelinesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent, which owns this collection of pipelines. Format must be
	// projects/{project_id}/locations/{location_name}.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of pipelines to return. The service may return
	// fewer than this value. If unspecified, at most 50 pipelines will
	// be returned. The maximum value is 1000; values above 1000 will be set
	// to 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListDeliveryPipelines` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other provided parameters match
	// the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Filter pipelines to be returned. See https://google.aip.dev/160 for more
	// details.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Field to sort by. See https://google.aip.dev/132#ordering for more details.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListDeliveryPipelinesRequest) Reset() {
	*x = ListDeliveryPipelinesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListDeliveryPipelinesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDeliveryPipelinesRequest) ProtoMessage() {}

func (x *ListDeliveryPipelinesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDeliveryPipelinesRequest.ProtoReflect.Descriptor instead.
func (*ListDeliveryPipelinesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{8}
}

func (x *ListDeliveryPipelinesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListDeliveryPipelinesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListDeliveryPipelinesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListDeliveryPipelinesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListDeliveryPipelinesRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// The response object from `ListDeliveryPipelines`.
type ListDeliveryPipelinesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The `DeliveryPipeline` objects.
	DeliveryPipelines []*DeliveryPipeline `protobuf:"bytes,1,rep,name=delivery_pipelines,json=deliveryPipelines,proto3" json:"delivery_pipelines,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListDeliveryPipelinesResponse) Reset() {
	*x = ListDeliveryPipelinesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListDeliveryPipelinesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDeliveryPipelinesResponse) ProtoMessage() {}

func (x *ListDeliveryPipelinesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDeliveryPipelinesResponse.ProtoReflect.Descriptor instead.
func (*ListDeliveryPipelinesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{9}
}

func (x *ListDeliveryPipelinesResponse) GetDeliveryPipelines() []*DeliveryPipeline {
	if x != nil {
		return x.DeliveryPipelines
	}
	return nil
}

func (x *ListDeliveryPipelinesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListDeliveryPipelinesResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// The request object for `GetDeliveryPipeline`
type GetDeliveryPipelineRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the `DeliveryPipeline`. Format must be
	// projects/{project_id}/locations/{location_name}/deliveryPipelines/{pipeline_name}.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetDeliveryPipelineRequest) Reset() {
	*x = GetDeliveryPipelineRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetDeliveryPipelineRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDeliveryPipelineRequest) ProtoMessage() {}

func (x *GetDeliveryPipelineRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDeliveryPipelineRequest.ProtoReflect.Descriptor instead.
func (*GetDeliveryPipelineRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{10}
}

func (x *GetDeliveryPipelineRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request object for `CreateDeliveryPipeline`.
type CreateDeliveryPipelineRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent collection in which the `DeliveryPipeline` should be created.
	// Format should be projects/{project_id}/locations/{location_name}.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. ID of the `DeliveryPipeline`.
	DeliveryPipelineId string `protobuf:"bytes,2,opt,name=delivery_pipeline_id,json=deliveryPipelineId,proto3" json:"delivery_pipeline_id,omitempty"`
	// Required. The `DeliveryPipeline` to create.
	DeliveryPipeline *DeliveryPipeline `protobuf:"bytes,3,opt,name=delivery_pipeline,json=deliveryPipeline,proto3" json:"delivery_pipeline,omitempty"`
	// Optional. A request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server will know to ignore
	// the request if it has already been completed. The server will guarantee
	// that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and the
	// request times out. If you make the request again with the same request ID,
	// the server can check if original operation with the same request ID was
	// received, and if so, will ignore the second request. This prevents clients
	// from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Optional. If set to true, the request is validated and the user is provided with
	// an expected result, but no actual change is made.
	ValidateOnly bool `protobuf:"varint,5,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *CreateDeliveryPipelineRequest) Reset() {
	*x = CreateDeliveryPipelineRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateDeliveryPipelineRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateDeliveryPipelineRequest) ProtoMessage() {}

func (x *CreateDeliveryPipelineRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateDeliveryPipelineRequest.ProtoReflect.Descriptor instead.
func (*CreateDeliveryPipelineRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{11}
}

func (x *CreateDeliveryPipelineRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateDeliveryPipelineRequest) GetDeliveryPipelineId() string {
	if x != nil {
		return x.DeliveryPipelineId
	}
	return ""
}

func (x *CreateDeliveryPipelineRequest) GetDeliveryPipeline() *DeliveryPipeline {
	if x != nil {
		return x.DeliveryPipeline
	}
	return nil
}

func (x *CreateDeliveryPipelineRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *CreateDeliveryPipelineRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// The request object for `UpdateDeliveryPipeline`.
type UpdateDeliveryPipelineRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Field mask is used to specify the fields to be overwritten in the
	// `DeliveryPipeline` resource by the update.
	// The fields specified in the update_mask are relative to the resource, not
	// the full request. A field will be overwritten if it is in the mask. If the
	// user does not provide a mask then all fields will be overwritten.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. The `DeliveryPipeline` to update.
	DeliveryPipeline *DeliveryPipeline `protobuf:"bytes,2,opt,name=delivery_pipeline,json=deliveryPipeline,proto3" json:"delivery_pipeline,omitempty"`
	// Optional. A request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server will know to ignore
	// the request if it has already been completed. The server will guarantee
	// that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and the
	// request times out. If you make the request again with the same request ID,
	// the server can check if original operation with the same request ID was
	// received, and if so, will ignore the second request. This prevents clients
	// from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Optional. If set to true, updating a `DeliveryPipeline` that does not exist will
	// result in the creation of a new `DeliveryPipeline`.
	AllowMissing bool `protobuf:"varint,4,opt,name=allow_missing,json=allowMissing,proto3" json:"allow_missing,omitempty"`
	// Optional. If set to true, the request is validated and the user is provided with
	// an expected result, but no actual change is made.
	ValidateOnly bool `protobuf:"varint,5,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *UpdateDeliveryPipelineRequest) Reset() {
	*x = UpdateDeliveryPipelineRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateDeliveryPipelineRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateDeliveryPipelineRequest) ProtoMessage() {}

func (x *UpdateDeliveryPipelineRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateDeliveryPipelineRequest.ProtoReflect.Descriptor instead.
func (*UpdateDeliveryPipelineRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{12}
}

func (x *UpdateDeliveryPipelineRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateDeliveryPipelineRequest) GetDeliveryPipeline() *DeliveryPipeline {
	if x != nil {
		return x.DeliveryPipeline
	}
	return nil
}

func (x *UpdateDeliveryPipelineRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *UpdateDeliveryPipelineRequest) GetAllowMissing() bool {
	if x != nil {
		return x.AllowMissing
	}
	return false
}

func (x *UpdateDeliveryPipelineRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// The request object for `DeleteDeliveryPipeline`.
type DeleteDeliveryPipelineRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the `DeliveryPipeline` to delete. Format should be
	// projects/{project_id}/locations/{location_name}/deliveryPipelines/{pipeline_name}.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. A request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server will know to ignore
	// the request if it has already been completed. The server will guarantee
	// that for at least 60 minutes after the first request.
	//
	// For example, consider a situation where you make an initial request and the
	// request times out. If you make the request again with the same request ID,
	// the server can check if original operation with the same request ID was
	// received, and if so, will ignore the second request. This prevents clients
	// from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Optional. If set to true, then deleting an already deleted or non-existing
	// `DeliveryPipeline` will succeed.
	AllowMissing bool `protobuf:"varint,3,opt,name=allow_missing,json=allowMissing,proto3" json:"allow_missing,omitempty"`
	// Optional. If set, validate the request and preview the review, but do not actually
	// post it.
	ValidateOnly bool `protobuf:"varint,4,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
	// Optional. If set to true, all child resources under this pipeline will also be
	// deleted. Otherwise, the request will only work if the pipeline has
	// no child resources.
	Force bool `protobuf:"varint,6,opt,name=force,proto3" json:"force,omitempty"`
	// Optional. This checksum is computed by the server based on the value of other
	// fields, and may be sent on update and delete requests to ensure the
	// client has an up-to-date value before proceeding.
	Etag string `protobuf:"bytes,5,opt,name=etag,proto3" json:"etag,omitempty"`
}

func (x *DeleteDeliveryPipelineRequest) Reset() {
	*x = DeleteDeliveryPipelineRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteDeliveryPipelineRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteDeliveryPipelineRequest) ProtoMessage() {}

func (x *DeleteDeliveryPipelineRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteDeliveryPipelineRequest.ProtoReflect.Descriptor instead.
func (*DeleteDeliveryPipelineRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{13}
}

func (x *DeleteDeliveryPipelineRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteDeliveryPipelineRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *DeleteDeliveryPipelineRequest) GetAllowMissing() bool {
	if x != nil {
		return x.AllowMissing
	}
	return false
}

func (x *DeleteDeliveryPipelineRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

func (x *DeleteDeliveryPipelineRequest) GetForce() bool {
	if x != nil {
		return x.Force
	}
	return false
}

func (x *DeleteDeliveryPipelineRequest) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

// A `Target` resource in the Google Cloud Deploy API.
//
// A `Target` defines a location to which a Skaffold configuration
// can be deployed.
type Target struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Name of the `Target`. Format is
	// projects/{project}/locations/{location}/targets/[a-z][a-z0-9\-]{0,62}.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Resource id of the `Target`.
	TargetId string `protobuf:"bytes,2,opt,name=target_id,json=targetId,proto3" json:"target_id,omitempty"`
	// Output only. Unique identifier of the `Target`.
	Uid string `protobuf:"bytes,3,opt,name=uid,proto3" json:"uid,omitempty"`
	// Optional. Description of the `Target`. Max length is 255 characters.
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// Optional. User annotations. These attributes can only be set and used by the
	// user, and not by Google Cloud Deploy. See
	// https://google.aip.dev/128#annotations for more details such as format and
	// size limitations.
	Annotations map[string]string `protobuf:"bytes,5,rep,name=annotations,proto3" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. Labels are attributes that can be set and used by both the
	// user and by Google Cloud Deploy. Labels must meet the following
	// constraints:
	//
	// * Keys and values can contain only lowercase letters, numeric characters,
	// underscores, and dashes.
	// * All characters must use UTF-8 encoding, and international characters are
	// allowed.
	// * Keys must start with a lowercase letter or international character.
	// * Each resource is limited to a maximum of 64 labels.
	//
	// Both keys and values are additionally constrained to be <= 128 bytes.
	Labels map[string]string `protobuf:"bytes,6,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. Whether or not the `Target` requires approval.
	RequireApproval bool `protobuf:"varint,13,opt,name=require_approval,json=requireApproval,proto3" json:"require_approval,omitempty"`
	// Output only. Time at which the `Target` was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Most recent time at which the `Target` was updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,9,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Destination to which the Skaffold configuration is applied during a
	// rollout.
	//
	// Types that are assignable to DeploymentTarget:
	//
	//	*Target_Gke
	//	*Target_AnthosCluster
	//	*Target_Run
	DeploymentTarget isTarget_DeploymentTarget `protobuf_oneof:"deployment_target"`
	// Optional. This checksum is computed by the server based on the value of other
	// fields, and may be sent on update and delete requests to ensure the
	// client has an up-to-date value before proceeding.
	Etag string `protobuf:"bytes,12,opt,name=etag,proto3" json:"etag,omitempty"`
	// Configurations for all execution that relates to this `Target`.
	// Each `ExecutionEnvironmentUsage` value may only be used in a single
	// configuration; using the same value multiple times is an error.
	// When one or more configurations are specified, they must include the
	// `RENDER` and `DEPLOY` `ExecutionEnvironmentUsage` values.
	// When no configurations are specified, execution will use the default
	// specified in `DefaultPool`.
	ExecutionConfigs []*ExecutionConfig `protobuf:"bytes,16,rep,name=execution_configs,json=executionConfigs,proto3" json:"execution_configs,omitempty"`
}

func (x *Target) Reset() {
	*x = Target{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Target) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Target) ProtoMessage() {}

func (x *Target) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Target.ProtoReflect.Descriptor instead.
func (*Target) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{14}
}

func (x *Target) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Target) GetTargetId() string {
	if x != nil {
		return x.TargetId
	}
	return ""
}

func (x *Target) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

func (x *Target) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Target) GetAnnotations() map[string]string {
	if x != nil {
		return x.Annotations
	}
	return nil
}

func (x *Target) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Target) GetRequireApproval() bool {
	if x != nil {
		return x.RequireApproval
	}
	return false
}

func (x *Target) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Target) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (m *Target) GetDeploymentTarget() isTarget_DeploymentTarget {
	if m != nil {
		return m.DeploymentTarget
	}
	return nil
}

func (x *Target) GetGke() *GkeCluster {
	if x, ok := x.GetDeploymentTarget().(*Target_Gke); ok {
		return x.Gke
	}
	return nil
}

func (x *Target) GetAnthosCluster() *AnthosCluster {
	if x, ok := x.GetDeploymentTarget().(*Target_AnthosCluster); ok {
		return x.AnthosCluster
	}
	return nil
}

func (x *Target) GetRun() *CloudRunLocation {
	if x, ok := x.GetDeploymentTarget().(*Target_Run); ok {
		return x.Run
	}
	return nil
}

func (x *Target) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *Target) GetExecutionConfigs() []*ExecutionConfig {
	if x != nil {
		return x.ExecutionConfigs
	}
	return nil
}

type isTarget_DeploymentTarget interface {
	isTarget_DeploymentTarget()
}

type Target_Gke struct {
	// Information specifying a GKE Cluster.
	Gke *GkeCluster `protobuf:"bytes,15,opt,name=gke,proto3,oneof"`
}

type Target_AnthosCluster struct {
	// Information specifying an Anthos Cluster.
	AnthosCluster *AnthosCluster `protobuf:"bytes,17,opt,name=anthos_cluster,json=anthosCluster,proto3,oneof"`
}

type Target_Run struct {
	// Information specifying a Cloud Run deployment target.
	Run *CloudRunLocation `protobuf:"bytes,18,opt,name=run,proto3,oneof"`
}

func (*Target_Gke) isTarget_DeploymentTarget() {}

func (*Target_AnthosCluster) isTarget_DeploymentTarget() {}

func (*Target_Run) isTarget_DeploymentTarget() {}

// Configuration of the environment to use when calling Skaffold.
type ExecutionConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Usages when this configuration should be applied.
	Usages []ExecutionConfig_ExecutionEnvironmentUsage `protobuf:"varint,1,rep,packed,name=usages,proto3,enum=google.cloud.deploy.v1.ExecutionConfig_ExecutionEnvironmentUsage" json:"usages,omitempty"`
	// Details of the environment.
	//
	// Types that are assignable to ExecutionEnvironment:
	//
	//	*ExecutionConfig_DefaultPool
	//	*ExecutionConfig_PrivatePool
	ExecutionEnvironment isExecutionConfig_ExecutionEnvironment `protobuf_oneof:"execution_environment"`
	// Optional. The resource name of the `WorkerPool`, with the format
	// `projects/{project}/locations/{location}/workerPools/{worker_pool}`.
	// If this optional field is unspecified, the default Cloud Build pool will be
	// used.
	WorkerPool string `protobuf:"bytes,4,opt,name=worker_pool,json=workerPool,proto3" json:"worker_pool,omitempty"`
	// Optional. Google service account to use for execution. If unspecified,
	// the project execution service account
	// (<PROJECT_NUMBER>-compute@developer.gserviceaccount.com) is used.
	ServiceAccount string `protobuf:"bytes,5,opt,name=service_account,json=serviceAccount,proto3" json:"service_account,omitempty"`
	// Optional. Cloud Storage location in which to store execution outputs. This can
	// either be a bucket ("gs://my-bucket") or a path within a bucket
	// ("gs://my-bucket/my-dir").
	// If unspecified, a default bucket located in the same region will be used.
	ArtifactStorage string `protobuf:"bytes,6,opt,name=artifact_storage,json=artifactStorage,proto3" json:"artifact_storage,omitempty"`
	// Optional. Execution timeout for a Cloud Build Execution. This must be between 10m and
	// 24h in seconds format.
	// If unspecified, a default timeout of 1h is used.
	ExecutionTimeout *durationpb.Duration `protobuf:"bytes,7,opt,name=execution_timeout,json=executionTimeout,proto3" json:"execution_timeout,omitempty"`
}

func (x *ExecutionConfig) Reset() {
	*x = ExecutionConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecutionConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecutionConfig) ProtoMessage() {}

func (x *ExecutionConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecutionConfig.ProtoReflect.Descriptor instead.
func (*ExecutionConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{15}
}

func (x *ExecutionConfig) GetUsages() []ExecutionConfig_ExecutionEnvironmentUsage {
	if x != nil {
		return x.Usages
	}
	return nil
}

func (m *ExecutionConfig) GetExecutionEnvironment() isExecutionConfig_ExecutionEnvironment {
	if m != nil {
		return m.ExecutionEnvironment
	}
	return nil
}

func (x *ExecutionConfig) GetDefaultPool() *DefaultPool {
	if x, ok := x.GetExecutionEnvironment().(*ExecutionConfig_DefaultPool); ok {
		return x.DefaultPool
	}
	return nil
}

func (x *ExecutionConfig) GetPrivatePool() *PrivatePool {
	if x, ok := x.GetExecutionEnvironment().(*ExecutionConfig_PrivatePool); ok {
		return x.PrivatePool
	}
	return nil
}

func (x *ExecutionConfig) GetWorkerPool() string {
	if x != nil {
		return x.WorkerPool
	}
	return ""
}

func (x *ExecutionConfig) GetServiceAccount() string {
	if x != nil {
		return x.ServiceAccount
	}
	return ""
}

func (x *ExecutionConfig) GetArtifactStorage() string {
	if x != nil {
		return x.ArtifactStorage
	}
	return ""
}

func (x *ExecutionConfig) GetExecutionTimeout() *durationpb.Duration {
	if x != nil {
		return x.ExecutionTimeout
	}
	return nil
}

type isExecutionConfig_ExecutionEnvironment interface {
	isExecutionConfig_ExecutionEnvironment()
}

type ExecutionConfig_DefaultPool struct {
	// Optional. Use default Cloud Build pool.
	DefaultPool *DefaultPool `protobuf:"bytes,2,opt,name=default_pool,json=defaultPool,proto3,oneof"`
}

type ExecutionConfig_PrivatePool struct {
	// Optional. Use private Cloud Build pool.
	PrivatePool *PrivatePool `protobuf:"bytes,3,opt,name=private_pool,json=privatePool,proto3,oneof"`
}

func (*ExecutionConfig_DefaultPool) isExecutionConfig_ExecutionEnvironment() {}

func (*ExecutionConfig_PrivatePool) isExecutionConfig_ExecutionEnvironment() {}

// Execution using the default Cloud Build pool.
type DefaultPool struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Google service account to use for execution. If unspecified,
	// the project execution service account
	// (<PROJECT_NUMBER>-compute@developer.gserviceaccount.com) will be used.
	ServiceAccount string `protobuf:"bytes,1,opt,name=service_account,json=serviceAccount,proto3" json:"service_account,omitempty"`
	// Optional. Cloud Storage location where execution outputs should be stored. This can
	// either be a bucket ("gs://my-bucket") or a path within a bucket
	// ("gs://my-bucket/my-dir").
	// If unspecified, a default bucket located in the same region will be used.
	ArtifactStorage string `protobuf:"bytes,2,opt,name=artifact_storage,json=artifactStorage,proto3" json:"artifact_storage,omitempty"`
}

func (x *DefaultPool) Reset() {
	*x = DefaultPool{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DefaultPool) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DefaultPool) ProtoMessage() {}

func (x *DefaultPool) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DefaultPool.ProtoReflect.Descriptor instead.
func (*DefaultPool) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{16}
}

func (x *DefaultPool) GetServiceAccount() string {
	if x != nil {
		return x.ServiceAccount
	}
	return ""
}

func (x *DefaultPool) GetArtifactStorage() string {
	if x != nil {
		return x.ArtifactStorage
	}
	return ""
}

// Execution using a private Cloud Build pool.
type PrivatePool struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the Cloud Build worker pool to use. The format is
	// `projects/{project}/locations/{location}/workerPools/{pool}`.
	WorkerPool string `protobuf:"bytes,1,opt,name=worker_pool,json=workerPool,proto3" json:"worker_pool,omitempty"`
	// Optional. Google service account to use for execution. If unspecified,
	// the project execution service account
	// (<PROJECT_NUMBER>-compute@developer.gserviceaccount.com) will be used.
	ServiceAccount string `protobuf:"bytes,2,opt,name=service_account,json=serviceAccount,proto3" json:"service_account,omitempty"`
	// Optional. Cloud Storage location where execution outputs should be stored. This can
	// either be a bucket ("gs://my-bucket") or a path within a bucket
	// ("gs://my-bucket/my-dir").
	// If unspecified, a default bucket located in the same region will be used.
	ArtifactStorage string `protobuf:"bytes,3,opt,name=artifact_storage,json=artifactStorage,proto3" json:"artifact_storage,omitempty"`
}

func (x *PrivatePool) Reset() {
	*x = PrivatePool{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PrivatePool) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PrivatePool) ProtoMessage() {}

func (x *PrivatePool) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PrivatePool.ProtoReflect.Descriptor instead.
func (*PrivatePool) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{17}
}

func (x *PrivatePool) GetWorkerPool() string {
	if x != nil {
		return x.WorkerPool
	}
	return ""
}

func (x *PrivatePool) GetServiceAccount() string {
	if x != nil {
		return x.ServiceAccount
	}
	return ""
}

func (x *PrivatePool) GetArtifactStorage() string {
	if x != nil {
		return x.ArtifactStorage
	}
	return ""
}

// Information specifying a GKE Cluster.
type GkeCluster struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Information specifying a GKE Cluster. Format is
	// `projects/{project_id}/locations/{location_id}/clusters/{cluster_id}.
	Cluster string `protobuf:"bytes,1,opt,name=cluster,proto3" json:"cluster,omitempty"`
	// Optional. If true, `cluster` is accessed using the private IP address of the control
	// plane endpoint. Otherwise, the default IP address of the control plane
	// endpoint is used. The default IP address is the private IP address for
	// clusters with private control-plane endpoints and the public IP address
	// otherwise.
	//
	// Only specify this option when `cluster` is a [private GKE
	// cluster](https://cloud.google.com/kubernetes-engine/docs/concepts/private-cluster-concept).
	InternalIp bool `protobuf:"varint,2,opt,name=internal_ip,json=internalIp,proto3" json:"internal_ip,omitempty"`
}

func (x *GkeCluster) Reset() {
	*x = GkeCluster{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GkeCluster) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GkeCluster) ProtoMessage() {}

func (x *GkeCluster) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GkeCluster.ProtoReflect.Descriptor instead.
func (*GkeCluster) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{18}
}

func (x *GkeCluster) GetCluster() string {
	if x != nil {
		return x.Cluster
	}
	return ""
}

func (x *GkeCluster) GetInternalIp() bool {
	if x != nil {
		return x.InternalIp
	}
	return false
}

// Information specifying an Anthos Cluster.
type AnthosCluster struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Membership of the GKE Hub-registered cluster to which to apply the Skaffold
	// configuration. Format is
	// `projects/{project}/locations/{location}/memberships/{membership_name}`.
	Membership string `protobuf:"bytes,1,opt,name=membership,proto3" json:"membership,omitempty"`
}

func (x *AnthosCluster) Reset() {
	*x = AnthosCluster{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnthosCluster) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnthosCluster) ProtoMessage() {}

func (x *AnthosCluster) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnthosCluster.ProtoReflect.Descriptor instead.
func (*AnthosCluster) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{19}
}

func (x *AnthosCluster) GetMembership() string {
	if x != nil {
		return x.Membership
	}
	return ""
}

// Information specifying where to deploy a Cloud Run Service.
type CloudRunLocation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The location for the Cloud Run Service. Format must be
	// `projects/{project}/locations/{location}`.
	Location string `protobuf:"bytes,1,opt,name=location,proto3" json:"location,omitempty"`
}

func (x *CloudRunLocation) Reset() {
	*x = CloudRunLocation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CloudRunLocation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloudRunLocation) ProtoMessage() {}

func (x *CloudRunLocation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloudRunLocation.ProtoReflect.Descriptor instead.
func (*CloudRunLocation) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{20}
}

func (x *CloudRunLocation) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

// The request object for `ListTargets`.
type ListTargetsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent, which owns this collection of targets. Format must be
	// projects/{project_id}/locations/{location_name}.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of `Target` objects to return. The service may return
	// fewer than this value. If unspecified, at most 50 `Target` objects will be
	// returned. The maximum value is 1000; values above 1000 will be set to 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A page token, received from a previous `ListTargets` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other provided parameters match
	// the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Filter targets to be returned. See https://google.aip.dev/160 for more
	// details.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Field to sort by. See https://google.aip.dev/132#ordering for more details.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListTargetsRequest) Reset() {
	*x = ListTargetsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListTargetsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTargetsRequest) ProtoMessage() {}

func (x *ListTargetsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTargetsRequest.ProtoReflect.Descriptor instead.
func (*ListTargetsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{21}
}

func (x *ListTargetsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListTargetsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListTargetsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListTargetsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListTargetsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// The response object from `ListTargets`.
type ListTargetsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The `Target` objects.
	Targets []*Target `protobuf:"bytes,1,rep,name=targets,proto3" json:"targets,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListTargetsResponse) Reset() {
	*x = ListTargetsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListTargetsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTargetsResponse) ProtoMessage() {}

func (x *ListTargetsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTargetsResponse.ProtoReflect.Descriptor instead.
func (*ListTargetsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{22}
}

func (x *ListTargetsResponse) GetTargets() []*Target {
	if x != nil {
		return x.Targets
	}
	return nil
}

func (x *ListTargetsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListTargetsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// The request object for `GetTarget`.
type GetTargetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the `Target`. Format must be
	// projects/{project_id}/locations/{location_name}/targets/{target_name}.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetTargetRequest) Reset() {
	*x = GetTargetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetTargetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetTargetRequest) ProtoMessage() {}

func (x *GetTargetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetTargetRequest.ProtoReflect.Descriptor instead.
func (*GetTargetRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{23}
}

func (x *GetTargetRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request object for `CreateTarget`.
type CreateTargetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent collection in which the `Target` should be created.
	// Format should be
	// projects/{project_id}/locations/{location_name}.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. ID of the `Target`.
	TargetId string `protobuf:"bytes,2,opt,name=target_id,json=targetId,proto3" json:"target_id,omitempty"`
	// Required. The `Target` to create.
	Target *Target `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	// Optional. A request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server will know to ignore
	// the request if it has already been completed. The server will guarantee
	// that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and the
	// request times out. If you make the request again with the same request ID,
	// the server can check if original operation with the same request ID was
	// received, and if so, will ignore the second request. This prevents clients
	// from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Optional. If set to true, the request is validated and the user is provided with
	// an expected result, but no actual change is made.
	ValidateOnly bool `protobuf:"varint,5,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *CreateTargetRequest) Reset() {
	*x = CreateTargetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateTargetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateTargetRequest) ProtoMessage() {}

func (x *CreateTargetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateTargetRequest.ProtoReflect.Descriptor instead.
func (*CreateTargetRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{24}
}

func (x *CreateTargetRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateTargetRequest) GetTargetId() string {
	if x != nil {
		return x.TargetId
	}
	return ""
}

func (x *CreateTargetRequest) GetTarget() *Target {
	if x != nil {
		return x.Target
	}
	return nil
}

func (x *CreateTargetRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *CreateTargetRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// The request object for `UpdateTarget`.
type UpdateTargetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Field mask is used to specify the fields to be overwritten in the
	// Target resource by the update.
	// The fields specified in the update_mask are relative to the resource, not
	// the full request. A field will be overwritten if it is in the mask. If the
	// user does not provide a mask then all fields will be overwritten.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. The `Target` to update.
	Target *Target `protobuf:"bytes,2,opt,name=target,proto3" json:"target,omitempty"`
	// Optional. A request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server will know to ignore
	// the request if it has already been completed. The server will guarantee
	// that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and the
	// request times out. If you make the request again with the same request ID,
	// the server can check if original operation with the same request ID was
	// received, and if so, will ignore the second request. This prevents clients
	// from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Optional. If set to true, updating a `Target` that does not exist will
	// result in the creation of a new `Target`.
	AllowMissing bool `protobuf:"varint,4,opt,name=allow_missing,json=allowMissing,proto3" json:"allow_missing,omitempty"`
	// Optional. If set to true, the request is validated and the user is provided with
	// an expected result, but no actual change is made.
	ValidateOnly bool `protobuf:"varint,5,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *UpdateTargetRequest) Reset() {
	*x = UpdateTargetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateTargetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateTargetRequest) ProtoMessage() {}

func (x *UpdateTargetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateTargetRequest.ProtoReflect.Descriptor instead.
func (*UpdateTargetRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{25}
}

func (x *UpdateTargetRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateTargetRequest) GetTarget() *Target {
	if x != nil {
		return x.Target
	}
	return nil
}

func (x *UpdateTargetRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *UpdateTargetRequest) GetAllowMissing() bool {
	if x != nil {
		return x.AllowMissing
	}
	return false
}

func (x *UpdateTargetRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// The request object for `DeleteTarget`.
type DeleteTargetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the `Target` to delete. Format should be
	// projects/{project_id}/locations/{location_name}/targets/{target_name}.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. A request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server will know to ignore
	// the request if it has already been completed. The server will guarantee
	// that for at least 60 minutes after the first request.
	//
	// For example, consider a situation where you make an initial request and the
	// request times out. If you make the request again with the same request ID,
	// the server can check if original operation with the same request ID was
	// received, and if so, will ignore the second request. This prevents clients
	// from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Optional. If set to true, then deleting an already deleted or non-existing
	// DeliveryPipeline will succeed.
	AllowMissing bool `protobuf:"varint,3,opt,name=allow_missing,json=allowMissing,proto3" json:"allow_missing,omitempty"`
	// Optional. If set, validate the request and preview the review, but do not actually
	// post it.
	ValidateOnly bool `protobuf:"varint,4,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
	// Optional. This checksum is computed by the server based on the value of other
	// fields, and may be sent on update and delete requests to ensure the
	// client has an up-to-date value before proceeding.
	Etag string `protobuf:"bytes,5,opt,name=etag,proto3" json:"etag,omitempty"`
}

func (x *DeleteTargetRequest) Reset() {
	*x = DeleteTargetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteTargetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteTargetRequest) ProtoMessage() {}

func (x *DeleteTargetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteTargetRequest.ProtoReflect.Descriptor instead.
func (*DeleteTargetRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{26}
}

func (x *DeleteTargetRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteTargetRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *DeleteTargetRequest) GetAllowMissing() bool {
	if x != nil {
		return x.AllowMissing
	}
	return false
}

func (x *DeleteTargetRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

func (x *DeleteTargetRequest) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

// A `Release` resource in the Google Cloud Deploy API.
//
// A `Release` defines a specific Skaffold configuration instance
// that can be deployed.
type Release struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Name of the `Release`. Format is projects/{project}/
	// locations/{location}/deliveryPipelines/{deliveryPipeline}/
	// releases/[a-z][a-z0-9\-]{0,62}.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Unique identifier of the `Release`.
	Uid string `protobuf:"bytes,2,opt,name=uid,proto3" json:"uid,omitempty"`
	// Description of the `Release`. Max length is 255 characters.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// User annotations. These attributes can only be set and used by the
	// user, and not by Google Cloud Deploy. See
	// https://google.aip.dev/128#annotations for more details such as format and
	// size limitations.
	Annotations map[string]string `protobuf:"bytes,4,rep,name=annotations,proto3" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Labels are attributes that can be set and used by both the
	// user and by Google Cloud Deploy. Labels must meet the following
	// constraints:
	//
	// * Keys and values can contain only lowercase letters, numeric characters,
	// underscores, and dashes.
	// * All characters must use UTF-8 encoding, and international characters are
	// allowed.
	// * Keys must start with a lowercase letter or international character.
	// * Each resource is limited to a maximum of 64 labels.
	//
	// Both keys and values are additionally constrained to be <= 128 bytes.
	Labels map[string]string `protobuf:"bytes,5,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. Indicates whether this is an abandoned release.
	Abandoned bool `protobuf:"varint,23,opt,name=abandoned,proto3" json:"abandoned,omitempty"`
	// Output only. Time at which the `Release` was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Time at which the render began.
	RenderStartTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=render_start_time,json=renderStartTime,proto3" json:"render_start_time,omitempty"`
	// Output only. Time at which the render completed.
	RenderEndTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=render_end_time,json=renderEndTime,proto3" json:"render_end_time,omitempty"`
	// Cloud Storage URI of tar.gz archive containing Skaffold configuration.
	SkaffoldConfigUri string `protobuf:"bytes,17,opt,name=skaffold_config_uri,json=skaffoldConfigUri,proto3" json:"skaffold_config_uri,omitempty"`
	// Filepath of the Skaffold config inside of the config URI.
	SkaffoldConfigPath string `protobuf:"bytes,9,opt,name=skaffold_config_path,json=skaffoldConfigPath,proto3" json:"skaffold_config_path,omitempty"`
	// List of artifacts to pass through to Skaffold command.
	BuildArtifacts []*BuildArtifact `protobuf:"bytes,10,rep,name=build_artifacts,json=buildArtifacts,proto3" json:"build_artifacts,omitempty"`
	// Output only. Snapshot of the parent pipeline taken at release creation time.
	DeliveryPipelineSnapshot *DeliveryPipeline `protobuf:"bytes,11,opt,name=delivery_pipeline_snapshot,json=deliveryPipelineSnapshot,proto3" json:"delivery_pipeline_snapshot,omitempty"`
	// Output only. Snapshot of the targets taken at release creation time.
	TargetSnapshots []*Target `protobuf:"bytes,12,rep,name=target_snapshots,json=targetSnapshots,proto3" json:"target_snapshots,omitempty"`
	// Output only. Current state of the render operation.
	RenderState Release_RenderState `protobuf:"varint,13,opt,name=render_state,json=renderState,proto3,enum=google.cloud.deploy.v1.Release_RenderState" json:"render_state,omitempty"`
	// This checksum is computed by the server based on the value of other
	// fields, and may be sent on update and delete requests to ensure the
	// client has an up-to-date value before proceeding.
	Etag string `protobuf:"bytes,16,opt,name=etag,proto3" json:"etag,omitempty"`
	// The Skaffold version to use when operating on this release, such as
	// "1.20.0". Not all versions are valid; Google Cloud Deploy supports a
	// specific set of versions.
	//
	// If unset, the most recent supported Skaffold version will be used.
	SkaffoldVersion string `protobuf:"bytes,19,opt,name=skaffold_version,json=skaffoldVersion,proto3" json:"skaffold_version,omitempty"`
	// Output only. Map from target ID to the target artifacts created
	// during the render operation.
	TargetArtifacts map[string]*TargetArtifact `protobuf:"bytes,20,rep,name=target_artifacts,json=targetArtifacts,proto3" json:"target_artifacts,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. Map from target ID to details of the render operation for that target.
	TargetRenders map[string]*Release_TargetRender `protobuf:"bytes,22,rep,name=target_renders,json=targetRenders,proto3" json:"target_renders,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *Release) Reset() {
	*x = Release{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Release) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Release) ProtoMessage() {}

func (x *Release) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Release.ProtoReflect.Descriptor instead.
func (*Release) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{27}
}

func (x *Release) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Release) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

func (x *Release) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Release) GetAnnotations() map[string]string {
	if x != nil {
		return x.Annotations
	}
	return nil
}

func (x *Release) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Release) GetAbandoned() bool {
	if x != nil {
		return x.Abandoned
	}
	return false
}

func (x *Release) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Release) GetRenderStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.RenderStartTime
	}
	return nil
}

func (x *Release) GetRenderEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.RenderEndTime
	}
	return nil
}

func (x *Release) GetSkaffoldConfigUri() string {
	if x != nil {
		return x.SkaffoldConfigUri
	}
	return ""
}

func (x *Release) GetSkaffoldConfigPath() string {
	if x != nil {
		return x.SkaffoldConfigPath
	}
	return ""
}

func (x *Release) GetBuildArtifacts() []*BuildArtifact {
	if x != nil {
		return x.BuildArtifacts
	}
	return nil
}

func (x *Release) GetDeliveryPipelineSnapshot() *DeliveryPipeline {
	if x != nil {
		return x.DeliveryPipelineSnapshot
	}
	return nil
}

func (x *Release) GetTargetSnapshots() []*Target {
	if x != nil {
		return x.TargetSnapshots
	}
	return nil
}

func (x *Release) GetRenderState() Release_RenderState {
	if x != nil {
		return x.RenderState
	}
	return Release_RENDER_STATE_UNSPECIFIED
}

func (x *Release) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *Release) GetSkaffoldVersion() string {
	if x != nil {
		return x.SkaffoldVersion
	}
	return ""
}

func (x *Release) GetTargetArtifacts() map[string]*TargetArtifact {
	if x != nil {
		return x.TargetArtifacts
	}
	return nil
}

func (x *Release) GetTargetRenders() map[string]*Release_TargetRender {
	if x != nil {
		return x.TargetRenders
	}
	return nil
}

// Description of an a image to use during Skaffold rendering.
type BuildArtifact struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Image name in Skaffold configuration.
	Image string `protobuf:"bytes,3,opt,name=image,proto3" json:"image,omitempty"`
	// Image tag to use. This will generally be the full path to an image, such
	// as "gcr.io/my-project/busybox:1.2.3" or
	// "gcr.io/my-project/busybox@sha256:abc123".
	Tag string `protobuf:"bytes,2,opt,name=tag,proto3" json:"tag,omitempty"`
}

func (x *BuildArtifact) Reset() {
	*x = BuildArtifact{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BuildArtifact) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BuildArtifact) ProtoMessage() {}

func (x *BuildArtifact) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BuildArtifact.ProtoReflect.Descriptor instead.
func (*BuildArtifact) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{28}
}

func (x *BuildArtifact) GetImage() string {
	if x != nil {
		return x.Image
	}
	return ""
}

func (x *BuildArtifact) GetTag() string {
	if x != nil {
		return x.Tag
	}
	return ""
}

// The artifacts produced by a target render operation.
type TargetArtifact struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Uri:
	//
	//	*TargetArtifact_ArtifactUri
	Uri isTargetArtifact_Uri `protobuf_oneof:"uri"`
	// Output only. File path of the resolved Skaffold configuration relative to the URI.
	SkaffoldConfigPath string `protobuf:"bytes,2,opt,name=skaffold_config_path,json=skaffoldConfigPath,proto3" json:"skaffold_config_path,omitempty"`
	// Output only. File path of the rendered manifest relative to the URI.
	ManifestPath string `protobuf:"bytes,3,opt,name=manifest_path,json=manifestPath,proto3" json:"manifest_path,omitempty"`
}

func (x *TargetArtifact) Reset() {
	*x = TargetArtifact{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TargetArtifact) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TargetArtifact) ProtoMessage() {}

func (x *TargetArtifact) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TargetArtifact.ProtoReflect.Descriptor instead.
func (*TargetArtifact) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{29}
}

func (m *TargetArtifact) GetUri() isTargetArtifact_Uri {
	if m != nil {
		return m.Uri
	}
	return nil
}

func (x *TargetArtifact) GetArtifactUri() string {
	if x, ok := x.GetUri().(*TargetArtifact_ArtifactUri); ok {
		return x.ArtifactUri
	}
	return ""
}

func (x *TargetArtifact) GetSkaffoldConfigPath() string {
	if x != nil {
		return x.SkaffoldConfigPath
	}
	return ""
}

func (x *TargetArtifact) GetManifestPath() string {
	if x != nil {
		return x.ManifestPath
	}
	return ""
}

type isTargetArtifact_Uri interface {
	isTargetArtifact_Uri()
}

type TargetArtifact_ArtifactUri struct {
	// Output only. URI of a directory containing the artifacts. This contains
	// deployment configuration used by Skaffold during a rollout, and all
	// paths are relative to this location.
	ArtifactUri string `protobuf:"bytes,4,opt,name=artifact_uri,json=artifactUri,proto3,oneof"`
}

func (*TargetArtifact_ArtifactUri) isTargetArtifact_Uri() {}

// The request object for `ListReleases`.
type ListReleasesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The `DeliveryPipeline` which owns this collection of `Release` objects.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of `Release` objects to return. The service may return
	// fewer than this value. If unspecified, at most 50 `Release` objects will be
	// returned. The maximum value is 1000; values above 1000 will be set to 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A page token, received from a previous `ListReleases` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other provided parameters match
	// the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Filter releases to be returned. See https://google.aip.dev/160 for more
	// details.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Field to sort by. See https://google.aip.dev/132#ordering for more details.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListReleasesRequest) Reset() {
	*x = ListReleasesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListReleasesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListReleasesRequest) ProtoMessage() {}

func (x *ListReleasesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListReleasesRequest.ProtoReflect.Descriptor instead.
func (*ListReleasesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{30}
}

func (x *ListReleasesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListReleasesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListReleasesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListReleasesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListReleasesRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// The response object from `ListReleases`.
type ListReleasesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The `Release` objects.
	Releases []*Release `protobuf:"bytes,1,rep,name=releases,proto3" json:"releases,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListReleasesResponse) Reset() {
	*x = ListReleasesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListReleasesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListReleasesResponse) ProtoMessage() {}

func (x *ListReleasesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListReleasesResponse.ProtoReflect.Descriptor instead.
func (*ListReleasesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{31}
}

func (x *ListReleasesResponse) GetReleases() []*Release {
	if x != nil {
		return x.Releases
	}
	return nil
}

func (x *ListReleasesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListReleasesResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// The request object for `GetRelease`.
type GetReleaseRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the `Release`. Format must be
	// projects/{project_id}/locations/{location_name}/deliveryPipelines/{pipeline_name}/releases/{release_name}.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetReleaseRequest) Reset() {
	*x = GetReleaseRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetReleaseRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetReleaseRequest) ProtoMessage() {}

func (x *GetReleaseRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetReleaseRequest.ProtoReflect.Descriptor instead.
func (*GetReleaseRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{32}
}

func (x *GetReleaseRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request object for `CreateRelease`,
type CreateReleaseRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent collection in which the `Release` should be created.
	// Format should be
	// projects/{project_id}/locations/{location_name}/deliveryPipelines/{pipeline_name}.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. ID of the `Release`.
	ReleaseId string `protobuf:"bytes,2,opt,name=release_id,json=releaseId,proto3" json:"release_id,omitempty"`
	// Required. The `Release` to create.
	Release *Release `protobuf:"bytes,3,opt,name=release,proto3" json:"release,omitempty"`
	// Optional. A request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server will know to ignore
	// the request if it has already been completed. The server will guarantee
	// that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and the
	// request times out. If you make the request again with the same request ID,
	// the server can check if original operation with the same request ID was
	// received, and if so, will ignore the second request. This prevents clients
	// from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Optional. If set to true, the request is validated and the user is provided with
	// an expected result, but no actual change is made.
	ValidateOnly bool `protobuf:"varint,5,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *CreateReleaseRequest) Reset() {
	*x = CreateReleaseRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateReleaseRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateReleaseRequest) ProtoMessage() {}

func (x *CreateReleaseRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateReleaseRequest.ProtoReflect.Descriptor instead.
func (*CreateReleaseRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{33}
}

func (x *CreateReleaseRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateReleaseRequest) GetReleaseId() string {
	if x != nil {
		return x.ReleaseId
	}
	return ""
}

func (x *CreateReleaseRequest) GetRelease() *Release {
	if x != nil {
		return x.Release
	}
	return nil
}

func (x *CreateReleaseRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *CreateReleaseRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// A `Rollout` resource in the Google Cloud Deploy API.
//
// A `Rollout` contains information around a specific deployment to a `Target`.
type Rollout struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Name of the `Rollout`. Format is projects/{project}/
	// locations/{location}/deliveryPipelines/{deliveryPipeline}/
	// releases/{release}/rollouts/[a-z][a-z0-9\-]{0,62}.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Unique identifier of the `Rollout`.
	Uid string `protobuf:"bytes,2,opt,name=uid,proto3" json:"uid,omitempty"`
	// Description of the `Rollout` for user purposes. Max length is 255
	// characters.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// User annotations. These attributes can only be set and used by the
	// user, and not by Google Cloud Deploy. See
	// https://google.aip.dev/128#annotations for more details such as format and
	// size limitations.
	Annotations map[string]string `protobuf:"bytes,4,rep,name=annotations,proto3" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Labels are attributes that can be set and used by both the
	// user and by Google Cloud Deploy. Labels must meet the following
	// constraints:
	//
	// * Keys and values can contain only lowercase letters, numeric characters,
	// underscores, and dashes.
	// * All characters must use UTF-8 encoding, and international characters are
	// allowed.
	// * Keys must start with a lowercase letter or international character.
	// * Each resource is limited to a maximum of 64 labels.
	//
	// Both keys and values are additionally constrained to be <= 128 bytes.
	Labels map[string]string `protobuf:"bytes,5,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. Time at which the `Rollout` was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Time at which the `Rollout` was approved.
	ApproveTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=approve_time,json=approveTime,proto3" json:"approve_time,omitempty"`
	// Output only. Time at which the `Rollout` was enqueued.
	EnqueueTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=enqueue_time,json=enqueueTime,proto3" json:"enqueue_time,omitempty"`
	// Output only. Time at which the `Rollout` started deploying.
	DeployStartTime *timestamppb.Timestamp `protobuf:"bytes,9,opt,name=deploy_start_time,json=deployStartTime,proto3" json:"deploy_start_time,omitempty"`
	// Output only. Time at which the `Rollout` finished deploying.
	DeployEndTime *timestamppb.Timestamp `protobuf:"bytes,10,opt,name=deploy_end_time,json=deployEndTime,proto3" json:"deploy_end_time,omitempty"`
	// Required. The ID of Target to which this `Rollout` is deploying.
	TargetId string `protobuf:"bytes,18,opt,name=target_id,json=targetId,proto3" json:"target_id,omitempty"`
	// Output only. Approval state of the `Rollout`.
	ApprovalState Rollout_ApprovalState `protobuf:"varint,12,opt,name=approval_state,json=approvalState,proto3,enum=google.cloud.deploy.v1.Rollout_ApprovalState" json:"approval_state,omitempty"`
	// Output only. Current state of the `Rollout`.
	State Rollout_State `protobuf:"varint,13,opt,name=state,proto3,enum=google.cloud.deploy.v1.Rollout_State" json:"state,omitempty"`
	// Output only. Additional information about the rollout failure, if available.
	FailureReason string `protobuf:"bytes,14,opt,name=failure_reason,json=failureReason,proto3" json:"failure_reason,omitempty"`
	// Output only. The resource name of the Cloud Build `Build` object that is used to deploy
	// the Rollout. Format is
	// `projects/{project}/locations/{location}/builds/{build}`.
	DeployingBuild string `protobuf:"bytes,17,opt,name=deploying_build,json=deployingBuild,proto3" json:"deploying_build,omitempty"`
	// This checksum is computed by the server based on the value of other
	// fields, and may be sent on update and delete requests to ensure the
	// client has an up-to-date value before proceeding.
	Etag string `protobuf:"bytes,16,opt,name=etag,proto3" json:"etag,omitempty"`
	// Output only. The reason this rollout failed. This will always be unspecified while the
	// rollout is in progress.
	DeployFailureCause Rollout_FailureCause `protobuf:"varint,19,opt,name=deploy_failure_cause,json=deployFailureCause,proto3,enum=google.cloud.deploy.v1.Rollout_FailureCause" json:"deploy_failure_cause,omitempty"`
	// Output only. The phases that represent the workflows of this `Rollout`.
	Phases []*Phase `protobuf:"bytes,23,rep,name=phases,proto3" json:"phases,omitempty"`
	// Output only. Metadata contains information about the rollout.
	Metadata *Metadata `protobuf:"bytes,24,opt,name=metadata,proto3" json:"metadata,omitempty"`
}

func (x *Rollout) Reset() {
	*x = Rollout{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Rollout) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Rollout) ProtoMessage() {}

func (x *Rollout) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Rollout.ProtoReflect.Descriptor instead.
func (*Rollout) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{34}
}

func (x *Rollout) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Rollout) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

func (x *Rollout) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Rollout) GetAnnotations() map[string]string {
	if x != nil {
		return x.Annotations
	}
	return nil
}

func (x *Rollout) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Rollout) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Rollout) GetApproveTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ApproveTime
	}
	return nil
}

func (x *Rollout) GetEnqueueTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EnqueueTime
	}
	return nil
}

func (x *Rollout) GetDeployStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.DeployStartTime
	}
	return nil
}

func (x *Rollout) GetDeployEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.DeployEndTime
	}
	return nil
}

func (x *Rollout) GetTargetId() string {
	if x != nil {
		return x.TargetId
	}
	return ""
}

func (x *Rollout) GetApprovalState() Rollout_ApprovalState {
	if x != nil {
		return x.ApprovalState
	}
	return Rollout_APPROVAL_STATE_UNSPECIFIED
}

func (x *Rollout) GetState() Rollout_State {
	if x != nil {
		return x.State
	}
	return Rollout_STATE_UNSPECIFIED
}

func (x *Rollout) GetFailureReason() string {
	if x != nil {
		return x.FailureReason
	}
	return ""
}

func (x *Rollout) GetDeployingBuild() string {
	if x != nil {
		return x.DeployingBuild
	}
	return ""
}

func (x *Rollout) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *Rollout) GetDeployFailureCause() Rollout_FailureCause {
	if x != nil {
		return x.DeployFailureCause
	}
	return Rollout_FAILURE_CAUSE_UNSPECIFIED
}

func (x *Rollout) GetPhases() []*Phase {
	if x != nil {
		return x.Phases
	}
	return nil
}

func (x *Rollout) GetMetadata() *Metadata {
	if x != nil {
		return x.Metadata
	}
	return nil
}

// Metadata includes information associated with a `Rollout`.
type Metadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The name of the Cloud Run Service that is associated with a `Rollout`.
	CloudRun *CloudRunMetadata `protobuf:"bytes,1,opt,name=cloud_run,json=cloudRun,proto3" json:"cloud_run,omitempty"`
}

func (x *Metadata) Reset() {
	*x = Metadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Metadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Metadata) ProtoMessage() {}

func (x *Metadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Metadata.ProtoReflect.Descriptor instead.
func (*Metadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{35}
}

func (x *Metadata) GetCloudRun() *CloudRunMetadata {
	if x != nil {
		return x.CloudRun
	}
	return nil
}

// DeployJobRunMetadata surfaces information associated with a `DeployJobRun` to
// the user.
type DeployJobRunMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The name of the Cloud Run Service that is associated with a `DeployJobRun`.
	CloudRun *CloudRunMetadata `protobuf:"bytes,1,opt,name=cloud_run,json=cloudRun,proto3" json:"cloud_run,omitempty"`
}

func (x *DeployJobRunMetadata) Reset() {
	*x = DeployJobRunMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeployJobRunMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeployJobRunMetadata) ProtoMessage() {}

func (x *DeployJobRunMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeployJobRunMetadata.ProtoReflect.Descriptor instead.
func (*DeployJobRunMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{36}
}

func (x *DeployJobRunMetadata) GetCloudRun() *CloudRunMetadata {
	if x != nil {
		return x.CloudRun
	}
	return nil
}

// CloudRunMetadata contains information from a Cloud Run deployment.
type CloudRunMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The name of the Cloud Run Service that is associated with a `Rollout`.
	// Format is projects/{project}/locations/{location}/services/{service}.
	Service string `protobuf:"bytes,1,opt,name=service,proto3" json:"service,omitempty"`
	// Output only. The Cloud Run Service urls that are associated with a `Rollout`.
	ServiceUrls []string `protobuf:"bytes,2,rep,name=service_urls,json=serviceUrls,proto3" json:"service_urls,omitempty"`
	// Output only. The Cloud Run Revision id associated with a `Rollout`.
	Revision string `protobuf:"bytes,3,opt,name=revision,proto3" json:"revision,omitempty"`
}

func (x *CloudRunMetadata) Reset() {
	*x = CloudRunMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[37]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CloudRunMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloudRunMetadata) ProtoMessage() {}

func (x *CloudRunMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[37]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloudRunMetadata.ProtoReflect.Descriptor instead.
func (*CloudRunMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{37}
}

func (x *CloudRunMetadata) GetService() string {
	if x != nil {
		return x.Service
	}
	return ""
}

func (x *CloudRunMetadata) GetServiceUrls() []string {
	if x != nil {
		return x.ServiceUrls
	}
	return nil
}

func (x *CloudRunMetadata) GetRevision() string {
	if x != nil {
		return x.Revision
	}
	return ""
}

// Phase represents a collection of jobs that are logically grouped together
// for a `Rollout`.
type Phase struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The ID of the Phase.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Output only. Current state of the Phase.
	State Phase_State `protobuf:"varint,3,opt,name=state,proto3,enum=google.cloud.deploy.v1.Phase_State" json:"state,omitempty"`
	// The job composition of this Phase.
	//
	// Types that are assignable to Jobs:
	//
	//	*Phase_DeploymentJobs
	Jobs isPhase_Jobs `protobuf_oneof:"jobs"`
}

func (x *Phase) Reset() {
	*x = Phase{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[38]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Phase) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Phase) ProtoMessage() {}

func (x *Phase) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[38]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Phase.ProtoReflect.Descriptor instead.
func (*Phase) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{38}
}

func (x *Phase) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Phase) GetState() Phase_State {
	if x != nil {
		return x.State
	}
	return Phase_STATE_UNSPECIFIED
}

func (m *Phase) GetJobs() isPhase_Jobs {
	if m != nil {
		return m.Jobs
	}
	return nil
}

func (x *Phase) GetDeploymentJobs() *DeploymentJobs {
	if x, ok := x.GetJobs().(*Phase_DeploymentJobs); ok {
		return x.DeploymentJobs
	}
	return nil
}

type isPhase_Jobs interface {
	isPhase_Jobs()
}

type Phase_DeploymentJobs struct {
	// Output only. Deployment job composition.
	DeploymentJobs *DeploymentJobs `protobuf:"bytes,4,opt,name=deployment_jobs,json=deploymentJobs,proto3,oneof"`
}

func (*Phase_DeploymentJobs) isPhase_Jobs() {}

// Deployment job composition.
type DeploymentJobs struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The deploy Job. This is the first job run in the phase.
	DeployJob *Job `protobuf:"bytes,1,opt,name=deploy_job,json=deployJob,proto3" json:"deploy_job,omitempty"`
	// Output only. The verify Job. Runs after a deploy if the deploy succeeds.
	VerifyJob *Job `protobuf:"bytes,2,opt,name=verify_job,json=verifyJob,proto3" json:"verify_job,omitempty"`
}

func (x *DeploymentJobs) Reset() {
	*x = DeploymentJobs{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[39]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeploymentJobs) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeploymentJobs) ProtoMessage() {}

func (x *DeploymentJobs) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[39]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeploymentJobs.ProtoReflect.Descriptor instead.
func (*DeploymentJobs) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{39}
}

func (x *DeploymentJobs) GetDeployJob() *Job {
	if x != nil {
		return x.DeployJob
	}
	return nil
}

func (x *DeploymentJobs) GetVerifyJob() *Job {
	if x != nil {
		return x.VerifyJob
	}
	return nil
}

// Job represents an operation for a `Rollout`.
type Job struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The ID of the Job.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Output only. The current state of the Job.
	State Job_State `protobuf:"varint,2,opt,name=state,proto3,enum=google.cloud.deploy.v1.Job_State" json:"state,omitempty"`
	// Output only. The name of the `JobRun` responsible for the most recent invocation of this
	// Job.
	JobRun string `protobuf:"bytes,3,opt,name=job_run,json=jobRun,proto3" json:"job_run,omitempty"`
	// The type of Job.
	//
	// Types that are assignable to JobType:
	//
	//	*Job_DeployJob
	//	*Job_VerifyJob
	JobType isJob_JobType `protobuf_oneof:"job_type"`
}

func (x *Job) Reset() {
	*x = Job{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[40]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Job) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Job) ProtoMessage() {}

func (x *Job) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[40]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Job.ProtoReflect.Descriptor instead.
func (*Job) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{40}
}

func (x *Job) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Job) GetState() Job_State {
	if x != nil {
		return x.State
	}
	return Job_STATE_UNSPECIFIED
}

func (x *Job) GetJobRun() string {
	if x != nil {
		return x.JobRun
	}
	return ""
}

func (m *Job) GetJobType() isJob_JobType {
	if m != nil {
		return m.JobType
	}
	return nil
}

func (x *Job) GetDeployJob() *DeployJob {
	if x, ok := x.GetJobType().(*Job_DeployJob); ok {
		return x.DeployJob
	}
	return nil
}

func (x *Job) GetVerifyJob() *VerifyJob {
	if x, ok := x.GetJobType().(*Job_VerifyJob); ok {
		return x.VerifyJob
	}
	return nil
}

type isJob_JobType interface {
	isJob_JobType()
}

type Job_DeployJob struct {
	// Output only. A deploy Job.
	DeployJob *DeployJob `protobuf:"bytes,4,opt,name=deploy_job,json=deployJob,proto3,oneof"`
}

type Job_VerifyJob struct {
	// Output only. A verify Job.
	VerifyJob *VerifyJob `protobuf:"bytes,5,opt,name=verify_job,json=verifyJob,proto3,oneof"`
}

func (*Job_DeployJob) isJob_JobType() {}

func (*Job_VerifyJob) isJob_JobType() {}

// A deploy Job.
type DeployJob struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *DeployJob) Reset() {
	*x = DeployJob{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[41]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeployJob) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeployJob) ProtoMessage() {}

func (x *DeployJob) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[41]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeployJob.ProtoReflect.Descriptor instead.
func (*DeployJob) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{41}
}

// A verify Job.
type VerifyJob struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *VerifyJob) Reset() {
	*x = VerifyJob{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[42]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VerifyJob) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VerifyJob) ProtoMessage() {}

func (x *VerifyJob) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[42]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VerifyJob.ProtoReflect.Descriptor instead.
func (*VerifyJob) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{42}
}

// ListRolloutsRequest is the request object used by `ListRollouts`.
type ListRolloutsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The `Release` which owns this collection of `Rollout` objects.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of `Rollout` objects to return. The service may return
	// fewer than this value. If unspecified, at most 50 `Rollout` objects will be
	// returned. The maximum value is 1000; values above 1000 will be set to 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A page token, received from a previous `ListRollouts` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other provided parameters match
	// the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Filter rollouts to be returned. See https://google.aip.dev/160 for more
	// details.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Field to sort by. See https://google.aip.dev/132#ordering for more details.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListRolloutsRequest) Reset() {
	*x = ListRolloutsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[43]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListRolloutsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRolloutsRequest) ProtoMessage() {}

func (x *ListRolloutsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[43]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListRolloutsRequest.ProtoReflect.Descriptor instead.
func (*ListRolloutsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{43}
}

func (x *ListRolloutsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListRolloutsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListRolloutsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListRolloutsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListRolloutsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// ListRolloutsResponse is the response object reutrned by `ListRollouts`.
type ListRolloutsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The `Rollout` objects.
	Rollouts []*Rollout `protobuf:"bytes,1,rep,name=rollouts,proto3" json:"rollouts,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListRolloutsResponse) Reset() {
	*x = ListRolloutsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[44]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListRolloutsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRolloutsResponse) ProtoMessage() {}

func (x *ListRolloutsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[44]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListRolloutsResponse.ProtoReflect.Descriptor instead.
func (*ListRolloutsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{44}
}

func (x *ListRolloutsResponse) GetRollouts() []*Rollout {
	if x != nil {
		return x.Rollouts
	}
	return nil
}

func (x *ListRolloutsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListRolloutsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// GetRolloutRequest is the request object used by `GetRollout`.
type GetRolloutRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the `Rollout`. Format must be
	// projects/{project_id}/locations/{location_name}/deliveryPipelines/{pipeline_name}/releases/{release_name}/rollouts/{rollout_name}.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetRolloutRequest) Reset() {
	*x = GetRolloutRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[45]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetRolloutRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetRolloutRequest) ProtoMessage() {}

func (x *GetRolloutRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[45]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetRolloutRequest.ProtoReflect.Descriptor instead.
func (*GetRolloutRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{45}
}

func (x *GetRolloutRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// CreateRolloutRequest is the request object used by `CreateRollout`.
type CreateRolloutRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent collection in which the `Rollout` should be created.
	// Format should be
	// projects/{project_id}/locations/{location_name}/deliveryPipelines/{pipeline_name}/releases/{release_name}.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. ID of the `Rollout`.
	RolloutId string `protobuf:"bytes,2,opt,name=rollout_id,json=rolloutId,proto3" json:"rollout_id,omitempty"`
	// Required. The `Rollout` to create.
	Rollout *Rollout `protobuf:"bytes,3,opt,name=rollout,proto3" json:"rollout,omitempty"`
	// Optional. A request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server will know to ignore
	// the request if it has already been completed. The server will guarantee
	// that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and the
	// request times out. If you make the request again with the same request ID,
	// the server can check if original operation with the same request ID was
	// received, and if so, will ignore the second request. This prevents clients
	// from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Optional. If set to true, the request is validated and the user is provided with
	// an expected result, but no actual change is made.
	ValidateOnly bool `protobuf:"varint,5,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *CreateRolloutRequest) Reset() {
	*x = CreateRolloutRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[46]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateRolloutRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateRolloutRequest) ProtoMessage() {}

func (x *CreateRolloutRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[46]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateRolloutRequest.ProtoReflect.Descriptor instead.
func (*CreateRolloutRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{46}
}

func (x *CreateRolloutRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateRolloutRequest) GetRolloutId() string {
	if x != nil {
		return x.RolloutId
	}
	return ""
}

func (x *CreateRolloutRequest) GetRollout() *Rollout {
	if x != nil {
		return x.Rollout
	}
	return nil
}

func (x *CreateRolloutRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *CreateRolloutRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// Represents the metadata of the long-running operation.
type OperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The time the operation was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time the operation finished running.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Output only. Server-defined resource path for the target of the operation.
	Target string `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	// Output only. Name of the verb executed by the operation.
	Verb string `protobuf:"bytes,4,opt,name=verb,proto3" json:"verb,omitempty"`
	// Output only. Human-readable status of the operation, if any.
	StatusMessage string `protobuf:"bytes,5,opt,name=status_message,json=statusMessage,proto3" json:"status_message,omitempty"`
	// Output only. Identifies whether the user has requested cancellation
	// of the operation. Operations that have successfully been cancelled
	// have [Operation.error][] value with a [google.rpc.Status.code][google.rpc.Status.code] of 1,
	// corresponding to `Code.CANCELLED`.
	RequestedCancellation bool `protobuf:"varint,6,opt,name=requested_cancellation,json=requestedCancellation,proto3" json:"requested_cancellation,omitempty"`
	// Output only. API version used to start the operation.
	ApiVersion string `protobuf:"bytes,7,opt,name=api_version,json=apiVersion,proto3" json:"api_version,omitempty"`
}

func (x *OperationMetadata) Reset() {
	*x = OperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[47]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OperationMetadata) ProtoMessage() {}

func (x *OperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[47]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OperationMetadata.ProtoReflect.Descriptor instead.
func (*OperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{47}
}

func (x *OperationMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *OperationMetadata) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *OperationMetadata) GetTarget() string {
	if x != nil {
		return x.Target
	}
	return ""
}

func (x *OperationMetadata) GetVerb() string {
	if x != nil {
		return x.Verb
	}
	return ""
}

func (x *OperationMetadata) GetStatusMessage() string {
	if x != nil {
		return x.StatusMessage
	}
	return ""
}

func (x *OperationMetadata) GetRequestedCancellation() bool {
	if x != nil {
		return x.RequestedCancellation
	}
	return false
}

func (x *OperationMetadata) GetApiVersion() string {
	if x != nil {
		return x.ApiVersion
	}
	return ""
}

// The request object used by `ApproveRollout`.
type ApproveRolloutRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the Rollout. Format is
	// projects/{project}/locations/{location}/deliveryPipelines/{deliveryPipeline}/
	// releases/{release}/rollouts/{rollout}.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. True = approve; false = reject
	Approved bool `protobuf:"varint,2,opt,name=approved,proto3" json:"approved,omitempty"`
}

func (x *ApproveRolloutRequest) Reset() {
	*x = ApproveRolloutRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[48]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApproveRolloutRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApproveRolloutRequest) ProtoMessage() {}

func (x *ApproveRolloutRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[48]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApproveRolloutRequest.ProtoReflect.Descriptor instead.
func (*ApproveRolloutRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{48}
}

func (x *ApproveRolloutRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ApproveRolloutRequest) GetApproved() bool {
	if x != nil {
		return x.Approved
	}
	return false
}

// The response object from `ApproveRollout`.
type ApproveRolloutResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ApproveRolloutResponse) Reset() {
	*x = ApproveRolloutResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[49]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApproveRolloutResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApproveRolloutResponse) ProtoMessage() {}

func (x *ApproveRolloutResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[49]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApproveRolloutResponse.ProtoReflect.Descriptor instead.
func (*ApproveRolloutResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{49}
}

// RetryJobRequest is the request object used by `RetryJob`.
type RetryJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the Rollout. Format is
	// projects/{project}/locations/{location}/deliveryPipelines/{deliveryPipeline}/
	// releases/{release}/rollouts/{rollout}.
	Rollout string `protobuf:"bytes,1,opt,name=rollout,proto3" json:"rollout,omitempty"`
	// Required. The phase ID the Job to retry belongs to.
	PhaseId string `protobuf:"bytes,2,opt,name=phase_id,json=phaseId,proto3" json:"phase_id,omitempty"`
	// Required. The job ID for the Job to retry.
	JobId string `protobuf:"bytes,3,opt,name=job_id,json=jobId,proto3" json:"job_id,omitempty"`
}

func (x *RetryJobRequest) Reset() {
	*x = RetryJobRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[50]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RetryJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RetryJobRequest) ProtoMessage() {}

func (x *RetryJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[50]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RetryJobRequest.ProtoReflect.Descriptor instead.
func (*RetryJobRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{50}
}

func (x *RetryJobRequest) GetRollout() string {
	if x != nil {
		return x.Rollout
	}
	return ""
}

func (x *RetryJobRequest) GetPhaseId() string {
	if x != nil {
		return x.PhaseId
	}
	return ""
}

func (x *RetryJobRequest) GetJobId() string {
	if x != nil {
		return x.JobId
	}
	return ""
}

// The response object from 'RetryJob'.
type RetryJobResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *RetryJobResponse) Reset() {
	*x = RetryJobResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[51]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RetryJobResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RetryJobResponse) ProtoMessage() {}

func (x *RetryJobResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[51]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RetryJobResponse.ProtoReflect.Descriptor instead.
func (*RetryJobResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{51}
}

// The request object used by `AbandonRelease`.
type AbandonReleaseRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the Release. Format is
	// projects/{project}/locations/{location}/deliveryPipelines/{deliveryPipeline}/
	// releases/{release}.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *AbandonReleaseRequest) Reset() {
	*x = AbandonReleaseRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[52]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AbandonReleaseRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AbandonReleaseRequest) ProtoMessage() {}

func (x *AbandonReleaseRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[52]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AbandonReleaseRequest.ProtoReflect.Descriptor instead.
func (*AbandonReleaseRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{52}
}

func (x *AbandonReleaseRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The response object for `AbandonRelease`.
type AbandonReleaseResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *AbandonReleaseResponse) Reset() {
	*x = AbandonReleaseResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[53]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AbandonReleaseResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AbandonReleaseResponse) ProtoMessage() {}

func (x *AbandonReleaseResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[53]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AbandonReleaseResponse.ProtoReflect.Descriptor instead.
func (*AbandonReleaseResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{53}
}

// A `JobRun` resource in the Google Cloud Deploy API.
//
// A `JobRun` contains information of a single `Rollout` job evaluation.
type JobRun struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Name of the `JobRun`. Format is projects/{project}/locations/{location}/
	// deliveryPipelines/{deliveryPipeline}/releases/{releases}/rollouts/
	// {rollouts}/jobRuns/{uuid}.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Unique identifier of the `JobRun`.
	Uid string `protobuf:"bytes,2,opt,name=uid,proto3" json:"uid,omitempty"`
	// Output only. ID of the `Rollout` phase this `JobRun` belongs in.
	PhaseId string `protobuf:"bytes,3,opt,name=phase_id,json=phaseId,proto3" json:"phase_id,omitempty"`
	// Output only. ID of the `Rollout` job this `JobRun` corresponds to.
	JobId string `protobuf:"bytes,4,opt,name=job_id,json=jobId,proto3" json:"job_id,omitempty"`
	// Output only. Time at which the `JobRun` was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Time at which the `JobRun` was started.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Output only. Time at which the `JobRun` ended.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Output only. The current state of the `JobRun`.
	State JobRun_State `protobuf:"varint,8,opt,name=state,proto3,enum=google.cloud.deploy.v1.JobRun_State" json:"state,omitempty"`
	// The `JobRun` type and the information for that type.
	//
	// Types that are assignable to JobRun:
	//
	//	*JobRun_DeployJobRun
	//	*JobRun_VerifyJobRun
	JobRun isJobRun_JobRun `protobuf_oneof:"job_run"`
	// Output only. This checksum is computed by the server based on the value of other
	// fields, and may be sent on update and delete requests to ensure the
	// client has an up-to-date value before proceeding.
	Etag string `protobuf:"bytes,11,opt,name=etag,proto3" json:"etag,omitempty"`
}

func (x *JobRun) Reset() {
	*x = JobRun{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[54]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *JobRun) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JobRun) ProtoMessage() {}

func (x *JobRun) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[54]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JobRun.ProtoReflect.Descriptor instead.
func (*JobRun) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{54}
}

func (x *JobRun) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *JobRun) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

func (x *JobRun) GetPhaseId() string {
	if x != nil {
		return x.PhaseId
	}
	return ""
}

func (x *JobRun) GetJobId() string {
	if x != nil {
		return x.JobId
	}
	return ""
}

func (x *JobRun) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *JobRun) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *JobRun) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *JobRun) GetState() JobRun_State {
	if x != nil {
		return x.State
	}
	return JobRun_STATE_UNSPECIFIED
}

func (m *JobRun) GetJobRun() isJobRun_JobRun {
	if m != nil {
		return m.JobRun
	}
	return nil
}

func (x *JobRun) GetDeployJobRun() *DeployJobRun {
	if x, ok := x.GetJobRun().(*JobRun_DeployJobRun); ok {
		return x.DeployJobRun
	}
	return nil
}

func (x *JobRun) GetVerifyJobRun() *VerifyJobRun {
	if x, ok := x.GetJobRun().(*JobRun_VerifyJobRun); ok {
		return x.VerifyJobRun
	}
	return nil
}

func (x *JobRun) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

type isJobRun_JobRun interface {
	isJobRun_JobRun()
}

type JobRun_DeployJobRun struct {
	// Output only. Information specific to a deploy `JobRun`.
	DeployJobRun *DeployJobRun `protobuf:"bytes,9,opt,name=deploy_job_run,json=deployJobRun,proto3,oneof"`
}

type JobRun_VerifyJobRun struct {
	// Output only. Information specific to a verify `JobRun`.
	VerifyJobRun *VerifyJobRun `protobuf:"bytes,10,opt,name=verify_job_run,json=verifyJobRun,proto3,oneof"`
}

func (*JobRun_DeployJobRun) isJobRun_JobRun() {}

func (*JobRun_VerifyJobRun) isJobRun_JobRun() {}

// DeployJobRun contains information specific to a deploy `JobRun`.
type DeployJobRun struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name of the Cloud Build `Build` object that is used to deploy.
	// Format is projects/{project}/locations/{location}/builds/{build}.
	Build string `protobuf:"bytes,1,opt,name=build,proto3" json:"build,omitempty"`
	// Output only. The reason the deploy failed. This will always be unspecified while the
	// deploy is in progress or if it succeeded.
	FailureCause DeployJobRun_FailureCause `protobuf:"varint,2,opt,name=failure_cause,json=failureCause,proto3,enum=google.cloud.deploy.v1.DeployJobRun_FailureCause" json:"failure_cause,omitempty"`
	// Output only. Additional information about the deploy failure, if available.
	FailureMessage string `protobuf:"bytes,3,opt,name=failure_message,json=failureMessage,proto3" json:"failure_message,omitempty"`
	// Output only. Metadata containing information about the deploy job run.
	Metadata *DeployJobRunMetadata `protobuf:"bytes,4,opt,name=metadata,proto3" json:"metadata,omitempty"`
}

func (x *DeployJobRun) Reset() {
	*x = DeployJobRun{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[55]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeployJobRun) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeployJobRun) ProtoMessage() {}

func (x *DeployJobRun) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[55]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeployJobRun.ProtoReflect.Descriptor instead.
func (*DeployJobRun) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{55}
}

func (x *DeployJobRun) GetBuild() string {
	if x != nil {
		return x.Build
	}
	return ""
}

func (x *DeployJobRun) GetFailureCause() DeployJobRun_FailureCause {
	if x != nil {
		return x.FailureCause
	}
	return DeployJobRun_FAILURE_CAUSE_UNSPECIFIED
}

func (x *DeployJobRun) GetFailureMessage() string {
	if x != nil {
		return x.FailureMessage
	}
	return ""
}

func (x *DeployJobRun) GetMetadata() *DeployJobRunMetadata {
	if x != nil {
		return x.Metadata
	}
	return nil
}

// VerifyJobRun contains information specific to a verify `JobRun`.
type VerifyJobRun struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name of the Cloud Build `Build` object that is used to verify.
	// Format is projects/{project}/locations/{location}/builds/{build}.
	Build string `protobuf:"bytes,1,opt,name=build,proto3" json:"build,omitempty"`
	// Output only. URI of a directory containing the verify artifacts. This contains the
	// Skaffold event log.
	ArtifactUri string `protobuf:"bytes,2,opt,name=artifact_uri,json=artifactUri,proto3" json:"artifact_uri,omitempty"`
	// Output only. File path of the Skaffold event log relative to the artifact URI.
	EventLogPath string `protobuf:"bytes,3,opt,name=event_log_path,json=eventLogPath,proto3" json:"event_log_path,omitempty"`
	// Output only. The reason the verify failed. This will always be unspecified while the
	// verify is in progress or if it succeeded.
	FailureCause VerifyJobRun_FailureCause `protobuf:"varint,4,opt,name=failure_cause,json=failureCause,proto3,enum=google.cloud.deploy.v1.VerifyJobRun_FailureCause" json:"failure_cause,omitempty"`
	// Output only. Additional information about the verify failure, if available.
	FailureMessage string `protobuf:"bytes,5,opt,name=failure_message,json=failureMessage,proto3" json:"failure_message,omitempty"`
}

func (x *VerifyJobRun) Reset() {
	*x = VerifyJobRun{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[56]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VerifyJobRun) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VerifyJobRun) ProtoMessage() {}

func (x *VerifyJobRun) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[56]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VerifyJobRun.ProtoReflect.Descriptor instead.
func (*VerifyJobRun) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{56}
}

func (x *VerifyJobRun) GetBuild() string {
	if x != nil {
		return x.Build
	}
	return ""
}

func (x *VerifyJobRun) GetArtifactUri() string {
	if x != nil {
		return x.ArtifactUri
	}
	return ""
}

func (x *VerifyJobRun) GetEventLogPath() string {
	if x != nil {
		return x.EventLogPath
	}
	return ""
}

func (x *VerifyJobRun) GetFailureCause() VerifyJobRun_FailureCause {
	if x != nil {
		return x.FailureCause
	}
	return VerifyJobRun_FAILURE_CAUSE_UNSPECIFIED
}

func (x *VerifyJobRun) GetFailureMessage() string {
	if x != nil {
		return x.FailureMessage
	}
	return ""
}

// ListJobRunsRequest is the request object used by `ListJobRuns`.
type ListJobRunsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The `Rollout` which owns this collection of `JobRun` objects.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of `JobRun` objects to return. The service may return
	// fewer than this value. If unspecified, at most 50 `JobRun` objects will be
	// returned. The maximum value is 1000; values above 1000 will be set to 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A page token, received from a previous `ListJobRuns` call. Provide this
	// to retrieve the subsequent page.
	//
	// When paginating, all other provided parameters match the call that provided
	// the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Filter results to be returned. See https://google.aip.dev/160 for more
	// details.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Field to sort by. See https://google.aip.dev/132#ordering for more details.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListJobRunsRequest) Reset() {
	*x = ListJobRunsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[57]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListJobRunsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListJobRunsRequest) ProtoMessage() {}

func (x *ListJobRunsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[57]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListJobRunsRequest.ProtoReflect.Descriptor instead.
func (*ListJobRunsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{57}
}

func (x *ListJobRunsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListJobRunsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListJobRunsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListJobRunsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListJobRunsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// ListJobRunsResponse is the response object returned by `ListJobRuns`.
type ListJobRunsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The `JobRun` objects.
	JobRuns []*JobRun `protobuf:"bytes,1,rep,name=job_runs,json=jobRuns,proto3" json:"job_runs,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page. If
	// this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListJobRunsResponse) Reset() {
	*x = ListJobRunsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[58]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListJobRunsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListJobRunsResponse) ProtoMessage() {}

func (x *ListJobRunsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[58]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListJobRunsResponse.ProtoReflect.Descriptor instead.
func (*ListJobRunsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{58}
}

func (x *ListJobRunsResponse) GetJobRuns() []*JobRun {
	if x != nil {
		return x.JobRuns
	}
	return nil
}

func (x *ListJobRunsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListJobRunsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// GetJobRunRequest is the request object used by `GetJobRun`.
type GetJobRunRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the `JobRun`. Format must be
	// projects/{project_id}/locations/{location_name}/deliveryPipelines/{pipeline_name}/releases/{release_name}/rollouts/{rollout_name}/jobRuns/{job_run_name}.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetJobRunRequest) Reset() {
	*x = GetJobRunRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[59]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetJobRunRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetJobRunRequest) ProtoMessage() {}

func (x *GetJobRunRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[59]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetJobRunRequest.ProtoReflect.Descriptor instead.
func (*GetJobRunRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{59}
}

func (x *GetJobRunRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Service-wide configuration.
type Config struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the configuration.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. All supported versions of Skaffold.
	SupportedVersions []*SkaffoldVersion `protobuf:"bytes,2,rep,name=supported_versions,json=supportedVersions,proto3" json:"supported_versions,omitempty"`
	// Output only. Default Skaffold version that is assigned when a Release is created without
	// specifying a Skaffold version.
	DefaultSkaffoldVersion string `protobuf:"bytes,3,opt,name=default_skaffold_version,json=defaultSkaffoldVersion,proto3" json:"default_skaffold_version,omitempty"`
}

func (x *Config) Reset() {
	*x = Config{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[60]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Config) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Config) ProtoMessage() {}

func (x *Config) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[60]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Config.ProtoReflect.Descriptor instead.
func (*Config) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{60}
}

func (x *Config) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Config) GetSupportedVersions() []*SkaffoldVersion {
	if x != nil {
		return x.SupportedVersions
	}
	return nil
}

func (x *Config) GetDefaultSkaffoldVersion() string {
	if x != nil {
		return x.DefaultSkaffoldVersion
	}
	return ""
}

// Details of a supported Skaffold version.
type SkaffoldVersion struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Release version number. For example, "1.20.3".
	Version string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	// Date when this version is expected to no longer be supported.
	SupportEndDate *date.Date `protobuf:"bytes,2,opt,name=support_end_date,json=supportEndDate,proto3" json:"support_end_date,omitempty"`
}

func (x *SkaffoldVersion) Reset() {
	*x = SkaffoldVersion{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[61]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SkaffoldVersion) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SkaffoldVersion) ProtoMessage() {}

func (x *SkaffoldVersion) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[61]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SkaffoldVersion.ProtoReflect.Descriptor instead.
func (*SkaffoldVersion) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{61}
}

func (x *SkaffoldVersion) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *SkaffoldVersion) GetSupportEndDate() *date.Date {
	if x != nil {
		return x.SupportEndDate
	}
	return nil
}

// Request to get a configuration.
type GetConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of requested configuration.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetConfigRequest) Reset() {
	*x = GetConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[62]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetConfigRequest) ProtoMessage() {}

func (x *GetConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[62]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetConfigRequest.ProtoReflect.Descriptor instead.
func (*GetConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{62}
}

func (x *GetConfigRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Details of rendering for a single target.
type Release_TargetRender struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name of the Cloud Build `Build` object that is used to
	// render the manifest for this target. Format is
	// `projects/{project}/locations/{location}/builds/{build}`.
	RenderingBuild string `protobuf:"bytes,1,opt,name=rendering_build,json=renderingBuild,proto3" json:"rendering_build,omitempty"`
	// Output only. Current state of the render operation for this Target.
	RenderingState Release_TargetRender_TargetRenderState `protobuf:"varint,2,opt,name=rendering_state,json=renderingState,proto3,enum=google.cloud.deploy.v1.Release_TargetRender_TargetRenderState" json:"rendering_state,omitempty"`
	// Output only. Reason this render failed. This will always be unspecified while the
	// render in progress.
	FailureCause Release_TargetRender_FailureCause `protobuf:"varint,4,opt,name=failure_cause,json=failureCause,proto3,enum=google.cloud.deploy.v1.Release_TargetRender_FailureCause" json:"failure_cause,omitempty"`
	// Output only. Additional information about the render failure, if available.
	FailureMessage string `protobuf:"bytes,5,opt,name=failure_message,json=failureMessage,proto3" json:"failure_message,omitempty"`
}

func (x *Release_TargetRender) Reset() {
	*x = Release_TargetRender{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[67]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Release_TargetRender) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Release_TargetRender) ProtoMessage() {}

func (x *Release_TargetRender) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[67]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Release_TargetRender.ProtoReflect.Descriptor instead.
func (*Release_TargetRender) Descriptor() ([]byte, []int) {
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP(), []int{27, 0}
}

func (x *Release_TargetRender) GetRenderingBuild() string {
	if x != nil {
		return x.RenderingBuild
	}
	return ""
}

func (x *Release_TargetRender) GetRenderingState() Release_TargetRender_TargetRenderState {
	if x != nil {
		return x.RenderingState
	}
	return Release_TargetRender_TARGET_RENDER_STATE_UNSPECIFIED
}

func (x *Release_TargetRender) GetFailureCause() Release_TargetRender_FailureCause {
	if x != nil {
		return x.FailureCause
	}
	return Release_TargetRender_FAILURE_CAUSE_UNSPECIFIED
}

func (x *Release_TargetRender) GetFailureMessage() string {
	if x != nil {
		return x.FailureMessage
	}
	return ""
}

var File_google_cloud_deploy_v1_cloud_deploy_proto protoreflect.FileDescriptor

var file_google_cloud_deploy_v1_cloud_deploy_proto_rawDesc = []byte{
	0x0a, 0x29, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x64,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x16, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79,
	0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c,
	0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68,
	0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c,
	0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x16,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x64, 0x61, 0x74, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xee, 0x06, 0x0a, 0x10, 0x44, 0x65, 0x6c, 0x69, 0x76,
	0x65, 0x72, 0x79, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x15, 0x0a, 0x03, 0x75, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x03, 0x75, 0x69, 0x64, 0x12, 0x20, 0x0a, 0x0b, 0x64,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5b, 0x0a,
	0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x69,
	0x76, 0x65, 0x72, 0x79, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x41, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0b, 0x61,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x4c, 0x0a, 0x06, 0x6c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79,
	0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x50, 0x69, 0x70, 0x65,
	0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x51, 0x0a, 0x0f,
	0x73, 0x65, 0x72, 0x69, 0x61, 0x6c, 0x5f, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x65, 0x72, 0x69, 0x61, 0x6c, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x48, 0x00, 0x52,
	0x0e, 0x73, 0x65, 0x72, 0x69, 0x61, 0x6c, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x12,
	0x4c, 0x0a, 0x09, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0b, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x69, 0x70, 0x65,
	0x6c, 0x69, 0x6e, 0x65, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x09, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a,
	0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x65, 0x74, 0x61,
	0x67, 0x12, 0x1c, 0x0a, 0x09, 0x73, 0x75, 0x73, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x64, 0x18, 0x0c,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x73, 0x75, 0x73, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x64, 0x1a,
	0x3e, 0x0a, 0x10, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a,
	0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10,
	0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79,
	0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0x7f, 0xea, 0x41, 0x7c, 0x0a,
	0x2b, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x65, 0x6c, 0x69,
	0x76, 0x65, 0x72, 0x79, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x12, 0x4d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x50, 0x69,
	0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x2f, 0x7b, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72,
	0x79, 0x5f, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x7d, 0x42, 0x0a, 0x0a, 0x08, 0x70,
	0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x22, 0x47, 0x0a, 0x0e, 0x53, 0x65, 0x72, 0x69, 0x61,
	0x6c, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x12, 0x35, 0x0a, 0x06, 0x73, 0x74, 0x61,
	0x67, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e,
	0x76, 0x31, 0x2e, 0x53, 0x74, 0x61, 0x67, 0x65, 0x52, 0x06, 0x73, 0x74, 0x61, 0x67, 0x65, 0x73,
	0x22, 0x83, 0x01, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x67, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x74, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x74,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x49, 0x64, 0x12, 0x1a, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x66, 0x69,
	0x6c, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x66, 0x69,
	0x6c, 0x65, 0x73, 0x12, 0x41, 0x0a, 0x08, 0x73, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x73, 0x74,
	0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x22, 0x61, 0x0a, 0x08, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65,
	0x67, 0x79, 0x12, 0x3e, 0x0a, 0x08, 0x73, 0x74, 0x61, 0x6e, 0x64, 0x61, 0x72, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74,
	0x61, 0x6e, 0x64, 0x61, 0x72, 0x64, 0x48, 0x00, 0x52, 0x08, 0x73, 0x74, 0x61, 0x6e, 0x64, 0x61,
	0x72, 0x64, 0x42, 0x15, 0x0a, 0x13, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74,
	0x5f, 0x73, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x22, 0x22, 0x0a, 0x08, 0x53, 0x74, 0x61,
	0x6e, 0x64, 0x61, 0x72, 0x64, 0x12, 0x16, 0x0a, 0x06, 0x76, 0x65, 0x72, 0x69, 0x66, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x06, 0x76, 0x65, 0x72, 0x69, 0x66, 0x79, 0x22, 0x6d, 0x0a,
	0x16, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x52, 0x65, 0x61, 0x64, 0x79, 0x43, 0x6f,
	0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12,
	0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x22, 0xbf, 0x01, 0x0a,
	0x17, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x50, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x74, 0x43,
	0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x12, 0x4f, 0x0a, 0x0f, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x5f, 0x74, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x42, 0x26, 0xfa, 0x41, 0x23, 0x0a, 0x21,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x52, 0x0e, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x73, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x22, 0xea,
	0x01, 0x0a, 0x11, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x43, 0x6f, 0x6e, 0x64, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x68, 0x0a, 0x18, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65,
	0x5f, 0x72, 0x65, 0x61, 0x64, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e,
	0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x52, 0x65, 0x61, 0x64, 0x79, 0x43, 0x6f, 0x6e,
	0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x16, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65,
	0x52, 0x65, 0x61, 0x64, 0x79, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x6b,
	0x0a, 0x19, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x5f, 0x70, 0x72, 0x65, 0x73, 0x65, 0x6e,
	0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x73, 0x50, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x17, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x50, 0x72, 0x65, 0x73, 0x65,
	0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xda, 0x01, 0x0a, 0x1c,
	0x4c, 0x69, 0x73, 0x74, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x50, 0x69, 0x70, 0x65,
	0x6c, 0x69, 0x6e, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x2d, 0x12, 0x2b, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e,
	0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61,
	0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x19, 0x0a,
	0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0xc2, 0x01, 0x0a, 0x1d, 0x4c, 0x69, 0x73,
	0x74, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e,
	0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x57, 0x0a, 0x12, 0x64, 0x65,
	0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x5f, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e,
	0x44, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65,
	0x52, 0x11, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69,
	0x6e, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65,
	0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75,
	0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09,
	0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x65, 0x0a,
	0x1a, 0x47, 0x65, 0x74, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x50, 0x69, 0x70, 0x65,
	0x6c, 0x69, 0x6e, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x2d, 0x0a, 0x2b, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x65,
	0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x22, 0xcd, 0x02, 0x0a, 0x1d, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44,
	0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x12, 0x2b,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x65, 0x6c, 0x69, 0x76,
	0x65, 0x72, 0x79, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0x35, 0x0a, 0x14, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x5f,
	0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x12, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79,
	0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x49, 0x64, 0x12, 0x5a, 0x0a, 0x11, 0x64, 0x65,
	0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x5f, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x44,
	0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x10, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x50, 0x69,
	0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x28, 0x0a, 0x0d, 0x76, 0x61,
	0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65,
	0x4f, 0x6e, 0x6c, 0x79, 0x22, 0xb5, 0x02, 0x0a, 0x1d, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x44,
	0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69,
	0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x5a, 0x0a, 0x11, 0x64, 0x65, 0x6c, 0x69,
	0x76, 0x65, 0x72, 0x79, 0x5f, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c,
	0x69, 0x76, 0x65, 0x72, 0x79, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x10, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x50, 0x69, 0x70, 0x65,
	0x6c, 0x69, 0x6e, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f,
	0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x28, 0x0a, 0x0d, 0x61, 0x6c, 0x6c, 0x6f,
	0x77, 0x5f, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x4d, 0x69, 0x73, 0x73, 0x69,
	0x6e, 0x67, 0x12, 0x28, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f,
	0x6e, 0x6c, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c,
	0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x22, 0x94, 0x02, 0x0a,
	0x1d, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x50,
	0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e,
	0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x28, 0x0a, 0x0d, 0x61,
	0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x4d, 0x69,
	0x73, 0x73, 0x69, 0x6e, 0x67, 0x12, 0x28, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x12,
	0x19, 0x0a, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x65, 0x74,
	0x61, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x65,
	0x74, 0x61, 0x67, 0x22, 0xfd, 0x07, 0x0a, 0x06, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x17,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x09, 0x74, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x08, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x49, 0x64, 0x12, 0x15, 0x0a, 0x03, 0x75, 0x69, 0x64,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x03, 0x75, 0x69, 0x64,
	0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x56, 0x0a, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c,
	0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x2e, 0x41, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12,
	0x47, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x2e,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x2e, 0x0a, 0x10, 0x72, 0x65, 0x71, 0x75,
	0x69, 0x72, 0x65, 0x5f, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c, 0x18, 0x0d, 0x20, 0x01,
	0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65,
	0x41, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x36, 0x0a, 0x03,
	0x67, 0x6b, 0x65, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e,
	0x76, 0x31, 0x2e, 0x47, 0x6b, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x48, 0x00, 0x52,
	0x03, 0x67, 0x6b, 0x65, 0x12, 0x4e, 0x0a, 0x0e, 0x61, 0x6e, 0x74, 0x68, 0x6f, 0x73, 0x5f, 0x63,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c,
	0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x74, 0x68, 0x6f, 0x73, 0x43, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x48, 0x00, 0x52, 0x0d, 0x61, 0x6e, 0x74, 0x68, 0x6f, 0x73, 0x43, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x12, 0x3c, 0x0a, 0x03, 0x72, 0x75, 0x6e, 0x18, 0x12, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x52, 0x75, 0x6e, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x03, 0x72,
	0x75, 0x6e, 0x12, 0x17, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x12, 0x54, 0x0a, 0x11, 0x65,
	0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73,
	0x18, 0x10, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e,
	0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52,
	0x10, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x73, 0x1a, 0x3e, 0x0a, 0x10, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38,
	0x01, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b,
	0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0x60, 0xea, 0x41,
	0x5d, 0x0a, 0x21, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x12, 0x38, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x74, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x73, 0x2f, 0x7b, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x7d, 0x42, 0x13,
	0x0a, 0x11, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x22, 0x90, 0x05, 0x0a, 0x0f, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x5e, 0x0a, 0x06, 0x75, 0x73, 0x61, 0x67, 0x65,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31,
	0x2e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f,
	0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x55, 0x73, 0x61, 0x67, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x06, 0x75, 0x73, 0x61, 0x67, 0x65, 0x73, 0x12, 0x4d, 0x0a, 0x0c, 0x64, 0x65, 0x66, 0x61, 0x75,
	0x6c, 0x74, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70,
	0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x50, 0x6f,
	0x6f, 0x6c, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x0b, 0x64, 0x65, 0x66, 0x61, 0x75,
	0x6c, 0x74, 0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x4d, 0x0a, 0x0c, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74,
	0x65, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c,
	0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x50, 0x6f, 0x6f,
	0x6c, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x0b, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74,
	0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x4d, 0x0a, 0x0b, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x5f,
	0x70, 0x6f, 0x6f, 0x6c, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x01, 0xfa,
	0x41, 0x26, 0x0a, 0x24, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x57, 0x6f,
	0x72, 0x6b, 0x65, 0x72, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x0a, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72,
	0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x2c, 0x0a, 0x0f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f,
	0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x12, 0x2e, 0x0a, 0x10, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x5f, 0x73,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0f, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x53, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x12, 0x4b, 0x0a, 0x11, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x65,
	0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x22,
	0x6c, 0x0a, 0x19, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x6e, 0x76, 0x69,
	0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x55, 0x73, 0x61, 0x67, 0x65, 0x12, 0x2b, 0x0a, 0x27,
	0x45, 0x58, 0x45, 0x43, 0x55, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x45, 0x4e, 0x56, 0x49, 0x52, 0x4f,
	0x4e, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x55, 0x53, 0x41, 0x47, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x52, 0x45, 0x4e,
	0x44, 0x45, 0x52, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x44, 0x45, 0x50, 0x4c, 0x4f, 0x59, 0x10,
	0x02, 0x12, 0x0a, 0x0a, 0x06, 0x56, 0x45, 0x52, 0x49, 0x46, 0x59, 0x10, 0x03, 0x42, 0x17, 0x0a,
	0x15, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x6e, 0x76, 0x69, 0x72,
	0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0x6b, 0x0a, 0x0b, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c,
	0x74, 0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x2c, 0x0a, 0x0f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x0e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x12, 0x2e, 0x0a, 0x10, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x5f,
	0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0f, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x53, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x22, 0xba, 0x01, 0x0a, 0x0b, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x50,
	0x6f, 0x6f, 0x6c, 0x12, 0x4d, 0x0a, 0x0b, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x5f, 0x70, 0x6f,
	0x6f, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26,
	0x0a, 0x24, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x57, 0x6f, 0x72, 0x6b,
	0x65, 0x72, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x0a, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x50, 0x6f,
	0x6f, 0x6c, 0x12, 0x2c, 0x0a, 0x0f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x12, 0x2e, 0x0a, 0x10, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x5f, 0x73, 0x74, 0x6f,
	0x72, 0x61, 0x67, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0f, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x22, 0x73, 0x0a, 0x0a, 0x47, 0x6b, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x3f,
	0x0a, 0x07, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x25, 0xfa, 0x41, 0x22, 0x0a, 0x20, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x07, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12,
	0x24, 0x0a, 0x0b, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x69, 0x70, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x69, 0x6e, 0x74, 0x65, 0x72,
	0x6e, 0x61, 0x6c, 0x49, 0x70, 0x22, 0x56, 0x0a, 0x0d, 0x41, 0x6e, 0x74, 0x68, 0x6f, 0x73, 0x43,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x45, 0x0a, 0x0a, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72,
	0x73, 0x68, 0x69, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x25, 0xfa, 0x41, 0x22, 0x0a,
	0x20, 0x67, 0x6b, 0x65, 0x68, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69,
	0x70, 0x52, 0x0a, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x22, 0x59, 0x0a,
	0x10, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x52, 0x75, 0x6e, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x45, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x08,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xda, 0x01, 0x0a, 0x12, 0x4c, 0x69, 0x73,
	0x74, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x12, 0x21, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x65,
	0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65,
	0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1e, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62,
	0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x6f, 0x72,
	0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0x99, 0x01, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x38, 0x0a,
	0x07, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65,
	0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x07,
	0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12,
	0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03,
	0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c,
	0x65, 0x22, 0x51, 0x0a, 0x10, 0x47, 0x65, 0x74, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3d, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x22, 0x85, 0x02, 0x0a, 0x13, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x23, 0x12, 0x21, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x20, 0x0a, 0x09, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x49,
	0x64, 0x12, 0x3b, 0x0a, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x22,
	0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x49, 0x64, 0x12, 0x28, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f,
	0x6e, 0x6c, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c,
	0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x22, 0x8c, 0x02, 0x0a,
	0x13, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d,
	0x61, 0x73, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c,
	0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x3b, 0x0a, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e,
	0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x74, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69,
	0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x28, 0x0a, 0x0d, 0x61, 0x6c, 0x6c, 0x6f, 0x77,
	0x5f, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x0c, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x4d, 0x69, 0x73, 0x73, 0x69, 0x6e,
	0x67, 0x12, 0x28, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e,
	0x6c, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x76,
	0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x22, 0xe5, 0x01, 0x0a, 0x13,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x3d, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x28, 0x0a, 0x0d, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f,
	0x6d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0c, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x4d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67,
	0x12, 0x28, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c,
	0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x76, 0x61,
	0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x12, 0x17, 0x0a, 0x04, 0x65, 0x74,
	0x61, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x65,
	0x74, 0x61, 0x67, 0x22, 0xa1, 0x12, 0x0a, 0x07, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x12,
	0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x15, 0x0a, 0x03, 0x75, 0x69, 0x64, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x03, 0x75, 0x69, 0x64, 0x12,
	0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x52, 0x0a, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e,
	0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x43, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18,
	0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x52,
	0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x21, 0x0a, 0x09, 0x61, 0x62,
	0x61, 0x6e, 0x64, 0x6f, 0x6e, 0x65, 0x64, 0x18, 0x17, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x09, 0x61, 0x62, 0x61, 0x6e, 0x64, 0x6f, 0x6e, 0x65, 0x64, 0x12, 0x40, 0x0a,
	0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x4b, 0x0a, 0x11, 0x72, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x5f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x72, 0x65, 0x6e,
	0x64, 0x65, 0x72, 0x53, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x47, 0x0a, 0x0f,
	0x72, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x5f, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x72, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x45, 0x6e,
	0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x2e, 0x0a, 0x13, 0x73, 0x6b, 0x61, 0x66, 0x66, 0x6f, 0x6c,
	0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x11, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x11, 0x73, 0x6b, 0x61, 0x66, 0x66, 0x6f, 0x6c, 0x64, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x55, 0x72, 0x69, 0x12, 0x30, 0x0a, 0x14, 0x73, 0x6b, 0x61, 0x66, 0x66, 0x6f, 0x6c,
	0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x09, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x12, 0x73, 0x6b, 0x61, 0x66, 0x66, 0x6f, 0x6c, 0x64, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x50, 0x61, 0x74, 0x68, 0x12, 0x4e, 0x0a, 0x0f, 0x62, 0x75, 0x69, 0x6c, 0x64,
	0x5f, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x41,
	0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x52, 0x0e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x41, 0x72,
	0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x73, 0x12, 0x6b, 0x0a, 0x1a, 0x64, 0x65, 0x6c, 0x69, 0x76,
	0x65, 0x72, 0x79, 0x5f, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x73, 0x6e, 0x61,
	0x70, 0x73, 0x68, 0x6f, 0x74, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x50, 0x69, 0x70,
	0x65, 0x6c, 0x69, 0x6e, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x18, 0x64, 0x65, 0x6c, 0x69,
	0x76, 0x65, 0x72, 0x79, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x53, 0x6e, 0x61, 0x70,
	0x73, 0x68, 0x6f, 0x74, 0x12, 0x4e, 0x0a, 0x10, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x73,
	0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x73, 0x18, 0x0c, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65,
	0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x53, 0x6e, 0x61, 0x70, 0x73,
	0x68, 0x6f, 0x74, 0x73, 0x12, 0x53, 0x0a, 0x0c, 0x72, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x5f, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79,
	0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x2e, 0x52, 0x65, 0x6e, 0x64,
	0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x72, 0x65,
	0x6e, 0x64, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x65, 0x74, 0x61,
	0x67, 0x18, 0x10, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x12, 0x29, 0x0a,
	0x10, 0x73, 0x6b, 0x61, 0x66, 0x66, 0x6f, 0x6c, 0x64, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x18, 0x13, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x73, 0x6b, 0x61, 0x66, 0x66, 0x6f, 0x6c,
	0x64, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x64, 0x0a, 0x10, 0x74, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x5f, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x73, 0x18, 0x14, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x6c, 0x65,
	0x61, 0x73, 0x65, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61,
	0x63, 0x74, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x74,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x73, 0x12, 0x5e,
	0x0a, 0x0e, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x72, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x73,
	0x18, 0x16, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e,
	0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x65,
	0x6e, 0x64, 0x65, 0x72, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0d, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x73, 0x1a, 0xa9,
	0x04, 0x0a, 0x0c, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x12,
	0x50, 0x0a, 0x0f, 0x72, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x62, 0x75, 0x69,
	0x6c, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x21,
	0x0a, 0x1f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x75, 0x69, 0x6c,
	0x64, 0x52, 0x0e, 0x72, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x42, 0x75, 0x69, 0x6c,
	0x64, 0x12, 0x6c, 0x0a, 0x0f, 0x72, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79,
	0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x2e, 0x54, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x52, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52,
	0x65, 0x6e, 0x64, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0e, 0x72, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12,
	0x63, 0x0a, 0x0d, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x5f, 0x63, 0x61, 0x75, 0x73, 0x65,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e,
	0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x65,
	0x6e, 0x64, 0x65, 0x72, 0x2e, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x43, 0x61, 0x75, 0x73,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x43,
	0x61, 0x75, 0x73, 0x65, 0x12, 0x2c, 0x0a, 0x0f, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x5f,
	0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0e, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x4d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x22, 0x64, 0x0a, 0x11, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x65, 0x6e, 0x64,
	0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x23, 0x0a, 0x1f, 0x54, 0x41, 0x52, 0x47, 0x45,
	0x54, 0x5f, 0x52, 0x45, 0x4e, 0x44, 0x45, 0x52, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09,
	0x53, 0x55, 0x43, 0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x46,
	0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0f, 0x0a, 0x0b, 0x49, 0x4e, 0x5f, 0x50, 0x52,
	0x4f, 0x47, 0x52, 0x45, 0x53, 0x53, 0x10, 0x03, 0x22, 0x60, 0x0a, 0x0c, 0x46, 0x61, 0x69, 0x6c,
	0x75, 0x72, 0x65, 0x43, 0x61, 0x75, 0x73, 0x65, 0x12, 0x1d, 0x0a, 0x19, 0x46, 0x41, 0x49, 0x4c,
	0x55, 0x52, 0x45, 0x5f, 0x43, 0x41, 0x55, 0x53, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1b, 0x0a, 0x17, 0x43, 0x4c, 0x4f, 0x55, 0x44,
	0x5f, 0x42, 0x55, 0x49, 0x4c, 0x44, 0x5f, 0x55, 0x4e, 0x41, 0x56, 0x41, 0x49, 0x4c, 0x41, 0x42,
	0x4c, 0x45, 0x10, 0x01, 0x12, 0x14, 0x0a, 0x10, 0x45, 0x58, 0x45, 0x43, 0x55, 0x54, 0x49, 0x4f,
	0x4e, 0x5f, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x02, 0x1a, 0x3e, 0x0a, 0x10, 0x41, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10,
	0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79,
	0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x6a, 0x0a, 0x14, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x41,
	0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a,
	0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12,
	0x3c, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65,
	0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x41, 0x72,
	0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38,
	0x01, 0x1a, 0x6e, 0x0a, 0x12, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x65, 0x6e, 0x64, 0x65,
	0x72, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x42, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76,
	0x31, 0x2e, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x52, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38,
	0x01, 0x22, 0x57, 0x0a, 0x0b, 0x52, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x12, 0x1c, 0x0a, 0x18, 0x52, 0x45, 0x4e, 0x44, 0x45, 0x52, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0d,
	0x0a, 0x09, 0x53, 0x55, 0x43, 0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0a, 0x0a,
	0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0f, 0x0a, 0x0b, 0x49, 0x4e, 0x5f,
	0x50, 0x52, 0x4f, 0x47, 0x52, 0x45, 0x53, 0x53, 0x10, 0x03, 0x3a, 0x8a, 0x01, 0xea, 0x41, 0x86,
	0x01, 0x0a, 0x22, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65,
	0x6c, 0x65, 0x61, 0x73, 0x65, 0x12, 0x60, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x64,
	0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x73,
	0x2f, 0x7b, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x5f, 0x70, 0x69, 0x70, 0x65, 0x6c,
	0x69, 0x6e, 0x65, 0x7d, 0x2f, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x73, 0x2f, 0x7b, 0x72,
	0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x7d, 0x22, 0x37, 0x0a, 0x0d, 0x42, 0x75, 0x69, 0x6c, 0x64,
	0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x69, 0x6d, 0x61, 0x67,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x12, 0x10,
	0x0a, 0x03, 0x74, 0x61, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x74, 0x61, 0x67,
	0x22, 0xa2, 0x01, 0x0a, 0x0e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x41, 0x72, 0x74, 0x69, 0x66,
	0x61, 0x63, 0x74, 0x12, 0x28, 0x0a, 0x0c, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x5f,
	0x75, 0x72, 0x69, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00,
	0x52, 0x0b, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x55, 0x72, 0x69, 0x12, 0x35, 0x0a,
	0x14, 0x73, 0x6b, 0x61, 0x66, 0x66, 0x6f, 0x6c, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x12, 0x73, 0x6b, 0x61, 0x66, 0x66, 0x6f, 0x6c, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x50, 0x61, 0x74, 0x68, 0x12, 0x28, 0x0a, 0x0d, 0x6d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74,
	0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0c, 0x6d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x50, 0x61, 0x74, 0x68, 0x42, 0x05,
	0x0a, 0x03, 0x75, 0x72, 0x69, 0x22, 0xe5, 0x01, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65,
	0x6c, 0x65, 0x61, 0x73, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x65, 0x70, 0x6c,
	0x6f, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69,
	0x6e, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1e, 0x0a,
	0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0x9d, 0x01,
	0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3b, 0x0a, 0x08, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73,
	0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76,
	0x31, 0x2e, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x52, 0x08, 0x72, 0x65, 0x6c, 0x65, 0x61,
	0x73, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65,
	0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75,
	0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09,
	0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x53, 0x0a,
	0x11, 0x47, 0x65, 0x74, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x3e, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x22, 0x95, 0x02, 0x0a, 0x14, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x65, 0x6c,
	0x65, 0x61, 0x73, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x44, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65,
	0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x6c, 0x65,
	0x61, 0x73, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x09, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x49, 0x64, 0x12, 0x3e, 0x0a, 0x07,
	0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70,
	0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x07, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x12, 0x22, 0x0a, 0x0a,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64,
	0x12, 0x28, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c,
	0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x76, 0x61,
	0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x22, 0x85, 0x0f, 0x0a, 0x07, 0x52,
	0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x15, 0x0a, 0x03, 0x75, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x03, 0x75, 0x69, 0x64, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x52, 0x0a, 0x0b, 0x61, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70,
	0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x2e, 0x41,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52,
	0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x43, 0x0a, 0x06,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c,
	0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x2e, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x42, 0x0a, 0x0c, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x61, 0x70, 0x70, 0x72,
	0x6f, 0x76, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x42, 0x0a, 0x0c, 0x65, 0x6e, 0x71, 0x75, 0x65,
	0x75, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b,
	0x65, 0x6e, 0x71, 0x75, 0x65, 0x75, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x4b, 0x0a, 0x11, 0x64,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x5f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x53,
	0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x47, 0x0a, 0x0f, 0x64, 0x65, 0x70, 0x6c,
	0x6f, 0x79, 0x5f, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0d, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x45, 0x6e, 0x64, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x20, 0x0a, 0x09, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x12,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x74, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x49, 0x64, 0x12, 0x59, 0x0a, 0x0e, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c, 0x5f,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x2e, 0x41, 0x70, 0x70,
	0x72, 0x6f, 0x76, 0x61, 0x6c, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0d, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x40,
	0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x25, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70,
	0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x2e, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x12, 0x2a, 0x0a, 0x0e, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x5f, 0x72, 0x65, 0x61, 0x73,
	0x6f, 0x6e, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x66,
	0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12, 0x50, 0x0a, 0x0f,
	0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x69, 0x6e, 0x67, 0x5f, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x18,
	0x11, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x52, 0x0e,
	0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x69, 0x6e, 0x67, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x12, 0x12,
	0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x10, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x65, 0x74,
	0x61, 0x67, 0x12, 0x63, 0x0a, 0x14, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x5f, 0x66, 0x61, 0x69,
	0x6c, 0x75, 0x72, 0x65, 0x5f, 0x63, 0x61, 0x75, 0x73, 0x65, 0x18, 0x13, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75,
	0x74, 0x2e, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x43, 0x61, 0x75, 0x73, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x12, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x46, 0x61, 0x69, 0x6c, 0x75,
	0x72, 0x65, 0x43, 0x61, 0x75, 0x73, 0x65, 0x12, 0x3a, 0x0a, 0x06, 0x70, 0x68, 0x61, 0x73, 0x65,
	0x73, 0x18, 0x17, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31,
	0x2e, 0x50, 0x68, 0x61, 0x73, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x70, 0x68, 0x61,
	0x73, 0x65, 0x73, 0x12, 0x41, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18,
	0x18, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x6d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x1a, 0x3e, 0x0a, 0x10, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38,
	0x01, 0x22, 0x7b, 0x0a, 0x0d, 0x41, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x12, 0x1e, 0x0a, 0x1a, 0x41, 0x50, 0x50, 0x52, 0x4f, 0x56, 0x41, 0x4c, 0x5f, 0x53,
	0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x12, 0x0a, 0x0e, 0x4e, 0x45, 0x45, 0x44, 0x53, 0x5f, 0x41, 0x50, 0x50, 0x52,
	0x4f, 0x56, 0x41, 0x4c, 0x10, 0x01, 0x12, 0x1a, 0x0a, 0x16, 0x44, 0x4f, 0x45, 0x53, 0x5f, 0x4e,
	0x4f, 0x54, 0x5f, 0x4e, 0x45, 0x45, 0x44, 0x5f, 0x41, 0x50, 0x50, 0x52, 0x4f, 0x56, 0x41, 0x4c,
	0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x41, 0x50, 0x50, 0x52, 0x4f, 0x56, 0x45, 0x44, 0x10, 0x03,
	0x12, 0x0c, 0x0a, 0x08, 0x52, 0x45, 0x4a, 0x45, 0x43, 0x54, 0x45, 0x44, 0x10, 0x04, 0x22, 0x99,
	0x01, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x0d, 0x0a, 0x09, 0x53, 0x55, 0x43, 0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0a,
	0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0f, 0x0a, 0x0b, 0x49, 0x4e,
	0x5f, 0x50, 0x52, 0x4f, 0x47, 0x52, 0x45, 0x53, 0x53, 0x10, 0x03, 0x12, 0x14, 0x0a, 0x10, 0x50,
	0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x5f, 0x41, 0x50, 0x50, 0x52, 0x4f, 0x56, 0x41, 0x4c, 0x10,
	0x04, 0x12, 0x15, 0x0a, 0x11, 0x41, 0x50, 0x50, 0x52, 0x4f, 0x56, 0x41, 0x4c, 0x5f, 0x52, 0x45,
	0x4a, 0x45, 0x43, 0x54, 0x45, 0x44, 0x10, 0x05, 0x12, 0x0b, 0x0a, 0x07, 0x50, 0x45, 0x4e, 0x44,
	0x49, 0x4e, 0x47, 0x10, 0x06, 0x12, 0x13, 0x0a, 0x0f, 0x50, 0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47,
	0x5f, 0x52, 0x45, 0x4c, 0x45, 0x41, 0x53, 0x45, 0x10, 0x07, 0x22, 0xc5, 0x01, 0x0a, 0x0c, 0x46,
	0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x43, 0x61, 0x75, 0x73, 0x65, 0x12, 0x1d, 0x0a, 0x19, 0x46,
	0x41, 0x49, 0x4c, 0x55, 0x52, 0x45, 0x5f, 0x43, 0x41, 0x55, 0x53, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1b, 0x0a, 0x17, 0x43, 0x4c,
	0x4f, 0x55, 0x44, 0x5f, 0x42, 0x55, 0x49, 0x4c, 0x44, 0x5f, 0x55, 0x4e, 0x41, 0x56, 0x41, 0x49,
	0x4c, 0x41, 0x42, 0x4c, 0x45, 0x10, 0x01, 0x12, 0x14, 0x0a, 0x10, 0x45, 0x58, 0x45, 0x43, 0x55,
	0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x02, 0x12, 0x15, 0x0a,
	0x11, 0x44, 0x45, 0x41, 0x44, 0x4c, 0x49, 0x4e, 0x45, 0x5f, 0x45, 0x58, 0x43, 0x45, 0x45, 0x44,
	0x45, 0x44, 0x10, 0x03, 0x12, 0x12, 0x0a, 0x0e, 0x52, 0x45, 0x4c, 0x45, 0x41, 0x53, 0x45, 0x5f,
	0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x04, 0x12, 0x15, 0x0a, 0x11, 0x52, 0x45, 0x4c, 0x45,
	0x41, 0x53, 0x45, 0x5f, 0x41, 0x42, 0x41, 0x4e, 0x44, 0x4f, 0x4e, 0x45, 0x44, 0x10, 0x05, 0x12,
	0x21, 0x0a, 0x1d, 0x56, 0x45, 0x52, 0x49, 0x46, 0x49, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f,
	0x43, 0x4f, 0x4e, 0x46, 0x49, 0x47, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x46, 0x4f, 0x55, 0x4e, 0x44,
	0x10, 0x06, 0x3a, 0x9d, 0x01, 0xea, 0x41, 0x99, 0x01, 0x0a, 0x22, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x12, 0x73, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x50,
	0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x2f, 0x7b, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65,
	0x72, 0x79, 0x5f, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x7d, 0x2f, 0x72, 0x65, 0x6c,
	0x65, 0x61, 0x73, 0x65, 0x73, 0x2f, 0x7b, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x7d, 0x2f,
	0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x73, 0x2f, 0x7b, 0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75,
	0x74, 0x7d, 0x22, 0x56, 0x0a, 0x08, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x4a,
	0x0a, 0x09, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x72, 0x75, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x52, 0x75, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x08, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x52, 0x75, 0x6e, 0x22, 0x62, 0x0a, 0x14, 0x44, 0x65,
	0x70, 0x6c, 0x6f, 0x79, 0x4a, 0x6f, 0x62, 0x52, 0x75, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x12, 0x4a, 0x0a, 0x09, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x72, 0x75, 0x6e, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x52, 0x75, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x52, 0x75, 0x6e, 0x22, 0x7a,
	0x0a, 0x10, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x52, 0x75, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x12, 0x1d, 0x0a, 0x07, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x12, 0x26, 0x0a, 0x0c, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x75, 0x72, 0x6c,
	0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x55, 0x72, 0x6c, 0x73, 0x12, 0x1f, 0x0a, 0x08, 0x72, 0x65, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x08, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0xa2, 0x02, 0x0a, 0x05, 0x50,
	0x68, 0x61, 0x73, 0x65, 0x12, 0x13, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x02, 0x69, 0x64, 0x12, 0x3e, 0x0a, 0x05, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76,
	0x31, 0x2e, 0x50, 0x68, 0x61, 0x73, 0x65, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x56, 0x0a, 0x0f, 0x64, 0x65, 0x70,
	0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x6a, 0x6f, 0x62, 0x73, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x70, 0x6c,
	0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x4a, 0x6f, 0x62, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48,
	0x00, 0x52, 0x0e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x4a, 0x6f, 0x62,
	0x73, 0x22, 0x64, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54,
	0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x0b, 0x0a, 0x07, 0x50, 0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0f,
	0x0a, 0x0b, 0x49, 0x4e, 0x5f, 0x50, 0x52, 0x4f, 0x47, 0x52, 0x45, 0x53, 0x53, 0x10, 0x02, 0x12,
	0x0d, 0x0a, 0x09, 0x53, 0x55, 0x43, 0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10, 0x03, 0x12, 0x0a,
	0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x04, 0x12, 0x0b, 0x0a, 0x07, 0x41, 0x42,
	0x4f, 0x52, 0x54, 0x45, 0x44, 0x10, 0x05, 0x42, 0x06, 0x0a, 0x04, 0x6a, 0x6f, 0x62, 0x73, 0x22,
	0x92, 0x01, 0x0a, 0x0e, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x4a, 0x6f,
	0x62, 0x73, 0x12, 0x3f, 0x0a, 0x0a, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x5f, 0x6a, 0x6f, 0x62,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e,
	0x4a, 0x6f, 0x62, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79,
	0x4a, 0x6f, 0x62, 0x12, 0x3f, 0x0a, 0x0a, 0x76, 0x65, 0x72, 0x69, 0x66, 0x79, 0x5f, 0x6a, 0x6f,
	0x62, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31,
	0x2e, 0x4a, 0x6f, 0x62, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x76, 0x65, 0x72, 0x69, 0x66,
	0x79, 0x4a, 0x6f, 0x62, 0x22, 0xae, 0x03, 0x0a, 0x03, 0x4a, 0x6f, 0x62, 0x12, 0x13, 0x0a, 0x02,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x02, 0x69,
	0x64, 0x12, 0x3c, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x4a, 0x6f, 0x62, 0x2e, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12,
	0x42, 0x0a, 0x07, 0x6a, 0x6f, 0x62, 0x5f, 0x72, 0x75, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x29, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4a, 0x6f, 0x62, 0x52, 0x75, 0x6e, 0x52, 0x06, 0x6a, 0x6f, 0x62,
	0x52, 0x75, 0x6e, 0x12, 0x47, 0x0a, 0x0a, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x5f, 0x6a, 0x6f,
	0x62, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x4a, 0x6f, 0x62, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48,
	0x00, 0x52, 0x09, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x4a, 0x6f, 0x62, 0x12, 0x47, 0x0a, 0x0a,
	0x76, 0x65, 0x72, 0x69, 0x66, 0x79, 0x5f, 0x6a, 0x6f, 0x62, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x65, 0x72, 0x69, 0x66, 0x79,
	0x4a, 0x6f, 0x62, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x09, 0x76, 0x65, 0x72, 0x69,
	0x66, 0x79, 0x4a, 0x6f, 0x62, 0x22, 0x72, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15,
	0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x50, 0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47,
	0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x49, 0x53, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x02,
	0x12, 0x0f, 0x0a, 0x0b, 0x49, 0x4e, 0x5f, 0x50, 0x52, 0x4f, 0x47, 0x52, 0x45, 0x53, 0x53, 0x10,
	0x03, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x55, 0x43, 0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10, 0x04,
	0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x05, 0x12, 0x0b, 0x0a, 0x07,
	0x41, 0x42, 0x4f, 0x52, 0x54, 0x45, 0x44, 0x10, 0x06, 0x42, 0x0a, 0x0a, 0x08, 0x6a, 0x6f, 0x62,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x22, 0x0b, 0x0a, 0x09, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x4a,
	0x6f, 0x62, 0x22, 0x0b, 0x0a, 0x09, 0x56, 0x65, 0x72, 0x69, 0x66, 0x79, 0x4a, 0x6f, 0x62, 0x22,
	0xdc, 0x01, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a,
	0x22, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x6c, 0x65,
	0x61, 0x73, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a,
	0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1e,
	0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0x9d,
	0x01, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3b, 0x0a, 0x08, 0x72, 0x6f, 0x6c, 0x6c, 0x6f,
	0x75, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e,
	0x76, 0x31, 0x2e, 0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x52, 0x08, 0x72, 0x6f, 0x6c, 0x6c,
	0x6f, 0x75, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e,
	0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b,
	0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x53,
	0x0a, 0x11, 0x47, 0x65, 0x74, 0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x3e, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x22, 0x8c, 0x02, 0x0a, 0x14, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x6f,
	0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0x22, 0x0a, 0x0a, 0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x72, 0x6f, 0x6c, 0x6c, 0x6f,
	0x75, 0x74, 0x49, 0x64, 0x12, 0x3e, 0x0a, 0x07, 0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x52,
	0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x72, 0x6f, 0x6c,
	0x6c, 0x6f, 0x75, 0x74, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f,
	0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x28, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e,
	0x6c, 0x79, 0x22, 0xd5, 0x02, 0x0a, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x08, 0x65, 0x6e,
	0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x65,
	0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x74, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x76, 0x65, 0x72, 0x62, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x76, 0x65, 0x72, 0x62, 0x12, 0x2a, 0x0a, 0x0e,
	0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x73, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x3a, 0x0a, 0x16, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x63, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x6c, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x15, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x6c, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x24, 0x0a, 0x0b, 0x61, 0x70, 0x69, 0x5f, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a,
	0x61, 0x70, 0x69, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x78, 0x0a, 0x15, 0x41, 0x70,
	0x70, 0x72, 0x6f, 0x76, 0x65, 0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x3e, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x1f, 0x0a, 0x08, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x64, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x61, 0x70, 0x70, 0x72,
	0x6f, 0x76, 0x65, 0x64, 0x22, 0x18, 0x0a, 0x16, 0x41, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x52,
	0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x93,
	0x01, 0x0a, 0x0f, 0x52, 0x65, 0x74, 0x72, 0x79, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x44, 0x0a, 0x07, 0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x52,
	0x07, 0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x12, 0x1e, 0x0a, 0x08, 0x70, 0x68, 0x61, 0x73,
	0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x07, 0x70, 0x68, 0x61, 0x73, 0x65, 0x49, 0x64, 0x12, 0x1a, 0x0a, 0x06, 0x6a, 0x6f, 0x62, 0x5f,
	0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x6a,
	0x6f, 0x62, 0x49, 0x64, 0x22, 0x12, 0x0a, 0x10, 0x52, 0x65, 0x74, 0x72, 0x79, 0x4a, 0x6f, 0x62,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x57, 0x0a, 0x15, 0x41, 0x62, 0x61, 0x6e,
	0x64, 0x6f, 0x6e, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x3e, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x65,
	0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x22, 0x18, 0x0a, 0x16, 0x41, 0x62, 0x61, 0x6e, 0x64, 0x6f, 0x6e, 0x52, 0x65, 0x6c, 0x65,
	0x61, 0x73, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xbb, 0x06, 0x0a, 0x06,
	0x4a, 0x6f, 0x62, 0x52, 0x75, 0x6e, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x15, 0x0a, 0x03, 0x75, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x03, 0x75, 0x69, 0x64, 0x12, 0x1e, 0x0a, 0x08, 0x70, 0x68, 0x61, 0x73, 0x65, 0x5f,
	0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x70,
	0x68, 0x61, 0x73, 0x65, 0x49, 0x64, 0x12, 0x1a, 0x0a, 0x06, 0x6a, 0x6f, 0x62, 0x5f, 0x69, 0x64,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x6a, 0x6f, 0x62,
	0x49, 0x64, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x3e, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x3f, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x4a, 0x6f, 0x62, 0x52, 0x75, 0x6e, 0x2e,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74,
	0x65, 0x12, 0x51, 0x0a, 0x0e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x5f, 0x6a, 0x6f, 0x62, 0x5f,
	0x72, 0x75, 0x6e, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e,
	0x76, 0x31, 0x2e, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x4a, 0x6f, 0x62, 0x52, 0x75, 0x6e, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x0c, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x4a, 0x6f,
	0x62, 0x52, 0x75, 0x6e, 0x12, 0x51, 0x0a, 0x0e, 0x76, 0x65, 0x72, 0x69, 0x66, 0x79, 0x5f, 0x6a,
	0x6f, 0x62, 0x5f, 0x72, 0x75, 0x6e, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c,
	0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x65, 0x72, 0x69, 0x66, 0x79, 0x4a, 0x6f, 0x62, 0x52,
	0x75, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x0c, 0x76, 0x65, 0x72, 0x69, 0x66,
	0x79, 0x4a, 0x6f, 0x62, 0x52, 0x75, 0x6e, 0x12, 0x17, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18,
	0x0b, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67,
	0x22, 0x4a, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41,
	0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x0f, 0x0a, 0x0b, 0x49, 0x4e, 0x5f, 0x50, 0x52, 0x4f, 0x47, 0x52, 0x45, 0x53, 0x53, 0x10,
	0x01, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x55, 0x43, 0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10, 0x02,
	0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x03, 0x3a, 0xaf, 0x01, 0xea,
	0x41, 0xab, 0x01, 0x0a, 0x21, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x4a, 0x6f, 0x62, 0x52, 0x75, 0x6e, 0x12, 0x85, 0x01, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d,
	0x2f, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e,
	0x65, 0x73, 0x2f, 0x7b, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x5f, 0x70, 0x69, 0x70,
	0x65, 0x6c, 0x69, 0x6e, 0x65, 0x7d, 0x2f, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x73, 0x2f,
	0x7b, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x7d, 0x2f, 0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75,
	0x74, 0x73, 0x2f, 0x7b, 0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x7d, 0x2f, 0x6a, 0x6f, 0x62,
	0x52, 0x75, 0x6e, 0x73, 0x2f, 0x7b, 0x6a, 0x6f, 0x62, 0x5f, 0x72, 0x75, 0x6e, 0x7d, 0x42, 0x09,
	0x0a, 0x07, 0x6a, 0x6f, 0x62, 0x5f, 0x72, 0x75, 0x6e, 0x22, 0xa0, 0x03, 0x0a, 0x0c, 0x44, 0x65,
	0x70, 0x6c, 0x6f, 0x79, 0x4a, 0x6f, 0x62, 0x52, 0x75, 0x6e, 0x12, 0x3d, 0x0a, 0x05, 0x62, 0x75,
	0x69, 0x6c, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x03, 0xfa, 0x41,
	0x21, 0x0a, 0x1f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x75, 0x69,
	0x6c, 0x64, 0x52, 0x05, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x12, 0x5b, 0x0a, 0x0d, 0x66, 0x61, 0x69,
	0x6c, 0x75, 0x72, 0x65, 0x5f, 0x63, 0x61, 0x75, 0x73, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79,
	0x4a, 0x6f, 0x62, 0x52, 0x75, 0x6e, 0x2e, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x43, 0x61,
	0x75, 0x73, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72,
	0x65, 0x43, 0x61, 0x75, 0x73, 0x65, 0x12, 0x2c, 0x0a, 0x0f, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72,
	0x65, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x4d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x12, 0x4d, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e,
	0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x4a, 0x6f, 0x62, 0x52, 0x75, 0x6e, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x22, 0x77, 0x0a, 0x0c, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x43, 0x61,
	0x75, 0x73, 0x65, 0x12, 0x1d, 0x0a, 0x19, 0x46, 0x41, 0x49, 0x4c, 0x55, 0x52, 0x45, 0x5f, 0x43,
	0x41, 0x55, 0x53, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x1b, 0x0a, 0x17, 0x43, 0x4c, 0x4f, 0x55, 0x44, 0x5f, 0x42, 0x55, 0x49, 0x4c,
	0x44, 0x5f, 0x55, 0x4e, 0x41, 0x56, 0x41, 0x49, 0x4c, 0x41, 0x42, 0x4c, 0x45, 0x10, 0x01, 0x12,
	0x14, 0x0a, 0x10, 0x45, 0x58, 0x45, 0x43, 0x55, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x46, 0x41, 0x49,
	0x4c, 0x45, 0x44, 0x10, 0x02, 0x12, 0x15, 0x0a, 0x11, 0x44, 0x45, 0x41, 0x44, 0x4c, 0x49, 0x4e,
	0x45, 0x5f, 0x45, 0x58, 0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10, 0x03, 0x22, 0xc8, 0x03, 0x0a,
	0x0c, 0x56, 0x65, 0x72, 0x69, 0x66, 0x79, 0x4a, 0x6f, 0x62, 0x52, 0x75, 0x6e, 0x12, 0x3d, 0x0a,
	0x05, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41,
	0x03, 0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x42, 0x75, 0x69, 0x6c, 0x64, 0x52, 0x05, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x12, 0x26, 0x0a, 0x0c,
	0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63,
	0x74, 0x55, 0x72, 0x69, 0x12, 0x29, 0x0a, 0x0e, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x6c, 0x6f,
	0x67, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0c, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x4c, 0x6f, 0x67, 0x50, 0x61, 0x74, 0x68, 0x12,
	0x5b, 0x0a, 0x0d, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x5f, 0x63, 0x61, 0x75, 0x73, 0x65,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e,
	0x56, 0x65, 0x72, 0x69, 0x66, 0x79, 0x4a, 0x6f, 0x62, 0x52, 0x75, 0x6e, 0x2e, 0x46, 0x61, 0x69,
	0x6c, 0x75, 0x72, 0x65, 0x43, 0x61, 0x75, 0x73, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c,
	0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x43, 0x61, 0x75, 0x73, 0x65, 0x12, 0x2c, 0x0a, 0x0f,
	0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x66, 0x61, 0x69, 0x6c,
	0x75, 0x72, 0x65, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x22, 0x9a, 0x01, 0x0a, 0x0c, 0x46,
	0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x43, 0x61, 0x75, 0x73, 0x65, 0x12, 0x1d, 0x0a, 0x19, 0x46,
	0x41, 0x49, 0x4c, 0x55, 0x52, 0x45, 0x5f, 0x43, 0x41, 0x55, 0x53, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1b, 0x0a, 0x17, 0x43, 0x4c,
	0x4f, 0x55, 0x44, 0x5f, 0x42, 0x55, 0x49, 0x4c, 0x44, 0x5f, 0x55, 0x4e, 0x41, 0x56, 0x41, 0x49,
	0x4c, 0x41, 0x42, 0x4c, 0x45, 0x10, 0x01, 0x12, 0x14, 0x0a, 0x10, 0x45, 0x58, 0x45, 0x43, 0x55,
	0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x02, 0x12, 0x15, 0x0a,
	0x11, 0x44, 0x45, 0x41, 0x44, 0x4c, 0x49, 0x4e, 0x45, 0x5f, 0x45, 0x58, 0x43, 0x45, 0x45, 0x44,
	0x45, 0x44, 0x10, 0x03, 0x12, 0x21, 0x0a, 0x1d, 0x56, 0x45, 0x52, 0x49, 0x46, 0x49, 0x43, 0x41,
	0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x43, 0x4f, 0x4e, 0x46, 0x49, 0x47, 0x5f, 0x4e, 0x4f, 0x54, 0x5f,
	0x46, 0x4f, 0x55, 0x4e, 0x44, 0x10, 0x04, 0x22, 0xdb, 0x01, 0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74,
	0x4a, 0x6f, 0x62, 0x52, 0x75, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x65, 0x70,
	0x6c, 0x6f, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65,
	0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1e, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62,
	0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x6f, 0x72,
	0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0x9a, 0x01, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x4a, 0x6f,
	0x62, 0x52, 0x75, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x39, 0x0a,
	0x08, 0x6a, 0x6f, 0x62, 0x5f, 0x72, 0x75, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x4a, 0x6f, 0x62, 0x52, 0x75, 0x6e, 0x52,
	0x07, 0x6a, 0x6f, 0x62, 0x52, 0x75, 0x6e, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74,
	0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18,
	0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62,
	0x6c, 0x65, 0x22, 0x51, 0x0a, 0x10, 0x47, 0x65, 0x74, 0x4a, 0x6f, 0x62, 0x52, 0x75, 0x6e, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3d, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4a, 0x6f, 0x62, 0x52, 0x75, 0x6e, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x90, 0x02, 0x0a, 0x06, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x5b, 0x0a, 0x12, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65,
	0x64, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6b, 0x61, 0x66, 0x66, 0x6f,
	0x6c, 0x64, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x11,
	0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x73, 0x12, 0x3d, 0x0a, 0x18, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x73, 0x6b, 0x61,
	0x66, 0x66, 0x6f, 0x6c, 0x64, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x16, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c,
	0x74, 0x53, 0x6b, 0x61, 0x66, 0x66, 0x6f, 0x6c, 0x64, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x3a, 0x56, 0xea, 0x41, 0x53, 0x0a, 0x21, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x65, 0x70, 0x6c,
	0x6f, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x2e, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x7d, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x68, 0x0a, 0x0f, 0x53, 0x6b, 0x61, 0x66,
	0x66, 0x6f, 0x6c, 0x64, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x18, 0x0a, 0x07, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x3b, 0x0a, 0x10, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74,
	0x5f, 0x65, 0x6e, 0x64, 0x5f, 0x64, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x11, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x44, 0x61,
	0x74, 0x65, 0x52, 0x0e, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x45, 0x6e, 0x64, 0x44, 0x61,
	0x74, 0x65, 0x22, 0x51, 0x0a, 0x10, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3d, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x32, 0xa5, 0x24, 0x0a, 0x0b, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x44,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x12, 0xcc, 0x01, 0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x65,
	0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x12,
	0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x65, 0x6c,
	0x69, 0x76, 0x65, 0x72, 0x79, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x50, 0x69, 0x70, 0x65, 0x6c,
	0x69, 0x6e, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x46, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x37, 0x12, 0x35, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65,
	0x72, 0x79, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0xb9, 0x01, 0x0a, 0x13, 0x47, 0x65, 0x74, 0x44, 0x65, 0x6c, 0x69,
	0x76, 0x65, 0x72, 0x79, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x12, 0x32, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c,
	0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72,
	0x79, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65,
	0x72, 0x79, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x22, 0x44, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x37, 0x12, 0x35, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x50, 0x69, 0x70,
	0x65, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x99, 0x02, 0x0a, 0x16, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44, 0x65, 0x6c, 0x69, 0x76,
	0x65, 0x72, 0x79, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x12, 0x35, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44, 0x65, 0x6c, 0x69, 0x76,
	0x65, 0x72, 0x79, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67,
	0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0xa8, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4a, 0x22, 0x35, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65,
	0x73, 0x3a, 0x11, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x5f, 0x70, 0x69, 0x70, 0x65,
	0x6c, 0x69, 0x6e, 0x65, 0xda, 0x41, 0x2d, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x64, 0x65,
	0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x5f, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2c,
	0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x5f, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e,
	0x65, 0x5f, 0x69, 0x64, 0xca, 0x41, 0x25, 0x0a, 0x10, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72,
	0x79, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x9b, 0x02, 0x0a,
	0x16, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x50,
	0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31,
	0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x50,
	0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e,
	0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xaa, 0x01,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x5c, 0x32, 0x47, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x64, 0x65, 0x6c,
	0x69, 0x76, 0x65, 0x72, 0x79, 0x5f, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x65, 0x6c, 0x69, 0x76,
	0x65, 0x72, 0x79, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a,
	0x11, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x5f, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69,
	0x6e, 0x65, 0xda, 0x41, 0x1d, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x5f, 0x70, 0x69,
	0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61,
	0x73, 0x6b, 0xca, 0x41, 0x25, 0x0a, 0x10, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x50,
	0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xe1, 0x01, 0x0a, 0x16, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x50, 0x69, 0x70,
	0x65, 0x6c, 0x69, 0x6e, 0x65, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x50, 0x69, 0x70,
	0x65, 0x6c, 0x69, 0x6e, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e,
	0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x71, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x37, 0x2a, 0x35, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x50, 0x69,
	0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0xca, 0x41, 0x2a, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x11, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xa4,
	0x01, 0x0a, 0x0b, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x12, 0x2a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65,
	0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79,
	0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x3c, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2d, 0x12,
	0x2b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0xda, 0x41, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x91, 0x01, 0x0a, 0x09, 0x47, 0x65, 0x74, 0x54, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x12, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74,
	0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70,
	0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x22, 0x3a, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x2d, 0x12, 0x2b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x2f,
	0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xcf, 0x01, 0x0a, 0x0c, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x2b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x73, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x35, 0x22, 0x2b,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x3a, 0x06, 0x74, 0x61, 0x72,
	0x67, 0x65, 0x74, 0xda, 0x41, 0x17, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x74, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x2c, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x69, 0x64, 0xca, 0x41, 0x1b,
	0x0a, 0x06, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xd1, 0x01, 0x0a, 0x0c,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x2b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c,
	0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x75, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3c,
	0x32, 0x32, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x2e, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0xda, 0x41, 0x12, 0x74,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73,
	0x6b, 0xca, 0x41, 0x1b, 0x0a, 0x06, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x11, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12,
	0xc3, 0x01, 0x0a, 0x0c, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x12, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69,
	0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x67, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x2d, 0x2a, 0x2b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x2f, 0x2a,
	0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0xca, 0x41, 0x2a, 0x0a, 0x15, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70,
	0x74, 0x79, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xbc, 0x01, 0x0a, 0x0c, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65,
	0x6c, 0x65, 0x61, 0x73, 0x65, 0x73, 0x12, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x51, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x42, 0x12, 0x40, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x65,
	0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0xa9, 0x01, 0x0a, 0x0a, 0x47, 0x65, 0x74, 0x52, 0x65, 0x6c, 0x65,
	0x61, 0x73, 0x65, 0x12, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74,
	0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65,
	0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x22,
	0x4f, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x42, 0x12, 0x40, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65,
	0x72, 0x79, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65,
	0x6c, 0x65, 0x61, 0x73, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0xeb, 0x01, 0x0a, 0x0d, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x65, 0x6c, 0x65, 0x61,
	0x73, 0x65, 0x12, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75,
	0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0x8c, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4b, 0x22, 0x40, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x65, 0x6c,
	0x69, 0x76, 0x65, 0x72, 0x79, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x2f, 0x2a,
	0x7d, 0x2f, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x73, 0x3a, 0x07, 0x72, 0x65, 0x6c, 0x65,
	0x61, 0x73, 0x65, 0xda, 0x41, 0x19, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x72, 0x65, 0x6c,
	0x65, 0x61, 0x73, 0x65, 0x2c, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x5f, 0x69, 0x64, 0xca,
	0x41, 0x1c, 0x0a, 0x07, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x12, 0x11, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xcb,
	0x01, 0x0a, 0x0e, 0x41, 0x62, 0x61, 0x6e, 0x64, 0x6f, 0x6e, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73,
	0x65, 0x12, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x62, 0x61, 0x6e, 0x64,
	0x6f, 0x6e, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x62, 0x61, 0x6e, 0x64, 0x6f,
	0x6e, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x5a, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4d, 0x22, 0x48, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x65, 0x6c, 0x69, 0x76,
	0x65, 0x72, 0x79, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x72,
	0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x61, 0x62, 0x61, 0x6e, 0x64,
	0x6f, 0x6e, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xd6, 0x01, 0x0a,
	0x0e, 0x41, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x12,
	0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x65,
	0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65,
	0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x52,
	0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x65,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x58, 0x22, 0x53, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72,
	0x79, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x6c,
	0x65, 0x61, 0x73, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x73,
	0x2f, 0x2a, 0x7d, 0x3a, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x3a, 0x01, 0x2a, 0xda, 0x41,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xc7, 0x01, 0x0a, 0x0c, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x6f,
	0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x73, 0x12, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x5c, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4d, 0x12, 0x4b, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x65,
	0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x2f,
	0x2a, 0x2f, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x72, 0x6f,
	0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0xb4, 0x01, 0x0a, 0x0a, 0x47, 0x65, 0x74, 0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x12, 0x29,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65,
	0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x52, 0x6f, 0x6c, 0x6c, 0x6f,
	0x75, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e,
	0x76, 0x31, 0x2e, 0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x22, 0x5a, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x4d, 0x12, 0x4b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x50, 0x69, 0x70,
	0x65, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65,
	0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0xda,
	0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xf6, 0x01, 0x0a, 0x0d, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x12, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x97, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x56, 0x22, 0x4b,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x50, 0x69, 0x70, 0x65, 0x6c,
	0x69, 0x6e, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x73, 0x3a, 0x07, 0x72, 0x6f, 0x6c,
	0x6c, 0x6f, 0x75, 0x74, 0xda, 0x41, 0x19, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x72, 0x6f,
	0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x2c, 0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x5f, 0x69, 0x64,
	0xca, 0x41, 0x1c, 0x0a, 0x07, 0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x12, 0x11, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12,
	0xdb, 0x01, 0x0a, 0x08, 0x52, 0x65, 0x74, 0x72, 0x79, 0x4a, 0x6f, 0x62, 0x12, 0x27, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c,
	0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x74, 0x72, 0x79, 0x4a, 0x6f, 0x62, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x52,
	0x65, 0x74, 0x72, 0x79, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x7c, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x5c, 0x22, 0x57, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x72, 0x6f,
	0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x65, 0x6c,
	0x69, 0x76, 0x65, 0x72, 0x79, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x2f, 0x2a,
	0x2f, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x6f, 0x6c, 0x6c,
	0x6f, 0x75, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x72, 0x65, 0x74, 0x72, 0x79, 0x4a, 0x6f, 0x62,
	0x3a, 0x01, 0x2a, 0xda, 0x41, 0x17, 0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x2c, 0x70, 0x68,
	0x61, 0x73, 0x65, 0x5f, 0x69, 0x64, 0x2c, 0x6a, 0x6f, 0x62, 0x5f, 0x69, 0x64, 0x12, 0xce, 0x01,
	0x0a, 0x0b, 0x4c, 0x69, 0x73, 0x74, 0x4a, 0x6f, 0x62, 0x52, 0x75, 0x6e, 0x73, 0x12, 0x2a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70,
	0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4a, 0x6f, 0x62, 0x52, 0x75,
	0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e,
	0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4a, 0x6f, 0x62, 0x52, 0x75, 0x6e, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x66, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x57, 0x12, 0x55,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x50, 0x69, 0x70, 0x65, 0x6c,
	0x69, 0x6e, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x73, 0x2f,
	0x2a, 0x2f, 0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6a, 0x6f,
	0x62, 0x52, 0x75, 0x6e, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0xbb,
	0x01, 0x0a, 0x09, 0x47, 0x65, 0x74, 0x4a, 0x6f, 0x62, 0x52, 0x75, 0x6e, 0x12, 0x28, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c,
	0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x4a, 0x6f, 0x62, 0x52, 0x75, 0x6e, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e,
	0x4a, 0x6f, 0x62, 0x52, 0x75, 0x6e, 0x22, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x57, 0x12, 0x55,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e,
	0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x73, 0x2f, 0x2a, 0x2f,
	0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6a, 0x6f, 0x62, 0x52, 0x75,
	0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x8e, 0x01, 0x0a,
	0x09, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x28, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79,
	0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x22, 0x37, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2a, 0x12, 0x28, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x1a, 0x4e, 0xca,
	0x41, 0x1a, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68,
	0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0xe7, 0x04,
	0x0a, 0x1a, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x76, 0x31, 0x42, 0x10, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01,
	0x5a, 0x3c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e,
	0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x65,
	0x70, 0x6c, 0x6f, 0x79, 0x2f, 0x76, 0x31, 0x3b, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0xea, 0x41,
	0x59, 0x0a, 0x1f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x75, 0x69,
	0x6c, 0x64, 0x12, 0x36, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x62, 0x75, 0x69, 0x6c,
	0x64, 0x73, 0x2f, 0x7b, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x7d, 0xea, 0x41, 0x5e, 0x0a, 0x20, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12,
	0x3a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x73, 0x2f, 0x7b, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x7d, 0xea, 0x41, 0x66, 0x0a, 0x24,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3e, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x7d, 0xea, 0x41, 0x69, 0x0a, 0x24, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75,
	0x69, 0x6c, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x41, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x50, 0x6f, 0x6f,
	0x6c, 0x73, 0x2f, 0x7b, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x7d,
	0xea, 0x41, 0x64, 0x0a, 0x20, 0x67, 0x6b, 0x65, 0x68, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x65, 0x6d, 0x62, 0x65,
	0x72, 0x73, 0x68, 0x69, 0x70, 0x12, 0x40, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6d,
	0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x73, 0x2f, 0x7b, 0x6d, 0x65, 0x6d, 0x62,
	0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x7d, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescOnce sync.Once
	file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescData = file_google_cloud_deploy_v1_cloud_deploy_proto_rawDesc
)

func file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescGZIP() []byte {
	file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescOnce.Do(func() {
		file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescData)
	})
	return file_google_cloud_deploy_v1_cloud_deploy_proto_rawDescData
}

var file_google_cloud_deploy_v1_cloud_deploy_proto_enumTypes = make([]protoimpl.EnumInfo, 12)
var file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes = make([]protoimpl.MessageInfo, 74)
var file_google_cloud_deploy_v1_cloud_deploy_proto_goTypes = []interface{}{
	(ExecutionConfig_ExecutionEnvironmentUsage)(0), // 0: google.cloud.deploy.v1.ExecutionConfig.ExecutionEnvironmentUsage
	(Release_RenderState)(0),                       // 1: google.cloud.deploy.v1.Release.RenderState
	(Release_TargetRender_TargetRenderState)(0),    // 2: google.cloud.deploy.v1.Release.TargetRender.TargetRenderState
	(Release_TargetRender_FailureCause)(0),         // 3: google.cloud.deploy.v1.Release.TargetRender.FailureCause
	(Rollout_ApprovalState)(0),                     // 4: google.cloud.deploy.v1.Rollout.ApprovalState
	(Rollout_State)(0),                             // 5: google.cloud.deploy.v1.Rollout.State
	(Rollout_FailureCause)(0),                      // 6: google.cloud.deploy.v1.Rollout.FailureCause
	(Phase_State)(0),                               // 7: google.cloud.deploy.v1.Phase.State
	(Job_State)(0),                                 // 8: google.cloud.deploy.v1.Job.State
	(JobRun_State)(0),                              // 9: google.cloud.deploy.v1.JobRun.State
	(DeployJobRun_FailureCause)(0),                 // 10: google.cloud.deploy.v1.DeployJobRun.FailureCause
	(VerifyJobRun_FailureCause)(0),                 // 11: google.cloud.deploy.v1.VerifyJobRun.FailureCause
	(*DeliveryPipeline)(nil),                       // 12: google.cloud.deploy.v1.DeliveryPipeline
	(*SerialPipeline)(nil),                         // 13: google.cloud.deploy.v1.SerialPipeline
	(*Stage)(nil),                                  // 14: google.cloud.deploy.v1.Stage
	(*Strategy)(nil),                               // 15: google.cloud.deploy.v1.Strategy
	(*Standard)(nil),                               // 16: google.cloud.deploy.v1.Standard
	(*PipelineReadyCondition)(nil),                 // 17: google.cloud.deploy.v1.PipelineReadyCondition
	(*TargetsPresentCondition)(nil),                // 18: google.cloud.deploy.v1.TargetsPresentCondition
	(*PipelineCondition)(nil),                      // 19: google.cloud.deploy.v1.PipelineCondition
	(*ListDeliveryPipelinesRequest)(nil),           // 20: google.cloud.deploy.v1.ListDeliveryPipelinesRequest
	(*ListDeliveryPipelinesResponse)(nil),          // 21: google.cloud.deploy.v1.ListDeliveryPipelinesResponse
	(*GetDeliveryPipelineRequest)(nil),             // 22: google.cloud.deploy.v1.GetDeliveryPipelineRequest
	(*CreateDeliveryPipelineRequest)(nil),          // 23: google.cloud.deploy.v1.CreateDeliveryPipelineRequest
	(*UpdateDeliveryPipelineRequest)(nil),          // 24: google.cloud.deploy.v1.UpdateDeliveryPipelineRequest
	(*DeleteDeliveryPipelineRequest)(nil),          // 25: google.cloud.deploy.v1.DeleteDeliveryPipelineRequest
	(*Target)(nil),                                 // 26: google.cloud.deploy.v1.Target
	(*ExecutionConfig)(nil),                        // 27: google.cloud.deploy.v1.ExecutionConfig
	(*DefaultPool)(nil),                            // 28: google.cloud.deploy.v1.DefaultPool
	(*PrivatePool)(nil),                            // 29: google.cloud.deploy.v1.PrivatePool
	(*GkeCluster)(nil),                             // 30: google.cloud.deploy.v1.GkeCluster
	(*AnthosCluster)(nil),                          // 31: google.cloud.deploy.v1.AnthosCluster
	(*CloudRunLocation)(nil),                       // 32: google.cloud.deploy.v1.CloudRunLocation
	(*ListTargetsRequest)(nil),                     // 33: google.cloud.deploy.v1.ListTargetsRequest
	(*ListTargetsResponse)(nil),                    // 34: google.cloud.deploy.v1.ListTargetsResponse
	(*GetTargetRequest)(nil),                       // 35: google.cloud.deploy.v1.GetTargetRequest
	(*CreateTargetRequest)(nil),                    // 36: google.cloud.deploy.v1.CreateTargetRequest
	(*UpdateTargetRequest)(nil),                    // 37: google.cloud.deploy.v1.UpdateTargetRequest
	(*DeleteTargetRequest)(nil),                    // 38: google.cloud.deploy.v1.DeleteTargetRequest
	(*Release)(nil),                                // 39: google.cloud.deploy.v1.Release
	(*BuildArtifact)(nil),                          // 40: google.cloud.deploy.v1.BuildArtifact
	(*TargetArtifact)(nil),                         // 41: google.cloud.deploy.v1.TargetArtifact
	(*ListReleasesRequest)(nil),                    // 42: google.cloud.deploy.v1.ListReleasesRequest
	(*ListReleasesResponse)(nil),                   // 43: google.cloud.deploy.v1.ListReleasesResponse
	(*GetReleaseRequest)(nil),                      // 44: google.cloud.deploy.v1.GetReleaseRequest
	(*CreateReleaseRequest)(nil),                   // 45: google.cloud.deploy.v1.CreateReleaseRequest
	(*Rollout)(nil),                                // 46: google.cloud.deploy.v1.Rollout
	(*Metadata)(nil),                               // 47: google.cloud.deploy.v1.Metadata
	(*DeployJobRunMetadata)(nil),                   // 48: google.cloud.deploy.v1.DeployJobRunMetadata
	(*CloudRunMetadata)(nil),                       // 49: google.cloud.deploy.v1.CloudRunMetadata
	(*Phase)(nil),                                  // 50: google.cloud.deploy.v1.Phase
	(*DeploymentJobs)(nil),                         // 51: google.cloud.deploy.v1.DeploymentJobs
	(*Job)(nil),                                    // 52: google.cloud.deploy.v1.Job
	(*DeployJob)(nil),                              // 53: google.cloud.deploy.v1.DeployJob
	(*VerifyJob)(nil),                              // 54: google.cloud.deploy.v1.VerifyJob
	(*ListRolloutsRequest)(nil),                    // 55: google.cloud.deploy.v1.ListRolloutsRequest
	(*ListRolloutsResponse)(nil),                   // 56: google.cloud.deploy.v1.ListRolloutsResponse
	(*GetRolloutRequest)(nil),                      // 57: google.cloud.deploy.v1.GetRolloutRequest
	(*CreateRolloutRequest)(nil),                   // 58: google.cloud.deploy.v1.CreateRolloutRequest
	(*OperationMetadata)(nil),                      // 59: google.cloud.deploy.v1.OperationMetadata
	(*ApproveRolloutRequest)(nil),                  // 60: google.cloud.deploy.v1.ApproveRolloutRequest
	(*ApproveRolloutResponse)(nil),                 // 61: google.cloud.deploy.v1.ApproveRolloutResponse
	(*RetryJobRequest)(nil),                        // 62: google.cloud.deploy.v1.RetryJobRequest
	(*RetryJobResponse)(nil),                       // 63: google.cloud.deploy.v1.RetryJobResponse
	(*AbandonReleaseRequest)(nil),                  // 64: google.cloud.deploy.v1.AbandonReleaseRequest
	(*AbandonReleaseResponse)(nil),                 // 65: google.cloud.deploy.v1.AbandonReleaseResponse
	(*JobRun)(nil),                                 // 66: google.cloud.deploy.v1.JobRun
	(*DeployJobRun)(nil),                           // 67: google.cloud.deploy.v1.DeployJobRun
	(*VerifyJobRun)(nil),                           // 68: google.cloud.deploy.v1.VerifyJobRun
	(*ListJobRunsRequest)(nil),                     // 69: google.cloud.deploy.v1.ListJobRunsRequest
	(*ListJobRunsResponse)(nil),                    // 70: google.cloud.deploy.v1.ListJobRunsResponse
	(*GetJobRunRequest)(nil),                       // 71: google.cloud.deploy.v1.GetJobRunRequest
	(*Config)(nil),                                 // 72: google.cloud.deploy.v1.Config
	(*SkaffoldVersion)(nil),                        // 73: google.cloud.deploy.v1.SkaffoldVersion
	(*GetConfigRequest)(nil),                       // 74: google.cloud.deploy.v1.GetConfigRequest
	nil,                                            // 75: google.cloud.deploy.v1.DeliveryPipeline.AnnotationsEntry
	nil,                                            // 76: google.cloud.deploy.v1.DeliveryPipeline.LabelsEntry
	nil,                                            // 77: google.cloud.deploy.v1.Target.AnnotationsEntry
	nil,                                            // 78: google.cloud.deploy.v1.Target.LabelsEntry
	(*Release_TargetRender)(nil),                   // 79: google.cloud.deploy.v1.Release.TargetRender
	nil,                                            // 80: google.cloud.deploy.v1.Release.AnnotationsEntry
	nil,                                            // 81: google.cloud.deploy.v1.Release.LabelsEntry
	nil,                                            // 82: google.cloud.deploy.v1.Release.TargetArtifactsEntry
	nil,                                            // 83: google.cloud.deploy.v1.Release.TargetRendersEntry
	nil,                                            // 84: google.cloud.deploy.v1.Rollout.AnnotationsEntry
	nil,                                            // 85: google.cloud.deploy.v1.Rollout.LabelsEntry
	(*timestamppb.Timestamp)(nil),                  // 86: google.protobuf.Timestamp
	(*fieldmaskpb.FieldMask)(nil),                  // 87: google.protobuf.FieldMask
	(*durationpb.Duration)(nil),                    // 88: google.protobuf.Duration
	(*date.Date)(nil),                              // 89: google.type.Date
	(*longrunning.Operation)(nil),                  // 90: google.longrunning.Operation
}
var file_google_cloud_deploy_v1_cloud_deploy_proto_depIdxs = []int32{
	75,  // 0: google.cloud.deploy.v1.DeliveryPipeline.annotations:type_name -> google.cloud.deploy.v1.DeliveryPipeline.AnnotationsEntry
	76,  // 1: google.cloud.deploy.v1.DeliveryPipeline.labels:type_name -> google.cloud.deploy.v1.DeliveryPipeline.LabelsEntry
	86,  // 2: google.cloud.deploy.v1.DeliveryPipeline.create_time:type_name -> google.protobuf.Timestamp
	86,  // 3: google.cloud.deploy.v1.DeliveryPipeline.update_time:type_name -> google.protobuf.Timestamp
	13,  // 4: google.cloud.deploy.v1.DeliveryPipeline.serial_pipeline:type_name -> google.cloud.deploy.v1.SerialPipeline
	19,  // 5: google.cloud.deploy.v1.DeliveryPipeline.condition:type_name -> google.cloud.deploy.v1.PipelineCondition
	14,  // 6: google.cloud.deploy.v1.SerialPipeline.stages:type_name -> google.cloud.deploy.v1.Stage
	15,  // 7: google.cloud.deploy.v1.Stage.strategy:type_name -> google.cloud.deploy.v1.Strategy
	16,  // 8: google.cloud.deploy.v1.Strategy.standard:type_name -> google.cloud.deploy.v1.Standard
	86,  // 9: google.cloud.deploy.v1.PipelineReadyCondition.update_time:type_name -> google.protobuf.Timestamp
	86,  // 10: google.cloud.deploy.v1.TargetsPresentCondition.update_time:type_name -> google.protobuf.Timestamp
	17,  // 11: google.cloud.deploy.v1.PipelineCondition.pipeline_ready_condition:type_name -> google.cloud.deploy.v1.PipelineReadyCondition
	18,  // 12: google.cloud.deploy.v1.PipelineCondition.targets_present_condition:type_name -> google.cloud.deploy.v1.TargetsPresentCondition
	12,  // 13: google.cloud.deploy.v1.ListDeliveryPipelinesResponse.delivery_pipelines:type_name -> google.cloud.deploy.v1.DeliveryPipeline
	12,  // 14: google.cloud.deploy.v1.CreateDeliveryPipelineRequest.delivery_pipeline:type_name -> google.cloud.deploy.v1.DeliveryPipeline
	87,  // 15: google.cloud.deploy.v1.UpdateDeliveryPipelineRequest.update_mask:type_name -> google.protobuf.FieldMask
	12,  // 16: google.cloud.deploy.v1.UpdateDeliveryPipelineRequest.delivery_pipeline:type_name -> google.cloud.deploy.v1.DeliveryPipeline
	77,  // 17: google.cloud.deploy.v1.Target.annotations:type_name -> google.cloud.deploy.v1.Target.AnnotationsEntry
	78,  // 18: google.cloud.deploy.v1.Target.labels:type_name -> google.cloud.deploy.v1.Target.LabelsEntry
	86,  // 19: google.cloud.deploy.v1.Target.create_time:type_name -> google.protobuf.Timestamp
	86,  // 20: google.cloud.deploy.v1.Target.update_time:type_name -> google.protobuf.Timestamp
	30,  // 21: google.cloud.deploy.v1.Target.gke:type_name -> google.cloud.deploy.v1.GkeCluster
	31,  // 22: google.cloud.deploy.v1.Target.anthos_cluster:type_name -> google.cloud.deploy.v1.AnthosCluster
	32,  // 23: google.cloud.deploy.v1.Target.run:type_name -> google.cloud.deploy.v1.CloudRunLocation
	27,  // 24: google.cloud.deploy.v1.Target.execution_configs:type_name -> google.cloud.deploy.v1.ExecutionConfig
	0,   // 25: google.cloud.deploy.v1.ExecutionConfig.usages:type_name -> google.cloud.deploy.v1.ExecutionConfig.ExecutionEnvironmentUsage
	28,  // 26: google.cloud.deploy.v1.ExecutionConfig.default_pool:type_name -> google.cloud.deploy.v1.DefaultPool
	29,  // 27: google.cloud.deploy.v1.ExecutionConfig.private_pool:type_name -> google.cloud.deploy.v1.PrivatePool
	88,  // 28: google.cloud.deploy.v1.ExecutionConfig.execution_timeout:type_name -> google.protobuf.Duration
	26,  // 29: google.cloud.deploy.v1.ListTargetsResponse.targets:type_name -> google.cloud.deploy.v1.Target
	26,  // 30: google.cloud.deploy.v1.CreateTargetRequest.target:type_name -> google.cloud.deploy.v1.Target
	87,  // 31: google.cloud.deploy.v1.UpdateTargetRequest.update_mask:type_name -> google.protobuf.FieldMask
	26,  // 32: google.cloud.deploy.v1.UpdateTargetRequest.target:type_name -> google.cloud.deploy.v1.Target
	80,  // 33: google.cloud.deploy.v1.Release.annotations:type_name -> google.cloud.deploy.v1.Release.AnnotationsEntry
	81,  // 34: google.cloud.deploy.v1.Release.labels:type_name -> google.cloud.deploy.v1.Release.LabelsEntry
	86,  // 35: google.cloud.deploy.v1.Release.create_time:type_name -> google.protobuf.Timestamp
	86,  // 36: google.cloud.deploy.v1.Release.render_start_time:type_name -> google.protobuf.Timestamp
	86,  // 37: google.cloud.deploy.v1.Release.render_end_time:type_name -> google.protobuf.Timestamp
	40,  // 38: google.cloud.deploy.v1.Release.build_artifacts:type_name -> google.cloud.deploy.v1.BuildArtifact
	12,  // 39: google.cloud.deploy.v1.Release.delivery_pipeline_snapshot:type_name -> google.cloud.deploy.v1.DeliveryPipeline
	26,  // 40: google.cloud.deploy.v1.Release.target_snapshots:type_name -> google.cloud.deploy.v1.Target
	1,   // 41: google.cloud.deploy.v1.Release.render_state:type_name -> google.cloud.deploy.v1.Release.RenderState
	82,  // 42: google.cloud.deploy.v1.Release.target_artifacts:type_name -> google.cloud.deploy.v1.Release.TargetArtifactsEntry
	83,  // 43: google.cloud.deploy.v1.Release.target_renders:type_name -> google.cloud.deploy.v1.Release.TargetRendersEntry
	39,  // 44: google.cloud.deploy.v1.ListReleasesResponse.releases:type_name -> google.cloud.deploy.v1.Release
	39,  // 45: google.cloud.deploy.v1.CreateReleaseRequest.release:type_name -> google.cloud.deploy.v1.Release
	84,  // 46: google.cloud.deploy.v1.Rollout.annotations:type_name -> google.cloud.deploy.v1.Rollout.AnnotationsEntry
	85,  // 47: google.cloud.deploy.v1.Rollout.labels:type_name -> google.cloud.deploy.v1.Rollout.LabelsEntry
	86,  // 48: google.cloud.deploy.v1.Rollout.create_time:type_name -> google.protobuf.Timestamp
	86,  // 49: google.cloud.deploy.v1.Rollout.approve_time:type_name -> google.protobuf.Timestamp
	86,  // 50: google.cloud.deploy.v1.Rollout.enqueue_time:type_name -> google.protobuf.Timestamp
	86,  // 51: google.cloud.deploy.v1.Rollout.deploy_start_time:type_name -> google.protobuf.Timestamp
	86,  // 52: google.cloud.deploy.v1.Rollout.deploy_end_time:type_name -> google.protobuf.Timestamp
	4,   // 53: google.cloud.deploy.v1.Rollout.approval_state:type_name -> google.cloud.deploy.v1.Rollout.ApprovalState
	5,   // 54: google.cloud.deploy.v1.Rollout.state:type_name -> google.cloud.deploy.v1.Rollout.State
	6,   // 55: google.cloud.deploy.v1.Rollout.deploy_failure_cause:type_name -> google.cloud.deploy.v1.Rollout.FailureCause
	50,  // 56: google.cloud.deploy.v1.Rollout.phases:type_name -> google.cloud.deploy.v1.Phase
	47,  // 57: google.cloud.deploy.v1.Rollout.metadata:type_name -> google.cloud.deploy.v1.Metadata
	49,  // 58: google.cloud.deploy.v1.Metadata.cloud_run:type_name -> google.cloud.deploy.v1.CloudRunMetadata
	49,  // 59: google.cloud.deploy.v1.DeployJobRunMetadata.cloud_run:type_name -> google.cloud.deploy.v1.CloudRunMetadata
	7,   // 60: google.cloud.deploy.v1.Phase.state:type_name -> google.cloud.deploy.v1.Phase.State
	51,  // 61: google.cloud.deploy.v1.Phase.deployment_jobs:type_name -> google.cloud.deploy.v1.DeploymentJobs
	52,  // 62: google.cloud.deploy.v1.DeploymentJobs.deploy_job:type_name -> google.cloud.deploy.v1.Job
	52,  // 63: google.cloud.deploy.v1.DeploymentJobs.verify_job:type_name -> google.cloud.deploy.v1.Job
	8,   // 64: google.cloud.deploy.v1.Job.state:type_name -> google.cloud.deploy.v1.Job.State
	53,  // 65: google.cloud.deploy.v1.Job.deploy_job:type_name -> google.cloud.deploy.v1.DeployJob
	54,  // 66: google.cloud.deploy.v1.Job.verify_job:type_name -> google.cloud.deploy.v1.VerifyJob
	46,  // 67: google.cloud.deploy.v1.ListRolloutsResponse.rollouts:type_name -> google.cloud.deploy.v1.Rollout
	46,  // 68: google.cloud.deploy.v1.CreateRolloutRequest.rollout:type_name -> google.cloud.deploy.v1.Rollout
	86,  // 69: google.cloud.deploy.v1.OperationMetadata.create_time:type_name -> google.protobuf.Timestamp
	86,  // 70: google.cloud.deploy.v1.OperationMetadata.end_time:type_name -> google.protobuf.Timestamp
	86,  // 71: google.cloud.deploy.v1.JobRun.create_time:type_name -> google.protobuf.Timestamp
	86,  // 72: google.cloud.deploy.v1.JobRun.start_time:type_name -> google.protobuf.Timestamp
	86,  // 73: google.cloud.deploy.v1.JobRun.end_time:type_name -> google.protobuf.Timestamp
	9,   // 74: google.cloud.deploy.v1.JobRun.state:type_name -> google.cloud.deploy.v1.JobRun.State
	67,  // 75: google.cloud.deploy.v1.JobRun.deploy_job_run:type_name -> google.cloud.deploy.v1.DeployJobRun
	68,  // 76: google.cloud.deploy.v1.JobRun.verify_job_run:type_name -> google.cloud.deploy.v1.VerifyJobRun
	10,  // 77: google.cloud.deploy.v1.DeployJobRun.failure_cause:type_name -> google.cloud.deploy.v1.DeployJobRun.FailureCause
	48,  // 78: google.cloud.deploy.v1.DeployJobRun.metadata:type_name -> google.cloud.deploy.v1.DeployJobRunMetadata
	11,  // 79: google.cloud.deploy.v1.VerifyJobRun.failure_cause:type_name -> google.cloud.deploy.v1.VerifyJobRun.FailureCause
	66,  // 80: google.cloud.deploy.v1.ListJobRunsResponse.job_runs:type_name -> google.cloud.deploy.v1.JobRun
	73,  // 81: google.cloud.deploy.v1.Config.supported_versions:type_name -> google.cloud.deploy.v1.SkaffoldVersion
	89,  // 82: google.cloud.deploy.v1.SkaffoldVersion.support_end_date:type_name -> google.type.Date
	2,   // 83: google.cloud.deploy.v1.Release.TargetRender.rendering_state:type_name -> google.cloud.deploy.v1.Release.TargetRender.TargetRenderState
	3,   // 84: google.cloud.deploy.v1.Release.TargetRender.failure_cause:type_name -> google.cloud.deploy.v1.Release.TargetRender.FailureCause
	41,  // 85: google.cloud.deploy.v1.Release.TargetArtifactsEntry.value:type_name -> google.cloud.deploy.v1.TargetArtifact
	79,  // 86: google.cloud.deploy.v1.Release.TargetRendersEntry.value:type_name -> google.cloud.deploy.v1.Release.TargetRender
	20,  // 87: google.cloud.deploy.v1.CloudDeploy.ListDeliveryPipelines:input_type -> google.cloud.deploy.v1.ListDeliveryPipelinesRequest
	22,  // 88: google.cloud.deploy.v1.CloudDeploy.GetDeliveryPipeline:input_type -> google.cloud.deploy.v1.GetDeliveryPipelineRequest
	23,  // 89: google.cloud.deploy.v1.CloudDeploy.CreateDeliveryPipeline:input_type -> google.cloud.deploy.v1.CreateDeliveryPipelineRequest
	24,  // 90: google.cloud.deploy.v1.CloudDeploy.UpdateDeliveryPipeline:input_type -> google.cloud.deploy.v1.UpdateDeliveryPipelineRequest
	25,  // 91: google.cloud.deploy.v1.CloudDeploy.DeleteDeliveryPipeline:input_type -> google.cloud.deploy.v1.DeleteDeliveryPipelineRequest
	33,  // 92: google.cloud.deploy.v1.CloudDeploy.ListTargets:input_type -> google.cloud.deploy.v1.ListTargetsRequest
	35,  // 93: google.cloud.deploy.v1.CloudDeploy.GetTarget:input_type -> google.cloud.deploy.v1.GetTargetRequest
	36,  // 94: google.cloud.deploy.v1.CloudDeploy.CreateTarget:input_type -> google.cloud.deploy.v1.CreateTargetRequest
	37,  // 95: google.cloud.deploy.v1.CloudDeploy.UpdateTarget:input_type -> google.cloud.deploy.v1.UpdateTargetRequest
	38,  // 96: google.cloud.deploy.v1.CloudDeploy.DeleteTarget:input_type -> google.cloud.deploy.v1.DeleteTargetRequest
	42,  // 97: google.cloud.deploy.v1.CloudDeploy.ListReleases:input_type -> google.cloud.deploy.v1.ListReleasesRequest
	44,  // 98: google.cloud.deploy.v1.CloudDeploy.GetRelease:input_type -> google.cloud.deploy.v1.GetReleaseRequest
	45,  // 99: google.cloud.deploy.v1.CloudDeploy.CreateRelease:input_type -> google.cloud.deploy.v1.CreateReleaseRequest
	64,  // 100: google.cloud.deploy.v1.CloudDeploy.AbandonRelease:input_type -> google.cloud.deploy.v1.AbandonReleaseRequest
	60,  // 101: google.cloud.deploy.v1.CloudDeploy.ApproveRollout:input_type -> google.cloud.deploy.v1.ApproveRolloutRequest
	55,  // 102: google.cloud.deploy.v1.CloudDeploy.ListRollouts:input_type -> google.cloud.deploy.v1.ListRolloutsRequest
	57,  // 103: google.cloud.deploy.v1.CloudDeploy.GetRollout:input_type -> google.cloud.deploy.v1.GetRolloutRequest
	58,  // 104: google.cloud.deploy.v1.CloudDeploy.CreateRollout:input_type -> google.cloud.deploy.v1.CreateRolloutRequest
	62,  // 105: google.cloud.deploy.v1.CloudDeploy.RetryJob:input_type -> google.cloud.deploy.v1.RetryJobRequest
	69,  // 106: google.cloud.deploy.v1.CloudDeploy.ListJobRuns:input_type -> google.cloud.deploy.v1.ListJobRunsRequest
	71,  // 107: google.cloud.deploy.v1.CloudDeploy.GetJobRun:input_type -> google.cloud.deploy.v1.GetJobRunRequest
	74,  // 108: google.cloud.deploy.v1.CloudDeploy.GetConfig:input_type -> google.cloud.deploy.v1.GetConfigRequest
	21,  // 109: google.cloud.deploy.v1.CloudDeploy.ListDeliveryPipelines:output_type -> google.cloud.deploy.v1.ListDeliveryPipelinesResponse
	12,  // 110: google.cloud.deploy.v1.CloudDeploy.GetDeliveryPipeline:output_type -> google.cloud.deploy.v1.DeliveryPipeline
	90,  // 111: google.cloud.deploy.v1.CloudDeploy.CreateDeliveryPipeline:output_type -> google.longrunning.Operation
	90,  // 112: google.cloud.deploy.v1.CloudDeploy.UpdateDeliveryPipeline:output_type -> google.longrunning.Operation
	90,  // 113: google.cloud.deploy.v1.CloudDeploy.DeleteDeliveryPipeline:output_type -> google.longrunning.Operation
	34,  // 114: google.cloud.deploy.v1.CloudDeploy.ListTargets:output_type -> google.cloud.deploy.v1.ListTargetsResponse
	26,  // 115: google.cloud.deploy.v1.CloudDeploy.GetTarget:output_type -> google.cloud.deploy.v1.Target
	90,  // 116: google.cloud.deploy.v1.CloudDeploy.CreateTarget:output_type -> google.longrunning.Operation
	90,  // 117: google.cloud.deploy.v1.CloudDeploy.UpdateTarget:output_type -> google.longrunning.Operation
	90,  // 118: google.cloud.deploy.v1.CloudDeploy.DeleteTarget:output_type -> google.longrunning.Operation
	43,  // 119: google.cloud.deploy.v1.CloudDeploy.ListReleases:output_type -> google.cloud.deploy.v1.ListReleasesResponse
	39,  // 120: google.cloud.deploy.v1.CloudDeploy.GetRelease:output_type -> google.cloud.deploy.v1.Release
	90,  // 121: google.cloud.deploy.v1.CloudDeploy.CreateRelease:output_type -> google.longrunning.Operation
	65,  // 122: google.cloud.deploy.v1.CloudDeploy.AbandonRelease:output_type -> google.cloud.deploy.v1.AbandonReleaseResponse
	61,  // 123: google.cloud.deploy.v1.CloudDeploy.ApproveRollout:output_type -> google.cloud.deploy.v1.ApproveRolloutResponse
	56,  // 124: google.cloud.deploy.v1.CloudDeploy.ListRollouts:output_type -> google.cloud.deploy.v1.ListRolloutsResponse
	46,  // 125: google.cloud.deploy.v1.CloudDeploy.GetRollout:output_type -> google.cloud.deploy.v1.Rollout
	90,  // 126: google.cloud.deploy.v1.CloudDeploy.CreateRollout:output_type -> google.longrunning.Operation
	63,  // 127: google.cloud.deploy.v1.CloudDeploy.RetryJob:output_type -> google.cloud.deploy.v1.RetryJobResponse
	70,  // 128: google.cloud.deploy.v1.CloudDeploy.ListJobRuns:output_type -> google.cloud.deploy.v1.ListJobRunsResponse
	66,  // 129: google.cloud.deploy.v1.CloudDeploy.GetJobRun:output_type -> google.cloud.deploy.v1.JobRun
	72,  // 130: google.cloud.deploy.v1.CloudDeploy.GetConfig:output_type -> google.cloud.deploy.v1.Config
	109, // [109:131] is the sub-list for method output_type
	87,  // [87:109] is the sub-list for method input_type
	87,  // [87:87] is the sub-list for extension type_name
	87,  // [87:87] is the sub-list for extension extendee
	0,   // [0:87] is the sub-list for field type_name
}

func init() { file_google_cloud_deploy_v1_cloud_deploy_proto_init() }
func file_google_cloud_deploy_v1_cloud_deploy_proto_init() {
	if File_google_cloud_deploy_v1_cloud_deploy_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeliveryPipeline); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SerialPipeline); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Stage); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Strategy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Standard); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PipelineReadyCondition); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TargetsPresentCondition); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PipelineCondition); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListDeliveryPipelinesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListDeliveryPipelinesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetDeliveryPipelineRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateDeliveryPipelineRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateDeliveryPipelineRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteDeliveryPipelineRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Target); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecutionConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DefaultPool); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PrivatePool); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GkeCluster); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnthosCluster); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CloudRunLocation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListTargetsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListTargetsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetTargetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateTargetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateTargetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteTargetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Release); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BuildArtifact); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TargetArtifact); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListReleasesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListReleasesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetReleaseRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateReleaseRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Rollout); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Metadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[36].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeployJobRunMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[37].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CloudRunMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[38].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Phase); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[39].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeploymentJobs); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[40].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Job); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[41].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeployJob); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[42].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VerifyJob); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[43].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListRolloutsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[44].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListRolloutsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[45].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetRolloutRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[46].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateRolloutRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[47].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[48].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApproveRolloutRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[49].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApproveRolloutResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[50].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RetryJobRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[51].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RetryJobResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[52].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AbandonReleaseRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[53].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AbandonReleaseResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[54].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*JobRun); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[55].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeployJobRun); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[56].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VerifyJobRun); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[57].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListJobRunsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[58].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListJobRunsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[59].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetJobRunRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[60].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Config); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[61].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SkaffoldVersion); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[62].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[67].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Release_TargetRender); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*DeliveryPipeline_SerialPipeline)(nil),
	}
	file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[3].OneofWrappers = []interface{}{
		(*Strategy_Standard)(nil),
	}
	file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[14].OneofWrappers = []interface{}{
		(*Target_Gke)(nil),
		(*Target_AnthosCluster)(nil),
		(*Target_Run)(nil),
	}
	file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[15].OneofWrappers = []interface{}{
		(*ExecutionConfig_DefaultPool)(nil),
		(*ExecutionConfig_PrivatePool)(nil),
	}
	file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[29].OneofWrappers = []interface{}{
		(*TargetArtifact_ArtifactUri)(nil),
	}
	file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[38].OneofWrappers = []interface{}{
		(*Phase_DeploymentJobs)(nil),
	}
	file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[40].OneofWrappers = []interface{}{
		(*Job_DeployJob)(nil),
		(*Job_VerifyJob)(nil),
	}
	file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes[54].OneofWrappers = []interface{}{
		(*JobRun_DeployJobRun)(nil),
		(*JobRun_VerifyJobRun)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_deploy_v1_cloud_deploy_proto_rawDesc,
			NumEnums:      12,
			NumMessages:   74,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_deploy_v1_cloud_deploy_proto_goTypes,
		DependencyIndexes: file_google_cloud_deploy_v1_cloud_deploy_proto_depIdxs,
		EnumInfos:         file_google_cloud_deploy_v1_cloud_deploy_proto_enumTypes,
		MessageInfos:      file_google_cloud_deploy_v1_cloud_deploy_proto_msgTypes,
	}.Build()
	File_google_cloud_deploy_v1_cloud_deploy_proto = out.File
	file_google_cloud_deploy_v1_cloud_deploy_proto_rawDesc = nil
	file_google_cloud_deploy_v1_cloud_deploy_proto_goTypes = nil
	file_google_cloud_deploy_v1_cloud_deploy_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// CloudDeployClient is the client API for CloudDeploy service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type CloudDeployClient interface {
	// Lists DeliveryPipelines in a given project and location.
	ListDeliveryPipelines(ctx context.Context, in *ListDeliveryPipelinesRequest, opts ...grpc.CallOption) (*ListDeliveryPipelinesResponse, error)
	// Gets details of a single DeliveryPipeline.
	GetDeliveryPipeline(ctx context.Context, in *GetDeliveryPipelineRequest, opts ...grpc.CallOption) (*DeliveryPipeline, error)
	// Creates a new DeliveryPipeline in a given project and location.
	CreateDeliveryPipeline(ctx context.Context, in *CreateDeliveryPipelineRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Updates the parameters of a single DeliveryPipeline.
	UpdateDeliveryPipeline(ctx context.Context, in *UpdateDeliveryPipelineRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Deletes a single DeliveryPipeline.
	DeleteDeliveryPipeline(ctx context.Context, in *DeleteDeliveryPipelineRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Lists Targets in a given project and location.
	ListTargets(ctx context.Context, in *ListTargetsRequest, opts ...grpc.CallOption) (*ListTargetsResponse, error)
	// Gets details of a single Target.
	GetTarget(ctx context.Context, in *GetTargetRequest, opts ...grpc.CallOption) (*Target, error)
	// Creates a new Target in a given project and location.
	CreateTarget(ctx context.Context, in *CreateTargetRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Updates the parameters of a single Target.
	UpdateTarget(ctx context.Context, in *UpdateTargetRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Deletes a single Target.
	DeleteTarget(ctx context.Context, in *DeleteTargetRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Lists Releases in a given project and location.
	ListReleases(ctx context.Context, in *ListReleasesRequest, opts ...grpc.CallOption) (*ListReleasesResponse, error)
	// Gets details of a single Release.
	GetRelease(ctx context.Context, in *GetReleaseRequest, opts ...grpc.CallOption) (*Release, error)
	// Creates a new Release in a given project and location.
	CreateRelease(ctx context.Context, in *CreateReleaseRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Abandons a Release in the Delivery Pipeline.
	AbandonRelease(ctx context.Context, in *AbandonReleaseRequest, opts ...grpc.CallOption) (*AbandonReleaseResponse, error)
	// Approves a Rollout.
	ApproveRollout(ctx context.Context, in *ApproveRolloutRequest, opts ...grpc.CallOption) (*ApproveRolloutResponse, error)
	// Lists Rollouts in a given project and location.
	ListRollouts(ctx context.Context, in *ListRolloutsRequest, opts ...grpc.CallOption) (*ListRolloutsResponse, error)
	// Gets details of a single Rollout.
	GetRollout(ctx context.Context, in *GetRolloutRequest, opts ...grpc.CallOption) (*Rollout, error)
	// Creates a new Rollout in a given project and location.
	CreateRollout(ctx context.Context, in *CreateRolloutRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Retries the specified Job in a Rollout.
	RetryJob(ctx context.Context, in *RetryJobRequest, opts ...grpc.CallOption) (*RetryJobResponse, error)
	// Lists JobRuns in a given project and location.
	ListJobRuns(ctx context.Context, in *ListJobRunsRequest, opts ...grpc.CallOption) (*ListJobRunsResponse, error)
	// Gets details of a single JobRun.
	GetJobRun(ctx context.Context, in *GetJobRunRequest, opts ...grpc.CallOption) (*JobRun, error)
	// Gets the configuration for a location.
	GetConfig(ctx context.Context, in *GetConfigRequest, opts ...grpc.CallOption) (*Config, error)
}

type cloudDeployClient struct {
	cc grpc.ClientConnInterface
}

func NewCloudDeployClient(cc grpc.ClientConnInterface) CloudDeployClient {
	return &cloudDeployClient{cc}
}

func (c *cloudDeployClient) ListDeliveryPipelines(ctx context.Context, in *ListDeliveryPipelinesRequest, opts ...grpc.CallOption) (*ListDeliveryPipelinesResponse, error) {
	out := new(ListDeliveryPipelinesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.deploy.v1.CloudDeploy/ListDeliveryPipelines", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) GetDeliveryPipeline(ctx context.Context, in *GetDeliveryPipelineRequest, opts ...grpc.CallOption) (*DeliveryPipeline, error) {
	out := new(DeliveryPipeline)
	err := c.cc.Invoke(ctx, "/google.cloud.deploy.v1.CloudDeploy/GetDeliveryPipeline", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) CreateDeliveryPipeline(ctx context.Context, in *CreateDeliveryPipelineRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.deploy.v1.CloudDeploy/CreateDeliveryPipeline", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) UpdateDeliveryPipeline(ctx context.Context, in *UpdateDeliveryPipelineRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.deploy.v1.CloudDeploy/UpdateDeliveryPipeline", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) DeleteDeliveryPipeline(ctx context.Context, in *DeleteDeliveryPipelineRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.deploy.v1.CloudDeploy/DeleteDeliveryPipeline", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) ListTargets(ctx context.Context, in *ListTargetsRequest, opts ...grpc.CallOption) (*ListTargetsResponse, error) {
	out := new(ListTargetsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.deploy.v1.CloudDeploy/ListTargets", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) GetTarget(ctx context.Context, in *GetTargetRequest, opts ...grpc.CallOption) (*Target, error) {
	out := new(Target)
	err := c.cc.Invoke(ctx, "/google.cloud.deploy.v1.CloudDeploy/GetTarget", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) CreateTarget(ctx context.Context, in *CreateTargetRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.deploy.v1.CloudDeploy/CreateTarget", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) UpdateTarget(ctx context.Context, in *UpdateTargetRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.deploy.v1.CloudDeploy/UpdateTarget", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) DeleteTarget(ctx context.Context, in *DeleteTargetRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.deploy.v1.CloudDeploy/DeleteTarget", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) ListReleases(ctx context.Context, in *ListReleasesRequest, opts ...grpc.CallOption) (*ListReleasesResponse, error) {
	out := new(ListReleasesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.deploy.v1.CloudDeploy/ListReleases", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) GetRelease(ctx context.Context, in *GetReleaseRequest, opts ...grpc.CallOption) (*Release, error) {
	out := new(Release)
	err := c.cc.Invoke(ctx, "/google.cloud.deploy.v1.CloudDeploy/GetRelease", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) CreateRelease(ctx context.Context, in *CreateReleaseRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.deploy.v1.CloudDeploy/CreateRelease", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) AbandonRelease(ctx context.Context, in *AbandonReleaseRequest, opts ...grpc.CallOption) (*AbandonReleaseResponse, error) {
	out := new(AbandonReleaseResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.deploy.v1.CloudDeploy/AbandonRelease", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) ApproveRollout(ctx context.Context, in *ApproveRolloutRequest, opts ...grpc.CallOption) (*ApproveRolloutResponse, error) {
	out := new(ApproveRolloutResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.deploy.v1.CloudDeploy/ApproveRollout", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) ListRollouts(ctx context.Context, in *ListRolloutsRequest, opts ...grpc.CallOption) (*ListRolloutsResponse, error) {
	out := new(ListRolloutsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.deploy.v1.CloudDeploy/ListRollouts", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) GetRollout(ctx context.Context, in *GetRolloutRequest, opts ...grpc.CallOption) (*Rollout, error) {
	out := new(Rollout)
	err := c.cc.Invoke(ctx, "/google.cloud.deploy.v1.CloudDeploy/GetRollout", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) CreateRollout(ctx context.Context, in *CreateRolloutRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.deploy.v1.CloudDeploy/CreateRollout", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) RetryJob(ctx context.Context, in *RetryJobRequest, opts ...grpc.CallOption) (*RetryJobResponse, error) {
	out := new(RetryJobResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.deploy.v1.CloudDeploy/RetryJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) ListJobRuns(ctx context.Context, in *ListJobRunsRequest, opts ...grpc.CallOption) (*ListJobRunsResponse, error) {
	out := new(ListJobRunsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.deploy.v1.CloudDeploy/ListJobRuns", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) GetJobRun(ctx context.Context, in *GetJobRunRequest, opts ...grpc.CallOption) (*JobRun, error) {
	out := new(JobRun)
	err := c.cc.Invoke(ctx, "/google.cloud.deploy.v1.CloudDeploy/GetJobRun", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudDeployClient) GetConfig(ctx context.Context, in *GetConfigRequest, opts ...grpc.CallOption) (*Config, error) {
	out := new(Config)
	err := c.cc.Invoke(ctx, "/google.cloud.deploy.v1.CloudDeploy/GetConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// CloudDeployServer is the server API for CloudDeploy service.
type CloudDeployServer interface {
	// Lists DeliveryPipelines in a given project and location.
	ListDeliveryPipelines(context.Context, *ListDeliveryPipelinesRequest) (*ListDeliveryPipelinesResponse, error)
	// Gets details of a single DeliveryPipeline.
	GetDeliveryPipeline(context.Context, *GetDeliveryPipelineRequest) (*DeliveryPipeline, error)
	// Creates a new DeliveryPipeline in a given project and location.
	CreateDeliveryPipeline(context.Context, *CreateDeliveryPipelineRequest) (*longrunning.Operation, error)
	// Updates the parameters of a single DeliveryPipeline.
	UpdateDeliveryPipeline(context.Context, *UpdateDeliveryPipelineRequest) (*longrunning.Operation, error)
	// Deletes a single DeliveryPipeline.
	DeleteDeliveryPipeline(context.Context, *DeleteDeliveryPipelineRequest) (*longrunning.Operation, error)
	// Lists Targets in a given project and location.
	ListTargets(context.Context, *ListTargetsRequest) (*ListTargetsResponse, error)
	// Gets details of a single Target.
	GetTarget(context.Context, *GetTargetRequest) (*Target, error)
	// Creates a new Target in a given project and location.
	CreateTarget(context.Context, *CreateTargetRequest) (*longrunning.Operation, error)
	// Updates the parameters of a single Target.
	UpdateTarget(context.Context, *UpdateTargetRequest) (*longrunning.Operation, error)
	// Deletes a single Target.
	DeleteTarget(context.Context, *DeleteTargetRequest) (*longrunning.Operation, error)
	// Lists Releases in a given project and location.
	ListReleases(context.Context, *ListReleasesRequest) (*ListReleasesResponse, error)
	// Gets details of a single Release.
	GetRelease(context.Context, *GetReleaseRequest) (*Release, error)
	// Creates a new Release in a given project and location.
	CreateRelease(context.Context, *CreateReleaseRequest) (*longrunning.Operation, error)
	// Abandons a Release in the Delivery Pipeline.
	AbandonRelease(context.Context, *AbandonReleaseRequest) (*AbandonReleaseResponse, error)
	// Approves a Rollout.
	ApproveRollout(context.Context, *ApproveRolloutRequest) (*ApproveRolloutResponse, error)
	// Lists Rollouts in a given project and location.
	ListRollouts(context.Context, *ListRolloutsRequest) (*ListRolloutsResponse, error)
	// Gets details of a single Rollout.
	GetRollout(context.Context, *GetRolloutRequest) (*Rollout, error)
	// Creates a new Rollout in a given project and location.
	CreateRollout(context.Context, *CreateRolloutRequest) (*longrunning.Operation, error)
	// Retries the specified Job in a Rollout.
	RetryJob(context.Context, *RetryJobRequest) (*RetryJobResponse, error)
	// Lists JobRuns in a given project and location.
	ListJobRuns(context.Context, *ListJobRunsRequest) (*ListJobRunsResponse, error)
	// Gets details of a single JobRun.
	GetJobRun(context.Context, *GetJobRunRequest) (*JobRun, error)
	// Gets the configuration for a location.
	GetConfig(context.Context, *GetConfigRequest) (*Config, error)
}

// UnimplementedCloudDeployServer can be embedded to have forward compatible implementations.
type UnimplementedCloudDeployServer struct {
}

func (*UnimplementedCloudDeployServer) ListDeliveryPipelines(context.Context, *ListDeliveryPipelinesRequest) (*ListDeliveryPipelinesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDeliveryPipelines not implemented")
}
func (*UnimplementedCloudDeployServer) GetDeliveryPipeline(context.Context, *GetDeliveryPipelineRequest) (*DeliveryPipeline, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDeliveryPipeline not implemented")
}
func (*UnimplementedCloudDeployServer) CreateDeliveryPipeline(context.Context, *CreateDeliveryPipelineRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateDeliveryPipeline not implemented")
}
func (*UnimplementedCloudDeployServer) UpdateDeliveryPipeline(context.Context, *UpdateDeliveryPipelineRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateDeliveryPipeline not implemented")
}
func (*UnimplementedCloudDeployServer) DeleteDeliveryPipeline(context.Context, *DeleteDeliveryPipelineRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteDeliveryPipeline not implemented")
}
func (*UnimplementedCloudDeployServer) ListTargets(context.Context, *ListTargetsRequest) (*ListTargetsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListTargets not implemented")
}
func (*UnimplementedCloudDeployServer) GetTarget(context.Context, *GetTargetRequest) (*Target, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetTarget not implemented")
}
func (*UnimplementedCloudDeployServer) CreateTarget(context.Context, *CreateTargetRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateTarget not implemented")
}
func (*UnimplementedCloudDeployServer) UpdateTarget(context.Context, *UpdateTargetRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateTarget not implemented")
}
func (*UnimplementedCloudDeployServer) DeleteTarget(context.Context, *DeleteTargetRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteTarget not implemented")
}
func (*UnimplementedCloudDeployServer) ListReleases(context.Context, *ListReleasesRequest) (*ListReleasesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListReleases not implemented")
}
func (*UnimplementedCloudDeployServer) GetRelease(context.Context, *GetReleaseRequest) (*Release, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetRelease not implemented")
}
func (*UnimplementedCloudDeployServer) CreateRelease(context.Context, *CreateReleaseRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateRelease not implemented")
}
func (*UnimplementedCloudDeployServer) AbandonRelease(context.Context, *AbandonReleaseRequest) (*AbandonReleaseResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AbandonRelease not implemented")
}
func (*UnimplementedCloudDeployServer) ApproveRollout(context.Context, *ApproveRolloutRequest) (*ApproveRolloutResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ApproveRollout not implemented")
}
func (*UnimplementedCloudDeployServer) ListRollouts(context.Context, *ListRolloutsRequest) (*ListRolloutsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListRollouts not implemented")
}
func (*UnimplementedCloudDeployServer) GetRollout(context.Context, *GetRolloutRequest) (*Rollout, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetRollout not implemented")
}
func (*UnimplementedCloudDeployServer) CreateRollout(context.Context, *CreateRolloutRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateRollout not implemented")
}
func (*UnimplementedCloudDeployServer) RetryJob(context.Context, *RetryJobRequest) (*RetryJobResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RetryJob not implemented")
}
func (*UnimplementedCloudDeployServer) ListJobRuns(context.Context, *ListJobRunsRequest) (*ListJobRunsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListJobRuns not implemented")
}
func (*UnimplementedCloudDeployServer) GetJobRun(context.Context, *GetJobRunRequest) (*JobRun, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetJobRun not implemented")
}
func (*UnimplementedCloudDeployServer) GetConfig(context.Context, *GetConfigRequest) (*Config, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetConfig not implemented")
}

func RegisterCloudDeployServer(s *grpc.Server, srv CloudDeployServer) {
	s.RegisterService(&_CloudDeploy_serviceDesc, srv)
}

func _CloudDeploy_ListDeliveryPipelines_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDeliveryPipelinesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).ListDeliveryPipelines(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.deploy.v1.CloudDeploy/ListDeliveryPipelines",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).ListDeliveryPipelines(ctx, req.(*ListDeliveryPipelinesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_GetDeliveryPipeline_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDeliveryPipelineRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).GetDeliveryPipeline(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.deploy.v1.CloudDeploy/GetDeliveryPipeline",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).GetDeliveryPipeline(ctx, req.(*GetDeliveryPipelineRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_CreateDeliveryPipeline_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDeliveryPipelineRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).CreateDeliveryPipeline(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.deploy.v1.CloudDeploy/CreateDeliveryPipeline",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).CreateDeliveryPipeline(ctx, req.(*CreateDeliveryPipelineRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_UpdateDeliveryPipeline_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateDeliveryPipelineRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).UpdateDeliveryPipeline(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.deploy.v1.CloudDeploy/UpdateDeliveryPipeline",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).UpdateDeliveryPipeline(ctx, req.(*UpdateDeliveryPipelineRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_DeleteDeliveryPipeline_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDeliveryPipelineRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).DeleteDeliveryPipeline(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.deploy.v1.CloudDeploy/DeleteDeliveryPipeline",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).DeleteDeliveryPipeline(ctx, req.(*DeleteDeliveryPipelineRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_ListTargets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTargetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).ListTargets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.deploy.v1.CloudDeploy/ListTargets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).ListTargets(ctx, req.(*ListTargetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_GetTarget_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTargetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).GetTarget(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.deploy.v1.CloudDeploy/GetTarget",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).GetTarget(ctx, req.(*GetTargetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_CreateTarget_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateTargetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).CreateTarget(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.deploy.v1.CloudDeploy/CreateTarget",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).CreateTarget(ctx, req.(*CreateTargetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_UpdateTarget_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateTargetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).UpdateTarget(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.deploy.v1.CloudDeploy/UpdateTarget",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).UpdateTarget(ctx, req.(*UpdateTargetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_DeleteTarget_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteTargetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).DeleteTarget(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.deploy.v1.CloudDeploy/DeleteTarget",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).DeleteTarget(ctx, req.(*DeleteTargetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_ListReleases_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListReleasesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).ListReleases(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.deploy.v1.CloudDeploy/ListReleases",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).ListReleases(ctx, req.(*ListReleasesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_GetRelease_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetReleaseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).GetRelease(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.deploy.v1.CloudDeploy/GetRelease",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).GetRelease(ctx, req.(*GetReleaseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_CreateRelease_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateReleaseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).CreateRelease(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.deploy.v1.CloudDeploy/CreateRelease",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).CreateRelease(ctx, req.(*CreateReleaseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_AbandonRelease_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AbandonReleaseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).AbandonRelease(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.deploy.v1.CloudDeploy/AbandonRelease",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).AbandonRelease(ctx, req.(*AbandonReleaseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_ApproveRollout_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ApproveRolloutRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).ApproveRollout(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.deploy.v1.CloudDeploy/ApproveRollout",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).ApproveRollout(ctx, req.(*ApproveRolloutRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_ListRollouts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListRolloutsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).ListRollouts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.deploy.v1.CloudDeploy/ListRollouts",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).ListRollouts(ctx, req.(*ListRolloutsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_GetRollout_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetRolloutRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).GetRollout(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.deploy.v1.CloudDeploy/GetRollout",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).GetRollout(ctx, req.(*GetRolloutRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_CreateRollout_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateRolloutRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).CreateRollout(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.deploy.v1.CloudDeploy/CreateRollout",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).CreateRollout(ctx, req.(*CreateRolloutRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_RetryJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RetryJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).RetryJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.deploy.v1.CloudDeploy/RetryJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).RetryJob(ctx, req.(*RetryJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_ListJobRuns_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListJobRunsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).ListJobRuns(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.deploy.v1.CloudDeploy/ListJobRuns",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).ListJobRuns(ctx, req.(*ListJobRunsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_GetJobRun_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetJobRunRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).GetJobRun(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.deploy.v1.CloudDeploy/GetJobRun",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).GetJobRun(ctx, req.(*GetJobRunRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudDeploy_GetConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudDeployServer).GetConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.deploy.v1.CloudDeploy/GetConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudDeployServer).GetConfig(ctx, req.(*GetConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _CloudDeploy_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.deploy.v1.CloudDeploy",
	HandlerType: (*CloudDeployServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListDeliveryPipelines",
			Handler:    _CloudDeploy_ListDeliveryPipelines_Handler,
		},
		{
			MethodName: "GetDeliveryPipeline",
			Handler:    _CloudDeploy_GetDeliveryPipeline_Handler,
		},
		{
			MethodName: "CreateDeliveryPipeline",
			Handler:    _CloudDeploy_CreateDeliveryPipeline_Handler,
		},
		{
			MethodName: "UpdateDeliveryPipeline",
			Handler:    _CloudDeploy_UpdateDeliveryPipeline_Handler,
		},
		{
			MethodName: "DeleteDeliveryPipeline",
			Handler:    _CloudDeploy_DeleteDeliveryPipeline_Handler,
		},
		{
			MethodName: "ListTargets",
			Handler:    _CloudDeploy_ListTargets_Handler,
		},
		{
			MethodName: "GetTarget",
			Handler:    _CloudDeploy_GetTarget_Handler,
		},
		{
			MethodName: "CreateTarget",
			Handler:    _CloudDeploy_CreateTarget_Handler,
		},
		{
			MethodName: "UpdateTarget",
			Handler:    _CloudDeploy_UpdateTarget_Handler,
		},
		{
			MethodName: "DeleteTarget",
			Handler:    _CloudDeploy_DeleteTarget_Handler,
		},
		{
			MethodName: "ListReleases",
			Handler:    _CloudDeploy_ListReleases_Handler,
		},
		{
			MethodName: "GetRelease",
			Handler:    _CloudDeploy_GetRelease_Handler,
		},
		{
			MethodName: "CreateRelease",
			Handler:    _CloudDeploy_CreateRelease_Handler,
		},
		{
			MethodName: "AbandonRelease",
			Handler:    _CloudDeploy_AbandonRelease_Handler,
		},
		{
			MethodName: "ApproveRollout",
			Handler:    _CloudDeploy_ApproveRollout_Handler,
		},
		{
			MethodName: "ListRollouts",
			Handler:    _CloudDeploy_ListRollouts_Handler,
		},
		{
			MethodName: "GetRollout",
			Handler:    _CloudDeploy_GetRollout_Handler,
		},
		{
			MethodName: "CreateRollout",
			Handler:    _CloudDeploy_CreateRollout_Handler,
		},
		{
			MethodName: "RetryJob",
			Handler:    _CloudDeploy_RetryJob_Handler,
		},
		{
			MethodName: "ListJobRuns",
			Handler:    _CloudDeploy_ListJobRuns_Handler,
		},
		{
			MethodName: "GetJobRun",
			Handler:    _CloudDeploy_GetJobRun_Handler,
		},
		{
			MethodName: "GetConfig",
			Handler:    _CloudDeploy_GetConfig_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/deploy/v1/cloud_deploy.proto",
}
