// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.31.0
// 	protoc        v4.23.2
// source: google/cloud/bigquery/migration/v2/translation_config.proto

package migrationpb

import (
	reflect "reflect"
	sync "sync"

	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The sub-dialect options for Teradata.
type TeradataDialect_Mode int32

const (
	// Unspecified mode.
	TeradataDialect_MODE_UNSPECIFIED TeradataDialect_Mode = 0
	// Teradata SQL mode.
	TeradataDialect_SQL TeradataDialect_Mode = 1
	// BTEQ mode (which includes SQL).
	TeradataDialect_BTEQ TeradataDialect_Mode = 2
)

// Enum value maps for TeradataDialect_Mode.
var (
	TeradataDialect_Mode_name = map[int32]string{
		0: "MODE_UNSPECIFIED",
		1: "SQL",
		2: "BTEQ",
	}
	TeradataDialect_Mode_value = map[string]int32{
		"MODE_UNSPECIFIED": 0,
		"SQL":              1,
		"BTEQ":             2,
	}
)

func (x TeradataDialect_Mode) Enum() *TeradataDialect_Mode {
	p := new(TeradataDialect_Mode)
	*p = x
	return p
}

func (x TeradataDialect_Mode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TeradataDialect_Mode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_bigquery_migration_v2_translation_config_proto_enumTypes[0].Descriptor()
}

func (TeradataDialect_Mode) Type() protoreflect.EnumType {
	return &file_google_cloud_bigquery_migration_v2_translation_config_proto_enumTypes[0]
}

func (x TeradataDialect_Mode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TeradataDialect_Mode.Descriptor instead.
func (TeradataDialect_Mode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_migration_v2_translation_config_proto_rawDescGZIP(), []int{5, 0}
}

// The type of the object that is being mapped.
type NameMappingKey_Type int32

const (
	// Unspecified name mapping type.
	NameMappingKey_TYPE_UNSPECIFIED NameMappingKey_Type = 0
	// The object being mapped is a database.
	NameMappingKey_DATABASE NameMappingKey_Type = 1
	// The object being mapped is a schema.
	NameMappingKey_SCHEMA NameMappingKey_Type = 2
	// The object being mapped is a relation.
	NameMappingKey_RELATION NameMappingKey_Type = 3
	// The object being mapped is an attribute.
	NameMappingKey_ATTRIBUTE NameMappingKey_Type = 4
	// The object being mapped is a relation alias.
	NameMappingKey_RELATION_ALIAS NameMappingKey_Type = 5
	// The object being mapped is a an attribute alias.
	NameMappingKey_ATTRIBUTE_ALIAS NameMappingKey_Type = 6
	// The object being mapped is a function.
	NameMappingKey_FUNCTION NameMappingKey_Type = 7
)

// Enum value maps for NameMappingKey_Type.
var (
	NameMappingKey_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "DATABASE",
		2: "SCHEMA",
		3: "RELATION",
		4: "ATTRIBUTE",
		5: "RELATION_ALIAS",
		6: "ATTRIBUTE_ALIAS",
		7: "FUNCTION",
	}
	NameMappingKey_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"DATABASE":         1,
		"SCHEMA":           2,
		"RELATION":         3,
		"ATTRIBUTE":        4,
		"RELATION_ALIAS":   5,
		"ATTRIBUTE_ALIAS":  6,
		"FUNCTION":         7,
	}
)

func (x NameMappingKey_Type) Enum() *NameMappingKey_Type {
	p := new(NameMappingKey_Type)
	*p = x
	return p
}

func (x NameMappingKey_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NameMappingKey_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_bigquery_migration_v2_translation_config_proto_enumTypes[1].Descriptor()
}

func (NameMappingKey_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_bigquery_migration_v2_translation_config_proto_enumTypes[1]
}

func (x NameMappingKey_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NameMappingKey_Type.Descriptor instead.
func (NameMappingKey_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_migration_v2_translation_config_proto_rawDescGZIP(), []int{18, 0}
}

// The translation config to capture necessary settings for a translation task
// and subtask.
type TranslationConfigDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The chosen path where the source for input files will be found.
	//
	// Types that are assignable to SourceLocation:
	//	*TranslationConfigDetails_GcsSourcePath
	SourceLocation isTranslationConfigDetails_SourceLocation `protobuf_oneof:"source_location"`
	// The chosen path where the destination for output files will be found.
	//
	// Types that are assignable to TargetLocation:
	//	*TranslationConfigDetails_GcsTargetPath
	TargetLocation isTranslationConfigDetails_TargetLocation `protobuf_oneof:"target_location"`
	// The mapping of full SQL object names from their current state to the
	// desired output.
	//
	// Types that are assignable to OutputNameMapping:
	//	*TranslationConfigDetails_NameMappingList
	OutputNameMapping isTranslationConfigDetails_OutputNameMapping `protobuf_oneof:"output_name_mapping"`
	// The dialect of the input files.
	SourceDialect *Dialect `protobuf:"bytes,3,opt,name=source_dialect,json=sourceDialect,proto3" json:"source_dialect,omitempty"`
	// The target dialect for the engine to translate the input to.
	TargetDialect *Dialect `protobuf:"bytes,4,opt,name=target_dialect,json=targetDialect,proto3" json:"target_dialect,omitempty"`
	// The default source environment values for the translation.
	SourceEnv *SourceEnv `protobuf:"bytes,6,opt,name=source_env,json=sourceEnv,proto3" json:"source_env,omitempty"`
	// The indicator to show translation request initiator.
	RequestSource string `protobuf:"bytes,8,opt,name=request_source,json=requestSource,proto3" json:"request_source,omitempty"`
}

func (x *TranslationConfigDetails) Reset() {
	*x = TranslationConfigDetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_migration_v2_translation_config_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TranslationConfigDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TranslationConfigDetails) ProtoMessage() {}

func (x *TranslationConfigDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_migration_v2_translation_config_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TranslationConfigDetails.ProtoReflect.Descriptor instead.
func (*TranslationConfigDetails) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_migration_v2_translation_config_proto_rawDescGZIP(), []int{0}
}

func (m *TranslationConfigDetails) GetSourceLocation() isTranslationConfigDetails_SourceLocation {
	if m != nil {
		return m.SourceLocation
	}
	return nil
}

func (x *TranslationConfigDetails) GetGcsSourcePath() string {
	if x, ok := x.GetSourceLocation().(*TranslationConfigDetails_GcsSourcePath); ok {
		return x.GcsSourcePath
	}
	return ""
}

func (m *TranslationConfigDetails) GetTargetLocation() isTranslationConfigDetails_TargetLocation {
	if m != nil {
		return m.TargetLocation
	}
	return nil
}

func (x *TranslationConfigDetails) GetGcsTargetPath() string {
	if x, ok := x.GetTargetLocation().(*TranslationConfigDetails_GcsTargetPath); ok {
		return x.GcsTargetPath
	}
	return ""
}

func (m *TranslationConfigDetails) GetOutputNameMapping() isTranslationConfigDetails_OutputNameMapping {
	if m != nil {
		return m.OutputNameMapping
	}
	return nil
}

func (x *TranslationConfigDetails) GetNameMappingList() *ObjectNameMappingList {
	if x, ok := x.GetOutputNameMapping().(*TranslationConfigDetails_NameMappingList); ok {
		return x.NameMappingList
	}
	return nil
}

func (x *TranslationConfigDetails) GetSourceDialect() *Dialect {
	if x != nil {
		return x.SourceDialect
	}
	return nil
}

func (x *TranslationConfigDetails) GetTargetDialect() *Dialect {
	if x != nil {
		return x.TargetDialect
	}
	return nil
}

func (x *TranslationConfigDetails) GetSourceEnv() *SourceEnv {
	if x != nil {
		return x.SourceEnv
	}
	return nil
}

func (x *TranslationConfigDetails) GetRequestSource() string {
	if x != nil {
		return x.RequestSource
	}
	return ""
}

type isTranslationConfigDetails_SourceLocation interface {
	isTranslationConfigDetails_SourceLocation()
}

type TranslationConfigDetails_GcsSourcePath struct {
	// The Cloud Storage path for a directory of files to translate in a task.
	GcsSourcePath string `protobuf:"bytes,1,opt,name=gcs_source_path,json=gcsSourcePath,proto3,oneof"`
}

func (*TranslationConfigDetails_GcsSourcePath) isTranslationConfigDetails_SourceLocation() {}

type isTranslationConfigDetails_TargetLocation interface {
	isTranslationConfigDetails_TargetLocation()
}

type TranslationConfigDetails_GcsTargetPath struct {
	// The Cloud Storage path to write back the corresponding input files to.
	GcsTargetPath string `protobuf:"bytes,2,opt,name=gcs_target_path,json=gcsTargetPath,proto3,oneof"`
}

func (*TranslationConfigDetails_GcsTargetPath) isTranslationConfigDetails_TargetLocation() {}

type isTranslationConfigDetails_OutputNameMapping interface {
	isTranslationConfigDetails_OutputNameMapping()
}

type TranslationConfigDetails_NameMappingList struct {
	// The mapping of objects to their desired output names in list form.
	NameMappingList *ObjectNameMappingList `protobuf:"bytes,5,opt,name=name_mapping_list,json=nameMappingList,proto3,oneof"`
}

func (*TranslationConfigDetails_NameMappingList) isTranslationConfigDetails_OutputNameMapping() {}

// The possible dialect options for translation.
type Dialect struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The possible dialect options that this message represents.
	//
	// Types that are assignable to DialectValue:
	//	*Dialect_BigqueryDialect
	//	*Dialect_HiveqlDialect
	//	*Dialect_RedshiftDialect
	//	*Dialect_TeradataDialect
	//	*Dialect_OracleDialect
	//	*Dialect_SparksqlDialect
	//	*Dialect_SnowflakeDialect
	//	*Dialect_NetezzaDialect
	//	*Dialect_AzureSynapseDialect
	//	*Dialect_VerticaDialect
	//	*Dialect_SqlServerDialect
	//	*Dialect_PostgresqlDialect
	//	*Dialect_PrestoDialect
	//	*Dialect_MysqlDialect
	DialectValue isDialect_DialectValue `protobuf_oneof:"dialect_value"`
}

func (x *Dialect) Reset() {
	*x = Dialect{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_migration_v2_translation_config_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Dialect) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Dialect) ProtoMessage() {}

func (x *Dialect) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_migration_v2_translation_config_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Dialect.ProtoReflect.Descriptor instead.
func (*Dialect) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_migration_v2_translation_config_proto_rawDescGZIP(), []int{1}
}

func (m *Dialect) GetDialectValue() isDialect_DialectValue {
	if m != nil {
		return m.DialectValue
	}
	return nil
}

func (x *Dialect) GetBigqueryDialect() *BigQueryDialect {
	if x, ok := x.GetDialectValue().(*Dialect_BigqueryDialect); ok {
		return x.BigqueryDialect
	}
	return nil
}

func (x *Dialect) GetHiveqlDialect() *HiveQLDialect {
	if x, ok := x.GetDialectValue().(*Dialect_HiveqlDialect); ok {
		return x.HiveqlDialect
	}
	return nil
}

func (x *Dialect) GetRedshiftDialect() *RedshiftDialect {
	if x, ok := x.GetDialectValue().(*Dialect_RedshiftDialect); ok {
		return x.RedshiftDialect
	}
	return nil
}

func (x *Dialect) GetTeradataDialect() *TeradataDialect {
	if x, ok := x.GetDialectValue().(*Dialect_TeradataDialect); ok {
		return x.TeradataDialect
	}
	return nil
}

func (x *Dialect) GetOracleDialect() *OracleDialect {
	if x, ok := x.GetDialectValue().(*Dialect_OracleDialect); ok {
		return x.OracleDialect
	}
	return nil
}

func (x *Dialect) GetSparksqlDialect() *SparkSQLDialect {
	if x, ok := x.GetDialectValue().(*Dialect_SparksqlDialect); ok {
		return x.SparksqlDialect
	}
	return nil
}

func (x *Dialect) GetSnowflakeDialect() *SnowflakeDialect {
	if x, ok := x.GetDialectValue().(*Dialect_SnowflakeDialect); ok {
		return x.SnowflakeDialect
	}
	return nil
}

func (x *Dialect) GetNetezzaDialect() *NetezzaDialect {
	if x, ok := x.GetDialectValue().(*Dialect_NetezzaDialect); ok {
		return x.NetezzaDialect
	}
	return nil
}

func (x *Dialect) GetAzureSynapseDialect() *AzureSynapseDialect {
	if x, ok := x.GetDialectValue().(*Dialect_AzureSynapseDialect); ok {
		return x.AzureSynapseDialect
	}
	return nil
}

func (x *Dialect) GetVerticaDialect() *VerticaDialect {
	if x, ok := x.GetDialectValue().(*Dialect_VerticaDialect); ok {
		return x.VerticaDialect
	}
	return nil
}

func (x *Dialect) GetSqlServerDialect() *SQLServerDialect {
	if x, ok := x.GetDialectValue().(*Dialect_SqlServerDialect); ok {
		return x.SqlServerDialect
	}
	return nil
}

func (x *Dialect) GetPostgresqlDialect() *PostgresqlDialect {
	if x, ok := x.GetDialectValue().(*Dialect_PostgresqlDialect); ok {
		return x.PostgresqlDialect
	}
	return nil
}

func (x *Dialect) GetPrestoDialect() *PrestoDialect {
	if x, ok := x.GetDialectValue().(*Dialect_PrestoDialect); ok {
		return x.PrestoDialect
	}
	return nil
}

func (x *Dialect) GetMysqlDialect() *MySQLDialect {
	if x, ok := x.GetDialectValue().(*Dialect_MysqlDialect); ok {
		return x.MysqlDialect
	}
	return nil
}

type isDialect_DialectValue interface {
	isDialect_DialectValue()
}

type Dialect_BigqueryDialect struct {
	// The BigQuery dialect
	BigqueryDialect *BigQueryDialect `protobuf:"bytes,1,opt,name=bigquery_dialect,json=bigqueryDialect,proto3,oneof"`
}

type Dialect_HiveqlDialect struct {
	// The HiveQL dialect
	HiveqlDialect *HiveQLDialect `protobuf:"bytes,2,opt,name=hiveql_dialect,json=hiveqlDialect,proto3,oneof"`
}

type Dialect_RedshiftDialect struct {
	// The Redshift dialect
	RedshiftDialect *RedshiftDialect `protobuf:"bytes,3,opt,name=redshift_dialect,json=redshiftDialect,proto3,oneof"`
}

type Dialect_TeradataDialect struct {
	// The Teradata dialect
	TeradataDialect *TeradataDialect `protobuf:"bytes,4,opt,name=teradata_dialect,json=teradataDialect,proto3,oneof"`
}

type Dialect_OracleDialect struct {
	// The Oracle dialect
	OracleDialect *OracleDialect `protobuf:"bytes,5,opt,name=oracle_dialect,json=oracleDialect,proto3,oneof"`
}

type Dialect_SparksqlDialect struct {
	// The SparkSQL dialect
	SparksqlDialect *SparkSQLDialect `protobuf:"bytes,6,opt,name=sparksql_dialect,json=sparksqlDialect,proto3,oneof"`
}

type Dialect_SnowflakeDialect struct {
	// The Snowflake dialect
	SnowflakeDialect *SnowflakeDialect `protobuf:"bytes,7,opt,name=snowflake_dialect,json=snowflakeDialect,proto3,oneof"`
}

type Dialect_NetezzaDialect struct {
	// The Netezza dialect
	NetezzaDialect *NetezzaDialect `protobuf:"bytes,8,opt,name=netezza_dialect,json=netezzaDialect,proto3,oneof"`
}

type Dialect_AzureSynapseDialect struct {
	// The Azure Synapse dialect
	AzureSynapseDialect *AzureSynapseDialect `protobuf:"bytes,9,opt,name=azure_synapse_dialect,json=azureSynapseDialect,proto3,oneof"`
}

type Dialect_VerticaDialect struct {
	// The Vertica dialect
	VerticaDialect *VerticaDialect `protobuf:"bytes,10,opt,name=vertica_dialect,json=verticaDialect,proto3,oneof"`
}

type Dialect_SqlServerDialect struct {
	// The SQL Server dialect
	SqlServerDialect *SQLServerDialect `protobuf:"bytes,11,opt,name=sql_server_dialect,json=sqlServerDialect,proto3,oneof"`
}

type Dialect_PostgresqlDialect struct {
	// The Postgresql dialect
	PostgresqlDialect *PostgresqlDialect `protobuf:"bytes,12,opt,name=postgresql_dialect,json=postgresqlDialect,proto3,oneof"`
}

type Dialect_PrestoDialect struct {
	// The Presto dialect
	PrestoDialect *PrestoDialect `protobuf:"bytes,13,opt,name=presto_dialect,json=prestoDialect,proto3,oneof"`
}

type Dialect_MysqlDialect struct {
	// The MySQL dialect
	MysqlDialect *MySQLDialect `protobuf:"bytes,14,opt,name=mysql_dialect,json=mysqlDialect,proto3,oneof"`
}

func (*Dialect_BigqueryDialect) isDialect_DialectValue() {}

func (*Dialect_HiveqlDialect) isDialect_DialectValue() {}

func (*Dialect_RedshiftDialect) isDialect_DialectValue() {}

func (*Dialect_TeradataDialect) isDialect_DialectValue() {}

func (*Dialect_OracleDialect) isDialect_DialectValue() {}

func (*Dialect_SparksqlDialect) isDialect_DialectValue() {}

func (*Dialect_SnowflakeDialect) isDialect_DialectValue() {}

func (*Dialect_NetezzaDialect) isDialect_DialectValue() {}

func (*Dialect_AzureSynapseDialect) isDialect_DialectValue() {}

func (*Dialect_VerticaDialect) isDialect_DialectValue() {}

func (*Dialect_SqlServerDialect) isDialect_DialectValue() {}

func (*Dialect_PostgresqlDialect) isDialect_DialectValue() {}

func (*Dialect_PrestoDialect) isDialect_DialectValue() {}

func (*Dialect_MysqlDialect) isDialect_DialectValue() {}

// The dialect definition for BigQuery.
type BigQueryDialect struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *BigQueryDialect) Reset() {
	*x = BigQueryDialect{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_migration_v2_translation_config_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BigQueryDialect) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BigQueryDialect) ProtoMessage() {}

func (x *BigQueryDialect) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_migration_v2_translation_config_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BigQueryDialect.ProtoReflect.Descriptor instead.
func (*BigQueryDialect) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_migration_v2_translation_config_proto_rawDescGZIP(), []int{2}
}

// The dialect definition for HiveQL.
type HiveQLDialect struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *HiveQLDialect) Reset() {
	*x = HiveQLDialect{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_migration_v2_translation_config_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HiveQLDialect) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HiveQLDialect) ProtoMessage() {}

func (x *HiveQLDialect) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_migration_v2_translation_config_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HiveQLDialect.ProtoReflect.Descriptor instead.
func (*HiveQLDialect) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_migration_v2_translation_config_proto_rawDescGZIP(), []int{3}
}

// The dialect definition for Redshift.
type RedshiftDialect struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *RedshiftDialect) Reset() {
	*x = RedshiftDialect{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_migration_v2_translation_config_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RedshiftDialect) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RedshiftDialect) ProtoMessage() {}

func (x *RedshiftDialect) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_migration_v2_translation_config_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RedshiftDialect.ProtoReflect.Descriptor instead.
func (*RedshiftDialect) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_migration_v2_translation_config_proto_rawDescGZIP(), []int{4}
}

// The dialect definition for Teradata.
type TeradataDialect struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Which Teradata sub-dialect mode the user specifies.
	Mode TeradataDialect_Mode `protobuf:"varint,1,opt,name=mode,proto3,enum=google.cloud.bigquery.migration.v2.TeradataDialect_Mode" json:"mode,omitempty"`
}

func (x *TeradataDialect) Reset() {
	*x = TeradataDialect{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_migration_v2_translation_config_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TeradataDialect) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TeradataDialect) ProtoMessage() {}

func (x *TeradataDialect) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_migration_v2_translation_config_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TeradataDialect.ProtoReflect.Descriptor instead.
func (*TeradataDialect) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_migration_v2_translation_config_proto_rawDescGZIP(), []int{5}
}

func (x *TeradataDialect) GetMode() TeradataDialect_Mode {
	if x != nil {
		return x.Mode
	}
	return TeradataDialect_MODE_UNSPECIFIED
}

// The dialect definition for Oracle.
type OracleDialect struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *OracleDialect) Reset() {
	*x = OracleDialect{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_migration_v2_translation_config_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OracleDialect) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OracleDialect) ProtoMessage() {}

func (x *OracleDialect) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_migration_v2_translation_config_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OracleDialect.ProtoReflect.Descriptor instead.
func (*OracleDialect) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_migration_v2_translation_config_proto_rawDescGZIP(), []int{6}
}

// The dialect definition for SparkSQL.
type SparkSQLDialect struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *SparkSQLDialect) Reset() {
	*x = SparkSQLDialect{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_migration_v2_translation_config_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SparkSQLDialect) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SparkSQLDialect) ProtoMessage() {}

func (x *SparkSQLDialect) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_migration_v2_translation_config_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SparkSQLDialect.ProtoReflect.Descriptor instead.
func (*SparkSQLDialect) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_migration_v2_translation_config_proto_rawDescGZIP(), []int{7}
}

// The dialect definition for Snowflake.
type SnowflakeDialect struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *SnowflakeDialect) Reset() {
	*x = SnowflakeDialect{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_migration_v2_translation_config_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SnowflakeDialect) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SnowflakeDialect) ProtoMessage() {}

func (x *SnowflakeDialect) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_migration_v2_translation_config_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SnowflakeDialect.ProtoReflect.Descriptor instead.
func (*SnowflakeDialect) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_migration_v2_translation_config_proto_rawDescGZIP(), []int{8}
}

// The dialect definition for Netezza.
type NetezzaDialect struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *NetezzaDialect) Reset() {
	*x = NetezzaDialect{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_migration_v2_translation_config_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NetezzaDialect) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NetezzaDialect) ProtoMessage() {}

func (x *NetezzaDialect) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_migration_v2_translation_config_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NetezzaDialect.ProtoReflect.Descriptor instead.
func (*NetezzaDialect) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_migration_v2_translation_config_proto_rawDescGZIP(), []int{9}
}

// The dialect definition for Azure Synapse.
type AzureSynapseDialect struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *AzureSynapseDialect) Reset() {
	*x = AzureSynapseDialect{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_migration_v2_translation_config_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AzureSynapseDialect) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AzureSynapseDialect) ProtoMessage() {}

func (x *AzureSynapseDialect) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_migration_v2_translation_config_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AzureSynapseDialect.ProtoReflect.Descriptor instead.
func (*AzureSynapseDialect) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_migration_v2_translation_config_proto_rawDescGZIP(), []int{10}
}

// The dialect definition for Vertica.
type VerticaDialect struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *VerticaDialect) Reset() {
	*x = VerticaDialect{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_migration_v2_translation_config_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VerticaDialect) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VerticaDialect) ProtoMessage() {}

func (x *VerticaDialect) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_migration_v2_translation_config_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VerticaDialect.ProtoReflect.Descriptor instead.
func (*VerticaDialect) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_migration_v2_translation_config_proto_rawDescGZIP(), []int{11}
}

// The dialect definition for SQL Server.
type SQLServerDialect struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *SQLServerDialect) Reset() {
	*x = SQLServerDialect{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_migration_v2_translation_config_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SQLServerDialect) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SQLServerDialect) ProtoMessage() {}

func (x *SQLServerDialect) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_migration_v2_translation_config_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SQLServerDialect.ProtoReflect.Descriptor instead.
func (*SQLServerDialect) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_migration_v2_translation_config_proto_rawDescGZIP(), []int{12}
}

// The dialect definition for Postgresql.
type PostgresqlDialect struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *PostgresqlDialect) Reset() {
	*x = PostgresqlDialect{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_migration_v2_translation_config_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PostgresqlDialect) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PostgresqlDialect) ProtoMessage() {}

func (x *PostgresqlDialect) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_migration_v2_translation_config_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PostgresqlDialect.ProtoReflect.Descriptor instead.
func (*PostgresqlDialect) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_migration_v2_translation_config_proto_rawDescGZIP(), []int{13}
}

// The dialect definition for Presto.
type PrestoDialect struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *PrestoDialect) Reset() {
	*x = PrestoDialect{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_migration_v2_translation_config_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PrestoDialect) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PrestoDialect) ProtoMessage() {}

func (x *PrestoDialect) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_migration_v2_translation_config_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PrestoDialect.ProtoReflect.Descriptor instead.
func (*PrestoDialect) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_migration_v2_translation_config_proto_rawDescGZIP(), []int{14}
}

// The dialect definition for MySQL.
type MySQLDialect struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *MySQLDialect) Reset() {
	*x = MySQLDialect{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_migration_v2_translation_config_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MySQLDialect) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MySQLDialect) ProtoMessage() {}

func (x *MySQLDialect) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_migration_v2_translation_config_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MySQLDialect.ProtoReflect.Descriptor instead.
func (*MySQLDialect) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_migration_v2_translation_config_proto_rawDescGZIP(), []int{15}
}

// Represents a map of name mappings using a list of key:value proto messages of
// existing name to desired output name.
type ObjectNameMappingList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The elements of the object name map.
	NameMap []*ObjectNameMapping `protobuf:"bytes,1,rep,name=name_map,json=nameMap,proto3" json:"name_map,omitempty"`
}

func (x *ObjectNameMappingList) Reset() {
	*x = ObjectNameMappingList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_migration_v2_translation_config_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ObjectNameMappingList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ObjectNameMappingList) ProtoMessage() {}

func (x *ObjectNameMappingList) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_migration_v2_translation_config_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ObjectNameMappingList.ProtoReflect.Descriptor instead.
func (*ObjectNameMappingList) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_migration_v2_translation_config_proto_rawDescGZIP(), []int{16}
}

func (x *ObjectNameMappingList) GetNameMap() []*ObjectNameMapping {
	if x != nil {
		return x.NameMap
	}
	return nil
}

// Represents a key-value pair of NameMappingKey to NameMappingValue to
// represent the mapping of SQL names from the input value to desired output.
type ObjectNameMapping struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the object in source that is being mapped.
	Source *NameMappingKey `protobuf:"bytes,1,opt,name=source,proto3" json:"source,omitempty"`
	// The desired target name of the object that is being mapped.
	Target *NameMappingValue `protobuf:"bytes,2,opt,name=target,proto3" json:"target,omitempty"`
}

func (x *ObjectNameMapping) Reset() {
	*x = ObjectNameMapping{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_migration_v2_translation_config_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ObjectNameMapping) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ObjectNameMapping) ProtoMessage() {}

func (x *ObjectNameMapping) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_migration_v2_translation_config_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ObjectNameMapping.ProtoReflect.Descriptor instead.
func (*ObjectNameMapping) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_migration_v2_translation_config_proto_rawDescGZIP(), []int{17}
}

func (x *ObjectNameMapping) GetSource() *NameMappingKey {
	if x != nil {
		return x.Source
	}
	return nil
}

func (x *ObjectNameMapping) GetTarget() *NameMappingValue {
	if x != nil {
		return x.Target
	}
	return nil
}

// The potential components of a full name mapping that will be mapped
// during translation in the source data warehouse.
type NameMappingKey struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The type of object that is being mapped.
	Type NameMappingKey_Type `protobuf:"varint,1,opt,name=type,proto3,enum=google.cloud.bigquery.migration.v2.NameMappingKey_Type" json:"type,omitempty"`
	// The database name (BigQuery project ID equivalent in the source data
	// warehouse).
	Database string `protobuf:"bytes,2,opt,name=database,proto3" json:"database,omitempty"`
	// The schema name (BigQuery dataset equivalent in the source data warehouse).
	Schema string `protobuf:"bytes,3,opt,name=schema,proto3" json:"schema,omitempty"`
	// The relation name (BigQuery table or view equivalent in the source data
	// warehouse).
	Relation string `protobuf:"bytes,4,opt,name=relation,proto3" json:"relation,omitempty"`
	// The attribute name (BigQuery column equivalent in the source data
	// warehouse).
	Attribute string `protobuf:"bytes,5,opt,name=attribute,proto3" json:"attribute,omitempty"`
}

func (x *NameMappingKey) Reset() {
	*x = NameMappingKey{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_migration_v2_translation_config_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NameMappingKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NameMappingKey) ProtoMessage() {}

func (x *NameMappingKey) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_migration_v2_translation_config_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NameMappingKey.ProtoReflect.Descriptor instead.
func (*NameMappingKey) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_migration_v2_translation_config_proto_rawDescGZIP(), []int{18}
}

func (x *NameMappingKey) GetType() NameMappingKey_Type {
	if x != nil {
		return x.Type
	}
	return NameMappingKey_TYPE_UNSPECIFIED
}

func (x *NameMappingKey) GetDatabase() string {
	if x != nil {
		return x.Database
	}
	return ""
}

func (x *NameMappingKey) GetSchema() string {
	if x != nil {
		return x.Schema
	}
	return ""
}

func (x *NameMappingKey) GetRelation() string {
	if x != nil {
		return x.Relation
	}
	return ""
}

func (x *NameMappingKey) GetAttribute() string {
	if x != nil {
		return x.Attribute
	}
	return ""
}

// The potential components of a full name mapping that will be mapped
// during translation in the target data warehouse.
type NameMappingValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The database name (BigQuery project ID equivalent in the target data
	// warehouse).
	Database string `protobuf:"bytes,1,opt,name=database,proto3" json:"database,omitempty"`
	// The schema name (BigQuery dataset equivalent in the target data warehouse).
	Schema string `protobuf:"bytes,2,opt,name=schema,proto3" json:"schema,omitempty"`
	// The relation name (BigQuery table or view equivalent in the target data
	// warehouse).
	Relation string `protobuf:"bytes,3,opt,name=relation,proto3" json:"relation,omitempty"`
	// The attribute name (BigQuery column equivalent in the target data
	// warehouse).
	Attribute string `protobuf:"bytes,4,opt,name=attribute,proto3" json:"attribute,omitempty"`
}

func (x *NameMappingValue) Reset() {
	*x = NameMappingValue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_migration_v2_translation_config_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NameMappingValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NameMappingValue) ProtoMessage() {}

func (x *NameMappingValue) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_migration_v2_translation_config_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NameMappingValue.ProtoReflect.Descriptor instead.
func (*NameMappingValue) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_migration_v2_translation_config_proto_rawDescGZIP(), []int{19}
}

func (x *NameMappingValue) GetDatabase() string {
	if x != nil {
		return x.Database
	}
	return ""
}

func (x *NameMappingValue) GetSchema() string {
	if x != nil {
		return x.Schema
	}
	return ""
}

func (x *NameMappingValue) GetRelation() string {
	if x != nil {
		return x.Relation
	}
	return ""
}

func (x *NameMappingValue) GetAttribute() string {
	if x != nil {
		return x.Attribute
	}
	return ""
}

// Represents the default source environment values for the translation.
type SourceEnv struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The default database name to fully qualify SQL objects when their database
	// name is missing.
	DefaultDatabase string `protobuf:"bytes,1,opt,name=default_database,json=defaultDatabase,proto3" json:"default_database,omitempty"`
	// The schema search path. When SQL objects are missing schema name,
	// translation engine will search through this list to find the value.
	SchemaSearchPath []string `protobuf:"bytes,2,rep,name=schema_search_path,json=schemaSearchPath,proto3" json:"schema_search_path,omitempty"`
}

func (x *SourceEnv) Reset() {
	*x = SourceEnv{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_migration_v2_translation_config_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SourceEnv) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SourceEnv) ProtoMessage() {}

func (x *SourceEnv) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_migration_v2_translation_config_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SourceEnv.ProtoReflect.Descriptor instead.
func (*SourceEnv) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_migration_v2_translation_config_proto_rawDescGZIP(), []int{20}
}

func (x *SourceEnv) GetDefaultDatabase() string {
	if x != nil {
		return x.DefaultDatabase
	}
	return ""
}

func (x *SourceEnv) GetSchemaSearchPath() []string {
	if x != nil {
		return x.SchemaSearchPath
	}
	return nil
}

var File_google_cloud_bigquery_migration_v2_translation_config_proto protoreflect.FileDescriptor

var file_google_cloud_bigquery_migration_v2_translation_config_proto_rawDesc = []byte{
	0x0a, 0x3b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x62,
	0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2f, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2f, 0x76, 0x32, 0x2f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x22, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x32, 0x22, 0xb1, 0x04, 0x0a, 0x18, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x28,
	0x0a, 0x0f, 0x67, 0x63, 0x73, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x70, 0x61, 0x74,
	0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0d, 0x67, 0x63, 0x73, 0x53, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x50, 0x61, 0x74, 0x68, 0x12, 0x28, 0x0a, 0x0f, 0x67, 0x63, 0x73, 0x5f,
	0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x48, 0x01, 0x52, 0x0d, 0x67, 0x63, 0x73, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x50, 0x61,
	0x74, 0x68, 0x12, 0x67, 0x0a, 0x11, 0x6e, 0x61, 0x6d, 0x65, 0x5f, 0x6d, 0x61, 0x70, 0x70, 0x69,
	0x6e, 0x67, 0x5f, 0x6c, 0x69, 0x73, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x32, 0x2e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x4d, 0x61, 0x70,
	0x70, 0x69, 0x6e, 0x67, 0x4c, 0x69, 0x73, 0x74, 0x48, 0x02, 0x52, 0x0f, 0x6e, 0x61, 0x6d, 0x65,
	0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x52, 0x0a, 0x0e, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x64, 0x69, 0x61, 0x6c, 0x65, 0x63, 0x74, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x6d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x69, 0x61, 0x6c, 0x65, 0x63, 0x74,
	0x52, 0x0d, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x44, 0x69, 0x61, 0x6c, 0x65, 0x63, 0x74, 0x12,
	0x52, 0x0a, 0x0e, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x64, 0x69, 0x61, 0x6c, 0x65, 0x63,
	0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e,
	0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x69, 0x61,
	0x6c, 0x65, 0x63, 0x74, 0x52, 0x0d, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x44, 0x69, 0x61, 0x6c,
	0x65, 0x63, 0x74, 0x12, 0x4c, 0x0a, 0x0a, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x65, 0x6e,
	0x76, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e,
	0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x45, 0x6e, 0x76, 0x52, 0x09, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x45, 0x6e,
	0x76, 0x12, 0x25, 0x0a, 0x0e, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x11, 0x0a, 0x0f, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x11, 0x0a, 0x0f, 0x74,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x15,
	0x0a, 0x13, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x5f, 0x6d, 0x61,
	0x70, 0x70, 0x69, 0x6e, 0x67, 0x22, 0xef, 0x0a, 0x0a, 0x07, 0x44, 0x69, 0x61, 0x6c, 0x65, 0x63,
	0x74, 0x12, 0x60, 0x0a, 0x10, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x64, 0x69,
	0x61, 0x6c, 0x65, 0x63, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75,
	0x65, 0x72, 0x79, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32,
	0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x44, 0x69, 0x61, 0x6c, 0x65, 0x63, 0x74,
	0x48, 0x00, 0x52, 0x0f, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x44, 0x69, 0x61, 0x6c,
	0x65, 0x63, 0x74, 0x12, 0x5a, 0x0a, 0x0e, 0x68, 0x69, 0x76, 0x65, 0x71, 0x6c, 0x5f, 0x64, 0x69,
	0x61, 0x6c, 0x65, 0x63, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75,
	0x65, 0x72, 0x79, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32,
	0x2e, 0x48, 0x69, 0x76, 0x65, 0x51, 0x4c, 0x44, 0x69, 0x61, 0x6c, 0x65, 0x63, 0x74, 0x48, 0x00,
	0x52, 0x0d, 0x68, 0x69, 0x76, 0x65, 0x71, 0x6c, 0x44, 0x69, 0x61, 0x6c, 0x65, 0x63, 0x74, 0x12,
	0x60, 0x0a, 0x10, 0x72, 0x65, 0x64, 0x73, 0x68, 0x69, 0x66, 0x74, 0x5f, 0x64, 0x69, 0x61, 0x6c,
	0x65, 0x63, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x52,
	0x65, 0x64, 0x73, 0x68, 0x69, 0x66, 0x74, 0x44, 0x69, 0x61, 0x6c, 0x65, 0x63, 0x74, 0x48, 0x00,
	0x52, 0x0f, 0x72, 0x65, 0x64, 0x73, 0x68, 0x69, 0x66, 0x74, 0x44, 0x69, 0x61, 0x6c, 0x65, 0x63,
	0x74, 0x12, 0x60, 0x0a, 0x10, 0x74, 0x65, 0x72, 0x61, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x64, 0x69,
	0x61, 0x6c, 0x65, 0x63, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75,
	0x65, 0x72, 0x79, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32,
	0x2e, 0x54, 0x65, 0x72, 0x61, 0x64, 0x61, 0x74, 0x61, 0x44, 0x69, 0x61, 0x6c, 0x65, 0x63, 0x74,
	0x48, 0x00, 0x52, 0x0f, 0x74, 0x65, 0x72, 0x61, 0x64, 0x61, 0x74, 0x61, 0x44, 0x69, 0x61, 0x6c,
	0x65, 0x63, 0x74, 0x12, 0x5a, 0x0a, 0x0e, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x5f, 0x64, 0x69,
	0x61, 0x6c, 0x65, 0x63, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75,
	0x65, 0x72, 0x79, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32,
	0x2e, 0x4f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x44, 0x69, 0x61, 0x6c, 0x65, 0x63, 0x74, 0x48, 0x00,
	0x52, 0x0d, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x44, 0x69, 0x61, 0x6c, 0x65, 0x63, 0x74, 0x12,
	0x60, 0x0a, 0x10, 0x73, 0x70, 0x61, 0x72, 0x6b, 0x73, 0x71, 0x6c, 0x5f, 0x64, 0x69, 0x61, 0x6c,
	0x65, 0x63, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x53,
	0x70, 0x61, 0x72, 0x6b, 0x53, 0x51, 0x4c, 0x44, 0x69, 0x61, 0x6c, 0x65, 0x63, 0x74, 0x48, 0x00,
	0x52, 0x0f, 0x73, 0x70, 0x61, 0x72, 0x6b, 0x73, 0x71, 0x6c, 0x44, 0x69, 0x61, 0x6c, 0x65, 0x63,
	0x74, 0x12, 0x63, 0x0a, 0x11, 0x73, 0x6e, 0x6f, 0x77, 0x66, 0x6c, 0x61, 0x6b, 0x65, 0x5f, 0x64,
	0x69, 0x61, 0x6c, 0x65, 0x63, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x32, 0x2e, 0x53, 0x6e, 0x6f, 0x77, 0x66, 0x6c, 0x61, 0x6b, 0x65, 0x44, 0x69, 0x61, 0x6c, 0x65,
	0x63, 0x74, 0x48, 0x00, 0x52, 0x10, 0x73, 0x6e, 0x6f, 0x77, 0x66, 0x6c, 0x61, 0x6b, 0x65, 0x44,
	0x69, 0x61, 0x6c, 0x65, 0x63, 0x74, 0x12, 0x5d, 0x0a, 0x0f, 0x6e, 0x65, 0x74, 0x65, 0x7a, 0x7a,
	0x61, 0x5f, 0x64, 0x69, 0x61, 0x6c, 0x65, 0x63, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62,
	0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x4e, 0x65, 0x74, 0x65, 0x7a, 0x7a, 0x61, 0x44, 0x69, 0x61, 0x6c,
	0x65, 0x63, 0x74, 0x48, 0x00, 0x52, 0x0e, 0x6e, 0x65, 0x74, 0x65, 0x7a, 0x7a, 0x61, 0x44, 0x69,
	0x61, 0x6c, 0x65, 0x63, 0x74, 0x12, 0x6d, 0x0a, 0x15, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x5f, 0x73,
	0x79, 0x6e, 0x61, 0x70, 0x73, 0x65, 0x5f, 0x64, 0x69, 0x61, 0x6c, 0x65, 0x63, 0x74, 0x18, 0x09,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x6d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x53,
	0x79, 0x6e, 0x61, 0x70, 0x73, 0x65, 0x44, 0x69, 0x61, 0x6c, 0x65, 0x63, 0x74, 0x48, 0x00, 0x52,
	0x13, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x53, 0x79, 0x6e, 0x61, 0x70, 0x73, 0x65, 0x44, 0x69, 0x61,
	0x6c, 0x65, 0x63, 0x74, 0x12, 0x5d, 0x0a, 0x0f, 0x76, 0x65, 0x72, 0x74, 0x69, 0x63, 0x61, 0x5f,
	0x64, 0x69, 0x61, 0x6c, 0x65, 0x63, 0x74, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x32, 0x2e, 0x56, 0x65, 0x72, 0x74, 0x69, 0x63, 0x61, 0x44, 0x69, 0x61, 0x6c, 0x65, 0x63,
	0x74, 0x48, 0x00, 0x52, 0x0e, 0x76, 0x65, 0x72, 0x74, 0x69, 0x63, 0x61, 0x44, 0x69, 0x61, 0x6c,
	0x65, 0x63, 0x74, 0x12, 0x64, 0x0a, 0x12, 0x73, 0x71, 0x6c, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x65,
	0x72, 0x5f, 0x64, 0x69, 0x61, 0x6c, 0x65, 0x63, 0x74, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62,
	0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x51, 0x4c, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x44, 0x69,
	0x61, 0x6c, 0x65, 0x63, 0x74, 0x48, 0x00, 0x52, 0x10, 0x73, 0x71, 0x6c, 0x53, 0x65, 0x72, 0x76,
	0x65, 0x72, 0x44, 0x69, 0x61, 0x6c, 0x65, 0x63, 0x74, 0x12, 0x66, 0x0a, 0x12, 0x70, 0x6f, 0x73,
	0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x5f, 0x64, 0x69, 0x61, 0x6c, 0x65, 0x63, 0x74, 0x18,
	0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x6d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x50, 0x6f, 0x73, 0x74, 0x67,
	0x72, 0x65, 0x73, 0x71, 0x6c, 0x44, 0x69, 0x61, 0x6c, 0x65, 0x63, 0x74, 0x48, 0x00, 0x52, 0x11,
	0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x44, 0x69, 0x61, 0x6c, 0x65, 0x63,
	0x74, 0x12, 0x5a, 0x0a, 0x0e, 0x70, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x5f, 0x64, 0x69, 0x61, 0x6c,
	0x65, 0x63, 0x74, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x50,
	0x72, 0x65, 0x73, 0x74, 0x6f, 0x44, 0x69, 0x61, 0x6c, 0x65, 0x63, 0x74, 0x48, 0x00, 0x52, 0x0d,
	0x70, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x44, 0x69, 0x61, 0x6c, 0x65, 0x63, 0x74, 0x12, 0x57, 0x0a,
	0x0d, 0x6d, 0x79, 0x73, 0x71, 0x6c, 0x5f, 0x64, 0x69, 0x61, 0x6c, 0x65, 0x63, 0x74, 0x18, 0x0e,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x6d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x79, 0x53, 0x51, 0x4c, 0x44,
	0x69, 0x61, 0x6c, 0x65, 0x63, 0x74, 0x48, 0x00, 0x52, 0x0c, 0x6d, 0x79, 0x73, 0x71, 0x6c, 0x44,
	0x69, 0x61, 0x6c, 0x65, 0x63, 0x74, 0x42, 0x0f, 0x0a, 0x0d, 0x64, 0x69, 0x61, 0x6c, 0x65, 0x63,
	0x74, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x11, 0x0a, 0x0f, 0x42, 0x69, 0x67, 0x51, 0x75,
	0x65, 0x72, 0x79, 0x44, 0x69, 0x61, 0x6c, 0x65, 0x63, 0x74, 0x22, 0x0f, 0x0a, 0x0d, 0x48, 0x69,
	0x76, 0x65, 0x51, 0x4c, 0x44, 0x69, 0x61, 0x6c, 0x65, 0x63, 0x74, 0x22, 0x11, 0x0a, 0x0f, 0x52,
	0x65, 0x64, 0x73, 0x68, 0x69, 0x66, 0x74, 0x44, 0x69, 0x61, 0x6c, 0x65, 0x63, 0x74, 0x22, 0x90,
	0x01, 0x0a, 0x0f, 0x54, 0x65, 0x72, 0x61, 0x64, 0x61, 0x74, 0x61, 0x44, 0x69, 0x61, 0x6c, 0x65,
	0x63, 0x74, 0x12, 0x4c, 0x0a, 0x04, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x65, 0x72, 0x61, 0x64, 0x61, 0x74, 0x61, 0x44, 0x69,
	0x61, 0x6c, 0x65, 0x63, 0x74, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x52, 0x04, 0x6d, 0x6f, 0x64, 0x65,
	0x22, 0x2f, 0x0a, 0x04, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x4d, 0x4f, 0x44, 0x45,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x07,
	0x0a, 0x03, 0x53, 0x51, 0x4c, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x42, 0x54, 0x45, 0x51, 0x10,
	0x02, 0x22, 0x0f, 0x0a, 0x0d, 0x4f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x44, 0x69, 0x61, 0x6c, 0x65,
	0x63, 0x74, 0x22, 0x11, 0x0a, 0x0f, 0x53, 0x70, 0x61, 0x72, 0x6b, 0x53, 0x51, 0x4c, 0x44, 0x69,
	0x61, 0x6c, 0x65, 0x63, 0x74, 0x22, 0x12, 0x0a, 0x10, 0x53, 0x6e, 0x6f, 0x77, 0x66, 0x6c, 0x61,
	0x6b, 0x65, 0x44, 0x69, 0x61, 0x6c, 0x65, 0x63, 0x74, 0x22, 0x10, 0x0a, 0x0e, 0x4e, 0x65, 0x74,
	0x65, 0x7a, 0x7a, 0x61, 0x44, 0x69, 0x61, 0x6c, 0x65, 0x63, 0x74, 0x22, 0x15, 0x0a, 0x13, 0x41,
	0x7a, 0x75, 0x72, 0x65, 0x53, 0x79, 0x6e, 0x61, 0x70, 0x73, 0x65, 0x44, 0x69, 0x61, 0x6c, 0x65,
	0x63, 0x74, 0x22, 0x10, 0x0a, 0x0e, 0x56, 0x65, 0x72, 0x74, 0x69, 0x63, 0x61, 0x44, 0x69, 0x61,
	0x6c, 0x65, 0x63, 0x74, 0x22, 0x12, 0x0a, 0x10, 0x53, 0x51, 0x4c, 0x53, 0x65, 0x72, 0x76, 0x65,
	0x72, 0x44, 0x69, 0x61, 0x6c, 0x65, 0x63, 0x74, 0x22, 0x13, 0x0a, 0x11, 0x50, 0x6f, 0x73, 0x74,
	0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x44, 0x69, 0x61, 0x6c, 0x65, 0x63, 0x74, 0x22, 0x0f, 0x0a,
	0x0d, 0x50, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x44, 0x69, 0x61, 0x6c, 0x65, 0x63, 0x74, 0x22, 0x0e,
	0x0a, 0x0c, 0x4d, 0x79, 0x53, 0x51, 0x4c, 0x44, 0x69, 0x61, 0x6c, 0x65, 0x63, 0x74, 0x22, 0x69,
	0x0a, 0x15, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x4d, 0x61, 0x70, 0x70,
	0x69, 0x6e, 0x67, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x50, 0x0a, 0x08, 0x6e, 0x61, 0x6d, 0x65, 0x5f,
	0x6d, 0x61, 0x70, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x4f,
	0x62, 0x6a, 0x65, 0x63, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67,
	0x52, 0x07, 0x6e, 0x61, 0x6d, 0x65, 0x4d, 0x61, 0x70, 0x22, 0xad, 0x01, 0x0a, 0x11, 0x4f, 0x62,
	0x6a, 0x65, 0x63, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x12,
	0x4a, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62,
	0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x4e, 0x61, 0x6d, 0x65, 0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67,
	0x4b, 0x65, 0x79, 0x52, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x4c, 0x0a, 0x06, 0x74,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75,
	0x65, 0x72, 0x79, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32,
	0x2e, 0x4e, 0x61, 0x6d, 0x65, 0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x52, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x22, 0xd8, 0x02, 0x0a, 0x0e, 0x4e, 0x61,
	0x6d, 0x65, 0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x4b, 0x65, 0x79, 0x12, 0x4b, 0x0a, 0x04,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e,
	0x4e, 0x61, 0x6d, 0x65, 0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x4b, 0x65, 0x79, 0x2e, 0x54,
	0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x64, 0x61, 0x74,
	0x61, 0x62, 0x61, 0x73, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x64, 0x61, 0x74,
	0x61, 0x62, 0x61, 0x73, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x1a, 0x0a,
	0x08, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x08, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1c, 0x0a, 0x09, 0x61, 0x74, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x61, 0x74,
	0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x22, 0x8a, 0x01, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x14, 0x0a, 0x10, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x41, 0x54, 0x41, 0x42, 0x41,
	0x53, 0x45, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x43, 0x48, 0x45, 0x4d, 0x41, 0x10, 0x02,
	0x12, 0x0c, 0x0a, 0x08, 0x52, 0x45, 0x4c, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x03, 0x12, 0x0d,
	0x0a, 0x09, 0x41, 0x54, 0x54, 0x52, 0x49, 0x42, 0x55, 0x54, 0x45, 0x10, 0x04, 0x12, 0x12, 0x0a,
	0x0e, 0x52, 0x45, 0x4c, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x41, 0x4c, 0x49, 0x41, 0x53, 0x10,
	0x05, 0x12, 0x13, 0x0a, 0x0f, 0x41, 0x54, 0x54, 0x52, 0x49, 0x42, 0x55, 0x54, 0x45, 0x5f, 0x41,
	0x4c, 0x49, 0x41, 0x53, 0x10, 0x06, 0x12, 0x0c, 0x0a, 0x08, 0x46, 0x55, 0x4e, 0x43, 0x54, 0x49,
	0x4f, 0x4e, 0x10, 0x07, 0x22, 0x80, 0x01, 0x0a, 0x10, 0x4e, 0x61, 0x6d, 0x65, 0x4d, 0x61, 0x70,
	0x70, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x64, 0x61, 0x74,
	0x61, 0x62, 0x61, 0x73, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x64, 0x61, 0x74,
	0x61, 0x62, 0x61, 0x73, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x1a, 0x0a,
	0x08, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x08, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1c, 0x0a, 0x09, 0x61, 0x74, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x61, 0x74,
	0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x22, 0x64, 0x0a, 0x09, 0x53, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x45, 0x6e, 0x76, 0x12, 0x29, 0x0a, 0x10, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f,
	0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f,
	0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x12,
	0x2c, 0x0a, 0x12, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x5f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x10, 0x73, 0x63, 0x68,
	0x65, 0x6d, 0x61, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x50, 0x61, 0x74, 0x68, 0x42, 0xd2, 0x01,
	0x0a, 0x26, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x6d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x42, 0x16, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x50, 0x01, 0x5a, 0x44, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x2f, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x32,
	0x2f, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x70, 0x62, 0x3b, 0x6d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x70, 0x62, 0xaa, 0x02, 0x22, 0x47, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x2e, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x56, 0x32, 0xca, 0x02, 0x22,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x42, 0x69, 0x67,
	0x51, 0x75, 0x65, 0x72, 0x79, 0x5c, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5c,
	0x56, 0x32, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_bigquery_migration_v2_translation_config_proto_rawDescOnce sync.Once
	file_google_cloud_bigquery_migration_v2_translation_config_proto_rawDescData = file_google_cloud_bigquery_migration_v2_translation_config_proto_rawDesc
)

func file_google_cloud_bigquery_migration_v2_translation_config_proto_rawDescGZIP() []byte {
	file_google_cloud_bigquery_migration_v2_translation_config_proto_rawDescOnce.Do(func() {
		file_google_cloud_bigquery_migration_v2_translation_config_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_bigquery_migration_v2_translation_config_proto_rawDescData)
	})
	return file_google_cloud_bigquery_migration_v2_translation_config_proto_rawDescData
}

var file_google_cloud_bigquery_migration_v2_translation_config_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_cloud_bigquery_migration_v2_translation_config_proto_msgTypes = make([]protoimpl.MessageInfo, 21)
var file_google_cloud_bigquery_migration_v2_translation_config_proto_goTypes = []interface{}{
	(TeradataDialect_Mode)(0),        // 0: google.cloud.bigquery.migration.v2.TeradataDialect.Mode
	(NameMappingKey_Type)(0),         // 1: google.cloud.bigquery.migration.v2.NameMappingKey.Type
	(*TranslationConfigDetails)(nil), // 2: google.cloud.bigquery.migration.v2.TranslationConfigDetails
	(*Dialect)(nil),                  // 3: google.cloud.bigquery.migration.v2.Dialect
	(*BigQueryDialect)(nil),          // 4: google.cloud.bigquery.migration.v2.BigQueryDialect
	(*HiveQLDialect)(nil),            // 5: google.cloud.bigquery.migration.v2.HiveQLDialect
	(*RedshiftDialect)(nil),          // 6: google.cloud.bigquery.migration.v2.RedshiftDialect
	(*TeradataDialect)(nil),          // 7: google.cloud.bigquery.migration.v2.TeradataDialect
	(*OracleDialect)(nil),            // 8: google.cloud.bigquery.migration.v2.OracleDialect
	(*SparkSQLDialect)(nil),          // 9: google.cloud.bigquery.migration.v2.SparkSQLDialect
	(*SnowflakeDialect)(nil),         // 10: google.cloud.bigquery.migration.v2.SnowflakeDialect
	(*NetezzaDialect)(nil),           // 11: google.cloud.bigquery.migration.v2.NetezzaDialect
	(*AzureSynapseDialect)(nil),      // 12: google.cloud.bigquery.migration.v2.AzureSynapseDialect
	(*VerticaDialect)(nil),           // 13: google.cloud.bigquery.migration.v2.VerticaDialect
	(*SQLServerDialect)(nil),         // 14: google.cloud.bigquery.migration.v2.SQLServerDialect
	(*PostgresqlDialect)(nil),        // 15: google.cloud.bigquery.migration.v2.PostgresqlDialect
	(*PrestoDialect)(nil),            // 16: google.cloud.bigquery.migration.v2.PrestoDialect
	(*MySQLDialect)(nil),             // 17: google.cloud.bigquery.migration.v2.MySQLDialect
	(*ObjectNameMappingList)(nil),    // 18: google.cloud.bigquery.migration.v2.ObjectNameMappingList
	(*ObjectNameMapping)(nil),        // 19: google.cloud.bigquery.migration.v2.ObjectNameMapping
	(*NameMappingKey)(nil),           // 20: google.cloud.bigquery.migration.v2.NameMappingKey
	(*NameMappingValue)(nil),         // 21: google.cloud.bigquery.migration.v2.NameMappingValue
	(*SourceEnv)(nil),                // 22: google.cloud.bigquery.migration.v2.SourceEnv
}
var file_google_cloud_bigquery_migration_v2_translation_config_proto_depIdxs = []int32{
	18, // 0: google.cloud.bigquery.migration.v2.TranslationConfigDetails.name_mapping_list:type_name -> google.cloud.bigquery.migration.v2.ObjectNameMappingList
	3,  // 1: google.cloud.bigquery.migration.v2.TranslationConfigDetails.source_dialect:type_name -> google.cloud.bigquery.migration.v2.Dialect
	3,  // 2: google.cloud.bigquery.migration.v2.TranslationConfigDetails.target_dialect:type_name -> google.cloud.bigquery.migration.v2.Dialect
	22, // 3: google.cloud.bigquery.migration.v2.TranslationConfigDetails.source_env:type_name -> google.cloud.bigquery.migration.v2.SourceEnv
	4,  // 4: google.cloud.bigquery.migration.v2.Dialect.bigquery_dialect:type_name -> google.cloud.bigquery.migration.v2.BigQueryDialect
	5,  // 5: google.cloud.bigquery.migration.v2.Dialect.hiveql_dialect:type_name -> google.cloud.bigquery.migration.v2.HiveQLDialect
	6,  // 6: google.cloud.bigquery.migration.v2.Dialect.redshift_dialect:type_name -> google.cloud.bigquery.migration.v2.RedshiftDialect
	7,  // 7: google.cloud.bigquery.migration.v2.Dialect.teradata_dialect:type_name -> google.cloud.bigquery.migration.v2.TeradataDialect
	8,  // 8: google.cloud.bigquery.migration.v2.Dialect.oracle_dialect:type_name -> google.cloud.bigquery.migration.v2.OracleDialect
	9,  // 9: google.cloud.bigquery.migration.v2.Dialect.sparksql_dialect:type_name -> google.cloud.bigquery.migration.v2.SparkSQLDialect
	10, // 10: google.cloud.bigquery.migration.v2.Dialect.snowflake_dialect:type_name -> google.cloud.bigquery.migration.v2.SnowflakeDialect
	11, // 11: google.cloud.bigquery.migration.v2.Dialect.netezza_dialect:type_name -> google.cloud.bigquery.migration.v2.NetezzaDialect
	12, // 12: google.cloud.bigquery.migration.v2.Dialect.azure_synapse_dialect:type_name -> google.cloud.bigquery.migration.v2.AzureSynapseDialect
	13, // 13: google.cloud.bigquery.migration.v2.Dialect.vertica_dialect:type_name -> google.cloud.bigquery.migration.v2.VerticaDialect
	14, // 14: google.cloud.bigquery.migration.v2.Dialect.sql_server_dialect:type_name -> google.cloud.bigquery.migration.v2.SQLServerDialect
	15, // 15: google.cloud.bigquery.migration.v2.Dialect.postgresql_dialect:type_name -> google.cloud.bigquery.migration.v2.PostgresqlDialect
	16, // 16: google.cloud.bigquery.migration.v2.Dialect.presto_dialect:type_name -> google.cloud.bigquery.migration.v2.PrestoDialect
	17, // 17: google.cloud.bigquery.migration.v2.Dialect.mysql_dialect:type_name -> google.cloud.bigquery.migration.v2.MySQLDialect
	0,  // 18: google.cloud.bigquery.migration.v2.TeradataDialect.mode:type_name -> google.cloud.bigquery.migration.v2.TeradataDialect.Mode
	19, // 19: google.cloud.bigquery.migration.v2.ObjectNameMappingList.name_map:type_name -> google.cloud.bigquery.migration.v2.ObjectNameMapping
	20, // 20: google.cloud.bigquery.migration.v2.ObjectNameMapping.source:type_name -> google.cloud.bigquery.migration.v2.NameMappingKey
	21, // 21: google.cloud.bigquery.migration.v2.ObjectNameMapping.target:type_name -> google.cloud.bigquery.migration.v2.NameMappingValue
	1,  // 22: google.cloud.bigquery.migration.v2.NameMappingKey.type:type_name -> google.cloud.bigquery.migration.v2.NameMappingKey.Type
	23, // [23:23] is the sub-list for method output_type
	23, // [23:23] is the sub-list for method input_type
	23, // [23:23] is the sub-list for extension type_name
	23, // [23:23] is the sub-list for extension extendee
	0,  // [0:23] is the sub-list for field type_name
}

func init() { file_google_cloud_bigquery_migration_v2_translation_config_proto_init() }
func file_google_cloud_bigquery_migration_v2_translation_config_proto_init() {
	if File_google_cloud_bigquery_migration_v2_translation_config_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_bigquery_migration_v2_translation_config_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TranslationConfigDetails); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_migration_v2_translation_config_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Dialect); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_migration_v2_translation_config_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BigQueryDialect); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_migration_v2_translation_config_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HiveQLDialect); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_migration_v2_translation_config_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RedshiftDialect); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_migration_v2_translation_config_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TeradataDialect); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_migration_v2_translation_config_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OracleDialect); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_migration_v2_translation_config_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SparkSQLDialect); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_migration_v2_translation_config_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SnowflakeDialect); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_migration_v2_translation_config_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NetezzaDialect); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_migration_v2_translation_config_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AzureSynapseDialect); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_migration_v2_translation_config_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VerticaDialect); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_migration_v2_translation_config_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SQLServerDialect); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_migration_v2_translation_config_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PostgresqlDialect); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_migration_v2_translation_config_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PrestoDialect); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_migration_v2_translation_config_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MySQLDialect); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_migration_v2_translation_config_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ObjectNameMappingList); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_migration_v2_translation_config_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ObjectNameMapping); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_migration_v2_translation_config_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NameMappingKey); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_migration_v2_translation_config_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NameMappingValue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_migration_v2_translation_config_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SourceEnv); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_bigquery_migration_v2_translation_config_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*TranslationConfigDetails_GcsSourcePath)(nil),
		(*TranslationConfigDetails_GcsTargetPath)(nil),
		(*TranslationConfigDetails_NameMappingList)(nil),
	}
	file_google_cloud_bigquery_migration_v2_translation_config_proto_msgTypes[1].OneofWrappers = []interface{}{
		(*Dialect_BigqueryDialect)(nil),
		(*Dialect_HiveqlDialect)(nil),
		(*Dialect_RedshiftDialect)(nil),
		(*Dialect_TeradataDialect)(nil),
		(*Dialect_OracleDialect)(nil),
		(*Dialect_SparksqlDialect)(nil),
		(*Dialect_SnowflakeDialect)(nil),
		(*Dialect_NetezzaDialect)(nil),
		(*Dialect_AzureSynapseDialect)(nil),
		(*Dialect_VerticaDialect)(nil),
		(*Dialect_SqlServerDialect)(nil),
		(*Dialect_PostgresqlDialect)(nil),
		(*Dialect_PrestoDialect)(nil),
		(*Dialect_MysqlDialect)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_bigquery_migration_v2_translation_config_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   21,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_bigquery_migration_v2_translation_config_proto_goTypes,
		DependencyIndexes: file_google_cloud_bigquery_migration_v2_translation_config_proto_depIdxs,
		EnumInfos:         file_google_cloud_bigquery_migration_v2_translation_config_proto_enumTypes,
		MessageInfos:      file_google_cloud_bigquery_migration_v2_translation_config_proto_msgTypes,
	}.Build()
	File_google_cloud_bigquery_migration_v2_translation_config_proto = out.File
	file_google_cloud_bigquery_migration_v2_translation_config_proto_rawDesc = nil
	file_google_cloud_bigquery_migration_v2_translation_config_proto_goTypes = nil
	file_google_cloud_bigquery_migration_v2_translation_config_proto_depIdxs = nil
}
